/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.opengl;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.util.Log;
import androidx.annotation.RequiresApi;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u001aJ\u0015\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Landroidx/graphics/opengl/QuadTextureRenderer;", "", "()V", "mFragmentShader", "", "mIsReleased", "", "mProgram", "mQuadCoords", "", "mQuadPositionHandle", "mQuadrantCoordinatesBuffer", "Ljava/nio/FloatBuffer;", "mSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "mTexPositionHandle", "mTextureTransform", "mTextureTransformHandle", "mTextureUniformHandle", "mVertexShader", "mViewProjectionMatrixHandle", "configureQuad", "width", "", "height", "draw", "", "mvpMatrix", "release", "setSurfaceTexture", "surfaceTexture", "setSurfaceTexture$graphics_core_release", "Companion", "graphics-core_release"})
@RequiresApi(value=26)
public final class QuadTextureRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private SurfaceTexture mSurfaceTexture;
    @NotNull
    private final float[] mQuadCoords = new float[8];
    @NotNull
    private final float[] mTextureTransform = new float[16];
    private int mQuadPositionHandle = -1;
    private int mTexPositionHandle = -1;
    private int mTextureUniformHandle = -1;
    private int mViewProjectionMatrixHandle = -1;
    private int mTextureTransformHandle = -1;
    private int mProgram = -1;
    private int mVertexShader = -1;
    private int mFragmentShader = -1;
    private boolean mIsReleased;
    @NotNull
    private final FloatBuffer mQuadrantCoordinatesBuffer;
    @NotNull
    private static final String TAG = "TextureRenderer";
    @NotNull
    public static final String uVPMatrix = "uVPMatrix";
    @NotNull
    public static final String tVPMatrix = "tVPMatrix";
    @NotNull
    public static final String aPosition = "aPosition";
    @NotNull
    public static final String aTexCoord = "aTexCoord";
    @NotNull
    private static final String vTexCoord = "vTexCoord";
    @NotNull
    public static final String uTexture = "uTexture";
    @NotNull
    public static final String VertexShader = "\n            uniform mat4 uVPMatrix;\n            uniform mat4 tVPMatrix;\n            attribute vec4 aPosition;\n            attribute vec2 aTexCoord;\n            varying vec2 vTexCoord;\n\n            void main(void)\n            {\n                gl_Position = uVPMatrix * aPosition;\n                vTexCoord = vec2(tVPMatrix * vec4(aTexCoord.x, 1.0 - aTexCoord.y, 1.0, 1.0));\n            }\n            ";
    @NotNull
    public static final String FragmentShader = "\n            #extension GL_OES_EGL_image_external : require\n            precision highp float;\n\n            uniform samplerExternalOES uTexture;\n\n            varying vec2 vTexCoord;\n\n            void main(void){\n                gl_FragColor = texture2D(uTexture, vTexCoord);\n            }\n            ";
    public static final int CoordsPerVertex = 2;
    public static final int VertexStride = 8;
    @NotNull
    private static final float[] TextureCoordinates;
    @NotNull
    private static final FloatBuffer TextureCoordinatesBuffer;
    @NotNull
    private static final short[] DrawOrder;
    @NotNull
    private static final ShortBuffer DrawOrderBuffer;

    /*
     * WARNING - void declaration
     */
    public QuadTextureRenderer() {
        FloatBuffer floatBuffer;
        void $this$mQuadrantCoordinatesBuffer_u24lambda_u241;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.mQuadCoords.length * 4);
        QuadTextureRenderer quadTextureRenderer = this;
        boolean bl = false;
        $this$mQuadrantCoordinatesBuffer_u24lambda_u241.order(ByteOrder.nativeOrder());
        FloatBuffer $this$mQuadrantCoordinatesBuffer_u24lambda_u241_u24lambda_u240 = floatBuffer = $this$mQuadrantCoordinatesBuffer_u24lambda_u241.asFloatBuffer();
        boolean bl2 = false;
        $this$mQuadrantCoordinatesBuffer_u24lambda_u241_u24lambda_u240.position(0);
        FloatBuffer floatBuffer2 = floatBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)floatBuffer2, (String)"allocateDirect(mQuadCoor\u2026)\n            }\n        }");
        quadTextureRenderer.mQuadrantCoordinatesBuffer = floatBuffer2;
        this.mVertexShader = Companion.loadShader$graphics_core_release(35633, VertexShader);
        this.mFragmentShader = Companion.loadShader$graphics_core_release(35632, FragmentShader);
        this.mProgram = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)this.mProgram, (int)this.mVertexShader);
        GLES20.glAttachShader((int)this.mProgram, (int)this.mFragmentShader);
        GLES20.glLinkProgram((int)this.mProgram);
        GLES20.glUseProgram((int)this.mProgram);
        this.mQuadPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)aPosition);
        this.mTexPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)aTexCoord);
        this.mTextureUniformHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)uTexture);
        this.mViewProjectionMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)uVPMatrix);
        this.mTextureTransformHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)tVPMatrix);
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)1, (int)771);
    }

    public final void release() {
        if (!this.mIsReleased) {
            if (this.mVertexShader != -1) {
                GLES20.glDeleteShader((int)this.mVertexShader);
                this.mVertexShader = -1;
            }
            if (this.mFragmentShader != -1) {
                GLES20.glDeleteShader((int)this.mFragmentShader);
                this.mFragmentShader = -1;
            }
            if (this.mProgram != -1) {
                GLES20.glDeleteProgram((int)this.mProgram);
                this.mProgram = -1;
            }
            this.mIsReleased = true;
        }
    }

    private final FloatBuffer configureQuad(float width, float height) {
        float[] fArray;
        FloatBuffer floatBuffer;
        FloatBuffer $this$configureQuad_u24lambda_u243 = floatBuffer = this.mQuadrantCoordinatesBuffer;
        boolean bl = false;
        float[] fArray2 = fArray = this.mQuadCoords;
        FloatBuffer floatBuffer2 = $this$configureQuad_u24lambda_u243;
        boolean bl2 = false;
        $this$configureQuad_u24lambda_u243_u24lambda_u242[0] = 0.0f;
        $this$configureQuad_u24lambda_u243_u24lambda_u242[1] = height;
        $this$configureQuad_u24lambda_u243_u24lambda_u242[2] = 0.0f;
        $this$configureQuad_u24lambda_u243_u24lambda_u242[3] = 0.0f;
        $this$configureQuad_u24lambda_u243_u24lambda_u242[4] = width;
        $this$configureQuad_u24lambda_u243_u24lambda_u242[5] = 0.0f;
        $this$configureQuad_u24lambda_u243_u24lambda_u242[6] = width;
        $this$configureQuad_u24lambda_u243_u24lambda_u242[7] = height;
        floatBuffer2.put(fArray);
        $this$configureQuad_u24lambda_u243.position(0);
        return floatBuffer;
    }

    public final void setSurfaceTexture$graphics_core_release(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.mSurfaceTexture = surfaceTexture;
    }

    /*
     * WARNING - void declaration
     */
    public final void draw(@NotNull float[] mvpMatrix, float width, float height) {
        void $this$draw_u24lambda_u244;
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)mvpMatrix, (String)"mvpMatrix");
        if (this.mIsReleased) {
            Log.w((String)TAG, (String)"Attempt to render when TextureRenderer has been released");
            return;
        }
        SurfaceTexture textureSource = this.mSurfaceTexture;
        if (textureSource == null) {
            Log.w((String)TAG, (String)"Attempt to render without texture source");
            return;
        }
        GLES20.glUseProgram((int)this.mProgram);
        textureSource.updateTexImage();
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        GLES20.glUniform1i((int)this.mTextureUniformHandle, (int)0);
        GLES20.glUniformMatrix4fv((int)this.mViewProjectionMatrixHandle, (int)1, (boolean)false, (float[])mvpMatrix, (int)0);
        float[] fArray2 = fArray = this.mTextureTransform;
        boolean bl = false;
        int n = 1;
        int n2 = this.mTextureTransformHandle;
        boolean bl2 = false;
        textureSource.getTransformMatrix((float[])$this$draw_u24lambda_u244);
        Unit unit = Unit.INSTANCE;
        GLES20.glUniformMatrix4fv((int)n2, (int)n, (boolean)bl, (float[])fArray, (int)0);
        GLES20.glVertexAttribPointer((int)this.mQuadPositionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.configureQuad(width, height));
        GLES20.glVertexAttribPointer((int)this.mTexPositionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)TextureCoordinatesBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mQuadPositionHandle);
        GLES20.glEnableVertexAttribArray((int)this.mTexPositionHandle);
        GLES20.glDrawElements((int)4, (int)DrawOrder.length, (int)5123, (Buffer)DrawOrderBuffer);
        GLES20.glDisableVertexAttribArray((int)this.mQuadPositionHandle);
        GLES20.glDisableVertexAttribArray((int)this.mTexPositionHandle);
    }

    static {
        Object[] objectArray = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        TextureCoordinates = objectArray;
        ByteBuffer $this$TextureCoordinatesBuffer_u24lambda_u246 = ByteBuffer.allocateDirect(TextureCoordinates.length * 4);
        boolean bl = false;
        $this$TextureCoordinatesBuffer_u24lambda_u246.order(ByteOrder.nativeOrder());
        Buffer buffer = $this$TextureCoordinatesBuffer_u24lambda_u246.asFloatBuffer();
        FloatBuffer $this$TextureCoordinatesBuffer_u24lambda_u246_u24lambda_u245 = buffer;
        boolean bl2 = false;
        $this$TextureCoordinatesBuffer_u24lambda_u246_u24lambda_u245.put(TextureCoordinates);
        $this$TextureCoordinatesBuffer_u24lambda_u246_u24lambda_u245.position(0);
        FloatBuffer floatBuffer = buffer;
        Intrinsics.checkNotNullExpressionValue((Object)floatBuffer, (String)"allocateDirect(TextureCo\u2026          }\n            }");
        TextureCoordinatesBuffer = floatBuffer;
        objectArray = new short[6];
        objectArray[0] = 0.0f;
        objectArray[1] = 1.0f;
        objectArray[2] = 2;
        objectArray[3] = 0.0f;
        objectArray[4] = 2;
        objectArray[5] = 3;
        DrawOrder = (short[])objectArray;
        ByteBuffer $this$DrawOrderBuffer_u24lambda_u248 = ByteBuffer.allocateDirect(DrawOrder.length * 2);
        boolean bl3 = false;
        $this$DrawOrderBuffer_u24lambda_u248.order(ByteOrder.nativeOrder());
        Buffer $this$DrawOrderBuffer_u24lambda_u248_u24lambda_u247 = buffer = $this$DrawOrderBuffer_u24lambda_u248.asShortBuffer();
        boolean bl4 = false;
        ((ShortBuffer)$this$DrawOrderBuffer_u24lambda_u248_u24lambda_u247).put(DrawOrder);
        ((ShortBuffer)$this$DrawOrderBuffer_u24lambda_u248_u24lambda_u247).position(0);
        Buffer buffer2 = buffer;
        Intrinsics.checkNotNullExpressionValue((Object)buffer2, (String)"allocateDirect(DrawOrder\u2026          }\n            }");
        DrawOrderBuffer = buffer2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nJ\u001d\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/graphics/opengl/QuadTextureRenderer$Companion;", "", "()V", "CoordsPerVertex", "", "DrawOrder", "", "DrawOrderBuffer", "Ljava/nio/ShortBuffer;", "FragmentShader", "", "TAG", "TextureCoordinates", "", "TextureCoordinatesBuffer", "Ljava/nio/FloatBuffer;", "VertexShader", "VertexStride", "aPosition", "aTexCoord", "tVPMatrix", "uTexture", "uVPMatrix", "vTexCoord", "checkError", "", "msg", "loadShader", "type", "shaderCode", "loadShader$graphics_core_release", "graphics-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void checkError(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            int error = GLES20.glGetError();
            if (error != 0) {
                Log.v((String)TAG, (String)("GLError " + msg + ": " + error));
            }
        }

        public final int loadShader$graphics_core_release(int type, @NotNull String shaderCode) {
            int n;
            Intrinsics.checkNotNullParameter((Object)shaderCode, (String)"shaderCode");
            int shader = n = GLES20.glCreateShader((int)type);
            boolean bl = false;
            GLES20.glShaderSource((int)shader, (String)shaderCode);
            GLES20.glCompileShader((int)shader);
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

