/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.opengl.egl;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import androidx.graphics.opengl.egl.EGLConfigAttributes;
import androidx.graphics.opengl.egl.EGLException;
import androidx.graphics.opengl.egl.EGLSpec;
import androidx.graphics.opengl.egl.EGLVersion;
import androidx.opengl.EGLExt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 82\u00020\u0001:\u00018B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u000eJ\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\u001fJ\u0010\u0010.\u001a\u0004\u0018\u00010\u000e2\u0006\u0010/\u001a\u000200J\u001a\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020\u00062\b\b\u0002\u00103\u001a\u00020\u0006H\u0007J\u0010\u00104\u001a\u00020+2\u0006\u00105\u001a\u00020\u0006H\u0002J\u0006\u00106\u001a\u00020+J\u0006\u00107\u001a\u00020+R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188G\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Landroidx/graphics/opengl/egl/EGLManager;", "", "eglSpec", "Landroidx/graphics/opengl/egl/EGLSpec;", "(Landroidx/graphics/opengl/egl/EGLSpec;)V", "currentDrawSurface", "Landroid/opengl/EGLSurface;", "getCurrentDrawSurface", "()Landroid/opengl/EGLSurface;", "currentReadSurface", "getCurrentReadSurface", "defaultSurface", "getDefaultSurface", "eglConfig", "Landroid/opengl/EGLConfig;", "getEGLConfig", "()Landroid/opengl/EGLConfig;", "eglContext", "Landroid/opengl/EGLContext;", "getEGLContext", "()Landroid/opengl/EGLContext;", "getEGLSpec", "()Landroidx/graphics/opengl/egl/EGLSpec;", "eglVersion", "Landroidx/graphics/opengl/egl/EGLVersion;", "getEGLVersion", "()Landroidx/graphics/opengl/egl/EGLVersion;", "mEglConfig", "mEglContext", "mEglExtensions", "", "", "mEglSpec", "mEglVersion", "mIsSingleBuffered", "", "mPBufferSurface", "mQueryResult", "", "mWideColorGamutSupport", "createContext", "config", "initialize", "", "isExtensionSupported", "extensionName", "loadConfig", "configAttributes", "Landroidx/graphics/opengl/egl/EGLConfigAttributes;", "makeCurrent", "drawSurface", "readSurface", "querySurface", "surface", "release", "swapAndFlushBuffers", "Companion", "graphics-core_release"})
@SourceDebugExtension(value={"SMAP\nEGLManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EGLManager.kt\nandroidx/graphics/opengl/egl/EGLManager\n+ 2 EGLConfigAttributes.kt\nandroidx/graphics/opengl/egl/EGLConfigAttributesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n47#2:251\n1#3:252\n1#3:253\n*S KotlinDebug\n*F\n+ 1 EGLManager.kt\nandroidx/graphics/opengl/egl/EGLManager\n*L\n84#1:251\n84#1:252\n*E\n"})
public final class EGLManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private EGLConfig mEglConfig;
    @NotNull
    private EGLSurface mPBufferSurface;
    @NotNull
    private EGLContext mEglContext;
    private boolean mWideColorGamutSupport;
    @NotNull
    private EGLVersion mEglVersion;
    @NotNull
    private final EGLSpec mEglSpec;
    @Nullable
    private Set<String> mEglExtensions;
    private boolean mIsSingleBuffered;
    @Nullable
    private int[] mQueryResult;
    @NotNull
    private static final String TAG = "EglManager";

    public EGLManager(@NotNull EGLSpec eglSpec) {
        Intrinsics.checkNotNullParameter((Object)eglSpec, (String)"eglSpec");
        EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
        Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"EGL_NO_SURFACE");
        this.mPBufferSurface = eGLSurface;
        EGLContext eGLContext = EGL14.EGL_NO_CONTEXT;
        Intrinsics.checkNotNullExpressionValue((Object)eGLContext, (String)"EGL_NO_CONTEXT");
        this.mEglContext = eGLContext;
        this.mEglVersion = EGLVersion.Unknown;
        this.mEglSpec = eglSpec;
    }

    public /* synthetic */ EGLManager(EGLSpec eGLSpec, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            eGLSpec = EGLSpec.V14;
        }
        this(eGLSpec);
    }

    public final void initialize() {
        EGLContext it = this.mEglContext;
        boolean bl = false;
        if (it == EGL14.EGL_NO_CONTEXT) {
            this.mEglVersion = this.getEGLSpec().eglInitialize();
            this.mEglExtensions = EGLExt.Companion.parseExtensions(this.getEGLSpec().eglQueryString(12373));
        }
    }

    @Nullable
    public final EGLConfig loadConfig(@NotNull EGLConfigAttributes configAttributes) {
        Intrinsics.checkNotNullParameter((Object)configAttributes, (String)"configAttributes");
        return this.getEGLSpec().loadConfig(configAttributes);
    }

    @NotNull
    public final EGLContext createContext(@NotNull EGLConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        EGLContext eglContext = this.getEGLSpec().eglCreateContext(config);
        if (eglContext != EGL14.EGL_NO_CONTEXT) {
            EGLSurface pbBufferSurface;
            EGLSurface eGLSurface;
            if (this.isExtensionSupported("EGL_KHR_surfaceless_context")) {
                EGLSurface eGLSurface2 = EGL14.EGL_NO_SURFACE;
                eGLSurface = eGLSurface2;
                Intrinsics.checkNotNullExpressionValue((Object)eGLSurface2, (String)"{\n                    EG\u2026SURFACE\n                }");
            } else {
                EGLConfigAttributes.Builder builder;
                boolean $i$f$EGLConfigAttributes = false;
                EGLConfigAttributes.Builder $this$EGLConfigAttributes_u24lambda_u240$iv = builder = new EGLConfigAttributes.Builder();
                boolean bl = false;
                EGLConfigAttributes.Builder $this$createContext_u24lambda_u241 = $this$EGLConfigAttributes_u24lambda_u240$iv;
                boolean bl2 = false;
                $this$createContext_u24lambda_u241.to(12375, 1);
                $this$createContext_u24lambda_u241.to(12374, 1);
                EGLConfigAttributes configAttrs = builder.build();
                eGLSurface = pbBufferSurface = this.getEGLSpec().eglCreatePBufferSurface(config, configAttrs);
            }
            if (!this.getEGLSpec().eglMakeCurrent(eglContext, pbBufferSurface, pbBufferSurface)) {
                throw new EGLException(this.getEGLSpec().eglGetError(), "Unable to make default surface current");
            }
            this.mPBufferSurface = pbBufferSurface;
            this.mEglContext = eglContext;
            this.mEglConfig = config;
        } else {
            EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
            Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"EGL_NO_SURFACE");
            this.mPBufferSurface = eGLSurface;
            EGLContext eGLContext = EGL14.EGL_NO_CONTEXT;
            Intrinsics.checkNotNullExpressionValue((Object)eGLContext, (String)"EGL_NO_CONTEXT");
            this.mEglContext = eGLContext;
            this.mEglConfig = null;
        }
        return eglContext;
    }

    public final void release() {
        EGLContext it = this.mEglContext;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it, (Object)EGL14.EGL_NO_CONTEXT)) {
            this.getEGLSpec().eglDestroyContext(it);
            EGLSurface pbBufferSurface = this.mPBufferSurface;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)pbBufferSurface, (Object)EGL14.EGL_NO_SURFACE)) {
                this.getEGLSpec().eglDestroySurface(pbBufferSurface);
            }
            EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
            Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"EGL_NO_SURFACE");
            this.mPBufferSurface = eGLSurface;
            EGLSpec eGLSpec = this.getEGLSpec();
            EGLContext eGLContext = EGL14.EGL_NO_CONTEXT;
            Intrinsics.checkNotNullExpressionValue((Object)eGLContext, (String)"EGL_NO_CONTEXT");
            EGLSurface eGLSurface2 = EGL14.EGL_NO_SURFACE;
            Intrinsics.checkNotNullExpressionValue((Object)eGLSurface2, (String)"EGL_NO_SURFACE");
            EGLSurface eGLSurface3 = EGL14.EGL_NO_SURFACE;
            Intrinsics.checkNotNullExpressionValue((Object)eGLSurface3, (String)"EGL_NO_SURFACE");
            eGLSpec.eglMakeCurrent(eGLContext, eGLSurface2, eGLSurface3);
            this.mEglVersion = EGLVersion.Unknown;
            EGLContext eGLContext2 = EGL14.EGL_NO_CONTEXT;
            Intrinsics.checkNotNullExpressionValue((Object)eGLContext2, (String)"EGL_NO_CONTEXT");
            this.mEglContext = eGLContext2;
            this.mEglConfig = null;
            this.mEglExtensions = null;
        }
    }

    @JvmName(name="getEGLSpec")
    @NotNull
    public final EGLSpec getEGLSpec() {
        return this.mEglSpec;
    }

    @JvmName(name="getEGLVersion")
    @NotNull
    public final EGLVersion getEGLVersion() {
        return this.mEglVersion;
    }

    @JvmName(name="getEGLContext")
    @Nullable
    public final EGLContext getEGLContext() {
        return this.mEglContext;
    }

    @JvmName(name="getEGLConfig")
    @Nullable
    public final EGLConfig getEGLConfig() {
        return this.mEglConfig;
    }

    public final boolean isExtensionSupported(@NotNull String extensionName) {
        Intrinsics.checkNotNullParameter((Object)extensionName, (String)"extensionName");
        Set<String> set = this.mEglExtensions;
        return set != null ? set.contains(extensionName) : false;
    }

    @JvmOverloads
    public final boolean makeCurrent(@NotNull EGLSurface drawSurface, @NotNull EGLSurface readSurface) {
        Intrinsics.checkNotNullParameter((Object)drawSurface, (String)"drawSurface");
        Intrinsics.checkNotNullParameter((Object)readSurface, (String)"readSurface");
        boolean result = this.getEGLSpec().eglMakeCurrent(this.mEglContext, drawSurface, readSurface);
        if (result) {
            this.querySurface(drawSurface);
        }
        return result;
    }

    public static /* synthetic */ boolean makeCurrent$default(EGLManager eGLManager, EGLSurface eGLSurface, EGLSurface eGLSurface2, int n, Object object) {
        if ((n & 2) != 0) {
            eGLSurface2 = eGLSurface;
        }
        return eGLManager.makeCurrent(eGLSurface, eGLSurface2);
    }

    public final void swapAndFlushBuffers() {
        if (this.mIsSingleBuffered) {
            GLES20.glFlush();
        }
        this.getEGLSpec().eglSwapBuffers(this.getCurrentDrawSurface());
    }

    @NotNull
    public final EGLSurface getDefaultSurface() {
        return this.mPBufferSurface;
    }

    @NotNull
    public final EGLSurface getCurrentDrawSurface() {
        return this.getEGLSpec().eglGetCurrentDrawSurface();
    }

    @NotNull
    public final EGLSurface getCurrentReadSurface() {
        return this.getEGLSpec().eglGetCurrentReadSurface();
    }

    private final void querySurface(EGLSurface surface) {
        if (Intrinsics.areEqual((Object)surface, (Object)EGL14.EGL_NO_SURFACE)) {
            this.mIsSingleBuffered = false;
        } else {
            int[] resultArray;
            int[] nArray = this.mQueryResult;
            if (this.mQueryResult == null) {
                int[] nArray2;
                int[] it = nArray2 = new int[1];
                boolean bl = false;
                this.mQueryResult = it;
                nArray = resultArray = nArray2;
            }
            if (this.getEGLSpec().eglQuerySurface(surface, 12422, resultArray, 0)) {
                this.mIsSingleBuffered = resultArray[0] == 12421;
            }
        }
    }

    @JvmOverloads
    public final boolean makeCurrent(@NotNull EGLSurface drawSurface) {
        Intrinsics.checkNotNullParameter((Object)drawSurface, (String)"drawSurface");
        return EGLManager.makeCurrent$default(this, drawSurface, null, 2, null);
    }

    public EGLManager() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/graphics/opengl/egl/EGLManager$Companion;", "", "()V", "TAG", "", "graphics-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

