/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.surface;

import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.HardwareBuffer;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import androidx.graphics.surface.JniBindings;
import androidx.graphics.surface.SurfaceControlCompat;
import androidx.graphics.surface.SurfaceControlWrapper;
import androidx.hardware.SyncFenceV19;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\fJ\u0006\u0010\u0013\u001a\u00020\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/graphics/surface/SurfaceControlWrapper;", "", "surfaceControl", "debugName", "", "(Landroidx/graphics/surface/SurfaceControlWrapper;Ljava/lang/String;)V", "surface", "Landroid/view/Surface;", "(Landroid/view/Surface;Ljava/lang/String;)V", "mNativeSurfaceControl", "", "equals", "", "other", "finalize", "", "hashCode", "", "isValid", "release", "Builder", "Transaction", "graphics-core_release"})
@RequiresApi(value=29)
public final class SurfaceControlWrapper {
    private long mNativeSurfaceControl;

    public SurfaceControlWrapper(@NotNull SurfaceControlWrapper surfaceControl, @NotNull String debugName) {
        Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        this.mNativeSurfaceControl = JniBindings.Companion.nCreate(surfaceControl.mNativeSurfaceControl, debugName);
        if (this.mNativeSurfaceControl == 0L) {
            throw new IllegalArgumentException();
        }
    }

    public SurfaceControlWrapper(@NotNull Surface surface, @NotNull String debugName) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        this.mNativeSurfaceControl = JniBindings.Companion.nCreateFromSurface(surface, debugName);
        if (this.mNativeSurfaceControl == 0L) {
            throw new IllegalArgumentException();
        }
    }

    public final boolean isValid() {
        return this.mNativeSurfaceControl != 0L;
    }

    public boolean equals(@Nullable Object other) {
        if (Intrinsics.areEqual((Object)other, (Object)this)) {
            return true;
        }
        Object object = other;
        if (other == null | !Intrinsics.areEqual(object != null ? object.getClass() : null, SurfaceControlWrapper.class)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type androidx.graphics.surface.SurfaceControlWrapper");
        SurfaceControlWrapper cfr_ignored_0 = (SurfaceControlWrapper)other;
        return ((SurfaceControlWrapper)other).mNativeSurfaceControl == this.mNativeSurfaceControl;
    }

    public int hashCode() {
        return Long.hashCode(this.mNativeSurfaceControl);
    }

    public final void release() {
        if (this.mNativeSurfaceControl != 0L) {
            JniBindings.Companion.nRelease(this.mNativeSurfaceControl);
            this.mNativeSurfaceControl = 0L;
        }
    }

    protected final void finalize() {
        this.release();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/graphics/surface/SurfaceControlWrapper$Builder;", "", "()V", "mDebugName", "", "mSurface", "Landroid/view/Surface;", "mSurfaceControl", "Landroidx/graphics/surface/SurfaceControlWrapper;", "build", "setDebugName", "debugName", "setParent", "surface", "surfaceControlWrapper", "graphics-core_release"})
    public static final class Builder {
        @Nullable
        private Surface mSurface;
        @Nullable
        private SurfaceControlWrapper mSurfaceControl;
        private String mDebugName;

        @NotNull
        public final Builder setParent(@NotNull Surface surface) {
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            this.mSurface = surface;
            this.mSurfaceControl = null;
            return this;
        }

        @NotNull
        public final Builder setParent(@NotNull SurfaceControlWrapper surfaceControlWrapper) {
            Intrinsics.checkNotNullParameter((Object)surfaceControlWrapper, (String)"surfaceControlWrapper");
            this.mSurface = null;
            this.mSurfaceControl = surfaceControlWrapper;
            return this;
        }

        @NotNull
        public final Builder setDebugName(@NotNull String debugName) {
            Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
            this.mDebugName = debugName;
            return this;
        }

        @NotNull
        public final SurfaceControlWrapper build() {
            SurfaceControlWrapper surfaceControlWrapper;
            Surface surface = this.mSurface;
            SurfaceControlWrapper surfaceControl = this.mSurfaceControl;
            if (surface != null) {
                String string = this.mDebugName;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mDebugName");
                    string = null;
                }
                surfaceControlWrapper = new SurfaceControlWrapper(surface, string);
            } else if (surfaceControl != null) {
                String string = this.mDebugName;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mDebugName");
                    string = null;
                }
                surfaceControlWrapper = new SurfaceControlWrapper(surfaceControl, string);
            } else {
                throw new IllegalStateException("");
            }
            return surfaceControlWrapper;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0015\u0010\n\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eJ\u0018\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013J\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\"\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010 \u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\u0018\u0010#\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010%J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0004J6\u0010(\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010-\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u001fJ\u0016\u0010/\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00100\u001a\u000201J \u00102\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u0017H\u0007J \u00105\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u00020\u0017H\u0007J\u0016\u00108\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00109\u001a\u000201R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Landroidx/graphics/surface/SurfaceControlWrapper$Transaction;", "", "()V", "mNativeSurfaceTransaction", "", "addTransactionCommittedListener", "executor", "Ljava/util/concurrent/Executor;", "listener", "Landroidx/graphics/surface/SurfaceControlCompat$TransactionCommittedListener;", "addTransactionCompletedListener", "Landroidx/graphics/surface/SurfaceControlCompat$TransactionCompletedListener;", "addTransactionCompletedListener$graphics_core_release", "close", "", "commit", "finalize", "reparent", "surfaceControl", "Landroidx/graphics/surface/SurfaceControlWrapper;", "newParent", "setAlpha", "alpha", "", "setBuffer", "hardwareBuffer", "Landroid/hardware/HardwareBuffer;", "syncFence", "Landroidx/hardware/SyncFenceV19;", "setBufferTransform", "transformation", "", "setCrop", "crop", "Landroid/graphics/Rect;", "setDamageRegion", "region", "Landroid/graphics/Region;", "setDesiredPresentTime", "desiredPresentTimeNano", "setGeometry", "width", "height", "dstWidth", "dstHeight", "setLayer", "zOrder", "setOpaque", "isOpaque", "", "setPosition", "x", "y", "setScale", "scaleX", "scaleY", "setVisibility", "visibility", "graphics-core_release"})
    public static final class Transaction {
        private long mNativeSurfaceTransaction = JniBindings.Companion.nTransactionCreate();

        public Transaction() {
            if (this.mNativeSurfaceTransaction == 0L) {
                throw new IllegalArgumentException();
            }
        }

        public final void commit() {
            JniBindings.Companion.nTransactionApply(this.mNativeSurfaceTransaction);
        }

        @NotNull
        public final Transaction addTransactionCompletedListener$graphics_core_release(@NotNull SurfaceControlCompat.TransactionCompletedListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            JniBindings.Companion.nTransactionSetOnComplete(this.mNativeSurfaceTransaction, listener);
            return this;
        }

        @RequiresApi(value=31)
        @NotNull
        public final Transaction addTransactionCommittedListener(@Nullable Executor executor, @NotNull SurfaceControlCompat.TransactionCommittedListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            SurfaceControlCompat.TransactionCommittedListener listenerWrapper = listener;
            if (executor != null) {
                listenerWrapper = new SurfaceControlCompat.TransactionCommittedListener(executor, listener){
                    final /* synthetic */ Executor $executor;
                    final /* synthetic */ SurfaceControlCompat.TransactionCommittedListener $listener;
                    {
                        this.$executor = $executor;
                        this.$listener = $listener;
                    }

                    public void onTransactionCommitted() {
                        this.$executor.execute(() -> addTransactionCommittedListener.1.onTransactionCommitted$lambda$0(this.$listener));
                    }

                    private static final void onTransactionCommitted$lambda$0(SurfaceControlCompat.TransactionCommittedListener $listener) {
                        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
                        $listener.onTransactionCommitted();
                    }
                };
            }
            JniBindings.Companion.nTransactionSetOnCommit(this.mNativeSurfaceTransaction, listenerWrapper);
            return this;
        }

        @JvmOverloads
        @NotNull
        public final Transaction setBuffer(@NotNull SurfaceControlWrapper surfaceControl, @NotNull HardwareBuffer hardwareBuffer, @NotNull SyncFenceV19 syncFence) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            Intrinsics.checkNotNullParameter((Object)hardwareBuffer, (String)"hardwareBuffer");
            Intrinsics.checkNotNullParameter((Object)syncFence, (String)"syncFence");
            JniBindings.Companion.nSetBuffer(this.mNativeSurfaceTransaction, surfaceControl.mNativeSurfaceControl, hardwareBuffer, syncFence);
            return this;
        }

        public static /* synthetic */ Transaction setBuffer$default(Transaction transaction2, SurfaceControlWrapper surfaceControlWrapper, HardwareBuffer hardwareBuffer, SyncFenceV19 syncFenceV19, int n, Object object) {
            if ((n & 4) != 0) {
                syncFenceV19 = new SyncFenceV19(-1);
            }
            return transaction2.setBuffer(surfaceControlWrapper, hardwareBuffer, syncFenceV19);
        }

        @NotNull
        public final Transaction setVisibility(@NotNull SurfaceControlWrapper surfaceControl, boolean visibility) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            JniBindings.Companion.nSetVisibility(this.mNativeSurfaceTransaction, surfaceControl.mNativeSurfaceControl, visibility ? (byte)1 : 0);
            return this;
        }

        @NotNull
        public final Transaction setLayer(@NotNull SurfaceControlWrapper surfaceControl, int zOrder) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            JniBindings.Companion.nSetZOrder(this.mNativeSurfaceTransaction, surfaceControl.mNativeSurfaceControl, zOrder);
            return this;
        }

        @NotNull
        public final Transaction setDamageRegion(@NotNull SurfaceControlWrapper surfaceControl, @Nullable Region region) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            Region region2 = region;
            JniBindings.Companion.nSetDamageRegion(this.mNativeSurfaceTransaction, surfaceControl.mNativeSurfaceControl, (Rect)(region2 != null ? region2.getBounds() : null));
            return this;
        }

        @NotNull
        public final Transaction reparent(@NotNull SurfaceControlWrapper surfaceControl, @Nullable SurfaceControlWrapper newParent) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            SurfaceControlWrapper surfaceControlWrapper = newParent;
            JniBindings.Companion.nTransactionReparent(this.mNativeSurfaceTransaction, surfaceControl.mNativeSurfaceControl, surfaceControlWrapper != null ? surfaceControlWrapper.mNativeSurfaceControl : 0L);
            return this;
        }

        @NotNull
        public final Transaction setDesiredPresentTime(long desiredPresentTimeNano) {
            JniBindings.Companion.nSetDesiredPresentTime(this.mNativeSurfaceTransaction, desiredPresentTimeNano);
            return this;
        }

        @NotNull
        public final Transaction setOpaque(@NotNull SurfaceControlWrapper surfaceControl, boolean isOpaque) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            JniBindings.Companion.nSetBufferTransparency(this.mNativeSurfaceTransaction, surfaceControl.mNativeSurfaceControl, isOpaque ? (byte)2 : 0);
            return this;
        }

        @NotNull
        public final Transaction setAlpha(@NotNull SurfaceControlWrapper surfaceControl, float alpha) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            if (alpha < 0.0f || alpha > 1.0f) {
                throw new IllegalArgumentException("Alpha value must be between 0.0 and 1.0.");
            }
            JniBindings.Companion.nSetBufferAlpha(this.mNativeSurfaceTransaction, surfaceControl.mNativeSurfaceControl, alpha);
            return this;
        }

        @RequiresApi(value=31)
        @NotNull
        public final Transaction setCrop(@NotNull SurfaceControlWrapper surfaceControl, @Nullable Rect crop) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            if (!(crop == null || crop.width() >= 0 && crop.height() >= 0)) {
                boolean bl = false;
                throw new IllegalArgumentException("width and height must be non-negative");
            }
            if (crop == null) {
                JniBindings.Companion.nSetCrop(this.mNativeSurfaceTransaction, surfaceControl.mNativeSurfaceControl, 0, 0, 0, 0);
            } else {
                JniBindings.Companion.nSetCrop(this.mNativeSurfaceTransaction, surfaceControl.mNativeSurfaceControl, crop.left, crop.top, crop.right, crop.bottom);
            }
            return this;
        }

        @RequiresApi(value=31)
        @NotNull
        public final Transaction setPosition(@NotNull SurfaceControlWrapper surfaceControl, float x, float y) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            JniBindings.Companion.nSetPosition(this.mNativeSurfaceTransaction, surfaceControl.mNativeSurfaceControl, x, y);
            return this;
        }

        @RequiresApi(value=31)
        @NotNull
        public final Transaction setScale(@NotNull SurfaceControlWrapper surfaceControl, float scaleX, float scaleY) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            JniBindings.Companion.nSetScale(this.mNativeSurfaceTransaction, surfaceControl.mNativeSurfaceControl, scaleX, scaleY);
            return this;
        }

        @RequiresApi(value=31)
        @NotNull
        public final Transaction setBufferTransform(@NotNull SurfaceControlWrapper surfaceControl, int transformation) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            JniBindings.Companion.nSetBufferTransform(this.mNativeSurfaceTransaction, surfaceControl.mNativeSurfaceControl, transformation);
            return this;
        }

        @NotNull
        public final Transaction setGeometry(@NotNull SurfaceControlWrapper surfaceControl, int width, int height, int dstWidth, int dstHeight, int transformation) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            JniBindings.Companion.nSetGeometry(this.mNativeSurfaceTransaction, surfaceControl.mNativeSurfaceControl, width, height, dstWidth, dstHeight, transformation);
            return this;
        }

        public final void close() {
            if (this.mNativeSurfaceTransaction != 0L) {
                JniBindings.Companion.nTransactionDelete(this.mNativeSurfaceTransaction);
                this.mNativeSurfaceTransaction = 0L;
            }
        }

        public final void finalize() {
            this.close();
        }

        @JvmOverloads
        @NotNull
        public final Transaction setBuffer(@NotNull SurfaceControlWrapper surfaceControl, @NotNull HardwareBuffer hardwareBuffer) {
            Intrinsics.checkNotNullParameter((Object)surfaceControl, (String)"surfaceControl");
            Intrinsics.checkNotNullParameter((Object)hardwareBuffer, (String)"hardwareBuffer");
            return Transaction.setBuffer$default(this, surfaceControl, hardwareBuffer, null, 4, null);
        }
    }
}

