/*
 * Decompiled with CFR 0.152.
 */
package androidx.hardware;

import androidx.annotation.RequiresApi;
import androidx.hardware.SyncFenceImpl;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0001\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0004J\b\u0010\u0011\u001a\u00020\u000bH\u0017J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0011\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004H\u0082 J\u0011\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0082 J\u0011\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0082 J\u0019\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0082 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/hardware/SyncFenceV19;", "Ljava/lang/AutoCloseable;", "Landroidx/hardware/SyncFenceImpl;", "fd", "", "(I)V", "fenceLock", "Ljava/util/concurrent/locks/ReentrantLock;", "await", "", "timeoutNanos", "", "awaitForever", "close", "", "dupeFileDescriptor", "finalize", "getSignalTimeNanos", "isValid", "nClose", "nDup", "nGetSignalTime", "nWait", "timeoutMillis", "Companion", "graphics-core_release"})
@RequiresApi(value=19)
public final class SyncFenceV19
implements AutoCloseable,
SyncFenceImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int fd;
    @NotNull
    private final ReentrantLock fenceLock;

    public SyncFenceV19(int fd) {
        this.fd = fd;
        this.fenceLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        boolean bl;
        Lock lock = this.fenceLock;
        lock.lock();
        try {
            boolean bl2 = false;
            bl = this.fd != -1;
        }
        finally {
            lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresApi(value=26)
    public long getSignalTimeNanos() {
        long l;
        Lock lock = this.fenceLock;
        lock.lock();
        try {
            boolean bl = false;
            l = this.isValid() ? this.nGetSignalTime(this.fd) : -1L;
        }
        finally {
            lock.unlock();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int dupeFileDescriptor() {
        Lock lock = this.fenceLock;
        lock.lock();
        try {
            boolean bl = false;
            int n = this.isValid() ? this.nDup(this.fd) : -1;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean await(long timeoutNanos) {
        Lock lock = this.fenceLock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.isValid()) {
                int timeout = 0;
                timeout = timeoutNanos < 0L ? -1 : (int)TimeUnit.NANOSECONDS.toMillis(timeoutNanos);
                boolean bl2 = this.nWait(this.fd, timeout);
                return bl2;
            }
            boolean bl3 = true;
            return bl3;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean awaitForever() {
        return this.await(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Lock lock = this.fenceLock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.isValid()) {
                this.nClose(this.fd);
                this.fd = -1;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    protected final void finalize() {
        this.close();
    }

    private final native boolean nWait(int var1, int var2);

    private final native long nGetSignalTime(int var1);

    private final native void nClose(int var1);

    private final native int nDup(int var1);

    static {
        System.loadLibrary("graphics-core");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Landroidx/hardware/SyncFenceV19$Companion;", "", "()V", "graphics-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

