/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.path;

import android.graphics.Path;
import android.os.Build;
import androidx.graphics.path.PathIteratorApi34Impl;
import androidx.graphics.path.PathIteratorImpl;
import androidx.graphics.path.PathIteratorPreApi34Impl;
import androidx.graphics.path.PathSegment;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\t\u0010\u0016\u001a\u00020\u0015H\u0096\u0002J\t\u0010\u0017\u001a\u00020\u0002H\u0096\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u0013H\u0007J\u0006\u0010\u001c\u001a\u00020\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Landroidx/graphics/path/PathIterator;", "", "Landroidx/graphics/path/PathSegment;", "path", "Landroid/graphics/Path;", "conicEvaluation", "Landroidx/graphics/path/PathIterator$ConicEvaluation;", "tolerance", "", "(Landroid/graphics/Path;Landroidx/graphics/path/PathIterator$ConicEvaluation;F)V", "getConicEvaluation", "()Landroidx/graphics/path/PathIterator$ConicEvaluation;", "implementation", "Landroidx/graphics/path/PathIteratorImpl;", "getPath", "()Landroid/graphics/Path;", "getTolerance", "()F", "calculateSize", "", "includeConvertedConics", "", "hasNext", "next", "Landroidx/graphics/path/PathSegment$Type;", "points", "", "offset", "peek", "ConicEvaluation", "graphics-path_release"})
public final class PathIterator
implements Iterator<PathSegment>,
KMappedMarker {
    @NotNull
    private final Path path;
    @NotNull
    private final ConicEvaluation conicEvaluation;
    private final float tolerance;
    @NotNull
    private final PathIteratorImpl implementation;

    public PathIterator(@NotNull Path path, @NotNull ConicEvaluation conicEvaluation, float tolerance) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)conicEvaluation), (String)"conicEvaluation");
        this.path = path;
        this.conicEvaluation = conicEvaluation;
        this.tolerance = tolerance;
        this.implementation = Build.VERSION.SDK_INT >= 34 ? (PathIteratorImpl)new PathIteratorApi34Impl(this.path, this.conicEvaluation, this.tolerance) : (PathIteratorImpl)new PathIteratorPreApi34Impl(this.path, this.conicEvaluation, this.tolerance);
    }

    public /* synthetic */ PathIterator(Path path, ConicEvaluation conicEvaluation, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            conicEvaluation = ConicEvaluation.AsQuadratics;
        }
        if ((n & 4) != 0) {
            f = 0.25f;
        }
        this(path, conicEvaluation, f);
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final ConicEvaluation getConicEvaluation() {
        return this.conicEvaluation;
    }

    public final float getTolerance() {
        return this.tolerance;
    }

    public final int calculateSize(boolean includeConvertedConics) {
        return this.implementation.calculateSize(includeConvertedConics);
    }

    public static /* synthetic */ int calculateSize$default(PathIterator pathIterator, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return pathIterator.calculateSize(bl);
    }

    @Override
    public boolean hasNext() {
        return this.implementation.hasNext();
    }

    @NotNull
    public final PathSegment.Type peek() {
        return this.implementation.peek();
    }

    @JvmOverloads
    @NotNull
    public final PathSegment.Type next(@NotNull float[] points, int offset) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        return this.implementation.next(points, offset);
    }

    public static /* synthetic */ PathSegment.Type next$default(PathIterator pathIterator, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return pathIterator.next(fArray, n);
    }

    @Override
    @NotNull
    public PathSegment next() {
        return this.implementation.next();
    }

    @JvmOverloads
    @NotNull
    public final PathSegment.Type next(@NotNull float[] points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        return PathIterator.next$default(this, points, 0, 2, null);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/graphics/path/PathIterator$ConicEvaluation;", "", "(Ljava/lang/String;I)V", "AsConic", "AsQuadratics", "graphics-path_release"})
    public static final class ConicEvaluation
    extends Enum<ConicEvaluation> {
        public static final /* enum */ ConicEvaluation AsConic = new ConicEvaluation();
        public static final /* enum */ ConicEvaluation AsQuadratics = new ConicEvaluation();
        private static final /* synthetic */ ConicEvaluation[] $VALUES;

        public static ConicEvaluation[] values() {
            return (ConicEvaluation[])$VALUES.clone();
        }

        public static ConicEvaluation valueOf(String value) {
            return Enum.valueOf(ConicEvaluation.class, value);
        }

        static {
            $VALUES = conicEvaluationArray = new ConicEvaluation[]{ConicEvaluation.AsConic, ConicEvaluation.AsQuadratics};
        }
    }
}

