/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.annotation.FloatRange;
import androidx.collection.FloatList;
import androidx.collection.MutableFloatList;
import androidx.graphics.shapes.Cubic;
import androidx.graphics.shapes.Feature;
import androidx.graphics.shapes.Measurer;
import androidx.graphics.shapes.PolygonMeasureKt;
import androidx.graphics.shapes.ProgressableFeature;
import androidx.graphics.shapes.RoundedPolygon;
import androidx.graphics.shapes.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.AbstractList;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00182\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0002\u0018\u0019B3\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u0015\u0010\u0016\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0010H\u0096\u0002R\u0018\u0010\b\u001a\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Landroidx/graphics/shapes/MeasuredPolygon;", "Lkotlin/collections/AbstractList;", "Landroidx/graphics/shapes/MeasuredPolygon$MeasuredCubic;", "measurer", "Landroidx/graphics/shapes/Measurer;", "features", "", "Landroidx/graphics/shapes/ProgressableFeature;", "cubics", "Landroidx/graphics/shapes/Cubic;", "outlineProgress", "Landroidx/collection/FloatList;", "(Landroidx/graphics/shapes/Measurer;Ljava/util/List;Ljava/util/List;Landroidx/collection/FloatList;)V", "getFeatures", "()Ljava/util/List;", "size", "", "getSize", "()I", "cutAndShift", "cuttingPoint", "", "get", "index", "Companion", "MeasuredCubic", "graphics-shapes"})
@SourceDebugExtension(value={"SMAP\nPolygonMeasure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolygonMeasure.kt\nandroidx/graphics/shapes/MeasuredPolygon\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Utils.kt\nandroidx/graphics/shapes/Utils\n*L\n1#1,370:1\n350#2,7:371\n152#3,4:378\n*S KotlinDebug\n*F\n+ 1 PolygonMeasure.kt\nandroidx/graphics/shapes/MeasuredPolygon\n*L\n186#1:371,7\n201#1:378,4\n*E\n"})
public final class MeasuredPolygon
extends AbstractList<MeasuredCubic> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Measurer measurer;
    @NotNull
    private final List<MeasuredCubic> cubics;
    @NotNull
    private final List<ProgressableFeature> features;

    @NotNull
    public final List<ProgressableFeature> getFeatures() {
        return this.features;
    }

    private MeasuredPolygon(Measurer measurer, List<ProgressableFeature> features, List<? extends Cubic> cubics, FloatList outlineProgress) {
        if (!(outlineProgress.getSize() == cubics.size() + 1)) {
            boolean $i$a$-require-MeasuredPolygon$42 = false;
            String $i$a$-require-MeasuredPolygon$42 = "Outline progress size is expected to be the cubics size + 1";
            throw new IllegalArgumentException($i$a$-require-MeasuredPolygon$42.toString());
        }
        if (!(outlineProgress.first() == 0.0f)) {
            boolean $i$a$-require-MeasuredPolygon$52 = false;
            String $i$a$-require-MeasuredPolygon$52 = "First outline progress value is expected to be zero";
            throw new IllegalArgumentException($i$a$-require-MeasuredPolygon$52.toString());
        }
        if (!(outlineProgress.last() == 1.0f)) {
            boolean $i$a$-require-MeasuredPolygon$62 = false;
            String $i$a$-require-MeasuredPolygon$62 = "Last outline progress value is expected to be one";
            throw new IllegalArgumentException($i$a$-require-MeasuredPolygon$62.toString());
        }
        this.measurer = measurer;
        this.features = features;
        List measuredCubics = new ArrayList();
        float startOutlineProgress = 0.0f;
        int n = cubics.size();
        for (int index = 0; index < n; ++index) {
            if (!(outlineProgress.get(index + 1) - outlineProgress.get(index) > 1.0E-4f)) continue;
            measuredCubics.add(new MeasuredCubic(cubics.get(index), startOutlineProgress, outlineProgress.get(index + 1)));
            startOutlineProgress = outlineProgress.get(index + 1);
        }
        MeasuredCubic.updateProgressRange$graphics_shapes$default((MeasuredCubic)measuredCubics.get(CollectionsKt.getLastIndex((List)measuredCubics)), 0.0f, 1.0f, 1, null);
        this.cubics = measuredCubics;
    }

    @NotNull
    public final MeasuredPolygon cutAndShift(float cuttingPoint) {
        List list;
        int n;
        int n2;
        block11: {
            if (!(0.0f <= cuttingPoint ? cuttingPoint <= 1.0f : false)) {
                boolean $i$a$-require-MeasuredPolygon$cutAndShift$22 = false;
                String $i$a$-require-MeasuredPolygon$cutAndShift$22 = "Cutting point is expected to be between 0 and 1";
                throw new IllegalArgumentException($i$a$-require-MeasuredPolygon$cutAndShift$22.toString());
            }
            if (cuttingPoint < 1.0E-4f) {
                return this;
            }
            List<MeasuredCubic> $this$indexOfFirst$iv = this.cubics;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<MeasuredCubic> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                MeasuredCubic item$iv;
                MeasuredCubic it = item$iv = iterator.next();
                n2 = 0;
                float f = it.getStartOutlineProgress();
                boolean bl = cuttingPoint <= it.getEndOutlineProgress() ? f <= cuttingPoint : false;
                if (bl) {
                    n = index$iv;
                    break block11;
                }
                ++index$iv;
            }
            n = -1;
        }
        int targetIndex = n;
        MeasuredCubic target = this.cubics.get(targetIndex);
        Pair<MeasuredCubic, MeasuredCubic> pair = target.cutAtProgress(cuttingPoint);
        MeasuredCubic b1 = (MeasuredCubic)pair.component1();
        MeasuredCubic b2 = (MeasuredCubic)pair.component2();
        String tag$iv = PolygonMeasureKt.access$getLOG_TAG$p();
        boolean $i$f$debugLog22 = false;
        Object[] $i$f$debugLog22 = new Cubic[]{b2.getCubic()};
        List retCubics = CollectionsKt.mutableListOf((Object[])$i$f$debugLog22);
        n2 = this.cubics.size();
        for (int i = 1; i < n2; ++i) {
            retCubics.add(this.cubics.get((i + targetIndex) % this.cubics.size()).getCubic());
        }
        retCubics.add(b1.getCubic());
        MutableFloatList retOutlineProgress = new MutableFloatList(this.cubics.size() + 2);
        int n3 = this.cubics.size() + 2;
        for (int index = 0; index < n3; ++index) {
            float f;
            int n4 = index;
            if (n4 == 0) {
                f = 0.0f;
            } else if (n4 == this.cubics.size() + 1) {
                f = 1.0f;
            } else {
                int cubicIndex = (targetIndex + index - 1) % this.cubics.size();
                f = Utils.positiveModulo(this.cubics.get(cubicIndex).getEndOutlineProgress() - cuttingPoint, 1.0f);
            }
            retOutlineProgress.add(f);
        }
        List $this$cutAndShift_u24lambda_u2410 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int n5 = this.features.size();
        for (int i = 0; i < n5; ++i) {
            $this$cutAndShift_u24lambda_u2410.add(new ProgressableFeature(Utils.positiveModulo(this.features.get(i).getProgress() - cuttingPoint, 1.0f), this.features.get(i).getFeature()));
        }
        List newFeatures = CollectionsKt.build((List)list);
        return new MeasuredPolygon(this.measurer, newFeatures, retCubics, (FloatList)retOutlineProgress);
    }

    public int getSize() {
        return this.cubics.size();
    }

    @NotNull
    public MeasuredCubic get(int index) {
        return this.cubics.get(index);
    }

    public /* synthetic */ MeasuredPolygon(Measurer measurer, List features, List cubics, FloatList outlineProgress, DefaultConstructorMarker $constructor_marker) {
        this(measurer, features, cubics, outlineProgress);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Landroidx/graphics/shapes/MeasuredPolygon$Companion;", "", "()V", "measurePolygon", "Landroidx/graphics/shapes/MeasuredPolygon;", "measurer", "Landroidx/graphics/shapes/Measurer;", "polygon", "Landroidx/graphics/shapes/RoundedPolygon;", "measurePolygon$graphics_shapes", "graphics-shapes"})
    @SourceDebugExtension(value={"SMAP\nPolygonMeasure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolygonMeasure.kt\nandroidx/graphics/shapes/MeasuredPolygon$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Utils.kt\nandroidx/graphics/shapes/Utils\n*L\n1#1,370:1\n2949#2:371\n2847#2,3:372\n2850#2,6:376\n1#3:375\n152#4,4:382\n*S KotlinDebug\n*F\n+ 1 PolygonMeasure.kt\nandroidx/graphics/shapes/MeasuredPolygon$Companion\n*L\n277#1:371\n277#1:372,3\n277#1:376,6\n277#1:375\n292#1:382,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MeasuredPolygon measurePolygon$graphics_shapes(@NotNull Measurer measurer, @NotNull RoundedPolygon polygon) {
            List list;
            List list2;
            void $this$scan$iv;
            Intrinsics.checkNotNullParameter((Object)measurer, (String)"measurer");
            Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
            List cubics = new ArrayList();
            List featureToCubic = new ArrayList();
            int n = polygon.getFeatures$graphics_shapes().size();
            for (int featureIndex = 0; featureIndex < n; ++featureIndex) {
                Feature feature = polygon.getFeatures$graphics_shapes().get(featureIndex);
                int n2 = feature.getCubics().size();
                for (int cubicIndex = 0; cubicIndex < n2; ++cubicIndex) {
                    if (feature instanceof Feature.Corner && cubicIndex == feature.getCubics().size() / 2) {
                        featureToCubic.add(TuplesKt.to((Object)feature, (Object)cubics.size()));
                    }
                    cubics.add(feature.getCubics().get(cubicIndex));
                }
            }
            Iterable iterable = cubics;
            Float initial$iv = Float.valueOf(0.0f);
            boolean $i$f$scan = false;
            void $this$runningFold$iv$iv22 = $this$scan$iv;
            boolean $i$f$runningFold = false;
            int estimatedSize$iv$iv = CollectionsKt.collectionSizeOrDefault((Iterable)$this$runningFold$iv$iv22, (int)9);
            if (estimatedSize$iv$iv == 0) {
                list2 = CollectionsKt.listOf((Object)initial$iv);
            } else {
                ArrayList<Float> arrayList;
                ArrayList<Float> $this$runningFold_u24lambda_u2418$iv$iv = arrayList = new ArrayList<Float>(estimatedSize$iv$iv + 1);
                boolean bl = false;
                $this$runningFold_u24lambda_u2418$iv$iv.add(initial$iv);
                ArrayList<Float> result$iv$iv = arrayList;
                Float accumulator$iv$iv = initial$iv;
                for (Object element$iv$iv : $this$runningFold$iv$iv22) {
                    void it;
                    void cubic;
                    float f;
                    Cubic cubic2 = (Cubic)element$iv$iv;
                    float measure = ((Number)accumulator$iv$iv).floatValue();
                    boolean bl2 = false;
                    float f2 = f = measurer.measureCubic((Cubic)cubic);
                    float f3 = measure;
                    boolean bl3 = false;
                    if (!(it >= 0.0f)) {
                        boolean bl4 = false;
                        String string = "Measured cubic is expected to be greater or equal to zero";
                        throw new IllegalArgumentException(string.toString());
                    }
                    Unit unit = Unit.INSTANCE;
                    accumulator$iv$iv = Float.valueOf(f3 + f);
                    result$iv$iv.add(accumulator$iv$iv);
                }
                list2 = result$iv$iv;
            }
            List measures = list2;
            float totalMeasure = ((Number)CollectionsKt.last((List)measures)).floatValue();
            MutableFloatList outlineProgress = new MutableFloatList(measures.size());
            int $this$runningFold$iv$iv22 = measures.size();
            for (int i = 0; i < $this$runningFold$iv$iv22; ++i) {
                outlineProgress.add(((Number)measures.get(i)).floatValue() / totalMeasure);
            }
            String tag$iv = PolygonMeasureKt.access$getLOG_TAG$p();
            boolean $i$f$debugLog = false;
            List $this$measurePolygon_u24lambda_u244 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            int n3 = featureToCubic.size();
            for (int i = 0; i < n3; ++i) {
                int ix = ((Number)((Pair)featureToCubic.get(i)).getSecond()).intValue();
                $this$measurePolygon_u24lambda_u244.add(new ProgressableFeature((outlineProgress.get(ix) + outlineProgress.get(ix + 1)) / (float)2, (Feature)((Pair)featureToCubic.get(i)).getFirst()));
            }
            List features = CollectionsKt.build((List)list);
            return new MeasuredPolygon(measurer, features, cubics, (FloatList)outlineProgress, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\"\u0010\u0010\u001a\u0016\u0012\b\u0012\u00060\u0000R\u00020\u0012\u0012\b\u0012\u00060\u0000R\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0016J!\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0019"}, d2={"Landroidx/graphics/shapes/MeasuredPolygon$MeasuredCubic;", "", "cubic", "Landroidx/graphics/shapes/Cubic;", "startOutlineProgress", "", "endOutlineProgress", "(Landroidx/graphics/shapes/MeasuredPolygon;Landroidx/graphics/shapes/Cubic;FF)V", "getCubic", "()Landroidx/graphics/shapes/Cubic;", "<set-?>", "getEndOutlineProgress", "()F", "measuredSize", "getMeasuredSize", "getStartOutlineProgress", "cutAtProgress", "Lkotlin/Pair;", "Landroidx/graphics/shapes/MeasuredPolygon;", "cutOutlineProgress", "toString", "", "updateProgressRange", "", "updateProgressRange$graphics_shapes", "graphics-shapes"})
    @SourceDebugExtension(value={"SMAP\nPolygonMeasure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolygonMeasure.kt\nandroidx/graphics/shapes/MeasuredPolygon$MeasuredCubic\n+ 2 Utils.kt\nandroidx/graphics/shapes/Utils\n*L\n1#1,370:1\n152#2,4:371\n*S KotlinDebug\n*F\n+ 1 PolygonMeasure.kt\nandroidx/graphics/shapes/MeasuredPolygon$MeasuredCubic\n*L\n135#1:371,4\n*E\n"})
    public final class MeasuredCubic {
        @NotNull
        private final Cubic cubic;
        private final float measuredSize;
        private float startOutlineProgress;
        private float endOutlineProgress;

        public MeasuredCubic(@FloatRange(from=0.0, to=1.0) Cubic cubic, @FloatRange(from=0.0, to=1.0) float startOutlineProgress, float endOutlineProgress) {
            Intrinsics.checkNotNullParameter((Object)cubic, (String)"cubic");
            this.cubic = cubic;
            if (!(endOutlineProgress >= startOutlineProgress)) {
                boolean bl = false;
                String string = "endOutlineProgress is expected to be equal or greater than startOutlineProgress";
                throw new IllegalArgumentException(string.toString());
            }
            this.measuredSize = MeasuredPolygon.this.measurer.measureCubic(this.cubic);
            this.startOutlineProgress = startOutlineProgress;
            this.endOutlineProgress = endOutlineProgress;
        }

        @NotNull
        public final Cubic getCubic() {
            return this.cubic;
        }

        public final float getMeasuredSize() {
            return this.measuredSize;
        }

        public final float getStartOutlineProgress() {
            return this.startOutlineProgress;
        }

        public final float getEndOutlineProgress() {
            return this.endOutlineProgress;
        }

        public final void updateProgressRange$graphics_shapes(float startOutlineProgress, float endOutlineProgress) {
            if (!(endOutlineProgress >= startOutlineProgress)) {
                boolean bl = false;
                String string = "endOutlineProgress is expected to be equal or greater than startOutlineProgress";
                throw new IllegalArgumentException(string.toString());
            }
            this.startOutlineProgress = startOutlineProgress;
            this.endOutlineProgress = endOutlineProgress;
        }

        public static /* synthetic */ void updateProgressRange$graphics_shapes$default(MeasuredCubic measuredCubic, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                f = measuredCubic.startOutlineProgress;
            }
            if ((n & 2) != 0) {
                f2 = measuredCubic.endOutlineProgress;
            }
            measuredCubic.updateProgressRange$graphics_shapes(f, f2);
        }

        @NotNull
        public final Pair<MeasuredCubic, MeasuredCubic> cutAtProgress(float cutOutlineProgress) {
            float outlineProgressSize = this.endOutlineProgress - this.startOutlineProgress;
            float progressFromStart = Utils.positiveModulo(cutOutlineProgress - this.startOutlineProgress, 1.0f);
            float mid = progressFromStart > (1.0f + outlineProgressSize) / (float)2 ? 0.0f : RangesKt.coerceAtMost((float)progressFromStart, (float)outlineProgressSize);
            float relativeMidProgress = mid / outlineProgressSize;
            float t = MeasuredPolygon.this.measurer.findCubicCutPoint(this.cubic, relativeMidProgress * this.measuredSize);
            if (!(0.0f <= t ? t <= 1.0f : false)) {
                boolean $i$a$-require-MeasuredPolygon$MeasuredCubic$cutAtProgress$22 = false;
                String $i$a$-require-MeasuredPolygon$MeasuredCubic$cutAtProgress$22 = "Cubic cut point is expected to be between 0 and 1";
                throw new IllegalArgumentException($i$a$-require-MeasuredPolygon$MeasuredCubic$cutAtProgress$22.toString());
            }
            String tag$iv = PolygonMeasureKt.access$getLOG_TAG$p();
            boolean $i$f$debugLog = false;
            Pair<Cubic, Cubic> pair = this.cubic.split(t);
            Cubic c1 = (Cubic)pair.component1();
            Cubic c2 = (Cubic)pair.component2();
            return TuplesKt.to((Object)new MeasuredCubic(c1, this.startOutlineProgress, cutOutlineProgress), (Object)new MeasuredCubic(c2, cutOutlineProgress, this.endOutlineProgress));
        }

        @NotNull
        public String toString() {
            return "MeasuredCubic(outlineProgress=[" + this.startOutlineProgress + " .. " + this.endOutlineProgress + "], size=" + this.measuredSize + ", cubic=" + this.cubic + ')';
        }
    }
}

