/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.graphics.shapes.AngleMeasurer;
import androidx.graphics.shapes.Cubic;
import androidx.graphics.shapes.DoubleMapper;
import androidx.graphics.shapes.FeatureMappingKt;
import androidx.graphics.shapes.MeasuredPolygon;
import androidx.graphics.shapes.MorphKt;
import androidx.graphics.shapes.MutableCubic;
import androidx.graphics.shapes.ProgressableFeature;
import androidx.graphics.shapes.RoundedPolygon;
import androidx.graphics.shapes.Utils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0010\u001a\u00020\u0011J2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00130\u0017H\u0087\b\u00f8\u0001\u0000R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u00078@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0019"}, d2={"Landroidx/graphics/shapes/Morph;", "", "start", "Landroidx/graphics/shapes/RoundedPolygon;", "end", "(Landroidx/graphics/shapes/RoundedPolygon;Landroidx/graphics/shapes/RoundedPolygon;)V", "_morphMatch", "", "Lkotlin/Pair;", "Landroidx/graphics/shapes/Cubic;", "morphMatch", "getMorphMatch$annotations", "()V", "getMorphMatch", "()Ljava/util/List;", "asCubics", "progress", "", "forEachCubic", "", "mutableCubic", "Landroidx/graphics/shapes/MutableCubic;", "callback", "Lkotlin/Function1;", "Companion", "graphics-shapes"})
@SourceDebugExtension(value={"SMAP\nMorph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Morph.kt\nandroidx/graphics/shapes/Morph\n*L\n1#1,265:1\n98#1,10:266\n*S KotlinDebug\n*F\n+ 1 Morph.kt\nandroidx/graphics/shapes/Morph\n*L\n-1#1:266,10\n*E\n"})
public final class Morph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Pair<Cubic, Cubic>> _morphMatch;

    public Morph(@NotNull RoundedPolygon start, @NotNull RoundedPolygon end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this._morphMatch = Companion.match$graphics_shapes(start, end);
    }

    @NotNull
    public final List<Pair<Cubic, Cubic>> getMorphMatch() {
        return this._morphMatch;
    }

    @PublishedApi
    public static /* synthetic */ void getMorphMatch$annotations() {
    }

    @NotNull
    public final List<Cubic> asCubics(float progress) {
        List list;
        List $this$asCubics_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int n = this._morphMatch.size();
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            float[] fArray = new float[8];
            while (n2 < 8) {
                int n3 = n2++;
                fArray[n3] = Utils.interpolate(((Cubic)this._morphMatch.get(i).getFirst()).getPoints$graphics_shapes()[n3], ((Cubic)this._morphMatch.get(i).getSecond()).getPoints$graphics_shapes()[n3], progress);
            }
            float[] fArray2 = fArray;
            new Cubic(fArray2);
        }
        return CollectionsKt.build((List)list);
    }

    @JvmOverloads
    public final void forEachCubic(float progress, @NotNull MutableCubic mutableCubic, @NotNull Function1<? super MutableCubic, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)mutableCubic, (String)"mutableCubic");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        boolean $i$f$forEachCubic = false;
        int n = this.getMorphMatch().size();
        for (int i = 0; i < n; ++i) {
            mutableCubic.interpolate((Cubic)this.getMorphMatch().get(i).getFirst(), (Cubic)this.getMorphMatch().get(i).getSecond(), progress);
            callback.invoke((Object)mutableCubic);
        }
    }

    public static /* synthetic */ void forEachCubic$default(Morph $this, float progress, MutableCubic mutableCubic, Function1 callback, int n, Object object) {
        if ((n & 2) != 0) {
            mutableCubic = new MutableCubic();
        }
        Intrinsics.checkNotNullParameter((Object)mutableCubic, (String)"mutableCubic");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        boolean $i$f$forEachCubic = false;
        int n2 = $this.getMorphMatch().size();
        for (int i = 0; i < n2; ++i) {
            mutableCubic.interpolate((Cubic)$this.getMorphMatch().get(i).getFirst(), (Cubic)$this.getMorphMatch().get(i).getSecond(), progress);
            callback.invoke((Object)mutableCubic);
        }
    }

    @JvmOverloads
    public final void forEachCubic(float progress, @NotNull Function1<? super MutableCubic, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        boolean $i$f$forEachCubic = false;
        MutableCubic mutableCubic$iv = new MutableCubic();
        boolean $i$f$forEachCubic2 = false;
        int n = this.getMorphMatch().size();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            mutableCubic$iv.interpolate((Cubic)this.getMorphMatch().get(i$iv).getFirst(), (Cubic)this.getMorphMatch().get(i$iv).getSecond(), progress);
            callback.invoke((Object)mutableCubic$iv);
        }
    }

    @JvmStatic
    @NotNull
    public static final List<Pair<Cubic, Cubic>> match$graphics_shapes(@NotNull RoundedPolygon p1, @NotNull RoundedPolygon p2) {
        return Companion.match$graphics_shapes(p1, p2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Landroidx/graphics/shapes/Morph$Companion;", "", "()V", "match", "", "Lkotlin/Pair;", "Landroidx/graphics/shapes/Cubic;", "p1", "Landroidx/graphics/shapes/RoundedPolygon;", "p2", "match$graphics_shapes", "graphics-shapes"})
    @SourceDebugExtension(value={"SMAP\nMorph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Morph.kt\nandroidx/graphics/shapes/Morph$Companion\n+ 2 Utils.kt\nandroidx/graphics/shapes/Utils\n*L\n1#1,265:1\n152#2,4:266\n152#2,4:270\n152#2,4:274\n152#2,4:278\n152#2,4:282\n*S KotlinDebug\n*F\n+ 1 Morph.kt\nandroidx/graphics/shapes/Morph$Companion\n*L\n170#1:266,4\n212#1:270,4\n217#1:274,4\n223#1:278,4\n228#1:282,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<Pair<Cubic, Cubic>> match$graphics_shapes(@NotNull RoundedPolygon p1, @NotNull RoundedPolygon p2) {
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            MeasuredPolygon measuredPolygon1 = MeasuredPolygon.Companion.measurePolygon$graphics_shapes(new AngleMeasurer(p1.getCenterX(), p1.getCenterY()), p1);
            MeasuredPolygon measuredPolygon2 = MeasuredPolygon.Companion.measurePolygon$graphics_shapes(new AngleMeasurer(p2.getCenterX(), p2.getCenterY()), p2);
            List<ProgressableFeature> features1 = measuredPolygon1.getFeatures();
            List<ProgressableFeature> features2 = measuredPolygon2.getFeatures();
            DoubleMapper doubleMapper = FeatureMappingKt.featureMapper(features1, features2);
            float polygon2CutPoint = doubleMapper.map(0.0f);
            String tag$iv = MorphKt.access$getLOG_TAG$p();
            boolean $i$f$debugLog = false;
            MeasuredPolygon bs1 = measuredPolygon1;
            MeasuredPolygon bs2 = measuredPolygon2.cutAndShift(polygon2CutPoint);
            List ret = new ArrayList();
            int i1 = 0;
            int i2 = 0;
            MeasuredPolygon.MeasuredCubic b1 = (MeasuredPolygon.MeasuredCubic)CollectionsKt.getOrNull((List)((List)((Object)bs1)), (int)i1++);
            MeasuredPolygon.MeasuredCubic b2 = (MeasuredPolygon.MeasuredCubic)CollectionsKt.getOrNull((List)((List)((Object)bs2)), (int)i2++);
            while (b1 != null && b2 != null) {
                Pair<MeasuredPolygon.MeasuredCubic, MeasuredPolygon.MeasuredCubic> pair;
                Pair<MeasuredPolygon.MeasuredCubic, MeasuredPolygon.MeasuredCubic> pair2;
                float b1a = i1 == bs1.size() ? 1.0f : b1.getEndOutlineProgress();
                float b2a = i2 == bs2.size() ? 1.0f : doubleMapper.mapBack(Utils.positiveModulo(b2.getEndOutlineProgress() + polygon2CutPoint, 1.0f));
                float minb = Math.min(b1a, b2a);
                String tag$iv2 = MorphKt.access$getLOG_TAG$p();
                boolean $i$f$debugLog2 = false;
                if (b1a > minb + 1.0E-6f) {
                    String tag$iv3 = MorphKt.access$getLOG_TAG$p();
                    boolean $i$f$debugLog3 = false;
                    pair2 = b1.cutAtProgress(minb);
                } else {
                    pair2 = TuplesKt.to((Object)b1, (Object)CollectionsKt.getOrNull((List)((List)((Object)bs1)), (int)i1++));
                }
                Pair<MeasuredPolygon.MeasuredCubic, MeasuredPolygon.MeasuredCubic> pair3 = pair2;
                MeasuredPolygon.MeasuredCubic seg1 = (MeasuredPolygon.MeasuredCubic)pair3.component1();
                MeasuredPolygon.MeasuredCubic newb1 = (MeasuredPolygon.MeasuredCubic)pair3.component2();
                if (b2a > minb + 1.0E-6f) {
                    String tag$iv4 = MorphKt.access$getLOG_TAG$p();
                    boolean $i$f$debugLog4 = false;
                    pair = b2.cutAtProgress(Utils.positiveModulo(doubleMapper.map(minb) - polygon2CutPoint, 1.0f));
                } else {
                    pair = TuplesKt.to((Object)b2, (Object)CollectionsKt.getOrNull((List)((List)((Object)bs2)), (int)i2++));
                }
                Pair<MeasuredPolygon.MeasuredCubic, MeasuredPolygon.MeasuredCubic> pair4 = pair;
                MeasuredPolygon.MeasuredCubic seg2 = (MeasuredPolygon.MeasuredCubic)pair4.component1();
                MeasuredPolygon.MeasuredCubic newb2 = (MeasuredPolygon.MeasuredCubic)pair4.component2();
                String tag$iv5 = MorphKt.access$getLOG_TAG$p();
                boolean $i$f$debugLog5 = false;
                ret.add(TuplesKt.to((Object)seg1.getCubic(), (Object)seg2.getCubic()));
                b1 = newb1;
                b2 = newb2;
            }
            if (!(b1 == null && b2 == null)) {
                boolean bl = false;
                String string = "Expected both Polygon's Cubic to be fully matched";
                throw new IllegalArgumentException(string.toString());
            }
            return ret;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

