/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.collection.FloatFloatPair;
import androidx.graphics.shapes.CornerRounding;
import androidx.graphics.shapes.Cubic;
import androidx.graphics.shapes.PointKt;
import androidx.graphics.shapes.Utils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B5\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u0011H\u0002Jf\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00112\n\u0010-\u001a\u00060\u0003j\u0002`\u00042\n\u0010.\u001a\u00060\u0003j\u0002`\u00042\n\u0010/\u001a\u00060\u0003j\u0002`\u00042\n\u00100\u001a\u00060\u0003j\u0002`\u00042\n\u00101\u001a\u00060\u0003j\u0002`\u00042\u0006\u00102\u001a\u00020\u0011H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b3\u00104J \u00105\u001a\b\u0012\u0004\u0012\u00020*062\u0006\u00107\u001a\u00020\u00112\b\b\u0002\u00108\u001a\u00020\u0011H\u0007JJ\u00109\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00042\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\n\u0010:\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u00042\n\u0010\u0016\u001a\u00060\u0003j\u0002`\u0004H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b;\u0010<R&\u0010\n\u001a\u00060\u0003j\u0002`\u0004X\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001d\u0010\u0016\u001a\u00060\u0003j\u0002`\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0017\u0010\fR\u001d\u0010\u0018\u001a\u00060\u0003j\u0002`\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0019\u0010\fR\u0011\u0010\u001a\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u001c\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u001d\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u001e\u0010\fR\u001d\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u001f\u0010\fR\u001d\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b \u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0013R\u0011\u0010%\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0013\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006="}, d2={"Landroidx/graphics/shapes/RoundedCorner;", "", "p0", "Landroidx/collection/FloatFloatPair;", "Landroidx/graphics/shapes/Point;", "p1", "p2", "rounding", "Landroidx/graphics/shapes/CornerRounding;", "(JJJLandroidx/graphics/shapes/CornerRounding;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "center", "getCenter-1ufDz9w", "()J", "setCenter-DnnuFBc", "(J)V", "J", "cornerRadius", "", "getCornerRadius", "()F", "cosAngle", "getCosAngle", "d1", "getD1-1ufDz9w", "d2", "getD2-1ufDz9w", "expectedCut", "getExpectedCut", "expectedRoundCut", "getExpectedRoundCut", "getP0-1ufDz9w", "getP1-1ufDz9w", "getP2-1ufDz9w", "getRounding", "()Landroidx/graphics/shapes/CornerRounding;", "sinAngle", "getSinAngle", "smoothing", "getSmoothing", "calculateActualSmoothingValue", "allowedCut", "computeFlankingCurve", "Landroidx/graphics/shapes/Cubic;", "actualRoundCut", "actualSmoothingValues", "corner", "sideStart", "circleSegmentIntersection", "otherCircleSegmentIntersection", "circleCenter", "actualR", "computeFlankingCurve-oAJzIJU", "(FFJJJJJF)Landroidx/graphics/shapes/Cubic;", "getCubics", "", "allowedCut0", "allowedCut1", "lineIntersection", "d0", "lineIntersection-CBFvKDc", "(JJJJ)Landroidx/collection/FloatFloatPair;", "graphics-shapes"})
final class RoundedCorner {
    private final long p0;
    private final long p1;
    private final long p2;
    @Nullable
    private final CornerRounding rounding;
    private final long d1;
    private final long d2;
    private final float cornerRadius;
    private final float smoothing;
    private final float cosAngle;
    private final float sinAngle;
    private final float expectedRoundCut;
    private long center;

    private RoundedCorner(long p0, long p1, long p2, CornerRounding rounding) {
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
        this.rounding = rounding;
        this.d1 = PointKt.getDirection-DnnuFBc(PointKt.minus-ybeJwSQ(this.p0, this.p1));
        this.d2 = PointKt.getDirection-DnnuFBc(PointKt.minus-ybeJwSQ(this.p2, this.p1));
        CornerRounding cornerRounding = this.rounding;
        this.cornerRadius = cornerRounding != null ? cornerRounding.getRadius() : 0.0f;
        CornerRounding cornerRounding2 = this.rounding;
        this.smoothing = cornerRounding2 != null ? cornerRounding2.getSmoothing() : 0.0f;
        this.cosAngle = PointKt.dotProduct-ybeJwSQ(this.d1, this.d2);
        this.sinAngle = (float)Math.sqrt(1.0f - Utils.square(this.cosAngle));
        this.expectedRoundCut = (double)this.sinAngle > 0.001 ? this.cornerRadius * (this.cosAngle + 1.0f) / this.sinAngle : 0.0f;
        this.center = FloatFloatPair.constructor-impl((float)0.0f, (float)0.0f);
    }

    public /* synthetic */ RoundedCorner(long l, long l2, long l3, CornerRounding cornerRounding, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            cornerRounding = null;
        }
        this(l, l2, l3, cornerRounding, null);
    }

    public final long getP0-1ufDz9w() {
        return this.p0;
    }

    public final long getP1-1ufDz9w() {
        return this.p1;
    }

    public final long getP2-1ufDz9w() {
        return this.p2;
    }

    @Nullable
    public final CornerRounding getRounding() {
        return this.rounding;
    }

    public final long getD1-1ufDz9w() {
        return this.d1;
    }

    public final long getD2-1ufDz9w() {
        return this.d2;
    }

    public final float getCornerRadius() {
        return this.cornerRadius;
    }

    public final float getSmoothing() {
        return this.smoothing;
    }

    public final float getCosAngle() {
        return this.cosAngle;
    }

    public final float getSinAngle() {
        return this.sinAngle;
    }

    public final float getExpectedRoundCut() {
        return this.expectedRoundCut;
    }

    public final float getExpectedCut() {
        return (1.0f + this.smoothing) * this.expectedRoundCut;
    }

    public final long getCenter-1ufDz9w() {
        return this.center;
    }

    public final void setCenter-DnnuFBc(long l) {
        this.center = l;
    }

    @JvmOverloads
    @NotNull
    public final List<Cubic> getCubics(float allowedCut0, float allowedCut1) {
        float allowedCut = Math.min(allowedCut0, allowedCut1);
        if (this.expectedRoundCut < 1.0E-4f || allowedCut < 1.0E-4f || this.cornerRadius < 1.0E-4f) {
            this.center = this.p1;
            return CollectionsKt.listOf((Object)Cubic.Companion.straightLine(PointKt.getX-DnnuFBc(this.p1), PointKt.getY-DnnuFBc(this.p1), PointKt.getX-DnnuFBc(this.p1), PointKt.getY-DnnuFBc(this.p1)));
        }
        float actualRoundCut = Math.min(allowedCut, this.expectedRoundCut);
        float actualSmoothing0 = this.calculateActualSmoothingValue(allowedCut0);
        float actualSmoothing1 = this.calculateActualSmoothingValue(allowedCut1);
        float actualR = this.cornerRadius * actualRoundCut / this.expectedRoundCut;
        float centerDistance = (float)Math.sqrt(Utils.square(actualR) + Utils.square(actualRoundCut));
        this.center = PointKt.plus-ybeJwSQ(this.p1, PointKt.times-so9K2fw(PointKt.getDirection-DnnuFBc(PointKt.div-so9K2fw(PointKt.plus-ybeJwSQ(this.d1, this.d2), 2.0f)), centerDistance));
        long circleIntersection0 = PointKt.plus-ybeJwSQ(this.p1, PointKt.times-so9K2fw(this.d1, actualRoundCut));
        long circleIntersection2 = PointKt.plus-ybeJwSQ(this.p1, PointKt.times-so9K2fw(this.d2, actualRoundCut));
        Cubic flanking0 = this.computeFlankingCurve-oAJzIJU(actualRoundCut, actualSmoothing0, this.p1, this.p0, circleIntersection0, circleIntersection2, this.center, actualR);
        Cubic flanking2 = this.computeFlankingCurve-oAJzIJU(actualRoundCut, actualSmoothing1, this.p1, this.p2, circleIntersection2, circleIntersection0, this.center, actualR).reverse();
        Object[] objectArray = new Cubic[]{flanking0, Cubic.Companion.circularArc(PointKt.getX-DnnuFBc(this.center), PointKt.getY-DnnuFBc(this.center), flanking0.getAnchor1X(), flanking0.getAnchor1Y(), flanking2.getAnchor0X(), flanking2.getAnchor0Y()), flanking2};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public static /* synthetic */ List getCubics$default(RoundedCorner roundedCorner, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = f;
        }
        return roundedCorner.getCubics(f, f2);
    }

    private final float calculateActualSmoothingValue(float allowedCut) {
        return allowedCut > this.getExpectedCut() ? this.smoothing : (allowedCut > this.expectedRoundCut ? this.smoothing * (allowedCut - this.expectedRoundCut) / (this.getExpectedCut() - this.expectedRoundCut) : 0.0f);
    }

    private final Cubic computeFlankingCurve-oAJzIJU(float actualRoundCut, float actualSmoothingValues, long corner, long sideStart, long circleSegmentIntersection, long otherCircleSegmentIntersection, long circleCenter, float actualR) {
        long sideDirection = PointKt.getDirection-DnnuFBc(PointKt.minus-ybeJwSQ(sideStart, corner));
        long curveStart = PointKt.plus-ybeJwSQ(corner, PointKt.times-so9K2fw(PointKt.times-so9K2fw(sideDirection, actualRoundCut), 1.0f + actualSmoothingValues));
        long p = PointKt.interpolate-dLqxh1s(circleSegmentIntersection, PointKt.div-so9K2fw(PointKt.plus-ybeJwSQ(circleSegmentIntersection, otherCircleSegmentIntersection), 2.0f), actualSmoothingValues);
        long curveEnd = PointKt.plus-ybeJwSQ(circleCenter, PointKt.times-so9K2fw(Utils.directionVector(PointKt.getX-DnnuFBc(p) - PointKt.getX-DnnuFBc(circleCenter), PointKt.getY-DnnuFBc(p) - PointKt.getY-DnnuFBc(circleCenter)), actualR));
        long circleTangent = Utils.rotate90-DnnuFBc(PointKt.minus-ybeJwSQ(curveEnd, circleCenter));
        FloatFloatPair floatFloatPair = this.lineIntersection-CBFvKDc(sideStart, sideDirection, curveEnd, circleTangent);
        long anchorEnd = floatFloatPair != null ? floatFloatPair.unbox-impl() : circleSegmentIntersection;
        long anchorStart = PointKt.div-so9K2fw(PointKt.plus-ybeJwSQ(curveStart, PointKt.times-so9K2fw(anchorEnd, 2.0f)), 3.0f);
        return new Cubic(curveStart, anchorStart, anchorEnd, curveEnd, null);
    }

    private final FloatFloatPair lineIntersection-CBFvKDc(long p0, long d0, long p1, long d1) {
        long rotatedD1 = Utils.rotate90-DnnuFBc(d1);
        float den = PointKt.dotProduct-ybeJwSQ(d0, rotatedD1);
        if (Math.abs(den) < 1.0E-4f) {
            return null;
        }
        float num = PointKt.dotProduct-ybeJwSQ(PointKt.minus-ybeJwSQ(p1, p0), rotatedD1);
        if (Math.abs(den) < 1.0E-4f * Math.abs(num)) {
            return null;
        }
        float k = num / den;
        return FloatFloatPair.box-impl((long)PointKt.plus-ybeJwSQ(p0, PointKt.times-so9K2fw(d0, k)));
    }

    @JvmOverloads
    @NotNull
    public final List<Cubic> getCubics(float allowedCut0) {
        return RoundedCorner.getCubics$default(this, allowedCut0, 0.0f, 2, null);
    }

    public /* synthetic */ RoundedCorner(long p0, long p1, long p2, CornerRounding rounding, DefaultConstructorMarker $constructor_marker) {
        this(p0, p1, p2, rounding);
    }
}

