/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.annotation.IntRange;
import androidx.graphics.shapes.CornerRounding;
import androidx.graphics.shapes.RoundedPolygon;
import androidx.graphics.shapes.RoundedPolygonKt;
import androidx.graphics.shapes.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u001a4\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0003\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u0007\u001aN\u0010\t\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\r2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u000f2\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006\u001ad\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u000f2\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u0007\u00a8\u0006\u0014"}, d2={"circle", "Landroidx/graphics/shapes/RoundedPolygon;", "Landroidx/graphics/shapes/RoundedPolygon$Companion;", "numVertices", "", "radius", "", "centerX", "centerY", "rectangle", "width", "height", "rounding", "Landroidx/graphics/shapes/CornerRounding;", "perVertexRounding", "", "star", "numVerticesPerRadius", "innerRadius", "innerRounding", "graphics-shapes"})
@SourceDebugExtension(value={"SMAP\nShapes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shapes.kt\nandroidx/graphics/shapes/ShapesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1360#2:161\n1446#2,5:162\n*S KotlinDebug\n*F\n+ 1 Shapes.kt\nandroidx/graphics/shapes/ShapesKt\n*L\n149#1:161\n149#1:162,5\n*E\n"})
public final class ShapesKt {
    @JvmOverloads
    @NotNull
    public static final RoundedPolygon circle(@NotNull RoundedPolygon.Companion $this$circle, @IntRange(from=3L) int numVertices, float radius, float centerX, float centerY) {
        Intrinsics.checkNotNullParameter((Object)$this$circle, (String)"<this>");
        if (numVertices < 3) {
            throw new IllegalArgumentException("Circle must have at least three vertices");
        }
        float theta = Utils.getFloatPi() / (float)numVertices;
        float polygonRadius = radius / (float)Math.cos(theta);
        CornerRounding cornerRounding = new CornerRounding(radius, 0.0f, 2, null);
        return RoundedPolygonKt.RoundedPolygon$default(numVertices, polygonRadius, centerX, centerY, cornerRounding, null, 32, null);
    }

    public static /* synthetic */ RoundedPolygon circle$default(RoundedPolygon.Companion companion, int n, float f, float f2, float f3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 8;
        }
        if ((n2 & 2) != 0) {
            f = 1.0f;
        }
        if ((n2 & 4) != 0) {
            f2 = 0.0f;
        }
        if ((n2 & 8) != 0) {
            f3 = 0.0f;
        }
        return ShapesKt.circle(companion, n, f, f2, f3);
    }

    @NotNull
    public static final RoundedPolygon rectangle(@NotNull RoundedPolygon.Companion $this$rectangle, float width, float height, @NotNull CornerRounding rounding, @Nullable List<CornerRounding> perVertexRounding, float centerX, float centerY) {
        Intrinsics.checkNotNullParameter((Object)$this$rectangle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        float left = centerX - width / (float)2;
        float top = centerY - height / (float)2;
        float right = centerX + width / (float)2;
        float bottom = centerY + height / (float)2;
        float[] fArray = new float[]{right, bottom, left, bottom, left, top, right, top};
        return RoundedPolygonKt.RoundedPolygon(fArray, rounding, perVertexRounding, centerX, centerY);
    }

    public static /* synthetic */ RoundedPolygon rectangle$default(RoundedPolygon.Companion companion, float f, float f2, CornerRounding cornerRounding, List list, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = 2.0f;
        }
        if ((n & 2) != 0) {
            f2 = 2.0f;
        }
        if ((n & 4) != 0) {
            cornerRounding = CornerRounding.Unrounded;
        }
        if ((n & 8) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            f3 = 0.0f;
        }
        if ((n & 0x20) != 0) {
            f4 = 0.0f;
        }
        return ShapesKt.rectangle(companion, f, f2, cornerRounding, list, f3, f4);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius, float radius, float innerRadius, @NotNull CornerRounding rounding, @Nullable CornerRounding innerRounding, @Nullable List<CornerRounding> perVertexRounding, float centerX, float centerY) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        if (radius <= 0.0f || innerRadius <= 0.0f) {
            throw new IllegalArgumentException("Star radii must both be greater than 0");
        }
        if (innerRadius >= radius) {
            throw new IllegalArgumentException("innerRadius must be less than radius");
        }
        List pvRounding = perVertexRounding;
        if (pvRounding == null && innerRounding != null) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = (Iterable)RangesKt.until((int)0, (int)numVerticesPerRadius);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv$iv;
                int it = element$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                Object[] objectArray = new CornerRounding[]{rounding, innerRounding};
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            pvRounding = (List)destination$iv$iv;
        }
        return RoundedPolygonKt.RoundedPolygon(Utils.starVerticesFromNumVerts(numVerticesPerRadius, radius, innerRadius, centerX, centerY), rounding, pvRounding, centerX, centerY);
    }

    public static /* synthetic */ RoundedPolygon star$default(RoundedPolygon.Companion companion, int n, float f, float f2, CornerRounding cornerRounding, CornerRounding cornerRounding2, List list, float f3, float f4, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 1.0f;
        }
        if ((n2 & 4) != 0) {
            f2 = 0.5f;
        }
        if ((n2 & 8) != 0) {
            cornerRounding = CornerRounding.Unrounded;
        }
        if ((n2 & 0x10) != 0) {
            cornerRounding2 = null;
        }
        if ((n2 & 0x20) != 0) {
            list = null;
        }
        if ((n2 & 0x40) != 0) {
            f3 = 0.0f;
        }
        if ((n2 & 0x80) != 0) {
            f4 = 0.0f;
        }
        return ShapesKt.star(companion, n, f, f2, cornerRounding, cornerRounding2, list, f3, f4);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon circle(@NotNull RoundedPolygon.Companion $this$circle, @IntRange(from=3L) int numVertices, float radius, float centerX) {
        Intrinsics.checkNotNullParameter((Object)$this$circle, (String)"<this>");
        return ShapesKt.circle$default($this$circle, numVertices, radius, centerX, 0.0f, 8, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon circle(@NotNull RoundedPolygon.Companion $this$circle, @IntRange(from=3L) int numVertices, float radius) {
        Intrinsics.checkNotNullParameter((Object)$this$circle, (String)"<this>");
        return ShapesKt.circle$default($this$circle, numVertices, radius, 0.0f, 0.0f, 12, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon circle(@NotNull RoundedPolygon.Companion $this$circle, @IntRange(from=3L) int numVertices) {
        Intrinsics.checkNotNullParameter((Object)$this$circle, (String)"<this>");
        return ShapesKt.circle$default($this$circle, numVertices, 0.0f, 0.0f, 0.0f, 14, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon circle(@NotNull RoundedPolygon.Companion $this$circle) {
        Intrinsics.checkNotNullParameter((Object)$this$circle, (String)"<this>");
        return ShapesKt.circle$default($this$circle, 0, 0.0f, 0.0f, 0.0f, 15, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius, float radius, float innerRadius, @NotNull CornerRounding rounding, @Nullable CornerRounding innerRounding, @Nullable List<CornerRounding> perVertexRounding, float centerX) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return ShapesKt.star$default($this$star, numVerticesPerRadius, radius, innerRadius, rounding, innerRounding, perVertexRounding, centerX, 0.0f, 128, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius, float radius, float innerRadius, @NotNull CornerRounding rounding, @Nullable CornerRounding innerRounding, @Nullable List<CornerRounding> perVertexRounding) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return ShapesKt.star$default($this$star, numVerticesPerRadius, radius, innerRadius, rounding, innerRounding, perVertexRounding, 0.0f, 0.0f, 192, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius, float radius, float innerRadius, @NotNull CornerRounding rounding, @Nullable CornerRounding innerRounding) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return ShapesKt.star$default($this$star, numVerticesPerRadius, radius, innerRadius, rounding, innerRounding, null, 0.0f, 0.0f, 224, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius, float radius, float innerRadius, @NotNull CornerRounding rounding) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return ShapesKt.star$default($this$star, numVerticesPerRadius, radius, innerRadius, rounding, null, null, 0.0f, 0.0f, 240, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius, float radius, float innerRadius) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        return ShapesKt.star$default($this$star, numVerticesPerRadius, radius, innerRadius, null, null, null, 0.0f, 0.0f, 248, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius, float radius) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        return ShapesKt.star$default($this$star, numVerticesPerRadius, radius, 0.0f, null, null, null, 0.0f, 0.0f, 252, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        return ShapesKt.star$default($this$star, numVerticesPerRadius, 0.0f, 0.0f, null, null, null, 0.0f, 0.0f, 254, null);
    }
}

