/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.graphics.shapes.Cubic;
import androidx.graphics.shapes.Measurer;
import androidx.graphics.shapes.PointKt;
import androidx.graphics.shapes.Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000e"}, d2={"Landroidx/graphics/shapes/AngleMeasurer;", "Landroidx/graphics/shapes/Measurer;", "centerX", "", "centerY", "(FF)V", "getCenterX", "()F", "getCenterY", "findCubicCutPoint", "c", "Landroidx/graphics/shapes/Cubic;", "m", "measureCubic", "graphics-shapes"})
public final class AngleMeasurer
implements Measurer {
    private final float centerX;
    private final float centerY;

    public AngleMeasurer(float centerX, float centerY) {
        this.centerX = centerX;
        this.centerY = centerY;
    }

    public final float getCenterX() {
        return this.centerX;
    }

    public final float getCenterY() {
        return this.centerY;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float measureCubic(@NotNull Cubic c) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        float it = Utils.positiveModulo(Utils.angle(c.getAnchor1X() - this.centerX, c.getAnchor1Y() - this.centerY) - Utils.angle(c.getAnchor0X() - this.centerX, c.getAnchor0Y() - this.centerY), Utils.getTwoPi());
        boolean bl = false;
        return it > Utils.getTwoPi() - 1.0E-4f ? 0.0f : var2_2;
    }

    @Override
    public float findCubicCutPoint(@NotNull Cubic c, float m) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        float angle0 = Utils.angle(c.getAnchor0X() - this.centerX, c.getAnchor0Y() - this.centerY);
        return Utils.findMinimum(0.0f, 1.0f, 1.0E-5f, arg_0 -> AngleMeasurer.findCubicCutPoint$lambda$1(c, this, angle0, m, arg_0));
    }

    private static final float findCubicCutPoint$lambda$1(Cubic $c, AngleMeasurer this$0, float $angle0, float $m, float t) {
        Intrinsics.checkNotNullParameter((Object)$c, (String)"$c");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        long curvePoint = $c.pointOnCurve-OOQOV4g$graphics_shapes(t);
        float angle = Utils.angle(PointKt.getX-DnnuFBc(curvePoint) - this$0.centerX, PointKt.getY-DnnuFBc(curvePoint) - this$0.centerY);
        return Math.abs(Utils.positiveModulo(angle - $angle0, Utils.getTwoPi()) - $m);
    }
}

