/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.collection.FloatFloatPair;
import androidx.graphics.shapes.CubicKt;
import androidx.graphics.shapes.MutableCubic;
import androidx.graphics.shapes.PointKt;
import androidx.graphics.shapes.PointTransformer;
import androidx.graphics.shapes.Utils;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 ?2\u00020\u0001:\u0001?B7\b\u0010\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0006\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0007\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\bB\u0011\b\u0000\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ!\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020\n2\b\b\u0002\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%J\u0011\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\rH\u0086\u0002J\u0011\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(H\u0086\u0002J\u0013\u0010)\u001a\u00020$2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010+\u001a\u00020(H\u0016J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000H\u0086\u0002J!\u0010.\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010/\u001a\u00020\rH\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b0\u00101J\u0006\u00102\u001a\u00020\u0000J\u001a\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0000042\u0006\u0010/\u001a\u00020\rJ\u0011\u00105\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\rH\u0086\u0002J\u0011\u00105\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(H\u0086\u0002J\b\u00106\u001a\u000207H\u0016J\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u00020$2\u0006\u0010<\u001a\u00020\rH\u0002J\r\u0010=\u001a\u00020$H\u0000\u00a2\u0006\u0002\b>R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0016\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\u001a\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006@"}, d2={"Landroidx/graphics/shapes/Cubic;", "", "anchor0", "Landroidx/collection/FloatFloatPair;", "Landroidx/graphics/shapes/Point;", "control0", "control1", "anchor1", "(JJJJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "points", "", "([F)V", "anchor0X", "", "getAnchor0X", "()F", "anchor0Y", "getAnchor0Y", "anchor1X", "getAnchor1X", "anchor1Y", "getAnchor1Y", "control0X", "getControl0X", "control0Y", "getControl0Y", "control1X", "getControl1X", "control1Y", "getControl1Y", "getPoints$graphics_shapes", "()[F", "calculateBounds", "", "bounds", "approximate", "", "calculateBounds$graphics_shapes", "div", "x", "", "equals", "other", "hashCode", "plus", "o", "pointOnCurve", "t", "pointOnCurve-OOQOV4g$graphics_shapes", "(F)J", "reverse", "split", "Lkotlin/Pair;", "times", "toString", "", "transformed", "f", "Landroidx/graphics/shapes/PointTransformer;", "zeroIsh", "value", "zeroLength", "zeroLength$graphics_shapes", "Companion", "graphics-shapes"})
@SourceDebugExtension(value={"SMAP\nCubic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cubic.kt\nandroidx/graphics/shapes/Cubic\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,440:1\n1#2:441\n*E\n"})
public class Cubic {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[] points;

    public Cubic(@NotNull float[] points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        this.points = points;
        if (!(this.points.length == 8)) {
            boolean bl = false;
            String string = "Points array size should be 8";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Cubic(float[] fArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fArray = new float[8];
        }
        this(fArray);
    }

    @NotNull
    public final float[] getPoints$graphics_shapes() {
        return this.points;
    }

    public final float getAnchor0X() {
        return this.points[0];
    }

    public final float getAnchor0Y() {
        return this.points[1];
    }

    public final float getControl0X() {
        return this.points[2];
    }

    public final float getControl0Y() {
        return this.points[3];
    }

    public final float getControl1X() {
        return this.points[4];
    }

    public final float getControl1Y() {
        return this.points[5];
    }

    public final float getAnchor1X() {
        return this.points[6];
    }

    public final float getAnchor1Y() {
        return this.points[7];
    }

    private Cubic(long anchor0, long control0, long control1, long anchor1) {
        float[] fArray = new float[]{PointKt.getX-DnnuFBc(anchor0), PointKt.getY-DnnuFBc(anchor0), PointKt.getX-DnnuFBc(control0), PointKt.getY-DnnuFBc(control0), PointKt.getX-DnnuFBc(control1), PointKt.getY-DnnuFBc(control1), PointKt.getX-DnnuFBc(anchor1), PointKt.getY-DnnuFBc(anchor1)};
        this(fArray);
    }

    public final long pointOnCurve-OOQOV4g$graphics_shapes(float t) {
        float u = 1.0f - t;
        return FloatFloatPair.constructor-impl((float)(this.getAnchor0X() * (u * u * u) + this.getControl0X() * ((float)3 * t * u * u) + this.getControl1X() * ((float)3 * t * t * u) + this.getAnchor1X() * (t * t * t)), (float)(this.getAnchor0Y() * (u * u * u) + this.getControl0Y() * ((float)3 * t * u * u) + this.getControl1Y() * ((float)3 * t * t * u) + this.getAnchor1Y() * (t * t * t)));
    }

    public final boolean zeroLength$graphics_shapes() {
        return Math.abs(this.getAnchor0X() - this.getAnchor1X()) < 1.0E-4f && Math.abs(this.getAnchor0Y() - this.getAnchor1Y()) < 1.0E-4f;
    }

    private final boolean zeroIsh(float value) {
        return Math.abs(value) < 1.0E-4f;
    }

    public final void calculateBounds$graphics_shapes(@NotNull float[] bounds, boolean approximate) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        if (this.zeroLength$graphics_shapes()) {
            bounds[0] = this.getAnchor0X();
            bounds[1] = this.getAnchor0Y();
            bounds[2] = this.getAnchor0X();
            bounds[3] = this.getAnchor0Y();
            return;
        }
        float minX = 0.0f;
        minX = Math.min(this.getAnchor0X(), this.getAnchor1X());
        float minY = 0.0f;
        minY = Math.min(this.getAnchor0Y(), this.getAnchor1Y());
        float maxX = 0.0f;
        maxX = Math.max(this.getAnchor0X(), this.getAnchor1X());
        float maxY = 0.0f;
        maxY = Math.max(this.getAnchor0Y(), this.getAnchor1Y());
        if (approximate) {
            bounds[0] = Math.min(minX, Math.min(this.getControl0X(), this.getControl1X()));
            bounds[1] = Math.min(minY, Math.min(this.getControl0Y(), this.getControl1Y()));
            bounds[2] = Math.max(maxX, Math.max(this.getControl0X(), this.getControl1X()));
            bounds[3] = Math.max(maxY, Math.max(this.getControl0Y(), this.getControl1Y()));
            return;
        }
        float xa = -this.getAnchor0X() + (float)3 * this.getControl0X() - (float)3 * this.getControl1X() + this.getAnchor1X();
        float xb = (float)2 * this.getAnchor0X() - (float)4 * this.getControl0X() + (float)2 * this.getControl1X();
        float xc = -this.getAnchor0X() + this.getControl0X();
        if (this.zeroIsh(xa)) {
            if (!(xb == 0.0f)) {
                float t = (float)2 * xc / ((float)-2 * xb);
                boolean bl = 0.0f <= t ? t <= 1.0f : false;
                if (bl) {
                    float it = PointKt.getX-DnnuFBc(this.pointOnCurve-OOQOV4g$graphics_shapes(t));
                    boolean bl2 = false;
                    if (it < minX) {
                        minX = it;
                    }
                    if (it > maxX) {
                        maxX = it;
                    }
                }
            }
        } else {
            float xs = xb * xb - (float)4 * xa * xc;
            if (xs >= 0.0f) {
                float t2;
                float t1 = (-xb + (float)Math.sqrt(xs)) / ((float)2 * xa);
                boolean bl = 0.0f <= t1 ? t1 <= 1.0f : false;
                if (bl) {
                    float it = PointKt.getX-DnnuFBc(this.pointOnCurve-OOQOV4g$graphics_shapes(t1));
                    boolean bl3 = false;
                    if (it < minX) {
                        minX = it;
                    }
                    if (it > maxX) {
                        maxX = it;
                    }
                }
                boolean bl4 = 0.0f <= (t2 = (-xb - (float)Math.sqrt(xs)) / ((float)2 * xa)) ? t2 <= 1.0f : false;
                if (bl4) {
                    float it = PointKt.getX-DnnuFBc(this.pointOnCurve-OOQOV4g$graphics_shapes(t2));
                    boolean bl5 = false;
                    if (it < minX) {
                        minX = it;
                    }
                    if (it > maxX) {
                        maxX = it;
                    }
                }
            }
        }
        float ya = -this.getAnchor0Y() + (float)3 * this.getControl0Y() - (float)3 * this.getControl1Y() + this.getAnchor1Y();
        float yb = (float)2 * this.getAnchor0Y() - (float)4 * this.getControl0Y() + (float)2 * this.getControl1Y();
        float yc = -this.getAnchor0Y() + this.getControl0Y();
        if (this.zeroIsh(ya)) {
            if (!(yb == 0.0f)) {
                float t = (float)2 * yc / ((float)-2 * yb);
                boolean bl = 0.0f <= t ? t <= 1.0f : false;
                if (bl) {
                    float it = PointKt.getY-DnnuFBc(this.pointOnCurve-OOQOV4g$graphics_shapes(t));
                    boolean bl6 = false;
                    if (it < minY) {
                        minY = it;
                    }
                    if (it > maxY) {
                        maxY = it;
                    }
                }
            }
        } else {
            float ys = yb * yb - (float)4 * ya * yc;
            if (ys >= 0.0f) {
                float t2;
                float t1 = (-yb + (float)Math.sqrt(ys)) / ((float)2 * ya);
                boolean bl = 0.0f <= t1 ? t1 <= 1.0f : false;
                if (bl) {
                    float it = PointKt.getY-DnnuFBc(this.pointOnCurve-OOQOV4g$graphics_shapes(t1));
                    boolean bl7 = false;
                    if (it < minY) {
                        minY = it;
                    }
                    if (it > maxY) {
                        maxY = it;
                    }
                }
                boolean bl8 = 0.0f <= (t2 = (-yb - (float)Math.sqrt(ys)) / ((float)2 * ya)) ? t2 <= 1.0f : false;
                if (bl8) {
                    float it = PointKt.getY-DnnuFBc(this.pointOnCurve-OOQOV4g$graphics_shapes(t2));
                    boolean bl9 = false;
                    if (it < minY) {
                        minY = it;
                    }
                    if (it > maxY) {
                        maxY = it;
                    }
                }
            }
        }
        bounds[0] = minX;
        bounds[1] = minY;
        bounds[2] = maxX;
        bounds[3] = maxY;
    }

    public static /* synthetic */ void calculateBounds$graphics_shapes$default(Cubic cubic, float[] fArray, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: calculateBounds");
        }
        if ((n & 1) != 0) {
            fArray = new float[4];
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        cubic.calculateBounds$graphics_shapes(fArray, bl);
    }

    @NotNull
    public final Pair<Cubic, Cubic> split(float t) {
        float u = 1.0f - t;
        long pointOnCurve = this.pointOnCurve-OOQOV4g$graphics_shapes(t);
        return TuplesKt.to((Object)CubicKt.Cubic(this.getAnchor0X(), this.getAnchor0Y(), this.getAnchor0X() * u + this.getControl0X() * t, this.getAnchor0Y() * u + this.getControl0Y() * t, this.getAnchor0X() * (u * u) + this.getControl0X() * ((float)2 * u * t) + this.getControl1X() * (t * t), this.getAnchor0Y() * (u * u) + this.getControl0Y() * ((float)2 * u * t) + this.getControl1Y() * (t * t), PointKt.getX-DnnuFBc(pointOnCurve), PointKt.getY-DnnuFBc(pointOnCurve)), (Object)CubicKt.Cubic(PointKt.getX-DnnuFBc(pointOnCurve), PointKt.getY-DnnuFBc(pointOnCurve), this.getControl0X() * (u * u) + this.getControl1X() * ((float)2 * u * t) + this.getAnchor1X() * (t * t), this.getControl0Y() * (u * u) + this.getControl1Y() * ((float)2 * u * t) + this.getAnchor1Y() * (t * t), this.getControl1X() * u + this.getAnchor1X() * t, this.getControl1Y() * u + this.getAnchor1Y() * t, this.getAnchor1X(), this.getAnchor1Y()));
    }

    @NotNull
    public final Cubic reverse() {
        return CubicKt.Cubic(this.getAnchor1X(), this.getAnchor1Y(), this.getControl1X(), this.getControl1Y(), this.getControl0X(), this.getControl0Y(), this.getAnchor0X(), this.getAnchor0Y());
    }

    @NotNull
    public final Cubic plus(@NotNull Cubic o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        int n = 0;
        float[] fArray = new float[8];
        while (n < 8) {
            int n2 = n++;
            fArray[n2] = this.points[n2] + o.points[n2];
        }
        float[] fArray2 = fArray;
        return new Cubic(fArray2);
    }

    @NotNull
    public final Cubic times(float x) {
        int n = 0;
        float[] fArray = new float[8];
        while (n < 8) {
            int n2 = n++;
            fArray[n2] = this.points[n2] * x;
        }
        float[] fArray2 = fArray;
        return new Cubic(fArray2);
    }

    @NotNull
    public final Cubic times(int x) {
        return this.times((float)x);
    }

    @NotNull
    public final Cubic div(float x) {
        return this.times(1.0f / x);
    }

    @NotNull
    public final Cubic div(int x) {
        return this.div((float)x);
    }

    @NotNull
    public String toString() {
        return "anchor0: (" + this.getAnchor0X() + ", " + this.getAnchor0Y() + ") control0: (" + this.getControl0X() + ", " + this.getControl0Y() + "), control1: (" + this.getControl1X() + ", " + this.getControl1Y() + "), anchor1: (" + this.getAnchor1X() + ", " + this.getAnchor1Y() + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Cubic)) {
            return false;
        }
        return Arrays.equals(this.points, ((Cubic)other).points);
    }

    @NotNull
    public final Cubic transformed(@NotNull PointTransformer f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        MutableCubic newCubic = new MutableCubic();
        ArraysKt.copyInto$default((float[])this.points, (float[])newCubic.getPoints$graphics_shapes(), (int)0, (int)0, (int)0, (int)14, null);
        newCubic.transform(f);
        return newCubic;
    }

    public int hashCode() {
        return Arrays.hashCode(this.points);
    }

    public Cubic() {
        this(null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final Cubic straightLine(float x0, float y0, float x1, float y1) {
        return Companion.straightLine(x0, y0, x1, y1);
    }

    @JvmStatic
    @NotNull
    public static final Cubic circularArc(float centerX, float centerY, float x0, float y0, float x1, float y1) {
        return Companion.circularArc(centerX, centerY, x0, y0, x1, y1);
    }

    public /* synthetic */ Cubic(long anchor0, long control0, long control1, long anchor1, DefaultConstructorMarker $constructor_marker) {
        this(anchor0, control0, control1, anchor1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J(\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0007\u00a8\u0006\r"}, d2={"Landroidx/graphics/shapes/Cubic$Companion;", "", "()V", "circularArc", "Landroidx/graphics/shapes/Cubic;", "centerX", "", "centerY", "x0", "y0", "x1", "y1", "straightLine", "graphics-shapes"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Cubic straightLine(float x0, float y0, float x1, float y1) {
            return CubicKt.Cubic(x0, y0, Utils.interpolate(x0, x1, 0.33333334f), Utils.interpolate(y0, y1, 0.33333334f), Utils.interpolate(x0, x1, 0.6666667f), Utils.interpolate(y0, y1, 0.6666667f), x1, y1);
        }

        @JvmStatic
        @NotNull
        public final Cubic circularArc(float centerX, float centerY, float x0, float y0, float x1, float y1) {
            long p0d = Utils.directionVector(x0 - centerX, y0 - centerY);
            long p1d = Utils.directionVector(x1 - centerX, y1 - centerY);
            long rotatedP0 = Utils.rotate90-DnnuFBc(p0d);
            long rotatedP1 = Utils.rotate90-DnnuFBc(p1d);
            boolean clockwise = PointKt.dotProduct-5P9i7ZU(rotatedP0, x1 - centerX, y1 - centerY) >= 0.0f;
            float cosa = PointKt.dotProduct-ybeJwSQ(p0d, p1d);
            if (cosa > 0.999f) {
                return this.straightLine(x0, y0, x1, y1);
            }
            float k = Utils.distance(x0 - centerX, y0 - centerY) * 4.0f / 3.0f * ((float)Math.sqrt((float)2 * (1.0f - cosa)) - (float)Math.sqrt(1.0f - cosa * cosa)) / (1.0f - cosa) * (clockwise ? 1.0f : -1.0f);
            return CubicKt.Cubic(x0, y0, x0 + PointKt.getX-DnnuFBc(rotatedP0) * k, y0 + PointKt.getY-DnnuFBc(rotatedP0) * k, x1 - PointKt.getX-DnnuFBc(rotatedP1) * k, y1 - PointKt.getY-DnnuFBc(rotatedP1) * k, x1, y1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

