/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.collection.FloatList;
import androidx.collection.MutableFloatList;
import androidx.graphics.shapes.FloatMappingKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB1\u0012*\u0010\u0002\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/graphics/shapes/DoubleMapper;", "", "mappings", "", "Lkotlin/Pair;", "", "([Lkotlin/Pair;)V", "sourceValues", "Landroidx/collection/MutableFloatList;", "targetValues", "map", "x", "mapBack", "Companion", "graphics-shapes"})
public final class DoubleMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableFloatList sourceValues;
    @NotNull
    private final MutableFloatList targetValues;
    @JvmField
    @NotNull
    public static final DoubleMapper Identity;

    public DoubleMapper(Pair<Float, Float> ... mappings) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        this.sourceValues = new MutableFloatList(mappings.length);
        this.targetValues = new MutableFloatList(mappings.length);
        int n = mappings.length;
        for (int i = 0; i < n; ++i) {
            this.sourceValues.add(((Number)mappings[i].getFirst()).floatValue());
            this.targetValues.add(((Number)mappings[i].getSecond()).floatValue());
        }
        FloatMappingKt.validateProgress((FloatList)this.sourceValues);
        FloatMappingKt.validateProgress((FloatList)this.targetValues);
    }

    public final float map(float x) {
        return FloatMappingKt.linearMap((FloatList)this.sourceValues, (FloatList)this.targetValues, x);
    }

    public final float mapBack(float x) {
        return FloatMappingKt.linearMap((FloatList)this.targetValues, (FloatList)this.sourceValues, x);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)), TuplesKt.to((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.5f))};
        Identity = new DoubleMapper(pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/graphics/shapes/DoubleMapper$Companion;", "", "()V", "Identity", "Landroidx/graphics/shapes/DoubleMapper;", "graphics-shapes"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

