/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.graphics.shapes.Cubic;
import androidx.graphics.shapes.DoubleMapper;
import androidx.graphics.shapes.Feature;
import androidx.graphics.shapes.ProgressableFeature;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a6\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00052\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00052\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005H\u0000\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\nH\u0000\u001a,\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00052\u0010\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000*\u0018\b\u0000\u0010\u000f\"\b\u0012\u0004\u0012\u00020\u00040\u00032\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a8\u0006\u0010"}, d2={"LOG_TAG", "", "doMapping", "", "Landroidx/graphics/shapes/ProgressableFeature;", "Landroidx/graphics/shapes/MeasuredFeatures;", "f1", "f2", "featureDistSquared", "", "Landroidx/graphics/shapes/Feature;", "featureMapper", "Landroidx/graphics/shapes/DoubleMapper;", "features1", "features2", "MeasuredFeatures", "graphics-shapes"})
@SourceDebugExtension(value={"SMAP\nFeatureMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureMapping.kt\nandroidx/graphics/shapes/FeatureMappingKt\n+ 2 Utils.kt\nandroidx/graphics/shapes/Utils\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n115#2,4:135\n115#2,4:141\n115#2,4:145\n37#3,2:139\n2310#4,14:149\n2310#4,14:164\n1#5:163\n*S KotlinDebug\n*F\n+ 1 FeatureMapping.kt\nandroidx/graphics/shapes/FeatureMappingKt\n*L\n66#1:135,4\n70#1:141,4\n91#1:145,4\n69#1:139,2\n113#1:149,14\n124#1:164,14\n*E\n"})
public final class FeatureMappingKt {
    @NotNull
    private static final String LOG_TAG = "FeatureMapping";

    @NotNull
    public static final DoubleMapper featureMapper(@NotNull List<ProgressableFeature> features1, @NotNull List<ProgressableFeature> features2) {
        Object object;
        List list;
        List list2;
        Intrinsics.checkNotNullParameter(features1, (String)"features1");
        Intrinsics.checkNotNullParameter(features2, (String)"features2");
        List $this$featureMapper_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        int n = features1.size();
        for (int i = 0; i < n; ++i) {
            if (!(features1.get(i).getFeature() instanceof Feature.Corner)) continue;
            $this$featureMapper_u24lambda_u240.add(features1.get(i));
        }
        List filteredFeatures1 = CollectionsKt.build((List)list2);
        List $this$featureMapper_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        int n2 = features2.size();
        for (int i = 0; i < n2; ++i) {
            if (!(features2.get(i).getFeature() instanceof Feature.Corner)) continue;
            $this$featureMapper_u24lambda_u241.add(features2.get(i));
        }
        List filteredFeatures2 = CollectionsKt.build((List)list);
        list = filteredFeatures1.size() > filteredFeatures2.size() ? TuplesKt.to(FeatureMappingKt.doMapping(filteredFeatures2, filteredFeatures1), (Object)filteredFeatures2) : TuplesKt.to((Object)filteredFeatures1, FeatureMappingKt.doMapping(filteredFeatures1, filteredFeatures2));
        List m1 = (List)list.component1();
        List m2 = (List)list.component2();
        Pair[] $this$featureMapper_u24lambda_u242 = object = CollectionsKt.createListBuilder();
        boolean bl3 = false;
        int n3 = m1.size();
        for (int i = 0; i < n3 && i != m2.size(); ++i) {
            $this$featureMapper_u24lambda_u242.add(TuplesKt.to((Object)Float.valueOf(((ProgressableFeature)m1.get(i)).getProgress()), (Object)Float.valueOf(((ProgressableFeature)m2.get(i)).getProgress())));
        }
        List mm = CollectionsKt.build((List)object);
        String tag$iv = LOG_TAG;
        boolean $i$f$debugLog = false;
        Collection $this$toTypedArray$iv = mm;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        object = thisCollection$iv.toArray(new Pair[0]);
        Object dm = object = new DoubleMapper(Arrays.copyOf(object, ((Pair[])object).length));
        boolean bl4 = false;
        String tag$iv2 = LOG_TAG;
        boolean $i$f$debugLog2 = false;
        return object;
    }

    public static final float featureDistSquared(@NotNull Feature f1, @NotNull Feature f2) {
        Intrinsics.checkNotNullParameter((Object)f1, (String)"f1");
        Intrinsics.checkNotNullParameter((Object)f2, (String)"f2");
        if (f1 instanceof Feature.Corner && f2 instanceof Feature.Corner && ((Feature.Corner)f1).getConvex() != ((Feature.Corner)f2).getConvex()) {
            String tag$iv = LOG_TAG;
            boolean $i$f$debugLog = false;
            return Float.MAX_VALUE;
        }
        float c1x = (((Cubic)CollectionsKt.first(f1.getCubics())).getAnchor0X() + ((Cubic)CollectionsKt.last(f1.getCubics())).getAnchor1X()) / 2.0f;
        float c1y = (((Cubic)CollectionsKt.first(f1.getCubics())).getAnchor0Y() + ((Cubic)CollectionsKt.last(f1.getCubics())).getAnchor1Y()) / 2.0f;
        float c2x = (((Cubic)CollectionsKt.first(f2.getCubics())).getAnchor0X() + ((Cubic)CollectionsKt.last(f2.getCubics())).getAnchor1X()) / 2.0f;
        float c2y = (((Cubic)CollectionsKt.first(f2.getCubics())).getAnchor0Y() + ((Cubic)CollectionsKt.last(f2.getCubics())).getAnchor1Y()) / 2.0f;
        float dx = c1x - c2x;
        float dy = c1y - c2y;
        return dx * dx + dy * dy;
    }

    @NotNull
    public static final List<ProgressableFeature> doMapping(@NotNull List<ProgressableFeature> f1, @NotNull List<ProgressableFeature> f2) {
        int n;
        Intrinsics.checkNotNullParameter(f1, (String)"f1");
        Intrinsics.checkNotNullParameter(f2, (String)"f2");
        Iterable $this$minBy$iv = (Iterable)CollectionsKt.getIndices((Collection)f2);
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        int minElem$iv22 = ((IntIterator)iterator$iv).nextInt();
        if (!iterator$iv.hasNext()) {
            n = minElem$iv22;
        } else {
            int it = minElem$iv22;
            boolean bl = false;
            float minValue$iv = FeatureMappingKt.featureDistSquared(f1.get(0).getFeature(), f2.get(it).getFeature());
            do {
                int e$iv;
                int it2 = e$iv = ((IntIterator)iterator$iv).nextInt();
                $i$a$-minByOrThrow-FeatureMappingKt$doMapping$ix$1 = false;
                float v$iv = FeatureMappingKt.featureDistSquared(f1.get(0).getFeature(), f2.get(it2).getFeature());
                if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                minElem$iv22 = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            n = minElem$iv22;
        }
        int ix = n;
        int m = f1.size();
        int n2 = f2.size();
        Object[] minElem$iv22 = new ProgressableFeature[]{f2.get(ix)};
        List ret = CollectionsKt.mutableListOf((Object[])minElem$iv22);
        int lastPicked = 0;
        lastPicked = ix;
        for (int i = 1; i < m; ++i) {
            int n3;
            int it = ix - (m - i);
            boolean bl = false;
            int last = it > lastPicked ? it : it + n2;
            Iterable $this$minBy$iv2 = (Iterable)new IntRange(lastPicked + 1, last);
            boolean $i$f$minByOrThrow2 = false;
            Iterator iterator$iv2 = $this$minBy$iv2.iterator();
            if (!iterator$iv2.hasNext()) {
                throw new NoSuchElementException();
            }
            int minElem$iv = ((IntIterator)iterator$iv2).nextInt();
            if (!iterator$iv2.hasNext()) {
                n3 = minElem$iv;
            } else {
                int it3 = minElem$iv;
                boolean bl2 = false;
                float minValue$iv = FeatureMappingKt.featureDistSquared(f1.get(i).getFeature(), f2.get(it3 % n2).getFeature());
                do {
                    int e$iv;
                    it3 = e$iv = ((IntIterator)iterator$iv2).nextInt();
                    bl2 = false;
                    float v$iv = FeatureMappingKt.featureDistSquared(f1.get(i).getFeature(), f2.get(it3 % n2).getFeature());
                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                n3 = minElem$iv;
            }
            int best = n3;
            ret.add(f2.get(best % n2));
            lastPicked = best;
        }
        return ret;
    }
}

