/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.graphics.shapes.AngleMeasurer;
import androidx.graphics.shapes.Cubic;
import androidx.graphics.shapes.CubicKt;
import androidx.graphics.shapes.DoubleMapper;
import androidx.graphics.shapes.FeatureMappingKt;
import androidx.graphics.shapes.MeasuredPolygon;
import androidx.graphics.shapes.MorphKt;
import androidx.graphics.shapes.MutableCubic;
import androidx.graphics.shapes.ProgressableFeature;
import androidx.graphics.shapes.RoundedPolygon;
import androidx.graphics.shapes.Utils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013J2\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00190\u001dH\u0087\b\u00f8\u0001\u0000R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b0\u00078@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"Landroidx/graphics/shapes/Morph;", "", "start", "Landroidx/graphics/shapes/RoundedPolygon;", "end", "(Landroidx/graphics/shapes/RoundedPolygon;Landroidx/graphics/shapes/RoundedPolygon;)V", "_morphMatch", "", "Lkotlin/Pair;", "Landroidx/graphics/shapes/Cubic;", "morphMatch", "getMorphMatch$annotations", "()V", "getMorphMatch", "()Ljava/util/List;", "asCubics", "progress", "", "calculateBounds", "", "bounds", "approximate", "", "calculateMaxBounds", "forEachCubic", "", "mutableCubic", "Landroidx/graphics/shapes/MutableCubic;", "callback", "Lkotlin/Function1;", "Companion", "graphics-shapes"})
@SourceDebugExtension(value={"SMAP\nMorph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Morph.kt\nandroidx/graphics/shapes/Morph\n*L\n1#1,331:1\n164#1,10:332\n*S KotlinDebug\n*F\n+ 1 Morph.kt\nandroidx/graphics/shapes/Morph\n*L\n-1#1:332,10\n*E\n"})
public final class Morph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoundedPolygon start;
    @NotNull
    private final RoundedPolygon end;
    @NotNull
    private final List<Pair<Cubic, Cubic>> _morphMatch;

    public Morph(@NotNull RoundedPolygon start, @NotNull RoundedPolygon end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.start = start;
        this.end = end;
        this._morphMatch = Companion.match$graphics_shapes(this.start, this.end);
    }

    @NotNull
    public final List<Pair<Cubic, Cubic>> getMorphMatch() {
        return this._morphMatch;
    }

    @PublishedApi
    public static /* synthetic */ void getMorphMatch$annotations() {
    }

    @JvmOverloads
    @NotNull
    public final float[] calculateBounds(@NotNull float[] bounds, boolean approximate) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.start.calculateBounds(bounds, approximate);
        float minX = bounds[0];
        float minY = bounds[1];
        float maxX = bounds[2];
        float maxY = bounds[3];
        this.end.calculateBounds(bounds, approximate);
        bounds[0] = Math.min(minX, bounds[0]);
        bounds[1] = Math.min(minY, bounds[1]);
        bounds[2] = Math.max(maxX, bounds[2]);
        bounds[3] = Math.max(maxY, bounds[3]);
        return bounds;
    }

    public static /* synthetic */ float[] calculateBounds$default(Morph morph, float[] fArray, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            fArray = new float[4];
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return morph.calculateBounds(fArray, bl);
    }

    @NotNull
    public final float[] calculateMaxBounds(@NotNull float[] bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.start.calculateMaxBounds(bounds);
        float minX = bounds[0];
        float minY = bounds[1];
        float maxX = bounds[2];
        float maxY = bounds[3];
        this.end.calculateMaxBounds(bounds);
        bounds[0] = Math.min(minX, bounds[0]);
        bounds[1] = Math.min(minY, bounds[1]);
        bounds[2] = Math.max(maxX, bounds[2]);
        bounds[3] = Math.max(maxY, bounds[3]);
        return bounds;
    }

    public static /* synthetic */ float[] calculateMaxBounds$default(Morph morph, float[] fArray, int n, Object object) {
        if ((n & 1) != 0) {
            fArray = new float[4];
        }
        return morph.calculateMaxBounds(fArray);
    }

    @NotNull
    public final List<Cubic> asCubics(float progress) {
        List list;
        List $this$asCubics_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Cubic firstCubic = null;
        Cubic lastCubic = null;
        int n = this._morphMatch.size();
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            float[] fArray = new float[8];
            while (n2 < 8) {
                int n3 = n2++;
                fArray[n3] = Utils.interpolate(((Cubic)this._morphMatch.get(i).getFirst()).getPoints$graphics_shapes()[n3], ((Cubic)this._morphMatch.get(i).getSecond()).getPoints$graphics_shapes()[n3], progress);
            }
            float[] fArray2 = fArray;
            Cubic cubic = new Cubic(fArray2);
            if (firstCubic == null) {
                firstCubic = cubic;
            }
            if (lastCubic != null) {
                $this$asCubics_u24lambda_u240.add(lastCubic);
            }
            lastCubic = cubic;
        }
        if (lastCubic != null && firstCubic != null) {
            $this$asCubics_u24lambda_u240.add(CubicKt.Cubic(lastCubic.getAnchor0X(), lastCubic.getAnchor0Y(), lastCubic.getControl0X(), lastCubic.getControl0Y(), lastCubic.getControl1X(), lastCubic.getControl1Y(), firstCubic.getAnchor0X(), firstCubic.getAnchor0Y()));
        }
        return CollectionsKt.build((List)list);
    }

    @JvmOverloads
    public final void forEachCubic(float progress, @NotNull MutableCubic mutableCubic, @NotNull Function1<? super MutableCubic, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)mutableCubic, (String)"mutableCubic");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        boolean $i$f$forEachCubic = false;
        int n = this.getMorphMatch().size();
        for (int i = 0; i < n; ++i) {
            mutableCubic.interpolate((Cubic)this.getMorphMatch().get(i).getFirst(), (Cubic)this.getMorphMatch().get(i).getSecond(), progress);
            callback.invoke((Object)mutableCubic);
        }
    }

    public static /* synthetic */ void forEachCubic$default(Morph $this, float progress, MutableCubic mutableCubic, Function1 callback, int n, Object object) {
        if ((n & 2) != 0) {
            mutableCubic = new MutableCubic();
        }
        Intrinsics.checkNotNullParameter((Object)mutableCubic, (String)"mutableCubic");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        boolean $i$f$forEachCubic = false;
        int n2 = $this.getMorphMatch().size();
        for (int i = 0; i < n2; ++i) {
            mutableCubic.interpolate((Cubic)$this.getMorphMatch().get(i).getFirst(), (Cubic)$this.getMorphMatch().get(i).getSecond(), progress);
            callback.invoke((Object)mutableCubic);
        }
    }

    @JvmOverloads
    @NotNull
    public final float[] calculateBounds(@NotNull float[] bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return Morph.calculateBounds$default(this, bounds, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final float[] calculateBounds() {
        return Morph.calculateBounds$default(this, null, false, 3, null);
    }

    @JvmOverloads
    public final void forEachCubic(float progress, @NotNull Function1<? super MutableCubic, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        boolean $i$f$forEachCubic = false;
        MutableCubic mutableCubic$iv = new MutableCubic();
        boolean $i$f$forEachCubic2 = false;
        int n = this.getMorphMatch().size();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            mutableCubic$iv.interpolate((Cubic)this.getMorphMatch().get(i$iv).getFirst(), (Cubic)this.getMorphMatch().get(i$iv).getSecond(), progress);
            callback.invoke((Object)mutableCubic$iv);
        }
    }

    @JvmStatic
    @NotNull
    public static final List<Pair<Cubic, Cubic>> match$graphics_shapes(@NotNull RoundedPolygon p1, @NotNull RoundedPolygon p2) {
        return Companion.match$graphics_shapes(p1, p2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Landroidx/graphics/shapes/Morph$Companion;", "", "()V", "match", "", "Lkotlin/Pair;", "Landroidx/graphics/shapes/Cubic;", "p1", "Landroidx/graphics/shapes/RoundedPolygon;", "p2", "match$graphics_shapes", "graphics-shapes"})
    @SourceDebugExtension(value={"SMAP\nMorph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Morph.kt\nandroidx/graphics/shapes/Morph$Companion\n+ 2 Utils.kt\nandroidx/graphics/shapes/Utils\n*L\n1#1,331:1\n115#2,4:332\n115#2,4:336\n115#2,4:340\n115#2,4:344\n115#2,4:348\n*S KotlinDebug\n*F\n+ 1 Morph.kt\nandroidx/graphics/shapes/Morph$Companion\n*L\n236#1:332,4\n278#1:336,4\n283#1:340,4\n289#1:344,4\n294#1:348,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<Pair<Cubic, Cubic>> match$graphics_shapes(@NotNull RoundedPolygon p1, @NotNull RoundedPolygon p2) {
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            MeasuredPolygon measuredPolygon1 = MeasuredPolygon.Companion.measurePolygon$graphics_shapes(new AngleMeasurer(p1.getCenterX(), p1.getCenterY()), p1);
            MeasuredPolygon measuredPolygon2 = MeasuredPolygon.Companion.measurePolygon$graphics_shapes(new AngleMeasurer(p2.getCenterX(), p2.getCenterY()), p2);
            List<ProgressableFeature> features1 = measuredPolygon1.getFeatures();
            List<ProgressableFeature> features2 = measuredPolygon2.getFeatures();
            DoubleMapper doubleMapper = FeatureMappingKt.featureMapper(features1, features2);
            float polygon2CutPoint = doubleMapper.map(0.0f);
            String tag$iv = MorphKt.access$getLOG_TAG$p();
            boolean $i$f$debugLog = false;
            MeasuredPolygon bs1 = measuredPolygon1;
            MeasuredPolygon bs2 = measuredPolygon2.cutAndShift(polygon2CutPoint);
            List ret = new ArrayList();
            int i1 = 0;
            int i2 = 0;
            MeasuredPolygon.MeasuredCubic b1 = (MeasuredPolygon.MeasuredCubic)CollectionsKt.getOrNull((List)((List)((Object)bs1)), (int)i1++);
            MeasuredPolygon.MeasuredCubic b2 = (MeasuredPolygon.MeasuredCubic)CollectionsKt.getOrNull((List)((List)((Object)bs2)), (int)i2++);
            while (b1 != null && b2 != null) {
                Pair<MeasuredPolygon.MeasuredCubic, MeasuredPolygon.MeasuredCubic> pair;
                Pair<MeasuredPolygon.MeasuredCubic, MeasuredPolygon.MeasuredCubic> pair2;
                float b1a = i1 == bs1.size() ? 1.0f : b1.getEndOutlineProgress();
                float b2a = i2 == bs2.size() ? 1.0f : doubleMapper.mapBack(Utils.positiveModulo(b2.getEndOutlineProgress() + polygon2CutPoint, 1.0f));
                float minb = Math.min(b1a, b2a);
                String tag$iv2 = MorphKt.access$getLOG_TAG$p();
                boolean $i$f$debugLog2 = false;
                if (b1a > minb + 1.0E-6f) {
                    String tag$iv3 = MorphKt.access$getLOG_TAG$p();
                    boolean $i$f$debugLog3 = false;
                    pair2 = b1.cutAtProgress(minb);
                } else {
                    pair2 = TuplesKt.to((Object)b1, (Object)CollectionsKt.getOrNull((List)((List)((Object)bs1)), (int)i1++));
                }
                Pair<MeasuredPolygon.MeasuredCubic, MeasuredPolygon.MeasuredCubic> pair3 = pair2;
                MeasuredPolygon.MeasuredCubic seg1 = (MeasuredPolygon.MeasuredCubic)pair3.component1();
                MeasuredPolygon.MeasuredCubic newb1 = (MeasuredPolygon.MeasuredCubic)pair3.component2();
                if (b2a > minb + 1.0E-6f) {
                    String tag$iv4 = MorphKt.access$getLOG_TAG$p();
                    boolean $i$f$debugLog4 = false;
                    pair = b2.cutAtProgress(Utils.positiveModulo(doubleMapper.map(minb) - polygon2CutPoint, 1.0f));
                } else {
                    pair = TuplesKt.to((Object)b2, (Object)CollectionsKt.getOrNull((List)((List)((Object)bs2)), (int)i2++));
                }
                Pair<MeasuredPolygon.MeasuredCubic, MeasuredPolygon.MeasuredCubic> pair4 = pair;
                MeasuredPolygon.MeasuredCubic seg2 = (MeasuredPolygon.MeasuredCubic)pair4.component1();
                MeasuredPolygon.MeasuredCubic newb2 = (MeasuredPolygon.MeasuredCubic)pair4.component2();
                String tag$iv5 = MorphKt.access$getLOG_TAG$p();
                boolean $i$f$debugLog5 = false;
                ret.add(TuplesKt.to((Object)seg1.getCubic(), (Object)seg2.getCubic()));
                b1 = newb1;
                b2 = newb2;
            }
            if (!(b1 == null && b2 == null)) {
                boolean bl = false;
                String string = "Expected both Polygon's Cubic to be fully matched";
                throw new IllegalArgumentException(string.toString());
            }
            return ret;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

