/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.collection.FloatFloatPair;
import androidx.graphics.shapes.Cubic;
import androidx.graphics.shapes.CubicKt;
import androidx.graphics.shapes.Feature;
import androidx.graphics.shapes.PointKt;
import androidx.graphics.shapes.PointTransformer;
import androidx.graphics.shapes.Utils;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B%\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012J\u0013\u0010\u0017\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u0000J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\""}, d2={"Landroidx/graphics/shapes/RoundedPolygon;", "", "features", "", "Landroidx/graphics/shapes/Feature;", "centerX", "", "centerY", "(Ljava/util/List;FF)V", "getCenterX", "()F", "getCenterY", "cubics", "Landroidx/graphics/shapes/Cubic;", "getCubics", "()Ljava/util/List;", "getFeatures$graphics_shapes", "calculateBounds", "", "bounds", "approximate", "", "calculateMaxBounds", "equals", "other", "hashCode", "", "normalized", "toString", "", "transformed", "f", "Landroidx/graphics/shapes/PointTransformer;", "Companion", "graphics-shapes"})
@SourceDebugExtension(value={"SMAP\nRoundedPolygon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoundedPolygon.kt\nandroidx/graphics/shapes/RoundedPolygon\n+ 2 Utils.kt\nandroidx/graphics/shapes/Utils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,670:1\n115#2,4:671\n115#2,4:675\n115#2,4:679\n1#3:683\n*S KotlinDebug\n*F\n+ 1 RoundedPolygon.kt\nandroidx/graphics/shapes/RoundedPolygon\n*L\n88#1:671,4\n91#1:675,4\n95#1:679,4\n*E\n"})
public final class RoundedPolygon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Feature> features;
    private final float centerX;
    private final float centerY;
    @NotNull
    private final List<Cubic> cubics;

    /*
     * WARNING - void declaration
     */
    public RoundedPolygon(@NotNull List<? extends Feature> features, float centerX, float centerY) {
        void $this$cubics_u24lambda_u240;
        int n;
        int i;
        List list;
        Intrinsics.checkNotNullParameter(features, (String)"features");
        this.features = features;
        this.centerX = centerX;
        this.centerY = centerY;
        List list2 = list = CollectionsKt.createListBuilder();
        RoundedPolygon roundedPolygon = this;
        boolean bl = false;
        Cubic firstCubic = null;
        Cubic lastCubic = null;
        List firstFeatureSplitStart = null;
        List firstFeatureSplitEnd = null;
        if (this.features.size() > 0 && this.features.get(0).getCubics().size() == 3) {
            Cubic centerCubic = this.features.get(0).getCubics().get(1);
            Pair<Cubic, Cubic> pair = centerCubic.split(0.5f);
            Cubic start = (Cubic)pair.component1();
            Cubic end = (Cubic)pair.component2();
            Object[] objectArray = new Cubic[]{this.features.get(0).getCubics().get(0), start};
            firstFeatureSplitStart = CollectionsKt.mutableListOf((Object[])objectArray);
            objectArray = new Cubic[]{end, this.features.get(0).getCubics().get(2)};
            firstFeatureSplitEnd = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        if ((i = 0) <= (n = this.features.size())) {
            while (true) {
                List list3;
                if (i == 0 && firstFeatureSplitEnd != null) {
                    list3 = firstFeatureSplitEnd;
                } else if (i == this.features.size()) {
                    list3 = firstFeatureSplitStart;
                    if (list3 == null) {
                        break;
                    }
                } else {
                    list3 = this.features.get(i).getCubics();
                }
                List featureCubics = list3;
                int n2 = featureCubics.size();
                for (int j = 0; j < n2; ++j) {
                    Cubic cubic = featureCubics.get(j);
                    if (!cubic.zeroLength$graphics_shapes()) {
                        if (lastCubic != null) {
                            $this$cubics_u24lambda_u240.add(lastCubic);
                        }
                        lastCubic = cubic;
                        if (firstCubic != null) continue;
                        firstCubic = cubic;
                        continue;
                    }
                    if (lastCubic == null) continue;
                    lastCubic.getPoints$graphics_shapes()[6] = cubic.getAnchor1X();
                    lastCubic.getPoints$graphics_shapes()[7] = cubic.getAnchor1Y();
                }
                if (i == n) break;
                ++i;
            }
        }
        if (lastCubic != null && firstCubic != null) {
            $this$cubics_u24lambda_u240.add(CubicKt.Cubic(lastCubic.getAnchor0X(), lastCubic.getAnchor0Y(), lastCubic.getControl0X(), lastCubic.getControl0Y(), lastCubic.getControl1X(), lastCubic.getControl1Y(), firstCubic.getAnchor0X(), firstCubic.getAnchor0Y()));
        }
        roundedPolygon.cubics = CollectionsKt.build((List)list);
        Cubic prevCubic = null;
        prevCubic = this.cubics.get(this.cubics.size() - 1);
        String tag$iv = "RoundedPolygon";
        boolean $i$f$debugLog = false;
        int n3 = this.cubics.size();
        for (int index = 0; index < n3; ++index) {
            Cubic cubic = this.cubics.get(index);
            String tag$iv2 = "RoundedPolygon";
            boolean $i$f$debugLog2 = false;
            if (Math.abs(cubic.getAnchor0X() - prevCubic.getAnchor1X()) > 1.0E-4f || Math.abs(cubic.getAnchor0Y() - prevCubic.getAnchor1Y()) > 1.0E-4f) {
                tag$iv2 = "RoundedPolygon";
                $i$f$debugLog2 = false;
                throw new IllegalArgumentException("RoundedPolygon must be contiguous, with the anchor points of all curves matching the anchor points of the preceding and succeeding cubics");
            }
            prevCubic = cubic;
        }
    }

    @NotNull
    public final List<Feature> getFeatures$graphics_shapes() {
        return this.features;
    }

    public final float getCenterX() {
        return this.centerX;
    }

    public final float getCenterY() {
        return this.centerY;
    }

    @NotNull
    public final List<Cubic> getCubics() {
        return this.cubics;
    }

    @NotNull
    public final RoundedPolygon transformed(@NotNull PointTransformer f) {
        List list;
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        long center = PointKt.transformed-so9K2fw(FloatFloatPair.constructor-impl((float)this.centerX, (float)this.centerY), f);
        List $this$transformed_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int n = this.features.size();
        for (int i = 0; i < n; ++i) {
            $this$transformed_u24lambda_u244.add(this.features.get(i).transformed$graphics_shapes(f));
        }
        float f2 = PointKt.getY-DnnuFBc(center);
        float f3 = PointKt.getX-DnnuFBc(center);
        List list2 = CollectionsKt.build((List)list);
        return new RoundedPolygon(list2, f3, f2);
    }

    @NotNull
    public final RoundedPolygon normalized() {
        float[] bounds = RoundedPolygon.calculateBounds$default(this, null, false, 3, null);
        float width = bounds[2] - bounds[0];
        float height = bounds[3] - bounds[1];
        float side = Math.max(width, height);
        float offsetX = (side - width) / (float)2 - bounds[0];
        float offsetY = (side - height) / (float)2 - bounds[1];
        return this.transformed(new PointTransformer(offsetX, side, offsetY){
            final /* synthetic */ float $offsetX;
            final /* synthetic */ float $side;
            final /* synthetic */ float $offsetY;
            {
                this.$offsetX = $offsetX;
                this.$side = $side;
                this.$offsetY = $offsetY;
            }

            public final long transform-XgqJiTY(float x, float y) {
                return FloatFloatPair.constructor-impl((float)((x + this.$offsetX) / this.$side), (float)((y + this.$offsetY) / this.$side));
            }
        });
    }

    @NotNull
    public String toString() {
        return "[RoundedPolygon. Cubics = " + CollectionsKt.joinToString$default((Iterable)this.cubics, null, null, null, (int)0, null, null, (int)63, null) + " || Features = " + CollectionsKt.joinToString$default((Iterable)this.features, null, null, null, (int)0, null, null, (int)63, null) + " || Center = (" + this.centerX + ", " + this.centerY + ")]";
    }

    @NotNull
    public final float[] calculateMaxBounds(@NotNull float[] bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        if (!(bounds.length >= 4)) {
            boolean $i$a$-require-RoundedPolygon$calculateMaxBounds$22 = false;
            String $i$a$-require-RoundedPolygon$calculateMaxBounds$22 = "Required bounds size of 4";
            throw new IllegalArgumentException($i$a$-require-RoundedPolygon$calculateMaxBounds$22.toString());
        }
        float maxDistSquared = 0.0f;
        int n = this.cubics.size();
        for (int i = 0; i < n; ++i) {
            Cubic cubic = this.cubics.get(i);
            float anchorDistance = Utils.distanceSquared(cubic.getAnchor0X() - this.centerX, cubic.getAnchor0Y() - this.centerY);
            long middlePoint = cubic.pointOnCurve-OOQOV4g$graphics_shapes(0.5f);
            float middleDistance = Utils.distanceSquared(PointKt.getX-DnnuFBc(middlePoint) - this.centerX, PointKt.getY-DnnuFBc(middlePoint) - this.centerY);
            maxDistSquared = Math.max(maxDistSquared, Math.max(anchorDistance, middleDistance));
        }
        float distance = (float)Math.sqrt(maxDistSquared);
        bounds[0] = this.centerX - distance;
        bounds[1] = this.centerY - distance;
        bounds[2] = this.centerX + distance;
        bounds[3] = this.centerY + distance;
        return bounds;
    }

    public static /* synthetic */ float[] calculateMaxBounds$default(RoundedPolygon roundedPolygon, float[] fArray, int n, Object object) {
        if ((n & 1) != 0) {
            fArray = new float[4];
        }
        return roundedPolygon.calculateMaxBounds(fArray);
    }

    @JvmOverloads
    @NotNull
    public final float[] calculateBounds(@NotNull float[] bounds, boolean approximate) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        if (!(bounds.length >= 4)) {
            boolean $i$a$-require-RoundedPolygon$calculateBounds$22 = false;
            String $i$a$-require-RoundedPolygon$calculateBounds$22 = "Required bounds size of 4";
            throw new IllegalArgumentException($i$a$-require-RoundedPolygon$calculateBounds$22.toString());
        }
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        int n = this.cubics.size();
        for (int i = 0; i < n; ++i) {
            Cubic cubic = this.cubics.get(i);
            cubic.calculateBounds$graphics_shapes(bounds, approximate);
            minX = Math.min(minX, bounds[0]);
            minY = Math.min(minY, bounds[1]);
            maxX = Math.max(maxX, bounds[2]);
            maxY = Math.max(maxY, bounds[3]);
        }
        bounds[0] = minX;
        bounds[1] = minY;
        bounds[2] = maxX;
        bounds[3] = maxY;
        return bounds;
    }

    public static /* synthetic */ float[] calculateBounds$default(RoundedPolygon roundedPolygon, float[] fArray, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            fArray = new float[4];
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return roundedPolygon.calculateBounds(fArray, bl);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RoundedPolygon)) {
            return false;
        }
        return Intrinsics.areEqual(this.features, ((RoundedPolygon)other).features);
    }

    public int hashCode() {
        return ((Object)this.features).hashCode();
    }

    @JvmOverloads
    @NotNull
    public final float[] calculateBounds(@NotNull float[] bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return RoundedPolygon.calculateBounds$default(this, bounds, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final float[] calculateBounds() {
        return RoundedPolygon.calculateBounds$default(this, null, false, 3, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Landroidx/graphics/shapes/RoundedPolygon$Companion;", "", "()V", "graphics-shapes"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

