/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.annotation.IntRange;
import androidx.collection.FloatFloatPair;
import androidx.collection.MutableFloatList;
import androidx.graphics.shapes.CornerRounding;
import androidx.graphics.shapes.Cubic;
import androidx.graphics.shapes.Feature;
import androidx.graphics.shapes.PointKt;
import androidx.graphics.shapes.RoundedCorner;
import androidx.graphics.shapes.RoundedPolygon;
import androidx.graphics.shapes.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a@\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0007\u001aL\u0010\u0000\u001a\u00020\u00012\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\n2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\bH\u0007\u001a\u0019\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0012\u001a(\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"RoundedPolygon", "Landroidx/graphics/shapes/RoundedPolygon;", "source", "vertices", "", "rounding", "Landroidx/graphics/shapes/CornerRounding;", "perVertexRounding", "", "centerX", "", "centerY", "numVertices", "", "radius", "calculateCenter", "Landroidx/collection/FloatFloatPair;", "Landroidx/graphics/shapes/Point;", "([F)J", "verticesFromNumVerts", "graphics-shapes"})
@SourceDebugExtension(value={"SMAP\nRoundedPolygon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoundedPolygon.kt\nandroidx/graphics/shapes/RoundedPolygonKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FloatFloatPair.kt\nandroidx/collection/FloatFloatPair\n+ 4 PackingHelpers.jvm.kt\nandroidx/collection/internal/PackingHelpers_jvmKt\n*L\n1#1,670:1\n1549#2:671\n1620#2,3:672\n67#3:675\n81#3:677\n22#4:676\n*S KotlinDebug\n*F\n+ 1 RoundedPolygon.kt\nandroidx/graphics/shapes/RoundedPolygonKt\n*L\n354#1:671\n354#1:672,3\n429#1:675\n429#1:677\n429#1:676\n*E\n"})
public final class RoundedPolygonKt {
    @JvmOverloads
    @NotNull
    public static final RoundedPolygon RoundedPolygon(@IntRange(from=3L) int numVertices, float radius, float centerX, float centerY, @NotNull CornerRounding rounding, @Nullable List<CornerRounding> perVertexRounding) {
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return RoundedPolygonKt.RoundedPolygon(RoundedPolygonKt.verticesFromNumVerts(numVertices, radius, centerX, centerY), rounding, perVertexRounding, centerX, centerY);
    }

    public static /* synthetic */ RoundedPolygon RoundedPolygon$default(int n, float f, float f2, float f3, CornerRounding cornerRounding, List list, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 1.0f;
        }
        if ((n2 & 4) != 0) {
            f2 = 0.0f;
        }
        if ((n2 & 8) != 0) {
            f3 = 0.0f;
        }
        if ((n2 & 0x10) != 0) {
            cornerRounding = CornerRounding.Unrounded;
        }
        if ((n2 & 0x20) != 0) {
            list = null;
        }
        return RoundedPolygonKt.RoundedPolygon(n, f, f2, f3, cornerRounding, list);
    }

    @NotNull
    public static final RoundedPolygon RoundedPolygon(@NotNull RoundedPolygon source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new RoundedPolygon(source.getFeatures$graphics_shapes(), source.getCenterX(), source.getCenterY());
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public static final RoundedPolygon RoundedPolygon(@NotNull float[] vertices, @NotNull CornerRounding rounding, @Nullable List<CornerRounding> perVertexRounding, float centerX, float centerY) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)vertices, (String)"vertices");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        if (vertices.length < 6) {
            throw new IllegalArgumentException("Polygons must have at least 3 vertices");
        }
        if (vertices.length % 2 == 1) {
            throw new IllegalArgumentException("The vertices array should have even size");
        }
        if (perVertexRounding != null && perVertexRounding.size() * 2 != vertices.length) {
            throw new IllegalArgumentException("perVertexRounding list should be either null or the same size as the number of vertices (vertices.size / 2)");
        }
        List corners = new ArrayList();
        int n = vertices.length / 2;
        List roundedCorners = new ArrayList();
        for (int i = 0; i < n; ++i) {
            List<CornerRounding> list = perVertexRounding;
            if (list == null || (list = list.get(i)) == null) {
                list = rounding;
            }
            List<CornerRounding> vtxRounding = list;
            int prevIndex = (i + n - 1) % n * 2;
            int nextIndex = (i + 1) % n * 2;
            roundedCorners.add(new RoundedCorner(FloatFloatPair.constructor-impl((float)vertices[prevIndex], (float)vertices[prevIndex + 1]), FloatFloatPair.constructor-impl((float)vertices[i * 2], (float)vertices[i * 2 + 1]), FloatFloatPair.constructor-impl((float)vertices[nextIndex], (float)vertices[nextIndex + 1]), (CornerRounding)((Object)vtxRounding), null));
        }
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)n);
        boolean $i$f$map = false;
        Iterable nextIndex = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void ix;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            float expectedRoundCut = ((RoundedCorner)roundedCorners.get((int)ix)).getExpectedRoundCut() + ((RoundedCorner)roundedCorners.get((int)((ix + true) % n))).getExpectedRoundCut();
            float expectedCut = ((RoundedCorner)roundedCorners.get((int)ix)).getExpectedCut() + ((RoundedCorner)roundedCorners.get((int)((ix + true) % n))).getExpectedCut();
            float vtxX = vertices[ix * 2];
            float nextVtxX = vertices[(ix + true) % n * 2];
            float vtxY = vertices[ix * 2 + true];
            float nextVtxY = vertices[(ix + true) % n * 2 + true];
            float sideSize = Utils.distance(vtxX - nextVtxX, vtxY - nextVtxY);
            collection.add(expectedRoundCut > sideSize ? TuplesKt.to((Object)Float.valueOf(sideSize / expectedRoundCut), (Object)Float.valueOf(0.0f)) : (expectedCut > sideSize ? TuplesKt.to((Object)Float.valueOf(1.0f), (Object)Float.valueOf((sideSize - expectedRoundCut) / (expectedCut - expectedRoundCut))) : TuplesKt.to((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f))));
        }
        List cutAdjusts = (List)destination$iv$iv;
        for (int i = 0; i < n; ++i) {
            MutableFloatList allowedCuts = new MutableFloatList(2);
            for (int delta = 0; delta < 2; ++delta) {
                destination$iv$iv = (Pair)cutAdjusts.get((i + n - 1 + delta) % n);
                float roundCutRatio = ((Number)destination$iv$iv.component1()).floatValue();
                float cutRatio = ((Number)destination$iv$iv.component2()).floatValue();
                allowedCuts.add(((RoundedCorner)roundedCorners.get(i)).getExpectedRoundCut() * roundCutRatio + (((RoundedCorner)roundedCorners.get(i)).getExpectedCut() - ((RoundedCorner)roundedCorners.get(i)).getExpectedRoundCut()) * cutRatio);
            }
            corners.add(((RoundedCorner)roundedCorners.get(i)).getCubics(allowedCuts.get(0), allowedCuts.get(1)));
        }
        List tempFeatures = new ArrayList();
        for (int i = 0; i < n; ++i) {
            int prevVtxIndex = (i + n - 1) % n;
            int nextVtxIndex = (i + 1) % n;
            long currVertex = FloatFloatPair.constructor-impl((float)vertices[i * 2], (float)vertices[i * 2 + 1]);
            long prevVertex = FloatFloatPair.constructor-impl((float)vertices[prevVtxIndex * 2], (float)vertices[prevVtxIndex * 2 + 1]);
            long nextVertex = FloatFloatPair.constructor-impl((float)vertices[nextVtxIndex * 2], (float)vertices[nextVtxIndex * 2 + 1]);
            boolean convex = PointKt.clockwise-ybeJwSQ(PointKt.minus-ybeJwSQ(currVertex, prevVertex), PointKt.minus-ybeJwSQ(nextVertex, currVertex));
            tempFeatures.add(new Feature.Corner((List)corners.get(i), currVertex, ((RoundedCorner)roundedCorners.get(i)).getCenter-1ufDz9w(), convex, null));
            tempFeatures.add(new Feature.Edge(CollectionsKt.listOf((Object)Cubic.Companion.straightLine(((Cubic)CollectionsKt.last((List)((List)corners.get(i)))).getAnchor1X(), ((Cubic)CollectionsKt.last((List)((List)corners.get(i)))).getAnchor1Y(), ((Cubic)CollectionsKt.first((List)((List)corners.get((i + 1) % n)))).getAnchor0X(), ((Cubic)CollectionsKt.first((List)((List)corners.get((i + 1) % n)))).getAnchor0Y()))));
        }
        long l = centerX == Float.MIN_VALUE || centerY == Float.MIN_VALUE ? RoundedPolygonKt.calculateCenter(vertices) : FloatFloatPair.constructor-impl((float)centerX, (float)centerY);
        boolean bl = false;
        int bits$iv$iv = (int)(l >> 32);
        boolean $i$f$floatFromBits = false;
        float cx = Float.intBitsToFloat(bits$iv$iv);
        boolean bl2 = false;
        int bits$iv$iv2 = (int)(l & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits2 = false;
        float cy = Float.intBitsToFloat(bits$iv$iv2);
        return new RoundedPolygon(tempFeatures, cx, cy);
    }

    public static /* synthetic */ RoundedPolygon RoundedPolygon$default(float[] fArray, CornerRounding cornerRounding, List list, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            cornerRounding = CornerRounding.Unrounded;
        }
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 8) != 0) {
            f = Float.MIN_VALUE;
        }
        if ((n & 0x10) != 0) {
            f2 = Float.MIN_VALUE;
        }
        return RoundedPolygonKt.RoundedPolygon(fArray, cornerRounding, list, f, f2);
    }

    private static final long calculateCenter(float[] vertices) {
        float cumulativeX = 0.0f;
        float cumulativeY = 0.0f;
        int index = 0;
        while (index < vertices.length) {
            cumulativeX += vertices[index++];
            cumulativeY += vertices[index++];
        }
        return FloatFloatPair.constructor-impl((float)(cumulativeX / (float)vertices.length / (float)2), (float)(cumulativeY / (float)vertices.length / (float)2));
    }

    private static final float[] verticesFromNumVerts(int numVertices, float radius, float centerX, float centerY) {
        float[] result = new float[numVertices * 2];
        int arrayIndex = 0;
        for (int i = 0; i < numVertices; ++i) {
            long vertex = PointKt.plus-ybeJwSQ(Utils.radialToCartesian-L6JJ3z0$default(radius, Utils.getFloatPi() / (float)numVertices * (float)2 * (float)i, 0L, 4, null), FloatFloatPair.constructor-impl((float)centerX, (float)centerY));
            result[arrayIndex++] = PointKt.getX-DnnuFBc(vertex);
            result[arrayIndex++] = PointKt.getY-DnnuFBc(vertex);
        }
        return result;
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon RoundedPolygon(@IntRange(from=3L) int numVertices, float radius, float centerX, float centerY, @NotNull CornerRounding rounding) {
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return RoundedPolygonKt.RoundedPolygon$default(numVertices, radius, centerX, centerY, rounding, null, 32, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon RoundedPolygon(@IntRange(from=3L) int numVertices, float radius, float centerX, float centerY) {
        return RoundedPolygonKt.RoundedPolygon$default(numVertices, radius, centerX, centerY, null, null, 48, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon RoundedPolygon(@IntRange(from=3L) int numVertices, float radius, float centerX) {
        return RoundedPolygonKt.RoundedPolygon$default(numVertices, radius, centerX, 0.0f, null, null, 56, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon RoundedPolygon(@IntRange(from=3L) int numVertices, float radius) {
        return RoundedPolygonKt.RoundedPolygon$default(numVertices, radius, 0.0f, 0.0f, null, null, 60, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon RoundedPolygon(@IntRange(from=3L) int numVertices) {
        return RoundedPolygonKt.RoundedPolygon$default(numVertices, 0.0f, 0.0f, 0.0f, null, null, 62, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon RoundedPolygon(@NotNull float[] vertices, @NotNull CornerRounding rounding, @Nullable List<CornerRounding> perVertexRounding, float centerX) {
        Intrinsics.checkNotNullParameter((Object)vertices, (String)"vertices");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return RoundedPolygonKt.RoundedPolygon$default(vertices, rounding, perVertexRounding, centerX, 0.0f, 16, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon RoundedPolygon(@NotNull float[] vertices, @NotNull CornerRounding rounding, @Nullable List<CornerRounding> perVertexRounding) {
        Intrinsics.checkNotNullParameter((Object)vertices, (String)"vertices");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return RoundedPolygonKt.RoundedPolygon$default(vertices, rounding, perVertexRounding, 0.0f, 0.0f, 24, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon RoundedPolygon(@NotNull float[] vertices, @NotNull CornerRounding rounding) {
        Intrinsics.checkNotNullParameter((Object)vertices, (String)"vertices");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return RoundedPolygonKt.RoundedPolygon$default(vertices, rounding, null, 0.0f, 0.0f, 28, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon RoundedPolygon(@NotNull float[] vertices) {
        Intrinsics.checkNotNullParameter((Object)vertices, (String)"vertices");
        return RoundedPolygonKt.RoundedPolygon$default(vertices, null, null, 0.0f, 0.0f, 30, null);
    }
}

