/*
 * Decompiled with CFR 0.152.
 */
package androidx.graphics.shapes;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.collection.FloatFloatPair;
import androidx.graphics.shapes.CornerRounding;
import androidx.graphics.shapes.PointKt;
import androidx.graphics.shapes.RoundedPolygon;
import androidx.graphics.shapes.RoundedPolygonKt;
import androidx.graphics.shapes.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u001aH\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a0\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a4\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\b\b\u0003\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u0007\u001a>\u0010\u0012\u001a\u00020\u000f*\u00020\u00102\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u0007\u001a\u0084\u0001\u0010\u0014\u001a\u00020\u000f*\u00020\u00102\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001a2\b\b\u0003\u0010\b\u001a\u00020\u00052\b\b\u0003\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u0007\u001aN\u0010\u001b\u001a\u00020\u000f*\u00020\u00102\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u00172\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001a2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u001ad\u0010\u001c\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001a2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u0007\u00a8\u0006\u001d"}, d2={"pillStarVerticesFromNumVerts", "", "numVerticesPerRadius", "", "width", "", "height", "innerRadius", "vertexSpacing", "startLocation", "centerX", "centerY", "starVerticesFromNumVerts", "radius", "circle", "Landroidx/graphics/shapes/RoundedPolygon;", "Landroidx/graphics/shapes/RoundedPolygon$Companion;", "numVertices", "pill", "smoothing", "pillStar", "innerRadiusRatio", "rounding", "Landroidx/graphics/shapes/CornerRounding;", "innerRounding", "perVertexRounding", "", "rectangle", "star", "graphics-shapes"})
@SourceDebugExtension(value={"SMAP\nShapes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Shapes.kt\nandroidx/graphics/shapes/ShapesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,449:1\n1360#2:450\n1446#2,5:451\n1360#2:456\n1446#2,5:457\n*S KotlinDebug\n*F\n+ 1 Shapes.kt\nandroidx/graphics/shapes/ShapesKt\n*L\n151#1:450\n151#1:451,5\n289#1:456\n289#1:457,5\n*E\n"})
public final class ShapesKt {
    @JvmOverloads
    @NotNull
    public static final RoundedPolygon circle(@NotNull RoundedPolygon.Companion $this$circle, @IntRange(from=3L) int numVertices, float radius, float centerX, float centerY) {
        Intrinsics.checkNotNullParameter((Object)$this$circle, (String)"<this>");
        if (numVertices < 3) {
            throw new IllegalArgumentException("Circle must have at least three vertices");
        }
        float theta = Utils.getFloatPi() / (float)numVertices;
        float polygonRadius = radius / (float)Math.cos(theta);
        CornerRounding cornerRounding = new CornerRounding(radius, 0.0f, 2, null);
        return RoundedPolygonKt.RoundedPolygon$default(numVertices, polygonRadius, centerX, centerY, cornerRounding, null, 32, null);
    }

    public static /* synthetic */ RoundedPolygon circle$default(RoundedPolygon.Companion companion, int n, float f, float f2, float f3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 8;
        }
        if ((n2 & 2) != 0) {
            f = 1.0f;
        }
        if ((n2 & 4) != 0) {
            f2 = 0.0f;
        }
        if ((n2 & 8) != 0) {
            f3 = 0.0f;
        }
        return ShapesKt.circle(companion, n, f, f2, f3);
    }

    @NotNull
    public static final RoundedPolygon rectangle(@NotNull RoundedPolygon.Companion $this$rectangle, float width, float height, @NotNull CornerRounding rounding, @Nullable List<CornerRounding> perVertexRounding, float centerX, float centerY) {
        Intrinsics.checkNotNullParameter((Object)$this$rectangle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        float left = centerX - width / (float)2;
        float top = centerY - height / (float)2;
        float right = centerX + width / (float)2;
        float bottom = centerY + height / (float)2;
        float[] fArray = new float[]{right, bottom, left, bottom, left, top, right, top};
        return RoundedPolygonKt.RoundedPolygon(fArray, rounding, perVertexRounding, centerX, centerY);
    }

    public static /* synthetic */ RoundedPolygon rectangle$default(RoundedPolygon.Companion companion, float f, float f2, CornerRounding cornerRounding, List list, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = 2.0f;
        }
        if ((n & 2) != 0) {
            f2 = 2.0f;
        }
        if ((n & 4) != 0) {
            cornerRounding = CornerRounding.Unrounded;
        }
        if ((n & 8) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            f3 = 0.0f;
        }
        if ((n & 0x20) != 0) {
            f4 = 0.0f;
        }
        return ShapesKt.rectangle(companion, f, f2, cornerRounding, list, f3, f4);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius, float radius, float innerRadius, @NotNull CornerRounding rounding, @Nullable CornerRounding innerRounding, @Nullable List<CornerRounding> perVertexRounding, float centerX, float centerY) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        if (radius <= 0.0f || innerRadius <= 0.0f) {
            throw new IllegalArgumentException("Star radii must both be greater than 0");
        }
        if (innerRadius >= radius) {
            throw new IllegalArgumentException("innerRadius must be less than radius");
        }
        List pvRounding = perVertexRounding;
        if (pvRounding == null && innerRounding != null) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = (Iterable)RangesKt.until((int)0, (int)numVerticesPerRadius);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv$iv;
                int it = element$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                Object[] objectArray = new CornerRounding[]{rounding, innerRounding};
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            pvRounding = (List)destination$iv$iv;
        }
        return RoundedPolygonKt.RoundedPolygon(ShapesKt.starVerticesFromNumVerts(numVerticesPerRadius, radius, innerRadius, centerX, centerY), rounding, pvRounding, centerX, centerY);
    }

    public static /* synthetic */ RoundedPolygon star$default(RoundedPolygon.Companion companion, int n, float f, float f2, CornerRounding cornerRounding, CornerRounding cornerRounding2, List list, float f3, float f4, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 1.0f;
        }
        if ((n2 & 4) != 0) {
            f2 = 0.5f;
        }
        if ((n2 & 8) != 0) {
            cornerRounding = CornerRounding.Unrounded;
        }
        if ((n2 & 0x10) != 0) {
            cornerRounding2 = null;
        }
        if ((n2 & 0x20) != 0) {
            list = null;
        }
        if ((n2 & 0x40) != 0) {
            f3 = 0.0f;
        }
        if ((n2 & 0x80) != 0) {
            f4 = 0.0f;
        }
        return ShapesKt.star(companion, n, f, f2, cornerRounding, cornerRounding2, list, f3, f4);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pill(@NotNull RoundedPolygon.Companion $this$pill, float width, float height, float smoothing, float centerX, float centerY) {
        Intrinsics.checkNotNullParameter((Object)$this$pill, (String)"<this>");
        if (!(width > 0.0f && height > 0.0f)) {
            boolean bl = false;
            throw new IllegalArgumentException("Pill shapes must have positive width and height");
        }
        float wHalf = width / (float)2;
        float hHalf = height / (float)2;
        float[] fArray = new float[]{wHalf + centerX, hHalf + centerY, -wHalf + centerX, hHalf + centerY, -wHalf + centerX, -hHalf + centerY, wHalf + centerX, -hHalf + centerY};
        return RoundedPolygonKt.RoundedPolygon$default(fArray, new CornerRounding(Math.min(wHalf, hHalf), smoothing), null, centerX, centerY, 4, null);
    }

    public static /* synthetic */ RoundedPolygon pill$default(RoundedPolygon.Companion companion, float f, float f2, float f3, float f4, float f5, int n, Object object) {
        if ((n & 1) != 0) {
            f = 2.0f;
        }
        if ((n & 2) != 0) {
            f2 = 1.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        if ((n & 8) != 0) {
            f4 = 0.0f;
        }
        if ((n & 0x10) != 0) {
            f5 = 0.0f;
        }
        return ShapesKt.pill(companion, f, f2, f3, f4, f5);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pillStar(@NotNull RoundedPolygon.Companion $this$pillStar, float width, float height, int numVerticesPerRadius, @FloatRange(from=0.0, to=1.0, fromInclusive=false, toInclusive=false) float innerRadiusRatio, @NotNull CornerRounding rounding, @Nullable CornerRounding innerRounding, @Nullable List<CornerRounding> perVertexRounding, @FloatRange(from=0.0, to=1.0) float vertexSpacing, @FloatRange(from=0.0, to=1.0) float startLocation, float centerX, float centerY) {
        Intrinsics.checkNotNullParameter((Object)$this$pillStar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        if (!(width > 0.0f && height > 0.0f)) {
            boolean bl = false;
            throw new IllegalArgumentException("Pill shapes must have positive width and height");
        }
        if (!(innerRadiusRatio > 0.0f && innerRadiusRatio <= 1.0f)) {
            boolean bl = false;
            throw new IllegalArgumentException("innerRadius must be between 0 and 1");
        }
        List pvRounding = perVertexRounding;
        if (pvRounding == null && innerRounding != null) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = (Iterable)RangesKt.until((int)0, (int)numVerticesPerRadius);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv$iv;
                int it = element$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                Object[] objectArray = new CornerRounding[]{rounding, innerRounding};
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            pvRounding = (List)destination$iv$iv;
        }
        return RoundedPolygonKt.RoundedPolygon(ShapesKt.pillStarVerticesFromNumVerts(numVerticesPerRadius, width, height, innerRadiusRatio, vertexSpacing, startLocation, centerX, centerY), rounding, pvRounding, centerX, centerY);
    }

    public static /* synthetic */ RoundedPolygon pillStar$default(RoundedPolygon.Companion companion, float f, float f2, int n, float f3, CornerRounding cornerRounding, CornerRounding cornerRounding2, List list, float f4, float f5, float f6, float f7, int n2, Object object) {
        if ((n2 & 1) != 0) {
            f = 2.0f;
        }
        if ((n2 & 2) != 0) {
            f2 = 1.0f;
        }
        if ((n2 & 4) != 0) {
            n = 8;
        }
        if ((n2 & 8) != 0) {
            f3 = 0.5f;
        }
        if ((n2 & 0x10) != 0) {
            cornerRounding = CornerRounding.Unrounded;
        }
        if ((n2 & 0x20) != 0) {
            cornerRounding2 = null;
        }
        if ((n2 & 0x40) != 0) {
            list = null;
        }
        if ((n2 & 0x80) != 0) {
            f4 = 0.5f;
        }
        if ((n2 & 0x100) != 0) {
            f5 = 0.0f;
        }
        if ((n2 & 0x200) != 0) {
            f6 = 0.0f;
        }
        if ((n2 & 0x400) != 0) {
            f7 = 0.0f;
        }
        return ShapesKt.pillStar(companion, f, f2, n, f3, cornerRounding, cornerRounding2, list, f4, f5, f6, f7);
    }

    private static final float[] pillStarVerticesFromNumVerts(int numVerticesPerRadius, float width, float height, float innerRadius, float vertexSpacing, float startLocation, float centerX, float centerY) {
        float[] sections;
        float endcapRadius = Math.min(width, height);
        float vSegLen = RangesKt.coerceAtLeast((float)(height - width), (float)0.0f);
        float hSegLen = RangesKt.coerceAtLeast((float)(width - height), (float)0.0f);
        float vSegHalf = vSegLen / (float)2;
        float hSegHalf = hSegLen / (float)2;
        float circlePerimeter = Utils.getTwoPi() * endcapRadius * Utils.interpolate(innerRadius, 1.0f, vertexSpacing);
        float perimeter = (float)2 * hSegLen + (float)2 * vSegLen + circlePerimeter;
        sections = new float[]{0.0f, vSegLen / (float)2, sections[1] + circlePerimeter / (float)4, sections[2] + hSegLen, sections[3] + circlePerimeter / (float)4, sections[4] + vSegLen, sections[5] + circlePerimeter / (float)4, sections[6] + hSegLen, sections[7] + circlePerimeter / (float)4, sections[8] + vSegLen / (float)2, perimeter};
        float tPerVertex = perimeter / (float)(2 * numVerticesPerRadius);
        boolean inner = false;
        int currSecIndex = 0;
        float secStart = 0.0f;
        float secEnd = sections[1];
        float t = startLocation * perimeter;
        float[] result = new float[numVerticesPerRadius * 4];
        int arrayIndex = 0;
        long rectBR = FloatFloatPair.constructor-impl((float)hSegHalf, (float)vSegHalf);
        long rectBL = FloatFloatPair.constructor-impl((float)(-hSegHalf), (float)vSegHalf);
        long rectTL = FloatFloatPair.constructor-impl((float)(-hSegHalf), (float)(-vSegHalf));
        long rectTR = FloatFloatPair.constructor-impl((float)hSegHalf, (float)(-vSegHalf));
        int n = numVerticesPerRadius * 2;
        for (int i = 0; i < n; ++i) {
            long l;
            float boundedT = t % perimeter;
            if (boundedT < secStart) {
                currSecIndex = 0;
            }
            while (boundedT >= sections[(currSecIndex + 1) % sections.length]) {
                currSecIndex = (currSecIndex + 1) % sections.length;
                secStart = sections[currSecIndex];
                secEnd = sections[(currSecIndex + 1) % sections.length];
            }
            float tInSection = boundedT - secStart;
            float tProportion = tInSection / (secEnd - secStart);
            float currRadius = inner ? endcapRadius * innerRadius : endcapRadius;
            switch (currSecIndex) {
                case 0: {
                    l = FloatFloatPair.constructor-impl((float)currRadius, (float)(tProportion * vSegHalf));
                    break;
                }
                case 1: {
                    l = PointKt.plus-ybeJwSQ(Utils.radialToCartesian-L6JJ3z0$default(currRadius, tProportion * Utils.getFloatPi() / (float)2, 0L, 4, null), rectBR);
                    break;
                }
                case 2: {
                    l = FloatFloatPair.constructor-impl((float)(hSegHalf - tProportion * hSegLen), (float)currRadius);
                    break;
                }
                case 3: {
                    l = PointKt.plus-ybeJwSQ(Utils.radialToCartesian-L6JJ3z0$default(currRadius, Utils.getFloatPi() / (float)2 + tProportion * Utils.getFloatPi() / (float)2, 0L, 4, null), rectBL);
                    break;
                }
                case 4: {
                    l = FloatFloatPair.constructor-impl((float)(-currRadius), (float)(vSegHalf - tProportion * vSegLen));
                    break;
                }
                case 5: {
                    l = PointKt.plus-ybeJwSQ(Utils.radialToCartesian-L6JJ3z0$default(currRadius, Utils.getFloatPi() + tProportion * Utils.getFloatPi() / (float)2, 0L, 4, null), rectTL);
                    break;
                }
                case 6: {
                    l = FloatFloatPair.constructor-impl((float)(-hSegHalf + tProportion * hSegLen), (float)(-currRadius));
                    break;
                }
                case 7: {
                    l = PointKt.plus-ybeJwSQ(Utils.radialToCartesian-L6JJ3z0$default(currRadius, Utils.getFloatPi() * 1.5f + tProportion * Utils.getFloatPi() / (float)2, 0L, 4, null), rectTR);
                    break;
                }
                default: {
                    l = FloatFloatPair.constructor-impl((float)currRadius, (float)(-vSegHalf + tProportion * vSegHalf));
                }
            }
            long vertex = l;
            result[arrayIndex++] = PointKt.getX-DnnuFBc(vertex) + centerX;
            result[arrayIndex++] = PointKt.getY-DnnuFBc(vertex) + centerY;
            t += tPerVertex;
            inner = !inner;
        }
        return result;
    }

    private static final float[] starVerticesFromNumVerts(int numVerticesPerRadius, float radius, float innerRadius, float centerX, float centerY) {
        float[] result = new float[numVerticesPerRadius * 4];
        int arrayIndex = 0;
        for (int i = 0; i < numVerticesPerRadius; ++i) {
            long vertex = Utils.radialToCartesian-L6JJ3z0$default(radius, Utils.getFloatPi() / (float)numVerticesPerRadius * (float)2 * (float)i, 0L, 4, null);
            result[arrayIndex++] = PointKt.getX-DnnuFBc(vertex) + centerX;
            result[arrayIndex++] = PointKt.getY-DnnuFBc(vertex) + centerY;
            vertex = Utils.radialToCartesian-L6JJ3z0$default(innerRadius, Utils.getFloatPi() / (float)numVerticesPerRadius * (float)(2 * i + 1), 0L, 4, null);
            result[arrayIndex++] = PointKt.getX-DnnuFBc(vertex) + centerX;
            result[arrayIndex++] = PointKt.getY-DnnuFBc(vertex) + centerY;
        }
        return result;
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon circle(@NotNull RoundedPolygon.Companion $this$circle, @IntRange(from=3L) int numVertices, float radius, float centerX) {
        Intrinsics.checkNotNullParameter((Object)$this$circle, (String)"<this>");
        return ShapesKt.circle$default($this$circle, numVertices, radius, centerX, 0.0f, 8, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon circle(@NotNull RoundedPolygon.Companion $this$circle, @IntRange(from=3L) int numVertices, float radius) {
        Intrinsics.checkNotNullParameter((Object)$this$circle, (String)"<this>");
        return ShapesKt.circle$default($this$circle, numVertices, radius, 0.0f, 0.0f, 12, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon circle(@NotNull RoundedPolygon.Companion $this$circle, @IntRange(from=3L) int numVertices) {
        Intrinsics.checkNotNullParameter((Object)$this$circle, (String)"<this>");
        return ShapesKt.circle$default($this$circle, numVertices, 0.0f, 0.0f, 0.0f, 14, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon circle(@NotNull RoundedPolygon.Companion $this$circle) {
        Intrinsics.checkNotNullParameter((Object)$this$circle, (String)"<this>");
        return ShapesKt.circle$default($this$circle, 0, 0.0f, 0.0f, 0.0f, 15, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius, float radius, float innerRadius, @NotNull CornerRounding rounding, @Nullable CornerRounding innerRounding, @Nullable List<CornerRounding> perVertexRounding, float centerX) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return ShapesKt.star$default($this$star, numVerticesPerRadius, radius, innerRadius, rounding, innerRounding, perVertexRounding, centerX, 0.0f, 128, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius, float radius, float innerRadius, @NotNull CornerRounding rounding, @Nullable CornerRounding innerRounding, @Nullable List<CornerRounding> perVertexRounding) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return ShapesKt.star$default($this$star, numVerticesPerRadius, radius, innerRadius, rounding, innerRounding, perVertexRounding, 0.0f, 0.0f, 192, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius, float radius, float innerRadius, @NotNull CornerRounding rounding, @Nullable CornerRounding innerRounding) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return ShapesKt.star$default($this$star, numVerticesPerRadius, radius, innerRadius, rounding, innerRounding, null, 0.0f, 0.0f, 224, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius, float radius, float innerRadius, @NotNull CornerRounding rounding) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return ShapesKt.star$default($this$star, numVerticesPerRadius, radius, innerRadius, rounding, null, null, 0.0f, 0.0f, 240, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius, float radius, float innerRadius) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        return ShapesKt.star$default($this$star, numVerticesPerRadius, radius, innerRadius, null, null, null, 0.0f, 0.0f, 248, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius, float radius) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        return ShapesKt.star$default($this$star, numVerticesPerRadius, radius, 0.0f, null, null, null, 0.0f, 0.0f, 252, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon star(@NotNull RoundedPolygon.Companion $this$star, int numVerticesPerRadius) {
        Intrinsics.checkNotNullParameter((Object)$this$star, (String)"<this>");
        return ShapesKt.star$default($this$star, numVerticesPerRadius, 0.0f, 0.0f, null, null, null, 0.0f, 0.0f, 254, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pill(@NotNull RoundedPolygon.Companion $this$pill, float width, float height, float smoothing, float centerX) {
        Intrinsics.checkNotNullParameter((Object)$this$pill, (String)"<this>");
        return ShapesKt.pill$default($this$pill, width, height, smoothing, centerX, 0.0f, 16, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pill(@NotNull RoundedPolygon.Companion $this$pill, float width, float height, float smoothing) {
        Intrinsics.checkNotNullParameter((Object)$this$pill, (String)"<this>");
        return ShapesKt.pill$default($this$pill, width, height, smoothing, 0.0f, 0.0f, 24, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pill(@NotNull RoundedPolygon.Companion $this$pill, float width, float height) {
        Intrinsics.checkNotNullParameter((Object)$this$pill, (String)"<this>");
        return ShapesKt.pill$default($this$pill, width, height, 0.0f, 0.0f, 0.0f, 28, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pill(@NotNull RoundedPolygon.Companion $this$pill, float width) {
        Intrinsics.checkNotNullParameter((Object)$this$pill, (String)"<this>");
        return ShapesKt.pill$default($this$pill, width, 0.0f, 0.0f, 0.0f, 0.0f, 30, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pill(@NotNull RoundedPolygon.Companion $this$pill) {
        Intrinsics.checkNotNullParameter((Object)$this$pill, (String)"<this>");
        return ShapesKt.pill$default($this$pill, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 31, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pillStar(@NotNull RoundedPolygon.Companion $this$pillStar, float width, float height, int numVerticesPerRadius, @FloatRange(from=0.0, to=1.0, fromInclusive=false, toInclusive=false) float innerRadiusRatio, @NotNull CornerRounding rounding, @Nullable CornerRounding innerRounding, @Nullable List<CornerRounding> perVertexRounding, @FloatRange(from=0.0, to=1.0) float vertexSpacing, @FloatRange(from=0.0, to=1.0) float startLocation, float centerX) {
        Intrinsics.checkNotNullParameter((Object)$this$pillStar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return ShapesKt.pillStar$default($this$pillStar, width, height, numVerticesPerRadius, innerRadiusRatio, rounding, innerRounding, perVertexRounding, vertexSpacing, startLocation, centerX, 0.0f, 1024, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pillStar(@NotNull RoundedPolygon.Companion $this$pillStar, float width, float height, int numVerticesPerRadius, @FloatRange(from=0.0, to=1.0, fromInclusive=false, toInclusive=false) float innerRadiusRatio, @NotNull CornerRounding rounding, @Nullable CornerRounding innerRounding, @Nullable List<CornerRounding> perVertexRounding, @FloatRange(from=0.0, to=1.0) float vertexSpacing, @FloatRange(from=0.0, to=1.0) float startLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$pillStar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return ShapesKt.pillStar$default($this$pillStar, width, height, numVerticesPerRadius, innerRadiusRatio, rounding, innerRounding, perVertexRounding, vertexSpacing, startLocation, 0.0f, 0.0f, 1536, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pillStar(@NotNull RoundedPolygon.Companion $this$pillStar, float width, float height, int numVerticesPerRadius, @FloatRange(from=0.0, to=1.0, fromInclusive=false, toInclusive=false) float innerRadiusRatio, @NotNull CornerRounding rounding, @Nullable CornerRounding innerRounding, @Nullable List<CornerRounding> perVertexRounding, @FloatRange(from=0.0, to=1.0) float vertexSpacing) {
        Intrinsics.checkNotNullParameter((Object)$this$pillStar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return ShapesKt.pillStar$default($this$pillStar, width, height, numVerticesPerRadius, innerRadiusRatio, rounding, innerRounding, perVertexRounding, vertexSpacing, 0.0f, 0.0f, 0.0f, 1792, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pillStar(@NotNull RoundedPolygon.Companion $this$pillStar, float width, float height, int numVerticesPerRadius, @FloatRange(from=0.0, to=1.0, fromInclusive=false, toInclusive=false) float innerRadiusRatio, @NotNull CornerRounding rounding, @Nullable CornerRounding innerRounding, @Nullable List<CornerRounding> perVertexRounding) {
        Intrinsics.checkNotNullParameter((Object)$this$pillStar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return ShapesKt.pillStar$default($this$pillStar, width, height, numVerticesPerRadius, innerRadiusRatio, rounding, innerRounding, perVertexRounding, 0.0f, 0.0f, 0.0f, 0.0f, 1920, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pillStar(@NotNull RoundedPolygon.Companion $this$pillStar, float width, float height, int numVerticesPerRadius, @FloatRange(from=0.0, to=1.0, fromInclusive=false, toInclusive=false) float innerRadiusRatio, @NotNull CornerRounding rounding, @Nullable CornerRounding innerRounding) {
        Intrinsics.checkNotNullParameter((Object)$this$pillStar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return ShapesKt.pillStar$default($this$pillStar, width, height, numVerticesPerRadius, innerRadiusRatio, rounding, innerRounding, null, 0.0f, 0.0f, 0.0f, 0.0f, 1984, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pillStar(@NotNull RoundedPolygon.Companion $this$pillStar, float width, float height, int numVerticesPerRadius, @FloatRange(from=0.0, to=1.0, fromInclusive=false, toInclusive=false) float innerRadiusRatio, @NotNull CornerRounding rounding) {
        Intrinsics.checkNotNullParameter((Object)$this$pillStar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rounding, (String)"rounding");
        return ShapesKt.pillStar$default($this$pillStar, width, height, numVerticesPerRadius, innerRadiusRatio, rounding, null, null, 0.0f, 0.0f, 0.0f, 0.0f, 2016, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pillStar(@NotNull RoundedPolygon.Companion $this$pillStar, float width, float height, int numVerticesPerRadius, @FloatRange(from=0.0, to=1.0, fromInclusive=false, toInclusive=false) float innerRadiusRatio) {
        Intrinsics.checkNotNullParameter((Object)$this$pillStar, (String)"<this>");
        return ShapesKt.pillStar$default($this$pillStar, width, height, numVerticesPerRadius, innerRadiusRatio, null, null, null, 0.0f, 0.0f, 0.0f, 0.0f, 2032, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pillStar(@NotNull RoundedPolygon.Companion $this$pillStar, float width, float height, int numVerticesPerRadius) {
        Intrinsics.checkNotNullParameter((Object)$this$pillStar, (String)"<this>");
        return ShapesKt.pillStar$default($this$pillStar, width, height, numVerticesPerRadius, 0.0f, null, null, null, 0.0f, 0.0f, 0.0f, 0.0f, 2040, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pillStar(@NotNull RoundedPolygon.Companion $this$pillStar, float width, float height) {
        Intrinsics.checkNotNullParameter((Object)$this$pillStar, (String)"<this>");
        return ShapesKt.pillStar$default($this$pillStar, width, height, 0, 0.0f, null, null, null, 0.0f, 0.0f, 0.0f, 0.0f, 2044, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pillStar(@NotNull RoundedPolygon.Companion $this$pillStar, float width) {
        Intrinsics.checkNotNullParameter((Object)$this$pillStar, (String)"<this>");
        return ShapesKt.pillStar$default($this$pillStar, width, 0.0f, 0, 0.0f, null, null, null, 0.0f, 0.0f, 0.0f, 0.0f, 2046, null);
    }

    @JvmOverloads
    @NotNull
    public static final RoundedPolygon pillStar(@NotNull RoundedPolygon.Companion $this$pillStar) {
        Intrinsics.checkNotNullParameter((Object)$this$pillStar, (String)"<this>");
        return ShapesKt.pillStar$default($this$pillStar, 0.0f, 0.0f, 0, 0.0f, null, null, null, 0.0f, 0.0f, 0.0f, 0.0f, 2047, null);
    }
}

