/*
 * Decompiled with CFR 0.152.
 */
package androidx.hilt.work;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.hilt.work.WorkerAssistedFactory;
import androidx.work.ListenableWorker;
import androidx.work.WorkerFactory;
import androidx.work.WorkerParameters;
import java.util.Map;
import javax.inject.Provider;

public final class HiltWorkerFactory
extends WorkerFactory {
    private final Map<String, Provider<WorkerAssistedFactory<? extends ListenableWorker>>> mWorkerFactories;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    HiltWorkerFactory(@NonNull Map<String, Provider<WorkerAssistedFactory<? extends ListenableWorker>>> workerFactories) {
        this.mWorkerFactories = workerFactories;
    }

    @Nullable
    public ListenableWorker createWorker(@NonNull Context appContext, @NonNull String workerClassName, @NonNull WorkerParameters workerParameters) {
        Provider<WorkerAssistedFactory<? extends ListenableWorker>> factoryProvider = this.mWorkerFactories.get(workerClassName);
        if (factoryProvider == null) {
            return null;
        }
        return ((WorkerAssistedFactory)factoryProvider.get()).create(appContext, workerParameters);
    }
}

