/*
 * Decompiled with CFR 0.152.
 */
package androidx.input.motionprediction.kalman;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.input.motionprediction.kalman.matrix.Matrix;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class KalmanFilter {
    @NonNull
    public Matrix x;
    @NonNull
    public Matrix P;
    @NonNull
    public Matrix Q;
    @NonNull
    public Matrix R;
    @NonNull
    public Matrix F;
    @NonNull
    public Matrix H;
    @NonNull
    public Matrix K;

    public KalmanFilter(int xDim, int zDim) {
        this.x = new Matrix(xDim, 1);
        this.P = Matrix.identity(xDim);
        this.Q = Matrix.identity(xDim);
        this.R = Matrix.identity(zDim);
        this.F = new Matrix(xDim, xDim);
        this.H = new Matrix(zDim, xDim);
        this.K = new Matrix(xDim, zDim);
    }

    public void reset() {
        this.x.fill(0.0);
        Matrix.setIdentity(this.P);
        this.K.fill(0.0);
    }

    public void predict() {
        this.x = this.F.dot(this.x);
        this.P = this.F.dot(this.P).dotTranspose(this.F).plus(this.Q);
    }

    public void update(@NonNull Matrix z) {
        Matrix y = z.minus(this.H.dot(this.x));
        Matrix tS = this.H.dot(this.P).dotTranspose(this.H).plus(this.R);
        this.K = this.P.dotTranspose(this.H).dot(tS.inverse());
        this.x = this.x.plus(this.K.dot(y));
        this.P = this.P.minus(this.K.dot(this.H).dot(this.P));
    }
}

