/*
 * Decompiled with CFR 0.152.
 */
package androidx.input.motionprediction.kalman;

import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.input.motionprediction.MotionEventPredictor;
import androidx.input.motionprediction.kalman.MultiPointerPredictor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class KalmanMotionEventPredictor
implements MotionEventPredictor {
    private MultiPointerPredictor mMultiPointerPredictor = new MultiPointerPredictor();
    private boolean mDisposed = false;

    public KalmanMotionEventPredictor() {
        this.mMultiPointerPredictor.setPredictionTarget(1);
    }

    @Override
    public void recordMovement(@NonNull MotionEvent event) {
        this.mMultiPointerPredictor.onTouchEvent(event);
    }

    @Override
    @Nullable
    public MotionEvent predict() {
        if (this.mDisposed) {
            return null;
        }
        return this.mMultiPointerPredictor.predict();
    }

    @Override
    public void dispose() {
        this.mDisposed = true;
    }
}

