/*
 * Decompiled with CFR 0.152.
 */
package androidx.input.motionprediction.kalman;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.input.motionprediction.kalman.KalmanFilter;
import androidx.input.motionprediction.kalman.matrix.DVector2;
import androidx.input.motionprediction.kalman.matrix.Matrix;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class PenKalmanFilter {
    private KalmanFilter mXKalman;
    private KalmanFilter mYKalman;
    private KalmanFilter mPKalman;
    private DVector2 mPosition = new DVector2();
    private DVector2 mVelocity = new DVector2();
    private DVector2 mAcceleration = new DVector2();
    private DVector2 mJank = new DVector2();
    private double mPressure = 0.0;
    private double mPressureChange = 0.0;
    private double mSigmaProcess;
    private double mSigmaMeasurement;
    private int mNumIterations = 0;
    private Matrix mNewX = new Matrix(1, 1);
    private Matrix mNewY = new Matrix(1, 1);
    private Matrix mNewP = new Matrix(1, 1);

    public PenKalmanFilter(double sigmaProcess, double sigmaMeasurement) {
        this.mSigmaProcess = sigmaProcess;
        this.mSigmaMeasurement = sigmaMeasurement;
        this.mXKalman = this.createAxisKalmanFilter();
        this.mYKalman = this.createAxisKalmanFilter();
        this.mPKalman = this.createAxisKalmanFilter();
    }

    public void reset() {
        this.mXKalman.reset();
        this.mYKalman.reset();
        this.mPKalman.reset();
        this.mNumIterations = 0;
    }

    public void update(float x, float y, float pressure) {
        if (this.mNumIterations == 0) {
            this.mXKalman.x.put(0, 0, x);
            this.mYKalman.x.put(0, 0, y);
            this.mPKalman.x.put(0, 0, pressure);
        } else {
            this.mNewX.put(0, 0, x);
            this.mXKalman.predict();
            this.mXKalman.update(this.mNewX);
            this.mNewY.put(0, 0, y);
            this.mYKalman.predict();
            this.mYKalman.update(this.mNewY);
            this.mNewP.put(0, 0, pressure);
            this.mPKalman.predict();
            this.mPKalman.update(this.mNewP);
        }
        ++this.mNumIterations;
        this.mPosition.a1 = this.mXKalman.x.get(0, 0);
        this.mPosition.a2 = this.mYKalman.x.get(0, 0);
        this.mVelocity.a1 = this.mXKalman.x.get(1, 0);
        this.mVelocity.a2 = this.mYKalman.x.get(1, 0);
        this.mAcceleration.a1 = this.mXKalman.x.get(2, 0);
        this.mAcceleration.a2 = this.mYKalman.x.get(2, 0);
        this.mJank.a1 = this.mXKalman.x.get(3, 0);
        this.mJank.a2 = this.mYKalman.x.get(3, 0);
        this.mPressure = this.mPKalman.x.get(0, 0);
        this.mPressureChange = this.mPKalman.x.get(1, 0);
    }

    @NonNull
    public DVector2 getPosition() {
        return this.mPosition;
    }

    @NonNull
    public DVector2 getVelocity() {
        return this.mVelocity;
    }

    @NonNull
    public DVector2 getAcceleration() {
        return this.mAcceleration;
    }

    @NonNull
    public DVector2 getJank() {
        return this.mJank;
    }

    public double getPressure() {
        return this.mPressure;
    }

    public double getPressureChange() {
        return this.mPressureChange;
    }

    public int getNumIterations() {
        return this.mNumIterations;
    }

    private KalmanFilter createAxisKalmanFilter() {
        double dt = 1.0;
        KalmanFilter kalman = new KalmanFilter(4, 1);
        kalman.F = new Matrix(4, new double[]{1.0, 1.0, 0.5, 0.16, 0.0, 1.0, 1.0, 0.5, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0});
        Matrix g = new Matrix(1, new double[]{0.16, 0.5, 1.0, 1.0});
        g.dotTranspose(g, kalman.Q);
        kalman.Q.scale(this.mSigmaProcess);
        kalman.H = new Matrix(4, new double[]{1.0, 0.0, 0.0, 0.0});
        kalman.R.put(0, 0, this.mSigmaMeasurement);
        return kalman;
    }
}

