/*
 * Decompiled with CFR 0.152.
 */
package androidx.input.motionprediction.kalman;

import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.util.Iterator;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class BatchedMotionEvent {
    public final MotionEvent.PointerCoords[] coords;
    public long timeMs;

    public BatchedMotionEvent(int pointerCount) {
        this.coords = new MotionEvent.PointerCoords[pointerCount];
        for (int i = 0; i < pointerCount; ++i) {
            this.coords[i] = new MotionEvent.PointerCoords();
        }
    }

    @NonNull
    public static IterableMotionEvent iterate(@NonNull MotionEvent ev) {
        return new IterableMotionEvent(ev);
    }

    public static class IterableMotionEvent
    implements Iterable<BatchedMotionEvent> {
        private final int mPointerCount;
        private final MotionEvent mMotionEvent;

        IterableMotionEvent(@NonNull MotionEvent motionEvent) {
            this.mMotionEvent = motionEvent;
            this.mPointerCount = motionEvent.getPointerCount();
        }

        @NonNull
        public MotionEvent getMotionEvent() {
            return this.mMotionEvent;
        }

        @NonNull
        public int getPointerCount() {
            return this.mPointerCount;
        }

        @Override
        @NonNull
        public Iterator<BatchedMotionEvent> iterator() {
            return new Iterator<BatchedMotionEvent>(){
                private int mHistoryId = 0;

                @Override
                public boolean hasNext() {
                    return this.mHistoryId < this.getMotionEvent().getHistorySize() + 1;
                }

                @Override
                public BatchedMotionEvent next() {
                    MotionEvent motionEvent = this.getMotionEvent();
                    int pointerCount = this.getPointerCount();
                    if (this.mHistoryId > motionEvent.getHistorySize()) {
                        return null;
                    }
                    BatchedMotionEvent batchedEvent = new BatchedMotionEvent(pointerCount);
                    if (this.mHistoryId < motionEvent.getHistorySize()) {
                        for (int pointerId = 0; pointerId < pointerCount; ++pointerId) {
                            motionEvent.getHistoricalPointerCoords(pointerId, this.mHistoryId, batchedEvent.coords[pointerId]);
                        }
                        batchedEvent.timeMs = motionEvent.getHistoricalEventTime(this.mHistoryId);
                    } else {
                        for (int pointerId = 0; pointerId < pointerCount; ++pointerId) {
                            motionEvent.getPointerCoords(pointerId, batchedEvent.coords[pointerId]);
                        }
                        batchedEvent.timeMs = motionEvent.getEventTime();
                    }
                    ++this.mHistoryId;
                    return batchedEvent;
                }
            };
        }
    }
}

