/*
 * Decompiled with CFR 0.152.
 */
package androidx.input.motionprediction.kalman;

import android.util.Log;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.input.motionprediction.kalman.BatchedMotionEvent;
import androidx.input.motionprediction.kalman.KalmanPredictor;
import androidx.input.motionprediction.kalman.PointerKalmanFilter;
import androidx.input.motionprediction.kalman.matrix.DVector2;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class SinglePointerPredictor
implements KalmanPredictor {
    private static final String TAG = "SinglePointerPredictor";
    private static final float JANK_INFLUENCE = 0.1f;
    private static final float ACCELERATION_INFLUENCE = 0.5f;
    private static final float VELOCITY_INFLUENCE = 1.0f;
    private static final float LOW_JANK = 0.02f;
    private static final float HIGH_JANK = 0.2f;
    private static final float LOW_SPEED = 0.0f;
    private static final float HIGH_SPEED = 2.0f;
    private static final int EVENT_TIME_IGNORED_THRESHOLD_MS = 20;
    private static final int MIN_KALMAN_FILTER_ITERATIONS = 4;
    private final PointerKalmanFilter mKalman = new PointerKalmanFilter(0.01, 1.0);
    private final DVector2 mLastPosition = new DVector2();
    private long mPrevEventTime;
    private List<Float> mReportRates = new LinkedList<Float>();
    private int mExpectedPredictionSampleSize = -1;
    private float mReportRateMs = 0.0f;
    private final DVector2 mPosition = new DVector2();
    private final DVector2 mVelocity = new DVector2();
    private final DVector2 mAcceleration = new DVector2();
    private final DVector2 mJank = new DVector2();
    private int mPointerId = 0;
    private int mToolType = 0;
    private double mPressure = 0.0;
    private double mLastOrientation = 0.0;
    private double mLastTilt = 0.0;

    public SinglePointerPredictor() {
        this.mKalman.reset();
        this.mPrevEventTime = 0L;
    }

    void initStrokePrediction(int pointerId, int toolType) {
        this.mKalman.reset();
        this.mPrevEventTime = 0L;
        this.mPointerId = pointerId;
        this.mToolType = toolType;
    }

    private void update(float x, float y, float pressure, float orientation, float tilt, long eventTime) {
        if ((double)x == this.mLastPosition.a1 && (double)y == this.mLastPosition.a2 && eventTime <= this.mPrevEventTime + 20L) {
            return;
        }
        this.mKalman.update(x, y, pressure);
        this.mLastPosition.a1 = x;
        this.mLastPosition.a2 = y;
        this.mLastOrientation = orientation;
        this.mLastTilt = tilt;
        if (this.mReportRates != null && this.mReportRates.size() < 20 && this.mPrevEventTime > 0L) {
            float dt = eventTime - this.mPrevEventTime;
            this.mReportRates.add(Float.valueOf(dt));
            float sum = 0.0f;
            for (float rate : this.mReportRates) {
                sum += rate;
            }
            this.mReportRateMs = sum / (float)this.mReportRates.size();
        }
        this.mPrevEventTime = eventTime;
    }

    @Override
    public void setReportRate(int reportRateMs) {
        if (reportRateMs <= 0) {
            throw new IllegalArgumentException("reportRateMs should always be a strictlypositive number");
        }
        this.mReportRateMs = reportRateMs;
        this.mReportRates = null;
    }

    @Override
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (event.getActionMasked() == 3) {
            this.mKalman.reset();
            this.mPrevEventTime = 0L;
            return false;
        }
        int pointerIndex = event.findPointerIndex(this.mPointerId);
        if (pointerIndex == -1) {
            Log.i((String)TAG, (String)String.format(Locale.ROOT, "onTouchEvent: Cannot find pointerId=%d in motionEvent=%s", this.mPointerId, event));
            return false;
        }
        for (BatchedMotionEvent ev : BatchedMotionEvent.iterate(event)) {
            MotionEvent.PointerCoords pointerCoords = ev.coords[pointerIndex];
            this.update(pointerCoords.x, pointerCoords.y, pointerCoords.pressure, pointerCoords.orientation, pointerCoords.getAxisValue(25), ev.timeMs);
        }
        return true;
    }

    @Override
    @Nullable
    public MotionEvent predict(int predictionTargetMs) {
        if (this.mReportRates == null) {
            this.mExpectedPredictionSampleSize = (int)Math.ceil((float)predictionTargetMs / this.mReportRateMs);
        }
        if (this.mExpectedPredictionSampleSize == -1 && this.mKalman.getNumIterations() < 4) {
            return null;
        }
        this.mPosition.set(this.mLastPosition);
        this.mVelocity.set(this.mKalman.getVelocity());
        this.mAcceleration.set(this.mKalman.getAcceleration());
        this.mJank.set(this.mKalman.getJank());
        this.mPressure = this.mKalman.getPressure();
        double pressureChange = this.mKalman.getPressureChange();
        double speedAbs = this.mVelocity.magnitude() / (double)this.mReportRateMs;
        double speedFactor = this.normalizeRange(speedAbs, 0.0, 2.0);
        double jankAbs = this.mJank.magnitude();
        double jankFactor = 1.0 - this.normalizeRange(jankAbs, 0.02f, 0.2f);
        double confidenceFactor = speedFactor * jankFactor;
        MotionEvent predictedEvent = null;
        MotionEvent.PointerProperties[] pointerProperties = new MotionEvent.PointerProperties[]{new MotionEvent.PointerProperties()};
        pointerProperties[0].id = this.mPointerId;
        pointerProperties[0].toolType = this.mToolType;
        int predictionTargetInSamples = (int)Math.ceil((double)((float)predictionTargetMs / this.mReportRateMs) * confidenceFactor);
        if (this.mExpectedPredictionSampleSize != -1 && predictionTargetInSamples > this.mExpectedPredictionSampleSize) {
            predictionTargetInSamples = this.mExpectedPredictionSampleSize;
        }
        for (int i = 0; i < predictionTargetInSamples; ++i) {
            this.mAcceleration.a1 += this.mJank.a1 * (double)0.1f;
            this.mAcceleration.a2 += this.mJank.a2 * (double)0.1f;
            this.mVelocity.a1 += this.mAcceleration.a1 * 0.5;
            this.mVelocity.a2 += this.mAcceleration.a2 * 0.5;
            this.mPosition.a1 += this.mVelocity.a1 * 1.0;
            this.mPosition.a2 += this.mVelocity.a2 * 1.0;
            this.mPressure += pressureChange;
            if (this.mPressure < 0.1) break;
            this.mPressure = Math.min(this.mPressure, 1.0);
            MotionEvent.PointerCoords[] coords = new MotionEvent.PointerCoords[]{new MotionEvent.PointerCoords()};
            coords[0].x = (float)this.mPosition.a1;
            coords[0].y = (float)this.mPosition.a2;
            coords[0].pressure = (float)this.mPressure;
            coords[0].orientation = (float)this.mLastOrientation;
            coords[0].setAxisValue(25, (float)this.mLastTilt);
            if (predictedEvent == null) {
                predictedEvent = MotionEvent.obtain((long)0L, (long)0L, (int)2, (int)1, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])coords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
                continue;
            }
            predictedEvent.addBatch(0L, coords, 0);
        }
        return predictedEvent;
    }

    private double normalizeRange(double x, double min, double max) {
        double normalized = (x - min) / (max - min);
        return Math.min(1.0, Math.max(normalized, 0.0));
    }

    @Nullable
    protected MotionEvent appendPredictedEvent(@Nullable MotionEvent predictedEvent) {
        int predictedEventSize;
        for (int i = predictedEventSize = predictedEvent == null ? 0 : predictedEvent.getHistorySize(); i < this.mExpectedPredictionSampleSize; ++i) {
            MotionEvent.PointerCoords[] coords = new MotionEvent.PointerCoords[]{new MotionEvent.PointerCoords()};
            coords[0].x = (float)this.mPosition.a1;
            coords[0].y = (float)this.mPosition.a2;
            coords[0].pressure = (float)this.mPressure;
            if (predictedEvent == null) {
                MotionEvent.PointerProperties[] pointerProperties = new MotionEvent.PointerProperties[]{new MotionEvent.PointerProperties()};
                pointerProperties[0].id = this.mPointerId;
                pointerProperties[0].toolType = this.mToolType;
                predictedEvent = MotionEvent.obtain((long)0L, (long)0L, (int)2, (int)1, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])coords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
                continue;
            }
            predictedEvent.addBatch(0L, coords, 0);
        }
        return predictedEvent;
    }
}

