/*
 * Decompiled with CFR 0.152.
 */
package androidx.input.motionprediction.kalman;

import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.input.motionprediction.kalman.BatchedMotionEvent;
import androidx.input.motionprediction.kalman.KalmanPredictor;
import androidx.input.motionprediction.kalman.SinglePointerPredictor;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class MultiPointerPredictor
implements KalmanPredictor {
    private static final String TAG = "MultiPointerPredictor";
    private static final boolean DEBUG_PREDICTION = Log.isLoggable((String)"MultiPointerPredictor", (int)3);
    private final SparseArray<SinglePointerPredictor> mPredictorMap = new SparseArray();
    private int mReportRateMs = 0;

    @Override
    public void setReportRate(int reportRateMs) {
        if (reportRateMs <= 0) {
            throw new IllegalArgumentException("reportRateMs should always be a strictlypositive number");
        }
        this.mReportRateMs = reportRateMs;
        for (int i = 0; i < this.mPredictorMap.size(); ++i) {
            ((SinglePointerPredictor)this.mPredictorMap.valueAt(i)).setReportRate(this.mReportRateMs);
        }
    }

    @Override
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        int action = event.getActionMasked();
        int actionIndex = event.getActionIndex();
        int pointerId = event.getPointerId(actionIndex);
        if (action == 0 || action == 5) {
            SinglePointerPredictor predictor = new SinglePointerPredictor(pointerId, event.getToolType(actionIndex));
            if (this.mReportRateMs > 0) {
                predictor.setReportRate(this.mReportRateMs);
            }
            predictor.onTouchEvent(event);
            this.mPredictorMap.put(pointerId, (Object)predictor);
        } else if (action == 1) {
            SinglePointerPredictor predictor = (SinglePointerPredictor)this.mPredictorMap.get(pointerId);
            if (predictor != null) {
                this.mPredictorMap.remove(pointerId);
                predictor.onTouchEvent(event);
            }
            this.mPredictorMap.clear();
        } else if (action == 6) {
            SinglePointerPredictor predictor = (SinglePointerPredictor)this.mPredictorMap.get(pointerId);
            if (predictor != null) {
                this.mPredictorMap.remove(pointerId);
                predictor.onTouchEvent(event);
            }
        } else if (action == 3) {
            this.mPredictorMap.clear();
        } else if (action == 2) {
            for (int i = 0; i < this.mPredictorMap.size(); ++i) {
                ((SinglePointerPredictor)this.mPredictorMap.valueAt(i)).onTouchEvent(event);
            }
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public MotionEvent predict(int predictionTargetMs) {
        void var10_23;
        void var10_21;
        int historyIndex;
        int pointerCount = this.mPredictorMap.size();
        if (pointerCount == 0) {
            if (DEBUG_PREDICTION) {
                Log.d((String)TAG, (String)"predict() -> null: no pointer on screen");
            }
            return null;
        }
        if (pointerCount == 1) {
            SinglePointerPredictor predictor = (SinglePointerPredictor)this.mPredictorMap.valueAt(0);
            MotionEvent predictedEv = predictor.predict(predictionTargetMs);
            if (DEBUG_PREDICTION) {
                Log.d((String)TAG, (String)("predict() -> MotionEvent: " + predictedEv));
            }
            return predictedEv;
        }
        int[] pointerIds = new int[pointerCount];
        MotionEvent[] singlePointerEvents = new MotionEvent[pointerCount];
        for (int i = 0; i < pointerCount; ++i) {
            pointerIds[i] = this.mPredictorMap.keyAt(i);
            SinglePointerPredictor predictor = (SinglePointerPredictor)this.mPredictorMap.valueAt(i);
            singlePointerEvents[i] = predictor.predict(predictionTargetMs);
        }
        boolean foundNullPrediction = false;
        int minHistorySize = Integer.MAX_VALUE;
        for (MotionEvent motionEvent : singlePointerEvents) {
            if (motionEvent == null) {
                foundNullPrediction = true;
                break;
            }
            if (motionEvent.getHistorySize() >= minHistorySize) continue;
            minHistorySize = motionEvent.getHistorySize();
        }
        if (foundNullPrediction) {
            for (MotionEvent motionEvent : singlePointerEvents) {
                if (motionEvent == null) continue;
                motionEvent.recycle();
            }
            return null;
        }
        MotionEvent.PointerCoords[][] pointerCoords = new MotionEvent.PointerCoords[++minHistorySize][pointerCount];
        block3: for (int pointerIndex = 0; pointerIndex < pointerCount; ++pointerIndex) {
            historyIndex = 0;
            for (Object ev : BatchedMotionEvent.iterate(singlePointerEvents[pointerIndex])) {
                pointerCoords[historyIndex][pointerIndex] = ev.coords[0];
                if (minHistorySize > ++historyIndex) continue;
                continue block3;
            }
        }
        MotionEvent[] pointerIndex = singlePointerEvents;
        historyIndex = pointerIndex.length;
        boolean bl = false;
        while (var10_21 < historyIndex) {
            Object ev;
            ev = pointerIndex[var10_21];
            ev.recycle();
            ++var10_21;
        }
        MotionEvent.PointerProperties[] pointerProperties = new MotionEvent.PointerProperties[pointerCount];
        for (int i = 0; i < pointerCount; ++i) {
            pointerProperties[i] = new MotionEvent.PointerProperties();
            pointerProperties[i].id = pointerIds[i];
        }
        MotionEvent multiPointerEvent = MotionEvent.obtain((long)0L, (long)0L, (int)2, (int)pointerCount, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords[0], (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
        boolean bl2 = true;
        while (var10_23 < minHistorySize) {
            multiPointerEvent.addBatch(0L, pointerCoords[var10_23], 0);
            ++var10_23;
        }
        if (DEBUG_PREDICTION) {
            StringBuilder stringBuilder = new StringBuilder(String.format(Locale.ROOT, "predict() -> MotionEvent: (pointerCount=%d, historySize=%d);", multiPointerEvent.getPointerCount(), multiPointerEvent.getHistorySize()));
            for (BatchedMotionEvent motionEvent : BatchedMotionEvent.iterate(multiPointerEvent)) {
                stringBuilder.append("      ");
                for (MotionEvent.PointerCoords coord : motionEvent.coords) {
                    stringBuilder.append(String.format(Locale.ROOT, "(%f, %f)", Float.valueOf(coord.x), Float.valueOf(coord.y)));
                }
                stringBuilder.append("\n");
            }
            Log.d((String)TAG, (String)stringBuilder.toString());
        }
        return multiPointerEvent;
    }
}

