/*
 * Decompiled with CFR 0.152.
 */
package androidx.input.motionprediction.utils;

import android.content.Context;
import android.os.Build;
import android.os.SystemClock;
import android.view.Display;
import android.view.MotionEvent;
import android.view.WindowManager;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class PredictionEstimator {
    private static final int MAX_PREDICTION_MS = 32;
    private static final int LEGACY_FRAME_TIME_MS = 16;
    private static final int MS_IN_A_SECOND = 1000;
    private long mLastEventTime = -1L;
    private final float mFrameTimeMs;

    public PredictionEstimator(@NonNull Context context) {
        this.mFrameTimeMs = this.getFastestFrameTimeMs(context);
    }

    public void record(@NonNull MotionEvent event) {
        this.mLastEventTime = event.getEventTime();
    }

    public int estimate() {
        if (this.mLastEventTime <= 0L) {
            return (int)this.mFrameTimeMs;
        }
        int estimatedMs = (int)((float)(SystemClock.uptimeMillis() - this.mLastEventTime) + this.mFrameTimeMs);
        return Math.min(32, estimatedMs);
    }

    private Display getDisplayForContext(Context context) {
        if (Build.VERSION.SDK_INT >= 30) {
            return Api30Impl.getDisplayForContext(context);
        }
        return ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
    }

    private float getFastestFrameTimeMs(Context context) {
        Display defaultDisplay = this.getDisplayForContext(context);
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getFastestFrameTimeMs(defaultDisplay);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return Api21Impl.getFastestFrameTimeMs(defaultDisplay);
        }
        return 16.0f;
    }

    @RequiresApi(value=30)
    static class Api30Impl {
        private Api30Impl() {
        }

        @DoNotInline
        static Display getDisplayForContext(Context context) {
            return context.getDisplay();
        }
    }

    @RequiresApi(value=23)
    static class Api23Impl {
        private Api23Impl() {
        }

        @DoNotInline
        static float getFastestFrameTimeMs(Display display) {
            Display.Mode[] displayModes = display.getSupportedModes();
            float largestRefreshRate = displayModes[0].getRefreshRate();
            for (int c = 1; c < displayModes.length; ++c) {
                float currentRefreshRate = displayModes[c].getRefreshRate();
                if (!(currentRefreshRate > largestRefreshRate)) continue;
                largestRefreshRate = currentRefreshRate;
            }
            return 1000.0f / largestRefreshRate;
        }
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        static float getFastestFrameTimeMs(Display display) {
            float[] refreshRates = display.getSupportedRefreshRates();
            float largestRefreshRate = refreshRates[0];
            for (int c = 1; c < refreshRates.length; ++c) {
                if (!(refreshRates[c] > largestRefreshRate)) continue;
                largestRefreshRate = refreshRates[c];
            }
            return 1000.0f / largestRefreshRate;
        }
    }
}

