/*
 * Decompiled with CFR 0.152.
 */
package androidx.input.motionprediction;

import android.content.Context;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.input.motionprediction.common.Configuration;
import androidx.input.motionprediction.kalman.KalmanMotionEventPredictor;
import androidx.input.motionprediction.system.SystemMotionEventPredictor;

public interface MotionEventPredictor {
    public void record(@NonNull MotionEvent var1);

    @Nullable
    public MotionEvent predict();

    @NonNull
    public static MotionEventPredictor newInstance(@NonNull View view) {
        Context context = view.getContext();
        Configuration configuration = Configuration.getInstance();
        if (Build.VERSION.SDK_INT >= 34 && configuration.preferSystemPrediction()) {
            return SystemMotionEventPredictor.newInstance(context, configuration.predictionStrategy());
        }
        return new KalmanMotionEventPredictor(context, configuration.predictionStrategy());
    }
}

