/*
 * Decompiled with CFR 0.152.
 */
package androidx.input.motionprediction.common;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.lang.reflect.Method;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class SystemProperty {
    private static final boolean BOOLEAN_PROPERTY_DEFAULT = false;
    private static final int INT_PROPERTY_DEFAULT = 0;

    private SystemProperty() {
    }

    public static boolean getBoolean(@NonNull String name) {
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            Method getMethod = systemProperties.getMethod("getBoolean", String.class, Boolean.TYPE);
            Boolean result = (Boolean)getMethod.invoke(systemProperties, name, false);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static int getInt(@NonNull String name) {
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            Method getMethod = systemProperties.getMethod("getInt", String.class, Integer.TYPE);
            Integer result = (Integer)getMethod.invoke(systemProperties, name, 0);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }
}

