/*
 * Decompiled with CFR 0.152.
 */
package androidx.input.motionprediction.kalman;

import android.util.Log;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.input.motionprediction.common.Configuration;
import androidx.input.motionprediction.kalman.BatchedMotionEvent;
import androidx.input.motionprediction.kalman.KalmanPredictor;
import androidx.input.motionprediction.kalman.PointerKalmanFilter;
import androidx.input.motionprediction.kalman.matrix.DVector2;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class SinglePointerPredictor
implements KalmanPredictor {
    private static final String TAG = "SinglePointerPredictor";
    private static final float JANK_INFLUENCE = 0.1f;
    private static final float ACCELERATION_INFLUENCE = 0.5f;
    private static final float VELOCITY_INFLUENCE = 1.0f;
    private static final float LOW_JANK = 0.02f;
    private static final float HIGH_JANK = 0.2f;
    private static final float ACCURATE_LOW_JANK = 0.1f;
    private static final float ACCURATE_HIGH_JANK = 0.2f;
    private static final float LOW_SPEED = 0.0f;
    private static final float HIGH_SPEED = 2.0f;
    private static final float ACCURATE_LOW_SPEED = 0.0f;
    private static final float ACCURATE_HIGH_SPEED = 0.0f;
    private static final int EVENT_TIME_IGNORED_THRESHOLD_MS = 20;
    private static final int MIN_KALMAN_FILTER_ITERATIONS = 4;
    private final PointerKalmanFilter mKalman = new PointerKalmanFilter(0.01, 1.0);
    private final DVector2 mLastPosition = new DVector2();
    private long mLastSeenEventTime;
    private long mLastPredictEventTime;
    private long mDownEventTime;
    private List<Float> mReportRates = new LinkedList<Float>();
    private int mExpectedPredictionSampleSize = -1;
    private float mReportRateMs = 0.0f;
    private final DVector2 mPosition = new DVector2();
    private final DVector2 mVelocity = new DVector2();
    private final DVector2 mAcceleration = new DVector2();
    private final DVector2 mJank = new DVector2();
    private int mPointerId;
    private int mToolType;
    private double mPressure = 0.0;
    private double mLastOrientation = 0.0;
    private double mLastTilt = 0.0;
    private final boolean mPredictLift;
    private final int mStrategy;

    public SinglePointerPredictor(int strategy, int pointerId, int toolType) {
        this.mStrategy = strategy;
        this.mKalman.reset();
        this.mLastSeenEventTime = 0L;
        this.mLastPredictEventTime = 0L;
        this.mDownEventTime = 0L;
        this.mPointerId = pointerId;
        this.mToolType = toolType;
        this.mPredictLift = Configuration.getInstance().predictLift();
    }

    private void update(float x, float y, float pressure, float orientation, float tilt, long eventTime) {
        if ((double)x == this.mLastPosition.a1 && (double)y == this.mLastPosition.a2 && eventTime <= this.mLastSeenEventTime + 20L) {
            return;
        }
        this.mKalman.update(x, y, pressure);
        this.mLastPosition.a1 = x;
        this.mLastPosition.a2 = y;
        this.mLastOrientation = orientation;
        this.mLastTilt = tilt;
        if (this.mReportRates != null && this.mReportRates.size() < 20 && this.mLastSeenEventTime > 0L) {
            float dt = eventTime - this.mLastSeenEventTime;
            this.mReportRates.add(Float.valueOf(dt));
            float sum = 0.0f;
            for (float rate : this.mReportRates) {
                sum += rate;
            }
            this.mReportRateMs = sum / (float)this.mReportRates.size();
        }
        this.mLastSeenEventTime = eventTime;
    }

    @Override
    public void setReportRate(int reportRateMs) {
        if (reportRateMs <= 0) {
            throw new IllegalArgumentException("reportRateMs should always be a strictlypositive number");
        }
        this.mReportRateMs = reportRateMs;
        this.mReportRates = null;
    }

    @Override
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (event.getActionMasked() == 3) {
            this.mKalman.reset();
            this.mLastSeenEventTime = 0L;
            this.mLastPredictEventTime = 0L;
            return false;
        }
        int pointerIndex = event.findPointerIndex(this.mPointerId);
        if (pointerIndex == -1) {
            Log.i((String)TAG, (String)String.format(Locale.ROOT, "onTouchEvent: Cannot find pointerId=%d in motionEvent=%s", this.mPointerId, event));
            return false;
        }
        this.mDownEventTime = event.getDownTime();
        for (BatchedMotionEvent ev : BatchedMotionEvent.iterate(event)) {
            MotionEvent.PointerCoords pointerCoords = ev.coords[pointerIndex];
            this.update(pointerCoords.x, pointerCoords.y, pointerCoords.pressure, pointerCoords.orientation, pointerCoords.getAxisValue(25), ev.timeMs);
        }
        return true;
    }

    @Override
    @Nullable
    public MotionEvent predict(int predictionTargetMs) {
        int minimumPredictionSampleSize;
        float highJank;
        float lowJank;
        float highSpeed;
        float lowSpeed;
        if (this.mReportRates == null) {
            this.mExpectedPredictionSampleSize = (int)Math.ceil((float)predictionTargetMs / this.mReportRateMs);
        }
        if (this.mExpectedPredictionSampleSize == -1 && this.mKalman.getNumIterations() < 4) {
            return null;
        }
        this.mPosition.set(this.mLastPosition);
        this.mVelocity.set(this.mKalman.getVelocity());
        this.mAcceleration.set(this.mKalman.getAcceleration());
        this.mJank.set(this.mKalman.getJank());
        this.mPressure = this.mKalman.getPressure();
        double pressureChange = this.mKalman.getPressureChange();
        double speedAbs = this.mVelocity.magnitude() / (double)this.mReportRateMs;
        if (this.usingAccurateTool()) {
            lowSpeed = 0.0f;
            highSpeed = 0.0f;
            lowJank = 0.1f;
            highJank = 0.2f;
        } else {
            lowSpeed = 0.0f;
            highSpeed = 2.0f;
            lowJank = 0.02f;
            highJank = 0.2f;
        }
        double speedFactor = this.normalizeRange(speedAbs, lowSpeed, highSpeed);
        double jankAbs = this.mJank.magnitude();
        double jankFactor = 1.0 - this.normalizeRange(jankAbs, lowJank, highJank);
        double confidenceFactor = speedFactor * jankFactor;
        if (this.mStrategy == 2) {
            confidenceFactor = 1.0;
        }
        MotionEvent predictedEvent = null;
        MotionEvent.PointerProperties[] pointerProperties = new MotionEvent.PointerProperties[]{new MotionEvent.PointerProperties()};
        pointerProperties[0].id = this.mPointerId;
        pointerProperties[0].toolType = this.mToolType;
        int predictionTargetInSamples = (int)Math.ceil((double)((float)predictionTargetMs / this.mReportRateMs) * confidenceFactor);
        if (this.mLastPredictEventTime > this.mLastSeenEventTime && predictionTargetInSamples < (minimumPredictionSampleSize = (int)Math.floor((float)(this.mLastPredictEventTime - this.mLastSeenEventTime) / this.mReportRateMs))) {
            predictionTargetInSamples = minimumPredictionSampleSize;
        }
        if (this.mExpectedPredictionSampleSize != -1 && predictionTargetInSamples > this.mExpectedPredictionSampleSize) {
            predictionTargetInSamples = this.mExpectedPredictionSampleSize;
        }
        if (this.mStrategy == 1) {
            predictionTargetInSamples = Math.max(predictionTargetInSamples, 1);
        }
        long predictedEventTime = this.mLastSeenEventTime;
        for (int i = 0; i < predictionTargetInSamples; ++i) {
            this.mAcceleration.a1 += this.mJank.a1 * (double)0.1f;
            this.mAcceleration.a2 += this.mJank.a2 * (double)0.1f;
            this.mVelocity.a1 += this.mAcceleration.a1 * 0.5;
            this.mVelocity.a2 += this.mAcceleration.a2 * 0.5;
            this.mPosition.a1 += this.mVelocity.a1 * 1.0;
            this.mPosition.a2 += this.mVelocity.a2 * 1.0;
            this.mPressure += pressureChange;
            if (this.mPressure < 0.0) {
                this.mPressure = 0.0;
            } else if (this.mPressure > 1.0) {
                this.mPressure = 1.0;
            }
            long nextPredictedEventTime = predictedEventTime + (long)Math.round(this.mReportRateMs);
            if (this.mPredictLift && this.mPressure < 0.1 && nextPredictedEventTime > this.mLastPredictEventTime) break;
            MotionEvent.PointerCoords[] coords = new MotionEvent.PointerCoords[]{new MotionEvent.PointerCoords()};
            coords[0].x = (float)this.mPosition.a1;
            coords[0].y = (float)this.mPosition.a2;
            coords[0].pressure = (float)this.mPressure;
            coords[0].orientation = (float)this.mLastOrientation;
            coords[0].setAxisValue(25, (float)this.mLastTilt);
            if (predictedEvent == null) {
                predictedEvent = MotionEvent.obtain((long)this.mDownEventTime, (long)nextPredictedEventTime, (int)2, (int)1, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])coords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
            } else {
                predictedEvent.addBatch(nextPredictedEventTime, coords, 0);
            }
            predictedEventTime = nextPredictedEventTime;
        }
        this.mLastPredictEventTime = predictedEventTime;
        return predictedEvent;
    }

    private boolean usingAccurateTool() {
        return this.mToolType != 1;
    }

    private double normalizeRange(double x, double min, double max) {
        double normalized = (x - min) / (max - min);
        return Math.min(1.0, Math.max(normalized, 0.0));
    }

    @Nullable
    protected MotionEvent appendPredictedEvent(@Nullable MotionEvent predictedEvent) {
        int predictedEventSize;
        for (int i = predictedEventSize = predictedEvent == null ? 0 : predictedEvent.getHistorySize(); i < this.mExpectedPredictionSampleSize; ++i) {
            MotionEvent.PointerCoords[] coords = new MotionEvent.PointerCoords[]{new MotionEvent.PointerCoords()};
            coords[0].x = (float)this.mPosition.a1;
            coords[0].y = (float)this.mPosition.a2;
            coords[0].pressure = (float)this.mPressure;
            if (predictedEvent == null) {
                MotionEvent.PointerProperties[] pointerProperties = new MotionEvent.PointerProperties[]{new MotionEvent.PointerProperties()};
                pointerProperties[0].id = this.mPointerId;
                pointerProperties[0].toolType = this.mToolType;
                predictedEvent = MotionEvent.obtain((long)0L, (long)0L, (int)2, (int)1, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])coords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
                continue;
            }
            predictedEvent.addBatch(0L, coords, 0);
        }
        return predictedEvent;
    }
}

