/*
 * Decompiled with CFR 0.152.
 */
package androidx.input.motionprediction.system;

import android.content.Context;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.MotionPredictor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.input.motionprediction.MotionEventPredictor;
import androidx.input.motionprediction.common.PredictionEstimator;
import androidx.input.motionprediction.kalman.MultiPointerPredictor;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=34)
public class SystemMotionEventPredictor
implements MotionEventPredictor {
    private MultiPointerPredictor mKalmanPredictor = null;
    private final MotionPredictor mSystemPredictor;
    private final PredictionEstimator mPredictionEstimator;
    private boolean mUsingSystemPredictor = true;
    private int mLastRecordedSource = -1;
    private int mLastRecordedDeviceId = -2;
    private final int mStrategy;

    public SystemMotionEventPredictor(@NonNull Context context, int strategy) {
        this.mPredictionEstimator = new PredictionEstimator(context);
        this.mSystemPredictor = new MotionPredictor(context);
        this.mStrategy = strategy;
    }

    @Override
    public void record(@NonNull MotionEvent event) {
        this.mPredictionEstimator.record(event);
        int source = event.getSource();
        int deviceId = event.getDeviceId();
        if (this.mLastRecordedSource != source || this.mLastRecordedDeviceId != deviceId) {
            this.mUsingSystemPredictor = this.mSystemPredictor.isPredictionAvailable(deviceId, source);
            this.mLastRecordedDeviceId = deviceId;
            this.mLastRecordedSource = source;
        }
        if (this.mUsingSystemPredictor) {
            this.mSystemPredictor.record(event);
        } else {
            this.getKalmanPredictor().onTouchEvent(event);
        }
    }

    @Override
    @Nullable
    public MotionEvent predict() {
        int predictionTimeDelta = this.mPredictionEstimator.estimate();
        if (this.mUsingSystemPredictor) {
            return this.mSystemPredictor.predict(TimeUnit.MILLISECONDS.toNanos(SystemClock.uptimeMillis() + (long)predictionTimeDelta));
        }
        return this.getKalmanPredictor().predict(predictionTimeDelta);
    }

    private MultiPointerPredictor getKalmanPredictor() {
        if (this.mKalmanPredictor == null) {
            this.mKalmanPredictor = new MultiPointerPredictor(this.mStrategy);
        }
        return this.mKalmanPredictor;
    }

    @NonNull
    public static SystemMotionEventPredictor newInstance(@NonNull Context context, int strategy) {
        return new SystemMotionEventPredictor(context, strategy);
    }
}

