/*
 * Decompiled with CFR 0.152.
 */
package androidx.input.motionprediction.common;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.input.motionprediction.common.SystemProperty;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class Configuration {
    public static final int STRATEGY_BALANCED = 0;
    public static final int STRATEGY_SAFE = 1;
    public static final int STRATEGY_AGGRESSIVE = 2;
    private static volatile Configuration sInstance = null;
    private static final Object sLock = new Object();
    private final boolean mPredictLift;
    private final boolean mPreferSystemPrediction = SystemProperty.getBoolean("debug.input.androidx_prefer_system_prediction");
    private final int mPredictionOffset = SystemProperty.getInt("debug.input.androidx_prediction_offset");
    private final int mPredictionStrategy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Configuration getInstance() {
        if (sInstance == null) {
            Object object = sLock;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new Configuration();
                }
            }
        }
        return sInstance;
    }

    private Configuration() {
        this.mPredictLift = SystemProperty.getBoolean("debug.input.androidx_predict_lift");
        this.mPredictionStrategy = SystemProperty.getInt("debug.input.androidx_prediction_strategy");
    }

    public boolean preferSystemPrediction() {
        return this.mPreferSystemPrediction;
    }

    public int predictionOffset() {
        return this.mPredictionOffset;
    }

    public boolean predictLift() {
        return this.mPredictLift;
    }

    public int predictionStrategy() {
        return this.mPredictionStrategy;
    }
}

