/*
 * Decompiled with CFR 0.152.
 */
package androidx.input.motionprediction.kalman;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.input.motionprediction.kalman.matrix.Matrix;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class KalmanFilter {
    @NonNull
    public Matrix x;
    @NonNull
    public Matrix P;
    @NonNull
    public Matrix Q;
    @NonNull
    public Matrix R;
    @NonNull
    public Matrix F;
    @NonNull
    public Matrix H;
    @NonNull
    private Matrix mBufferXDimOne;
    @NonNull
    private Matrix mBufferXDimXDim;
    @NonNull
    private Matrix mBufferXDimXDim2;
    @NonNull
    private Matrix mBufferXDimZDim;
    @NonNull
    private Matrix mBufferXDimZDim2;
    @NonNull
    private Matrix mBufferZDimOne;
    @NonNull
    private Matrix mBufferZDimXDim;
    @NonNull
    private Matrix mBufferZDimZDim;
    @NonNull
    private Matrix mBufferZDimTwiceZDim;

    public KalmanFilter(int xDim, int zDim) {
        this.x = new Matrix(xDim, 1);
        this.P = Matrix.identity(xDim);
        this.Q = Matrix.identity(xDim);
        this.R = Matrix.identity(zDim);
        this.F = new Matrix(xDim, xDim);
        this.H = new Matrix(zDim, xDim);
        this.mBufferXDimZDim = new Matrix(xDim, zDim);
        this.mBufferXDimZDim2 = new Matrix(xDim, zDim);
        this.mBufferXDimOne = new Matrix(xDim, 1);
        this.mBufferXDimXDim = new Matrix(xDim, xDim);
        this.mBufferXDimXDim2 = new Matrix(xDim, xDim);
        this.mBufferZDimOne = new Matrix(zDim, 1);
        this.mBufferZDimXDim = new Matrix(zDim, xDim);
        this.mBufferZDimZDim = new Matrix(zDim, zDim);
        this.mBufferZDimTwiceZDim = new Matrix(zDim, 2 * zDim);
    }

    public void reset() {
        this.x.fill(0.0);
        Matrix.setIdentity(this.P);
    }

    public void predict() {
        Matrix originalX = this.x;
        this.x = this.F.dot(this.x, this.mBufferXDimOne);
        this.mBufferXDimOne = originalX;
        this.F.dot(this.P, this.mBufferXDimXDim).dotTranspose(this.F, this.P).plus(this.Q);
    }

    public void update(@NonNull Matrix z) {
        z.minus(this.H.dot(this.x, this.mBufferZDimOne));
        this.H.dot(this.P, this.mBufferZDimXDim).dotTranspose(this.H, this.mBufferZDimZDim).plus(this.R).inverse(this.mBufferZDimTwiceZDim);
        this.P.dotTranspose(this.H, this.mBufferXDimZDim2).dot(this.mBufferZDimZDim, this.mBufferXDimZDim);
        this.x.plus(this.mBufferXDimZDim.dot(z, this.mBufferXDimOne));
        this.P.minus(this.mBufferXDimZDim.dot(this.H, this.mBufferXDimXDim).dot(this.P, this.mBufferXDimXDim2));
    }
}

