/*
 * Decompiled with CFR 0.152.
 */
package androidx.input.motionprediction.kalman;

import android.content.Context;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.input.motionprediction.MotionEventPredictor;
import androidx.input.motionprediction.common.PredictionEstimator;
import androidx.input.motionprediction.kalman.MultiPointerPredictor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class KalmanMotionEventPredictor
implements MotionEventPredictor {
    private final MultiPointerPredictor mMultiPointerPredictor;
    private final PredictionEstimator mPredictionEstimator;

    public KalmanMotionEventPredictor(@NonNull Context context, int strategy) {
        this.mPredictionEstimator = new PredictionEstimator(context);
        this.mMultiPointerPredictor = new MultiPointerPredictor(strategy);
    }

    @Override
    public void record(@NonNull MotionEvent event) {
        this.mPredictionEstimator.record(event);
        this.mMultiPointerPredictor.onTouchEvent(event);
    }

    @Override
    @Nullable
    public MotionEvent predict() {
        int predictionTimeDelta = this.mPredictionEstimator.estimate();
        return this.mMultiPointerPredictor.predict(predictionTimeDelta);
    }
}

