/*
 * Decompiled with CFR 0.152.
 */
package androidx.input.motionprediction.kalman;

import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.input.motionprediction.kalman.BatchedMotionEvent;
import androidx.input.motionprediction.kalman.KalmanPredictor;
import androidx.input.motionprediction.kalman.SinglePointerPredictor;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class MultiPointerPredictor
implements KalmanPredictor {
    private static final String TAG = "MultiPointerPredictor";
    private static final boolean DEBUG_PREDICTION = Log.isLoggable((String)"MultiPointerPredictor", (int)3);
    private final SparseArray<SinglePointerPredictor> mPredictorMap = new SparseArray();
    private int mReportRateMs = 0;
    private final int mStrategy;

    public MultiPointerPredictor(int strategy) {
        this.mStrategy = strategy;
    }

    @Override
    public void setReportRate(int reportRateMs) {
        if (reportRateMs <= 0) {
            throw new IllegalArgumentException("reportRateMs should always be a strictlypositive number");
        }
        this.mReportRateMs = reportRateMs;
        for (int i = 0; i < this.mPredictorMap.size(); ++i) {
            ((SinglePointerPredictor)this.mPredictorMap.valueAt(i)).setReportRate(this.mReportRateMs);
        }
    }

    @Override
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        int action = event.getActionMasked();
        int actionIndex = event.getActionIndex();
        int pointerId = event.getPointerId(actionIndex);
        if (action == 0 || action == 5) {
            SinglePointerPredictor predictor = new SinglePointerPredictor(this.mStrategy, pointerId, event.getToolType(actionIndex));
            if (this.mReportRateMs > 0) {
                predictor.setReportRate(this.mReportRateMs);
            }
            predictor.onTouchEvent(event);
            this.mPredictorMap.put(pointerId, (Object)predictor);
        } else if (action == 1) {
            SinglePointerPredictor predictor = (SinglePointerPredictor)this.mPredictorMap.get(pointerId);
            if (predictor != null) {
                this.mPredictorMap.remove(pointerId);
                predictor.onTouchEvent(event);
            }
            this.mPredictorMap.clear();
        } else if (action == 6) {
            SinglePointerPredictor predictor = (SinglePointerPredictor)this.mPredictorMap.get(pointerId);
            if (predictor != null) {
                this.mPredictorMap.remove(pointerId);
                predictor.onTouchEvent(event);
            }
        } else if (action == 3) {
            this.mPredictorMap.clear();
        } else if (action == 2) {
            for (int i = 0; i < this.mPredictorMap.size(); ++i) {
                ((SinglePointerPredictor)this.mPredictorMap.valueAt(i)).onTouchEvent(event);
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public MotionEvent predict(int predictionTargetMs) {
        int pointerCount = this.mPredictorMap.size();
        if (pointerCount == 0) {
            if (DEBUG_PREDICTION) {
                Log.d((String)TAG, (String)"predict() -> null: no pointer on screen");
            }
            return null;
        }
        if (pointerCount == 1) {
            SinglePointerPredictor predictor = (SinglePointerPredictor)this.mPredictorMap.valueAt(0);
            MotionEvent predictedEv = predictor.predict(predictionTargetMs);
            if (DEBUG_PREDICTION) {
                Log.d((String)TAG, (String)("predict() -> MotionEvent: " + predictedEv));
            }
            return predictedEv;
        }
        int[] pointerIds = new int[pointerCount];
        MotionEvent[] singlePointerEvents = new MotionEvent[pointerCount];
        for (int i = 0; i < pointerCount; ++i) {
            pointerIds[i] = this.mPredictorMap.keyAt(i);
            SinglePointerPredictor predictor = (SinglePointerPredictor)this.mPredictorMap.valueAt(i);
            singlePointerEvents[i] = predictor.predict(predictionTargetMs);
        }
        boolean foundNullPrediction = false;
        int minHistorySize = Integer.MAX_VALUE;
        for (MotionEvent ev : singlePointerEvents) {
            if (ev == null) {
                foundNullPrediction = true;
                break;
            }
            if (ev.getHistorySize() >= minHistorySize) continue;
            minHistorySize = ev.getHistorySize();
        }
        if (foundNullPrediction) {
            for (MotionEvent ev : singlePointerEvents) {
                if (ev == null) continue;
                ev.recycle();
            }
            return null;
        }
        MotionEvent.PointerCoords[][] pointerCoords = new MotionEvent.PointerCoords[++minHistorySize][pointerCount];
        long[] pointerEventTimes = new long[minHistorySize];
        block3: for (int pointerIndex = 0; pointerIndex < pointerCount; ++pointerIndex) {
            int historyIndex = 0;
            for (Object ev : BatchedMotionEvent.iterate(singlePointerEvents[pointerIndex])) {
                pointerCoords[historyIndex][pointerIndex] = ev.coords[0];
                pointerEventTimes[historyIndex] = ev.timeMs;
                if (minHistorySize > ++historyIndex) continue;
                continue block3;
            }
        }
        for (Object ev : singlePointerEvents) {
            ev.recycle();
        }
        MotionEvent.PointerProperties[] pointerProperties = new MotionEvent.PointerProperties[pointerCount];
        for (int i = 0; i < pointerCount; ++i) {
            pointerProperties[i] = new MotionEvent.PointerProperties();
            pointerProperties[i].id = pointerIds[i];
        }
        MotionEvent multiPointerEvent = MotionEvent.obtain((long)singlePointerEvents[0].getDownTime(), (long)pointerEventTimes[0], (int)2, (int)pointerCount, (MotionEvent.PointerProperties[])pointerProperties, (MotionEvent.PointerCoords[])pointerCoords[0], (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
        for (int historyIndex = 1; historyIndex < minHistorySize; ++historyIndex) {
            multiPointerEvent.addBatch(pointerEventTimes[historyIndex], pointerCoords[historyIndex], 0);
        }
        if (DEBUG_PREDICTION) {
            StringBuilder builder = new StringBuilder(String.format(Locale.ROOT, "predict() -> MotionEvent: (pointerCount=%d, historySize=%d);", multiPointerEvent.getPointerCount(), multiPointerEvent.getHistorySize()));
            for (BatchedMotionEvent motionEvent : BatchedMotionEvent.iterate(multiPointerEvent)) {
                builder.append("      ");
                for (MotionEvent.PointerCoords coord : motionEvent.coords) {
                    builder.append(String.format(Locale.ROOT, "(%f, %f)", Float.valueOf(coord.x), Float.valueOf(coord.y)));
                }
                builder.append("\n");
            }
            Log.d((String)TAG, (String)builder.toString());
        }
        return multiPointerEvent;
    }
}

