/*
 * Decompiled with CFR 0.152.
 */
package androidx.leanback.preference;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.leanback.preference.LeanbackPreferenceDialogFragmentCompat;
import androidx.leanback.preference.R;
import androidx.preference.DialogPreference;
import androidx.preference.EditTextPreference;

public class LeanbackEditTextPreferenceDialogFragmentCompat
extends LeanbackPreferenceDialogFragmentCompat {
    public static final String EXTRA_INPUT_TYPE = "input_type";
    public static final String EXTRA_IME_OPTIONS = "ime_option";
    private static final int DEFAULT_INPUT_TYPE = 1;
    private static final int DEFAULT_IME_OPTIONS = 2;
    private static final String SAVE_STATE_TITLE = "LeanbackEditPreferenceDialog.title";
    private static final String SAVE_STATE_MESSAGE = "LeanbackEditPreferenceDialog.message";
    private static final String SAVE_STATE_TEXT = "LeanbackEditPreferenceDialog.text";
    private static final String SAVE_STATE_INPUT_TYPE = "LeanbackEditPreferenceDialog.inputType";
    private static final String SAVE_STATE_IME_OPTIONS = "LeanbackEditPreferenceDialog.imeOptions";
    private CharSequence mDialogTitle;
    private CharSequence mDialogMessage;
    private CharSequence mText;
    private int mImeOptions;
    private int mInputType;

    public static LeanbackEditTextPreferenceDialogFragmentCompat newInstance(String key) {
        Bundle args = new Bundle(1);
        args.putString("key", key);
        LeanbackEditTextPreferenceDialogFragmentCompat fragment = new LeanbackEditTextPreferenceDialogFragmentCompat();
        fragment.setArguments(args);
        return fragment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            DialogPreference preference = this.getPreference();
            this.mDialogTitle = preference.getDialogTitle();
            this.mDialogMessage = preference.getDialogMessage();
            if (!(preference instanceof EditTextPreference)) throw new IllegalArgumentException("Preference must be a EditTextPreference");
            this.mDialogTitle = preference.getDialogTitle();
            this.mDialogMessage = preference.getDialogMessage();
            this.mText = ((EditTextPreference)preference).getText();
            this.mInputType = preference.getExtras().getInt(EXTRA_INPUT_TYPE, 1);
            this.mImeOptions = preference.getExtras().getInt(EXTRA_IME_OPTIONS, 2);
            return;
        } else {
            this.mDialogTitle = savedInstanceState.getCharSequence(SAVE_STATE_TITLE);
            this.mDialogMessage = savedInstanceState.getCharSequence(SAVE_STATE_MESSAGE);
            this.mText = savedInstanceState.getCharSequence(SAVE_STATE_TEXT);
            this.mInputType = savedInstanceState.getInt(SAVE_STATE_INPUT_TYPE, 1);
            this.mImeOptions = savedInstanceState.getInt(SAVE_STATE_IME_OPTIONS, 2);
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putCharSequence(SAVE_STATE_TITLE, this.mDialogTitle);
        outState.putCharSequence(SAVE_STATE_MESSAGE, this.mDialogMessage);
        outState.putCharSequence(SAVE_STATE_TEXT, this.mText);
        outState.putInt(SAVE_STATE_INPUT_TYPE, this.mInputType);
        outState.putInt(SAVE_STATE_IME_OPTIONS, this.mImeOptions);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        TypedValue tv = new TypedValue();
        this.getActivity().getTheme().resolveAttribute(R.attr.preferenceTheme, tv, true);
        int theme = tv.resourceId;
        if (theme == 0) {
            theme = R.style.PreferenceThemeOverlayLeanback;
        }
        ContextThemeWrapper styledContext = new ContextThemeWrapper((Context)this.getActivity(), theme);
        LayoutInflater styledInflater = inflater.cloneInContext((Context)styledContext);
        View view = styledInflater.inflate(R.layout.leanback_edit_preference_fragment, container, false);
        if (!TextUtils.isEmpty((CharSequence)this.mDialogTitle)) {
            TextView titleView = (TextView)view.findViewById(R.id.decor_title);
            titleView.setText(this.mDialogTitle);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mDialogMessage)) {
            TextView messageView = (TextView)view.findViewById(16908299);
            messageView.setVisibility(0);
            messageView.setText(this.mDialogMessage);
        }
        EditText editText = (EditText)view.findViewById(16908291);
        editText.setInputType(this.mInputType);
        editText.setImeOptions(this.mImeOptions);
        if (!TextUtils.isEmpty((CharSequence)this.mText)) {
            editText.setText(this.mText);
        }
        editText.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int actionId, KeyEvent event) {
                if (actionId == 6 || actionId == 2 || actionId == 3 || actionId == 5 || actionId == 4) {
                    InputMethodManager imm = (InputMethodManager)LeanbackEditTextPreferenceDialogFragmentCompat.this.getActivity().getSystemService("input_method");
                    imm.hideSoftInputFromWindow(textView.getWindowToken(), 0);
                    EditTextPreference preference = (EditTextPreference)LeanbackEditTextPreferenceDialogFragmentCompat.this.getPreference();
                    preference.setText(textView.getText().toString());
                    LeanbackEditTextPreferenceDialogFragmentCompat.this.getFragmentManager().popBackStack();
                    return true;
                }
                return false;
            }
        });
        return view;
    }

    public void onStart() {
        super.onStart();
        EditText editText = (EditText)this.getView().findViewById(16908291);
        InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
        editText.requestFocus();
        imm.showSoftInput((View)editText, 0);
    }
}

