/*
 * Decompiled with CFR 0.152.
 */
package androidx.leanback.preference;

import android.os.Bundle;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import androidx.leanback.preference.LeanbackEditTextPreferenceDialogFragmentCompat;
import androidx.leanback.preference.LeanbackListPreferenceDialogFragmentCompat;
import androidx.leanback.preference.LeanbackSettingsRootView;
import androidx.leanback.preference.R;
import androidx.preference.EditTextPreference;
import androidx.preference.ListPreference;
import androidx.preference.MultiSelectListPreference;
import androidx.preference.Preference;
import androidx.preference.PreferenceFragmentCompat;

public abstract class LeanbackSettingsFragmentCompat
extends Fragment
implements PreferenceFragmentCompat.OnPreferenceStartFragmentCallback,
PreferenceFragmentCompat.OnPreferenceStartScreenCallback,
PreferenceFragmentCompat.OnPreferenceDisplayDialogCallback {
    private static final String PREFERENCE_FRAGMENT_TAG = "androidx.leanback.preference.LeanbackSettingsFragment.PREFERENCE_FRAGMENT";
    private final RootViewOnKeyListener mRootViewOnKeyListener = new RootViewOnKeyListener();

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.leanback_settings_fragment, container, false);
        return v;
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState == null) {
            this.onPreferenceStartInitialScreen();
        }
    }

    public void onResume() {
        super.onResume();
        LeanbackSettingsRootView rootView = (LeanbackSettingsRootView)this.getView();
        if (rootView != null) {
            rootView.setOnBackKeyListener(this.mRootViewOnKeyListener);
        }
    }

    public void onPause() {
        super.onPause();
        LeanbackSettingsRootView rootView = (LeanbackSettingsRootView)this.getView();
        if (rootView != null) {
            rootView.setOnBackKeyListener(null);
        }
    }

    public boolean onPreferenceDisplayDialog(@NonNull PreferenceFragmentCompat caller, Preference pref) {
        if (caller == null) {
            throw new IllegalArgumentException("Cannot display dialog for preference " + pref + ", Caller must not be null!");
        }
        if (pref instanceof ListPreference) {
            ListPreference listPreference = (ListPreference)pref;
            LeanbackListPreferenceDialogFragmentCompat f = LeanbackListPreferenceDialogFragmentCompat.newInstanceSingle(listPreference.getKey());
            f.setTargetFragment((Fragment)caller, 0);
            this.startPreferenceFragment(f);
        } else if (pref instanceof MultiSelectListPreference) {
            MultiSelectListPreference listPreference = (MultiSelectListPreference)pref;
            LeanbackListPreferenceDialogFragmentCompat f = LeanbackListPreferenceDialogFragmentCompat.newInstanceMulti(listPreference.getKey());
            f.setTargetFragment((Fragment)caller, 0);
            this.startPreferenceFragment(f);
        } else if (pref instanceof EditTextPreference) {
            LeanbackEditTextPreferenceDialogFragmentCompat f = LeanbackEditTextPreferenceDialogFragmentCompat.newInstance(pref.getKey());
            f.setTargetFragment((Fragment)caller, 0);
            this.startPreferenceFragment(f);
        } else {
            return false;
        }
        return true;
    }

    public abstract void onPreferenceStartInitialScreen();

    public void startPreferenceFragment(@NonNull Fragment fragment) {
        FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
        Fragment prevFragment = this.getChildFragmentManager().findFragmentByTag(PREFERENCE_FRAGMENT_TAG);
        if (prevFragment != null) {
            transaction.addToBackStack(null).replace(R.id.settings_preference_fragment_container, fragment, PREFERENCE_FRAGMENT_TAG);
        } else {
            transaction.add(R.id.settings_preference_fragment_container, fragment, PREFERENCE_FRAGMENT_TAG);
        }
        transaction.commit();
    }

    public void startImmersiveFragment(@NonNull Fragment fragment) {
        FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
        Fragment preferenceFragment = this.getChildFragmentManager().findFragmentByTag(PREFERENCE_FRAGMENT_TAG);
        if (preferenceFragment != null && !preferenceFragment.isHidden()) {
            transaction.remove(preferenceFragment);
        }
        transaction.add(R.id.settings_dialog_container, fragment).addToBackStack(null).commit();
    }

    private class RootViewOnKeyListener
    implements View.OnKeyListener {
        RootViewOnKeyListener() {
        }

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (keyCode == 4) {
                return LeanbackSettingsFragmentCompat.this.getChildFragmentManager().popBackStackImmediate();
            }
            return false;
        }
    }
}

