/*
 * Decompiled with CFR 0.152.
 */
package androidx.leanback.preference;

import android.content.Context;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.Fragment;
import androidx.leanback.preference.R;
import androidx.leanback.widget.VerticalGridView;
import androidx.preference.PreferenceFragmentCompat;
import androidx.preference.PreferenceRecyclerViewAccessibilityDelegate;
import androidx.preference.R;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.RecyclerViewAccessibilityDelegate;

public abstract class BaseLeanbackPreferenceFragmentCompat
extends PreferenceFragmentCompat {
    private Context mThemedContext;

    @Nullable
    public Context getContext() {
        if (this.mThemedContext == null && this.getActivity() != null) {
            TypedValue tv = new TypedValue();
            this.getActivity().getTheme().resolveAttribute(R.attr.preferenceTheme, tv, true);
            int theme = tv.resourceId;
            if (theme == 0) {
                theme = R.style.PreferenceThemeOverlayLeanback;
            }
            this.mThemedContext = new ContextThemeWrapper(super.getContext(), theme);
        }
        return this.mThemedContext;
    }

    public RecyclerView onCreateRecyclerView(LayoutInflater inflater, ViewGroup parent, Bundle savedInstanceState) {
        VerticalGridView verticalGridView = (VerticalGridView)inflater.inflate(R.layout.leanback_preferences_list, parent, false);
        verticalGridView.setWindowAlignment(3);
        verticalGridView.setFocusScrollStrategy(0);
        verticalGridView.setAccessibilityDelegateCompat((RecyclerViewAccessibilityDelegate)new PreferenceRecyclerViewAccessibilityDelegate((RecyclerView)verticalGridView));
        return verticalGridView;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public Fragment getCallbackFragment() {
        return this.getParentFragment();
    }
}

