/*
 * Decompiled with CFR 0.152.
 */
package androidx.leanback.preference;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.collection.ArraySet;
import androidx.leanback.preference.LeanbackPreferenceDialogFragmentCompat;
import androidx.leanback.preference.R;
import androidx.leanback.widget.VerticalGridView;
import androidx.preference.DialogPreference;
import androidx.preference.ListPreference;
import androidx.preference.MultiSelectListPreference;
import androidx.preference.R;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LeanbackListPreferenceDialogFragmentCompat
extends LeanbackPreferenceDialogFragmentCompat {
    private static final String SAVE_STATE_IS_MULTI = "LeanbackListPreferenceDialogFragment.isMulti";
    private static final String SAVE_STATE_ENTRIES = "LeanbackListPreferenceDialogFragment.entries";
    private static final String SAVE_STATE_ENTRY_VALUES = "LeanbackListPreferenceDialogFragment.entryValues";
    private static final String SAVE_STATE_TITLE = "LeanbackListPreferenceDialogFragment.title";
    private static final String SAVE_STATE_MESSAGE = "LeanbackListPreferenceDialogFragment.message";
    private static final String SAVE_STATE_INITIAL_SELECTIONS = "LeanbackListPreferenceDialogFragment.initialSelections";
    private static final String SAVE_STATE_INITIAL_SELECTION = "LeanbackListPreferenceDialogFragment.initialSelection";
    private boolean mMulti;
    private CharSequence[] mEntries;
    private CharSequence[] mEntryValues;
    private CharSequence mDialogTitle;
    private CharSequence mDialogMessage;
    Set<String> mInitialSelections;
    private String mInitialSelection;

    public static LeanbackListPreferenceDialogFragmentCompat newInstanceSingle(String key) {
        Bundle args = new Bundle(1);
        args.putString("key", key);
        LeanbackListPreferenceDialogFragmentCompat fragment = new LeanbackListPreferenceDialogFragmentCompat();
        fragment.setArguments(args);
        return fragment;
    }

    public static LeanbackListPreferenceDialogFragmentCompat newInstanceMulti(String key) {
        Bundle args = new Bundle(1);
        args.putString("key", key);
        LeanbackListPreferenceDialogFragmentCompat fragment = new LeanbackListPreferenceDialogFragmentCompat();
        fragment.setArguments(args);
        return fragment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            DialogPreference preference = this.getPreference();
            this.mDialogTitle = preference.getDialogTitle();
            this.mDialogMessage = preference.getDialogMessage();
            if (preference instanceof ListPreference) {
                this.mMulti = false;
                this.mEntries = ((ListPreference)preference).getEntries();
                this.mEntryValues = ((ListPreference)preference).getEntryValues();
                this.mInitialSelection = ((ListPreference)preference).getValue();
                return;
            } else {
                if (!(preference instanceof MultiSelectListPreference)) throw new IllegalArgumentException("Preference must be a ListPreference or MultiSelectListPreference");
                this.mMulti = true;
                this.mEntries = ((MultiSelectListPreference)preference).getEntries();
                this.mEntryValues = ((MultiSelectListPreference)preference).getEntryValues();
                this.mInitialSelections = ((MultiSelectListPreference)preference).getValues();
            }
            return;
        } else {
            this.mDialogTitle = savedInstanceState.getCharSequence(SAVE_STATE_TITLE);
            this.mDialogMessage = savedInstanceState.getCharSequence(SAVE_STATE_MESSAGE);
            this.mMulti = savedInstanceState.getBoolean(SAVE_STATE_IS_MULTI);
            this.mEntries = savedInstanceState.getCharSequenceArray(SAVE_STATE_ENTRIES);
            this.mEntryValues = savedInstanceState.getCharSequenceArray(SAVE_STATE_ENTRY_VALUES);
            if (this.mMulti) {
                String[] initialSelections = savedInstanceState.getStringArray(SAVE_STATE_INITIAL_SELECTIONS);
                this.mInitialSelections = new ArraySet(initialSelections != null ? initialSelections.length : 0);
                if (initialSelections == null) return;
                Collections.addAll(this.mInitialSelections, initialSelections);
                return;
            } else {
                this.mInitialSelection = savedInstanceState.getString(SAVE_STATE_INITIAL_SELECTION);
            }
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putCharSequence(SAVE_STATE_TITLE, this.mDialogTitle);
        outState.putCharSequence(SAVE_STATE_MESSAGE, this.mDialogMessage);
        outState.putBoolean(SAVE_STATE_IS_MULTI, this.mMulti);
        outState.putCharSequenceArray(SAVE_STATE_ENTRIES, this.mEntries);
        outState.putCharSequenceArray(SAVE_STATE_ENTRY_VALUES, this.mEntryValues);
        if (this.mMulti) {
            outState.putStringArray(SAVE_STATE_INITIAL_SELECTIONS, this.mInitialSelections.toArray(new String[this.mInitialSelections.size()]));
        } else {
            outState.putString(SAVE_STATE_INITIAL_SELECTION, this.mInitialSelection);
        }
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        CharSequence message;
        TypedValue tv = new TypedValue();
        this.getActivity().getTheme().resolveAttribute(R.attr.preferenceTheme, tv, true);
        int theme = tv.resourceId;
        if (theme == 0) {
            theme = R.style.PreferenceThemeOverlayLeanback;
        }
        ContextThemeWrapper styledContext = new ContextThemeWrapper((Context)this.getActivity(), theme);
        LayoutInflater styledInflater = inflater.cloneInContext((Context)styledContext);
        View view = styledInflater.inflate(R.layout.leanback_list_preference_fragment, container, false);
        VerticalGridView verticalGridView = (VerticalGridView)view.findViewById(16908298);
        verticalGridView.setWindowAlignment(3);
        verticalGridView.setFocusScrollStrategy(0);
        verticalGridView.setAdapter(this.onCreateAdapter());
        verticalGridView.requestFocus();
        CharSequence title = this.mDialogTitle;
        if (!TextUtils.isEmpty((CharSequence)title)) {
            TextView titleView = (TextView)view.findViewById(R.id.decor_title);
            titleView.setText(title);
        }
        if (!TextUtils.isEmpty((CharSequence)(message = this.mDialogMessage))) {
            TextView messageView = (TextView)view.findViewById(16908299);
            messageView.setVisibility(0);
            messageView.setText(message);
        }
        return view;
    }

    RecyclerView.Adapter onCreateAdapter() {
        if (this.mMulti) {
            return new AdapterMulti(this.mEntries, this.mEntryValues, this.mInitialSelections);
        }
        return new AdapterSingle(this.mEntries, this.mEntryValues, this.mInitialSelection);
    }

    final class AdapterMulti
    extends RecyclerView.Adapter<ViewHolder>
    implements OnItemClickListener {
        private final CharSequence[] mEntries;
        private final CharSequence[] mEntryValues;
        private final Set<String> mSelections;

        AdapterMulti(CharSequence[] entries, CharSequence[] entryValues, Set<String> initialSelections) {
            this.mEntries = entries;
            this.mEntryValues = entryValues;
            this.mSelections = new HashSet<String>(initialSelections);
        }

        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
            View view = inflater.inflate(R.layout.leanback_list_preference_item_multi, parent, false);
            return new ViewHolder(view, this);
        }

        public void onBindViewHolder(ViewHolder holder, int position) {
            holder.getWidgetView().setChecked(this.mSelections.contains(this.mEntryValues[position].toString()));
            holder.getTitleView().setText(this.mEntries[position]);
        }

        public int getItemCount() {
            return this.mEntries.length;
        }

        @Override
        public void onItemClick(ViewHolder viewHolder) {
            int index = viewHolder.getAbsoluteAdapterPosition();
            if (index == -1) {
                return;
            }
            String entry = this.mEntryValues[index].toString();
            if (this.mSelections.contains(entry)) {
                this.mSelections.remove(entry);
            } else {
                this.mSelections.add(entry);
            }
            MultiSelectListPreference multiSelectListPreference = (MultiSelectListPreference)LeanbackListPreferenceDialogFragmentCompat.this.getPreference();
            if (multiSelectListPreference.callChangeListener(new HashSet<String>(this.mSelections))) {
                multiSelectListPreference.setValues(new HashSet<String>(this.mSelections));
                LeanbackListPreferenceDialogFragmentCompat.this.mInitialSelections = this.mSelections;
            } else if (this.mSelections.contains(entry)) {
                this.mSelections.remove(entry);
            } else {
                this.mSelections.add(entry);
            }
            this.notifyDataSetChanged();
        }
    }

    final class AdapterSingle
    extends RecyclerView.Adapter<ViewHolder>
    implements OnItemClickListener {
        private final CharSequence[] mEntries;
        private final CharSequence[] mEntryValues;
        private CharSequence mSelectedValue;

        AdapterSingle(CharSequence[] entries, CharSequence[] entryValues, CharSequence selectedValue) {
            this.mEntries = entries;
            this.mEntryValues = entryValues;
            this.mSelectedValue = selectedValue;
        }

        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
            View view = inflater.inflate(R.layout.leanback_list_preference_item_single, parent, false);
            return new ViewHolder(view, this);
        }

        public void onBindViewHolder(ViewHolder holder, int position) {
            holder.getWidgetView().setChecked(TextUtils.equals((CharSequence)this.mEntryValues[position].toString(), (CharSequence)this.mSelectedValue));
            holder.getTitleView().setText(this.mEntries[position]);
        }

        public int getItemCount() {
            return this.mEntries.length;
        }

        @Override
        public void onItemClick(ViewHolder viewHolder) {
            String value;
            int index = viewHolder.getAbsoluteAdapterPosition();
            if (index == -1) {
                return;
            }
            CharSequence entry = this.mEntryValues[index];
            ListPreference preference = (ListPreference)LeanbackListPreferenceDialogFragmentCompat.this.getPreference();
            if (index >= 0 && preference.callChangeListener((Object)(value = this.mEntryValues[index].toString()))) {
                preference.setValue(value);
                this.mSelectedValue = entry;
            }
            LeanbackListPreferenceDialogFragmentCompat.this.getFragmentManager().popBackStack();
            this.notifyDataSetChanged();
        }
    }

    public static final class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private final Checkable mWidgetView;
        private final TextView mTitleView;
        private final ViewGroup mContainer;
        private final OnItemClickListener mListener;

        ViewHolder(@NonNull View view, @NonNull OnItemClickListener listener) {
            super(view);
            this.mWidgetView = (Checkable)view.findViewById(R.id.button);
            this.mContainer = (ViewGroup)view.findViewById(R.id.container);
            this.mTitleView = (TextView)view.findViewById(16908310);
            this.mContainer.setOnClickListener((View.OnClickListener)this);
            this.mListener = listener;
        }

        public Checkable getWidgetView() {
            return this.mWidgetView;
        }

        public TextView getTitleView() {
            return this.mTitleView;
        }

        public ViewGroup getContainer() {
            return this.mContainer;
        }

        public void onClick(View v) {
            this.mListener.onItemClick(this);
        }
    }

    private static interface OnItemClickListener {
        public void onItemClick(ViewHolder var1);
    }
}

