/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.lifecycle.LiveData;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u000eB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0012\u0012\u000e\u0012\f0\bR\b\u0012\u0004\u0012\u00028\u00000\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Landroidx/lifecycle/PublisherLiveData;", "T", "Landroidx/lifecycle/LiveData;", "publisher", "Lorg/reactivestreams/Publisher;", "(Lorg/reactivestreams/Publisher;)V", "subscriber", "Ljava/util/concurrent/atomic/AtomicReference;", "Landroidx/lifecycle/PublisherLiveData$LiveDataSubscriber;", "getSubscriber", "()Ljava/util/concurrent/atomic/AtomicReference;", "onActive", "", "onInactive", "LiveDataSubscriber", "lifecycle-reactivestreams_release"})
final class PublisherLiveData<T>
extends LiveData<T> {
    @NotNull
    private final Publisher<T> publisher;
    @NotNull
    private final AtomicReference<LiveDataSubscriber> subscriber;

    public PublisherLiveData(@NotNull Publisher<T> publisher) {
        Intrinsics.checkNotNullParameter(publisher, (String)"publisher");
        this.publisher = publisher;
        this.subscriber = new AtomicReference();
    }

    @NotNull
    public final AtomicReference<LiveDataSubscriber> getSubscriber() {
        return this.subscriber;
    }

    protected void onActive() {
        super.onActive();
        LiveDataSubscriber s = new LiveDataSubscriber();
        this.subscriber.set(s);
        this.publisher.subscribe((Subscriber)s);
    }

    protected void onInactive() {
        block0: {
            LiveDataSubscriber s;
            super.onInactive();
            LiveDataSubscriber liveDataSubscriber = s = (LiveDataSubscriber)this.subscriber.getAndSet(null);
            if (liveDataSubscriber == null) break block0;
            liveDataSubscriber.cancelSubscription();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/lifecycle/PublisherLiveData$LiveDataSubscriber;", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/reactivestreams/Subscription;", "Lorg/reactivestreams/Subscriber;", "(Landroidx/lifecycle/PublisherLiveData;)V", "cancelSubscription", "", "onComplete", "onError", "ex", "", "onNext", "item", "(Ljava/lang/Object;)V", "onSubscribe", "s", "lifecycle-reactivestreams_release"})
    public final class LiveDataSubscriber
    extends AtomicReference<Subscription>
    implements Subscriber<T> {
        public void onSubscribe(@NotNull Subscription s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            if (this.compareAndSet(null, s)) {
                s.request(Long.MAX_VALUE);
            } else {
                s.cancel();
            }
        }

        public void onNext(T item) {
            PublisherLiveData.this.postValue(item);
        }

        public void onError(@NotNull Throwable ex) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            PublisherLiveData.this.getSubscriber().compareAndSet(this, null);
            ArchTaskExecutor.getInstance().executeOnMainThread(() -> LiveDataSubscriber.onError$lambda$0(ex));
        }

        public void onComplete() {
            PublisherLiveData.this.getSubscriber().compareAndSet(this, null);
        }

        public final void cancelSubscription() {
            block0: {
                Subscription s;
                Subscription subscription = s = (Subscription)this.get();
                if (subscription == null) break block0;
                subscription.cancel();
            }
        }

        private static final void onError$lambda$0(Throwable $ex) {
            Intrinsics.checkNotNullParameter((Object)$ex, (String)"$ex");
            throw new RuntimeException("LiveData does not handle errors. Errors from publishers should be handled upstream and propagated as state", $ex);
        }
    }
}

