/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0010B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Landroidx/lifecycle/LiveDataPublisher;", "T", "Lorg/reactivestreams/Publisher;", "lifecycle", "Landroidx/lifecycle/LifecycleOwner;", "liveData", "Landroidx/lifecycle/LiveData;", "(Landroidx/lifecycle/LifecycleOwner;Landroidx/lifecycle/LiveData;)V", "getLifecycle", "()Landroidx/lifecycle/LifecycleOwner;", "getLiveData", "()Landroidx/lifecycle/LiveData;", "subscribe", "", "subscriber", "Lorg/reactivestreams/Subscriber;", "LiveDataSubscription", "lifecycle-reactivestreams_release"})
final class LiveDataPublisher<T>
implements Publisher<T> {
    @NotNull
    private final LifecycleOwner lifecycle;
    @NotNull
    private final LiveData<T> liveData;

    public LiveDataPublisher(@NotNull LifecycleOwner lifecycle, @NotNull LiveData<T> liveData) {
        Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
        Intrinsics.checkNotNullParameter(liveData, (String)"liveData");
        this.lifecycle = lifecycle;
        this.liveData = liveData;
    }

    @NotNull
    public final LifecycleOwner getLifecycle() {
        return this.lifecycle;
    }

    @NotNull
    public final LiveData<T> getLiveData() {
        return this.liveData;
    }

    public void subscribe(@NotNull Subscriber<? super T> subscriber) {
        Intrinsics.checkNotNullParameter(subscriber, (String)"subscriber");
        subscriber.onSubscribe((Subscription)new LiveDataSubscription<T>(subscriber, this.lifecycle, this.liveData));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u00022\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0003B+\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010&\u001a\u00020'H\u0016J\u0017\u0010(\u001a\u00020'2\b\u0010)\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u001fH\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000e\"\u0004\b\u001d\u0010\u0010R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006,"}, d2={"Landroidx/lifecycle/LiveDataPublisher$LiveDataSubscription;", "T", "Lorg/reactivestreams/Subscription;", "Landroidx/lifecycle/Observer;", "subscriber", "Lorg/reactivestreams/Subscriber;", "lifecycle", "Landroidx/lifecycle/LifecycleOwner;", "liveData", "Landroidx/lifecycle/LiveData;", "(Lorg/reactivestreams/Subscriber;Landroidx/lifecycle/LifecycleOwner;Landroidx/lifecycle/LiveData;)V", "canceled", "", "getCanceled", "()Z", "setCanceled", "(Z)V", "latest", "getLatest", "()Ljava/lang/Object;", "setLatest", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getLifecycle", "()Landroidx/lifecycle/LifecycleOwner;", "getLiveData", "()Landroidx/lifecycle/LiveData;", "observing", "getObserving", "setObserving", "requested", "", "getRequested", "()J", "setRequested", "(J)V", "getSubscriber", "()Lorg/reactivestreams/Subscriber;", "cancel", "", "onChanged", "value", "request", "n", "lifecycle-reactivestreams_release"})
    public static final class LiveDataSubscription<T>
    implements Subscription,
    Observer<T> {
        @NotNull
        private final Subscriber<? super T> subscriber;
        @NotNull
        private final LifecycleOwner lifecycle;
        @NotNull
        private final LiveData<T> liveData;
        private volatile boolean canceled;
        private boolean observing;
        private long requested;
        @Nullable
        private T latest;

        public LiveDataSubscription(@NotNull Subscriber<? super T> subscriber, @NotNull LifecycleOwner lifecycle, @NotNull LiveData<T> liveData) {
            Intrinsics.checkNotNullParameter(subscriber, (String)"subscriber");
            Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
            Intrinsics.checkNotNullParameter(liveData, (String)"liveData");
            this.subscriber = subscriber;
            this.lifecycle = lifecycle;
            this.liveData = liveData;
        }

        @NotNull
        public final Subscriber<? super T> getSubscriber() {
            return this.subscriber;
        }

        @NotNull
        public final LifecycleOwner getLifecycle() {
            return this.lifecycle;
        }

        @NotNull
        public final LiveData<T> getLiveData() {
            return this.liveData;
        }

        public final boolean getCanceled() {
            return this.canceled;
        }

        public final void setCanceled(boolean bl) {
            this.canceled = bl;
        }

        public final boolean getObserving() {
            return this.observing;
        }

        public final void setObserving(boolean bl) {
            this.observing = bl;
        }

        public final long getRequested() {
            return this.requested;
        }

        public final void setRequested(long l) {
            this.requested = l;
        }

        @Nullable
        public final T getLatest() {
            return this.latest;
        }

        public final void setLatest(@Nullable T t) {
            this.latest = t;
        }

        public void onChanged(@Nullable T value) {
            if (this.canceled) {
                return;
            }
            if (this.requested > 0L) {
                this.latest = null;
                this.subscriber.onNext(value);
                if (this.requested != Long.MAX_VALUE) {
                    long l = this.requested;
                    this.requested = l + -1L;
                }
            } else {
                this.latest = value;
            }
        }

        public void request(long n) {
            if (this.canceled) {
                return;
            }
            ArchTaskExecutor.getInstance().executeOnMainThread(() -> LiveDataSubscription.request$lambda$0(this, n));
        }

        public void cancel() {
            if (this.canceled) {
                return;
            }
            this.canceled = true;
            ArchTaskExecutor.getInstance().executeOnMainThread(() -> LiveDataSubscription.cancel$lambda$1(this));
        }

        private static final void request$lambda$0(LiveDataSubscription this$0, long $n) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            if (this$0.canceled) {
                return;
            }
            if ($n <= 0L) {
                this$0.canceled = true;
                if (this$0.observing) {
                    this$0.liveData.removeObserver((Observer)this$0);
                    this$0.observing = false;
                }
                this$0.latest = null;
                this$0.subscriber.onError((Throwable)new IllegalArgumentException("Non-positive request"));
                return;
            }
            long l = this$0.requested = this$0.requested + $n >= this$0.requested ? this$0.requested + $n : Long.MAX_VALUE;
            if (!this$0.observing) {
                this$0.observing = true;
                this$0.liveData.observe(this$0.lifecycle, (Observer)this$0);
            } else if (this$0.latest != null) {
                this$0.onChanged(this$0.latest);
                this$0.latest = null;
            }
        }

        private static final void cancel$lambda$1(LiveDataSubscription this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            if (this$0.observing) {
                this$0.liveData.removeObserver((Observer)this$0);
                this$0.observing = false;
            }
            this$0.latest = null;
        }
    }
}

