/*
 * Decompiled with CFR 0.152.
 */
package androidx.media2.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.drawable.ScaleDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.LinearInterpolator;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.media2.MediaController;
import androidx.media2.MediaItem;
import androidx.media2.MediaMetadata;
import androidx.media2.SessionCommand;
import androidx.media2.SessionCommandGroup;
import androidx.media2.SessionToken;
import androidx.media2.UriMediaItem;
import androidx.media2.widget.BaseLayout;
import androidx.media2.widget.R;
import androidx.media2.widget.UriUtil;
import androidx.mediarouter.app.MediaRouteButton;
import androidx.mediarouter.media.MediaRouteSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;

@RequiresApi(value=19)
public class MediaControlView
extends BaseLayout {
    private static final String TAG = "MediaControlView";
    static final boolean DEBUG = Log.isLoggable((String)"MediaControlView", (int)3);
    static final String KEY_VIDEO_TRACK_COUNT = "VideoTrackCount";
    static final String KEY_AUDIO_TRACK_COUNT = "AudioTrackCount";
    static final String KEY_SUBTITLE_TRACK_COUNT = "SubtitleTrackCount";
    static final String KEY_SUBTITLE_TRACK_LANGUAGE_LIST = "SubtitleTrackLanguageList";
    static final String KEY_SELECTED_AUDIO_INDEX = "SelectedAudioIndex";
    static final String KEY_SELECTED_SUBTITLE_INDEX = "SelectedSubtitleIndex";
    static final String EVENT_UPDATE_TRACK_STATUS = "UpdateTrackStatus";
    static final String KEY_STATE_IS_ADVERTISEMENT = "MediaTypeAdvertisement";
    static final String EVENT_UPDATE_MEDIA_TYPE_STATUS = "UpdateMediaTypeStatus";
    static final String EVENT_UPDATE_SUBTITLE_SELECTED = "UpdateSubtitleSelected";
    static final String EVENT_UPDATE_SUBTITLE_DESELECTED = "UpdateSubtitleDeselected";
    static final String COMMAND_SHOW_SUBTITLE = "showSubtitle";
    static final String COMMAND_HIDE_SUBTITLE = "hideSubtitle";
    static final String COMMAND_SELECT_AUDIO_TRACK = "SelectTrack";
    private static final int SETTINGS_MODE_AUDIO_TRACK = 0;
    private static final int SETTINGS_MODE_PLAYBACK_SPEED = 1;
    private static final int SETTINGS_MODE_SUBTITLE_TRACK = 2;
    private static final int SETTINGS_MODE_VIDEO_QUALITY = 3;
    private static final int SETTINGS_MODE_MAIN = 4;
    private static final int PLAYBACK_SPEED_1x_INDEX = 3;
    private static final int MEDIA_TYPE_DEFAULT = 0;
    private static final int MEDIA_TYPE_MUSIC = 1;
    private static final int MEDIA_TYPE_ADVERTISEMENT = 2;
    private static final int BOTTOM_BAR_RIGHT_VIEW_MAX_ICON_NUM_DEFAULT = 3;
    private static final int BOTTOM_BAR_RIGHT_VIEW_MAX_ICON_NUM_MUSIC = 2;
    private static final int SIZE_TYPE_EMBEDDED = 0;
    private static final int SIZE_TYPE_FULL = 1;
    private static final int SIZE_TYPE_MINIMAL = 2;
    private static final int UX_STATE_ALL_VISIBLE = 0;
    private static final int UX_STATE_ONLY_PROGRESS_VISIBLE = 1;
    private static final int UX_STATE_NONE_VISIBLE = 2;
    private static final int UX_STATE_ANIMATING = 3;
    private static final long DEFAULT_SHOW_CONTROLLER_INTERVAL_MS = 2000L;
    private static final long DEFAULT_PROGRESS_UPDATE_TIME_MS = 1000L;
    private static final long REWIND_TIME_MS = 10000L;
    private static final long FORWARD_TIME_MS = 30000L;
    private static final long AD_SKIP_WAIT_TIME_MS = 5000L;
    private static final long HIDE_TIME_MS = 250L;
    private static final long SHOW_TIME_MS = 250L;
    private static final int MAX_PROGRESS = 1000;
    private static final int MAX_SCALE_LEVEL = 10000;
    private static final int RESOURCE_NON_EXISTENT = -1;
    private static final int SEEK_POSITION_NOT_SET = -1;
    private static final String RESOURCE_EMPTY = "";
    Resources mResources;
    Controller mController;
    OnFullScreenListener mOnFullScreenListener;
    private AccessibilityManager mAccessibilityManager;
    private WindowManager mWindowManager;
    private int mPrevWidth;
    private int mPrevOrientation;
    private int mOriginalLeftBarWidth;
    private int mMaxTimeViewWidth;
    private int mEmbeddedSettingsItemWidth;
    private int mFullSettingsItemWidth;
    private int mSettingsItemHeight;
    private int mSettingsWindowMargin;
    private int mIconSize;
    int mVideoTrackCount;
    int mAudioTrackCount;
    int mSubtitleTrackCount;
    int mSettingsMode;
    int mSelectedSubtitleTrackIndex;
    int mSelectedAudioTrackIndex;
    int mSelectedVideoQualityIndex;
    int mSelectedSpeedIndex;
    int mMediaType;
    int mSizeType;
    int mUxState;
    long mDuration;
    long mPlaybackActions;
    long mShowControllerIntervalMs;
    long mCurrentSeekPosition;
    long mNextSeekPosition;
    boolean mDragging;
    boolean mIsFullScreen;
    boolean mOverflowIsShowing;
    boolean mIsStopped;
    boolean mSeekAvailable;
    boolean mIsAdvertisement;
    boolean mNeedToHideBars;
    boolean mWasPlaying;
    private ViewGroup mRoot;
    private View mTitleBar;
    private TextView mTitleView;
    private View mAdExternalLink;
    private ImageButton mBackButton;
    private MediaRouteButton mRouteButton;
    private MediaRouteSelector mRouteSelector;
    private ViewGroup mCenterView;
    View mTransportControls;
    ImageButton mPlayPauseButton;
    ImageButton mFfwdButton;
    ImageButton mRewButton;
    private ImageButton mNextButton;
    private ImageButton mPrevButton;
    private LinearLayout mMinimalSizeFullScreenView;
    View mProgressBar;
    ProgressBar mProgress;
    private View mProgressBuffer;
    private ViewGroup mBottomBar;
    private ViewGroup mBottomBarLeftView;
    private ViewGroup mTimeView;
    private TextView mEndTime;
    TextView mCurrentTime;
    private TextView mAdSkipView;
    private StringBuilder mFormatBuilder;
    private Formatter mFormatter;
    private ViewGroup mBottomBarRightView;
    ViewGroup mBasicControls;
    ViewGroup mExtraControls;
    ViewGroup mCustomButtons;
    ImageButton mSubtitleButton;
    ImageButton mFullScreenButton;
    ImageButton mOverflowShowButton;
    ImageButton mOverflowHideButton;
    private ImageButton mVideoQualityButton;
    private ImageButton mSettingsButton;
    private TextView mAdRemainingView;
    private ListView mSettingsListView;
    private PopupWindow mSettingsWindow;
    SettingsAdapter mSettingsAdapter;
    SubSettingsAdapter mSubSettingsAdapter;
    private List<String> mSettingsMainTextsList;
    List<String> mSettingsSubTextsList;
    private List<Integer> mSettingsIconIdsList;
    List<String> mSubtitleDescriptionsList;
    List<String> mAudioTrackList;
    List<String> mVideoQualityList;
    List<String> mPlaybackSpeedTextList;
    List<Integer> mPlaybackSpeedMultBy100List;
    int mCustomPlaybackSpeedIndex;
    AnimatorSet mHideMainBarsAnimator;
    AnimatorSet mHideProgressBarAnimator;
    AnimatorSet mHideAllBarsAnimator;
    AnimatorSet mShowMainBarsAnimator;
    AnimatorSet mShowAllBarsAnimator;
    ValueAnimator mOverflowShowAnimator;
    ValueAnimator mOverflowHideAnimator;
    final Runnable mUpdateProgress = new Runnable(){

        @Override
        public void run() {
            boolean isShowing;
            boolean bl = isShowing = MediaControlView.this.getVisibility() == 0;
            if (!MediaControlView.this.mDragging && isShowing && MediaControlView.this.mController.isPlaying()) {
                long pos = MediaControlView.this.setProgress();
                MediaControlView.this.postDelayed(MediaControlView.this.mUpdateProgress, 1000L - pos % 1000L);
            }
        }
    };
    private final Runnable mShowAllBars = new Runnable(){

        @Override
        public void run() {
            MediaControlView.this.mShowAllBarsAnimator.start();
            if (MediaControlView.this.mController.isPlaying()) {
                MediaControlView.this.postDelayed(MediaControlView.this.mHideMainBars, MediaControlView.this.mShowControllerIntervalMs);
            }
        }
    };
    private final Runnable mShowMainBars = new Runnable(){

        @Override
        public void run() {
            MediaControlView.this.mShowMainBarsAnimator.start();
            MediaControlView.this.postDelayed(MediaControlView.this.mHideMainBars, MediaControlView.this.mShowControllerIntervalMs);
        }
    };
    private final Runnable mHideAllBars = new Runnable(){

        @Override
        public void run() {
            if (MediaControlView.this.shouldNotHideBars()) {
                return;
            }
            MediaControlView.this.mHideAllBarsAnimator.start();
        }
    };
    Runnable mHideMainBars = new Runnable(){

        @Override
        public void run() {
            if (!MediaControlView.this.mController.isPlaying() || MediaControlView.this.shouldNotHideBars()) {
                return;
            }
            MediaControlView.this.mHideMainBarsAnimator.start();
            MediaControlView.this.postDelayed(MediaControlView.this.mHideProgressBar, MediaControlView.this.mShowControllerIntervalMs);
        }
    };
    final Runnable mHideProgressBar = new Runnable(){

        @Override
        public void run() {
            if (!MediaControlView.this.mController.isPlaying() || MediaControlView.this.shouldNotHideBars()) {
                return;
            }
            MediaControlView.this.mHideProgressBarAnimator.start();
        }
    };
    private final SeekBar.OnSeekBarChangeListener mSeekListener = new SeekBar.OnSeekBarChangeListener(){

        public void onStartTrackingTouch(SeekBar bar) {
            if (!MediaControlView.this.mSeekAvailable) {
                return;
            }
            MediaControlView.this.mDragging = true;
            MediaControlView.this.removeCallbacks(MediaControlView.this.mUpdateProgress);
            MediaControlView.this.removeCallbacks(MediaControlView.this.mHideMainBars);
            MediaControlView.this.removeCallbacks(MediaControlView.this.mHideProgressBar);
            if (MediaControlView.this.mIsStopped) {
                MediaControlView.this.updateForStoppedState(false);
            }
            if (MediaControlView.this.isCurrentMediaItemFromNetwork() && MediaControlView.this.mController.isPlaying()) {
                MediaControlView.this.mWasPlaying = true;
                MediaControlView.this.mController.pause();
            }
        }

        public void onProgressChanged(SeekBar bar, int progress, boolean fromUser) {
            if (!MediaControlView.this.mSeekAvailable) {
                return;
            }
            if (!fromUser) {
                return;
            }
            if (MediaControlView.this.mDragging && MediaControlView.this.mDuration > 0L) {
                long newPosition = MediaControlView.this.mDuration * (long)progress / 1000L;
                boolean shouldSeekNow = !MediaControlView.this.isCurrentMediaItemFromNetwork();
                MediaControlView.this.seekTo(newPosition, shouldSeekNow);
            }
        }

        public void onStopTrackingTouch(SeekBar bar) {
            if (!MediaControlView.this.mSeekAvailable) {
                return;
            }
            MediaControlView.this.mDragging = false;
            long latestSeekPosition = MediaControlView.this.getLatestSeekPosition();
            if (MediaControlView.this.isCurrentMediaItemFromNetwork()) {
                MediaControlView.this.mCurrentSeekPosition = -1L;
                MediaControlView.this.mNextSeekPosition = -1L;
            }
            MediaControlView.this.seekTo(latestSeekPosition, true);
            if (MediaControlView.this.mWasPlaying) {
                MediaControlView.this.mWasPlaying = false;
                MediaControlView.this.mController.play();
            }
        }
    };
    private final View.OnClickListener mPlayPauseListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView.this.resetHideCallbacks();
            MediaControlView.this.togglePausePlayState();
        }
    };
    private final View.OnClickListener mRewListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView.this.resetHideCallbacks();
            MediaControlView.this.removeCallbacks(MediaControlView.this.mUpdateProgress);
            long latestSeekPosition = MediaControlView.this.getLatestSeekPosition();
            if (MediaControlView.this.mIsStopped && MediaControlView.this.mDuration != 0L) {
                MediaControlView.this.seekTo(MediaControlView.this.mDuration - 10000L, true);
                MediaControlView.this.updateForStoppedState(false);
            } else {
                MediaControlView.this.seekTo(Math.max(latestSeekPosition - 10000L, 0L), true);
            }
        }
    };
    private final View.OnClickListener mFfwdListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView.this.resetHideCallbacks();
            MediaControlView.this.removeCallbacks(MediaControlView.this.mUpdateProgress);
            long latestSeekPosition = MediaControlView.this.getLatestSeekPosition();
            MediaControlView.this.seekTo(Math.min(latestSeekPosition + 30000L, MediaControlView.this.mDuration), true);
            if (latestSeekPosition + 30000L >= MediaControlView.this.mDuration) {
                MediaControlView.this.updateForStoppedState(true);
            }
        }
    };
    private final View.OnClickListener mNextListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView.this.resetHideCallbacks();
            MediaControlView.this.mController.skipToNextItem();
        }
    };
    private final View.OnClickListener mPrevListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView.this.resetHideCallbacks();
            MediaControlView.this.mController.skipToPreviousItem();
        }
    };
    private final View.OnClickListener mBackListener = new View.OnClickListener(){

        public void onClick(View v) {
            View parent = (View)MediaControlView.this.getParent();
            if (parent != null) {
                parent.onKeyDown(4, new KeyEvent(0, 4));
            }
        }
    };
    private final View.OnClickListener mSubtitleListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView.this.removeCallbacks(MediaControlView.this.mHideMainBars);
            MediaControlView.this.removeCallbacks(MediaControlView.this.mHideProgressBar);
            MediaControlView.this.mSettingsMode = 2;
            MediaControlView.this.mSubSettingsAdapter.setTexts(MediaControlView.this.mSubtitleDescriptionsList);
            MediaControlView.this.mSubSettingsAdapter.setCheckPosition(MediaControlView.this.mSelectedSubtitleTrackIndex);
            MediaControlView.this.displaySettingsWindow(MediaControlView.this.mSubSettingsAdapter);
        }
    };
    private final View.OnClickListener mVideoQualityListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView.this.removeCallbacks(MediaControlView.this.mHideMainBars);
            MediaControlView.this.removeCallbacks(MediaControlView.this.mHideProgressBar);
            MediaControlView.this.mSettingsMode = 3;
            MediaControlView.this.mSubSettingsAdapter.setTexts(MediaControlView.this.mVideoQualityList);
            MediaControlView.this.mSubSettingsAdapter.setCheckPosition(MediaControlView.this.mSelectedVideoQualityIndex);
            MediaControlView.this.displaySettingsWindow(MediaControlView.this.mSubSettingsAdapter);
        }
    };
    private final View.OnClickListener mFullScreenListener = new View.OnClickListener(){

        public void onClick(View v) {
            boolean isEnteringFullScreen;
            MediaControlView.this.resetHideCallbacks();
            if (MediaControlView.this.mOnFullScreenListener == null) {
                return;
            }
            boolean bl = isEnteringFullScreen = !MediaControlView.this.mIsFullScreen;
            if (isEnteringFullScreen) {
                MediaControlView.this.mFullScreenButton.setImageDrawable(MediaControlView.this.mResources.getDrawable(R.drawable.ic_fullscreen_exit));
            } else {
                MediaControlView.this.mFullScreenButton.setImageDrawable(MediaControlView.this.mResources.getDrawable(R.drawable.ic_fullscreen));
            }
            MediaControlView.this.mIsFullScreen = isEnteringFullScreen;
            MediaControlView.this.mOnFullScreenListener.onFullScreen((View)MediaControlView.this, MediaControlView.this.mIsFullScreen);
        }
    };
    private final View.OnClickListener mOverflowShowListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView.this.resetHideCallbacks();
            MediaControlView.this.mOverflowIsShowing = true;
            MediaControlView.this.mOverflowShowAnimator.start();
        }
    };
    private final View.OnClickListener mOverflowHideListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView.this.resetHideCallbacks();
            MediaControlView.this.mOverflowIsShowing = false;
            MediaControlView.this.mOverflowHideAnimator.start();
        }
    };
    private final View.OnClickListener mSettingsButtonListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView.this.removeCallbacks(MediaControlView.this.mHideMainBars);
            MediaControlView.this.removeCallbacks(MediaControlView.this.mHideProgressBar);
            MediaControlView.this.mSettingsMode = 4;
            MediaControlView.this.mSettingsAdapter.setSubTexts(MediaControlView.this.mSettingsSubTextsList);
            MediaControlView.this.displaySettingsWindow(MediaControlView.this.mSettingsAdapter);
        }
    };
    private final AdapterView.OnItemClickListener mSettingsItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            switch (MediaControlView.this.mSettingsMode) {
                case 4: {
                    if (position == 0) {
                        MediaControlView.this.mSubSettingsAdapter.setTexts(MediaControlView.this.mAudioTrackList);
                        MediaControlView.this.mSubSettingsAdapter.setCheckPosition(MediaControlView.this.mSelectedAudioTrackIndex);
                        MediaControlView.this.mSettingsMode = 0;
                    } else if (position == 1) {
                        MediaControlView.this.mSubSettingsAdapter.setTexts(MediaControlView.this.mPlaybackSpeedTextList);
                        MediaControlView.this.mSubSettingsAdapter.setCheckPosition(MediaControlView.this.mSelectedSpeedIndex);
                        MediaControlView.this.mSettingsMode = 1;
                    }
                    MediaControlView.this.displaySettingsWindow(MediaControlView.this.mSubSettingsAdapter);
                    break;
                }
                case 0: {
                    if (position != MediaControlView.this.mSelectedAudioTrackIndex) {
                        MediaControlView.this.mSelectedAudioTrackIndex = position;
                        if (MediaControlView.this.mAudioTrackCount > 0) {
                            MediaControlView.this.mController.selectAudioTrack(position);
                        }
                        MediaControlView.this.mSettingsSubTextsList.set(0, MediaControlView.this.mSubSettingsAdapter.getMainText(position));
                    }
                    MediaControlView.this.dismissSettingsWindow();
                    break;
                }
                case 1: {
                    if (position != MediaControlView.this.mSelectedSpeedIndex) {
                        float speed = (float)MediaControlView.this.mPlaybackSpeedMultBy100List.get(position).intValue() / 100.0f;
                        MediaControlView.this.mController.setSpeed(speed);
                    }
                    MediaControlView.this.dismissSettingsWindow();
                    break;
                }
                case 2: {
                    if (position != MediaControlView.this.mSelectedSubtitleTrackIndex) {
                        if (position > 0) {
                            MediaControlView.this.mController.showSubtitle(position - 1);
                            MediaControlView.this.mSubtitleButton.setImageDrawable(MediaControlView.this.mResources.getDrawable(R.drawable.ic_subtitle_on));
                            MediaControlView.this.mSubtitleButton.setContentDescription((CharSequence)MediaControlView.this.mResources.getString(R.string.mcv2_cc_is_on));
                        } else {
                            MediaControlView.this.mController.hideSubtitle();
                            MediaControlView.this.mSubtitleButton.setImageDrawable(MediaControlView.this.mResources.getDrawable(R.drawable.ic_subtitle_off));
                            MediaControlView.this.mSubtitleButton.setContentDescription((CharSequence)MediaControlView.this.mResources.getString(R.string.mcv2_cc_is_off));
                        }
                    }
                    MediaControlView.this.dismissSettingsWindow();
                    break;
                }
                case 3: {
                    MediaControlView.this.mSelectedVideoQualityIndex = position;
                    MediaControlView.this.dismissSettingsWindow();
                }
            }
        }
    };
    private PopupWindow.OnDismissListener mSettingsDismissListener = new PopupWindow.OnDismissListener(){

        public void onDismiss() {
            if (MediaControlView.this.mNeedToHideBars) {
                MediaControlView.this.postDelayed(MediaControlView.this.mHideMainBars, MediaControlView.this.mShowControllerIntervalMs);
            }
        }
    };

    public MediaControlView(@NonNull Context context) {
        this(context, null);
    }

    public MediaControlView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MediaControlView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mResources = context.getResources();
        this.mController = new Controller();
        this.mRoot = this.makeControllerView();
        this.addView((View)this.mRoot);
        this.mShowControllerIntervalMs = 2000L;
        this.mAccessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
    }

    public void setSessionToken(@NonNull SessionToken token) {
        this.mController.setSessionToken(token);
        if (this.mController.hasMetadata()) {
            this.updateMetadata();
        }
    }

    public void setOnFullScreenListener(@NonNull OnFullScreenListener l) {
        this.mOnFullScreenListener = l;
        this.mFullScreenButton.setVisibility(0);
    }

    public void requestPlayButtonFocus() {
        if (this.mPlayPauseButton != null) {
            this.mPlayPauseButton.requestFocus();
        }
    }

    public CharSequence getAccessibilityClassName() {
        return MediaControlView.class.getName();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 1 && (this.mMediaType != 1 || this.mSizeType != 1)) {
            this.toggleMediaControlViewVisibility();
        }
        return true;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (ev.getAction() == 1 && (this.mMediaType != 1 || this.mSizeType != 1)) {
            this.toggleMediaControlViewVisibility();
        }
        return true;
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int currOrientation;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mPrevWidth != this.getMeasuredWidth()) {
            if (this.mTimeView.getWidth() == 0) {
                return;
            }
            int currWidth = this.getMeasuredWidth();
            int currHeight = this.getMeasuredHeight();
            Point screenSize = new Point();
            this.mWindowManager.getDefaultDisplay().getSize(screenSize);
            if (this.mMediaType == 0) {
                this.updateLayout(3, currWidth, currHeight, screenSize.x, screenSize.y);
            } else if (this.mMediaType == 1) {
                this.updateLayout(2, currWidth, currHeight, screenSize.x, screenSize.y);
            }
            this.mPrevWidth = currWidth;
            this.showAllBars();
            this.hideSettingsAndOverflow();
        }
        if ((currOrientation = this.retrieveOrientation()) != this.mPrevOrientation) {
            this.showAllBars();
            this.hideSettingsAndOverflow();
            this.mPrevOrientation = currOrientation;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.mPlayPauseButton != null) {
            this.mPlayPauseButton.setEnabled(enabled);
        }
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setEnabled(enabled);
        }
        if (this.mRewButton != null) {
            this.mRewButton.setEnabled(enabled);
        }
        if (this.mNextButton != null) {
            this.mNextButton.setEnabled(enabled);
        }
        if (this.mPrevButton != null) {
            this.mPrevButton.setEnabled(enabled);
        }
        if (this.mProgress != null) {
            this.mProgress.setEnabled(enabled);
        }
        if (this.mSubtitleButton != null) {
            this.mSubtitleButton.setEnabled(enabled);
        }
        if (this.mFullScreenButton != null) {
            this.mFullScreenButton.setEnabled(enabled);
        }
        if (this.mOverflowShowButton != null) {
            this.mOverflowShowButton.setEnabled(enabled);
        }
        if (this.mOverflowHideButton != null) {
            this.mOverflowHideButton.setEnabled(enabled);
        }
        if (this.mVideoQualityButton != null) {
            this.mVideoQualityButton.setEnabled(enabled);
        }
        if (this.mSettingsButton != null) {
            this.mSettingsButton.setEnabled(enabled);
        }
        if (this.mBackButton != null) {
            this.mBackButton.setEnabled(enabled);
        }
        if (this.mRouteButton != null) {
            this.mRouteButton.setEnabled(enabled);
        }
        this.disableUnsupportedButtons();
    }

    public void onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        if (isVisible) {
            this.disableUnsupportedButtons();
            this.removeCallbacks(this.mUpdateProgress);
            this.post(this.mUpdateProgress);
        } else {
            this.removeCallbacks(this.mUpdateProgress);
        }
    }

    void setRouteSelector(MediaRouteSelector selector) {
        this.mRouteSelector = selector;
        if (this.mRouteSelector != null && !this.mRouteSelector.isEmpty()) {
            this.mRouteButton.setRouteSelector(selector);
            this.mRouteButton.setVisibility(0);
        } else {
            this.mRouteButton.setRouteSelector(MediaRouteSelector.EMPTY);
            this.mRouteButton.setVisibility(8);
        }
    }

    void setShowControllerInterval(long interval) {
        this.mShowControllerIntervalMs = interval;
    }

    private ViewGroup makeControllerView() {
        ViewGroup root = (ViewGroup)MediaControlView.inflateLayout(this.getContext(), R.layout.media_controller);
        this.initControllerView(root);
        return root;
    }

    static View inflateLayout(Context context, int resId) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        return inflater.inflate(resId, null);
    }

    private void initControllerView(ViewGroup v) {
        this.mWindowManager = (WindowManager)this.getContext().getApplicationContext().getSystemService("window");
        this.mIconSize = this.mResources.getDimensionPixelSize(R.dimen.mcv2_icon_size);
        this.mTitleBar = v.findViewById(R.id.title_bar);
        this.mTitleView = (TextView)v.findViewById(R.id.title_text);
        this.mAdExternalLink = v.findViewById(R.id.ad_external_link);
        this.mBackButton = (ImageButton)v.findViewById(R.id.back);
        if (this.mBackButton != null) {
            this.mBackButton.setOnClickListener(this.mBackListener);
            this.mBackButton.setVisibility(8);
        }
        this.mRouteButton = (MediaRouteButton)v.findViewById(R.id.cast);
        this.mCenterView = (ViewGroup)v.findViewById(R.id.center_view);
        this.mTransportControls = this.inflateTransportControls(R.layout.embedded_transport_controls);
        this.mCenterView.addView(this.mTransportControls);
        this.mMinimalSizeFullScreenView = (LinearLayout)v.findViewById(R.id.minimal_fullscreen_view);
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mMinimalSizeFullScreenView.getLayoutParams();
        int iconSize = this.mResources.getDimensionPixelSize(R.dimen.mcv2_icon_size);
        params.setMargins(0, iconSize * -1, 0, 0);
        this.mMinimalSizeFullScreenView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mMinimalSizeFullScreenView.setVisibility(8);
        this.mProgressBar = v.findViewById(R.id.progress_bar);
        this.mProgress = (ProgressBar)v.findViewById(R.id.progress);
        if (this.mProgress != null) {
            if (this.mProgress instanceof SeekBar) {
                SeekBar seeker = (SeekBar)this.mProgress;
                seeker.setOnSeekBarChangeListener(this.mSeekListener);
                seeker.setProgressDrawable(this.mResources.getDrawable(R.drawable.custom_progress));
                seeker.setThumb(this.mResources.getDrawable(R.drawable.custom_progress_thumb));
                seeker.setThumbOffset(0);
            }
            this.mProgress.setMax(1000);
        }
        this.mProgressBuffer = v.findViewById(R.id.progress_buffer);
        this.mCurrentSeekPosition = -1L;
        this.mNextSeekPosition = -1L;
        this.mBottomBar = (ViewGroup)v.findViewById(R.id.bottom_bar);
        this.mBottomBarLeftView = (ViewGroup)v.findViewById(R.id.bottom_bar_left);
        this.mTimeView = (ViewGroup)v.findViewById(R.id.time);
        this.mEndTime = (TextView)v.findViewById(R.id.time_end);
        this.mCurrentTime = (TextView)v.findViewById(R.id.time_current);
        this.mAdSkipView = (TextView)v.findViewById(R.id.ad_skip_time);
        this.mFormatBuilder = new StringBuilder();
        this.mFormatter = new Formatter(this.mFormatBuilder, Locale.getDefault());
        this.mBasicControls = (ViewGroup)v.findViewById(R.id.basic_controls);
        this.mExtraControls = (ViewGroup)v.findViewById(R.id.extra_controls);
        this.mCustomButtons = (ViewGroup)v.findViewById(R.id.custom_buttons);
        this.mSubtitleButton = (ImageButton)v.findViewById(R.id.subtitle);
        if (this.mSubtitleButton != null) {
            this.mSubtitleButton.setOnClickListener(this.mSubtitleListener);
        }
        this.mFullScreenButton = (ImageButton)v.findViewById(R.id.fullscreen);
        if (this.mFullScreenButton != null) {
            this.mFullScreenButton.setOnClickListener(this.mFullScreenListener);
        }
        this.mOverflowShowButton = (ImageButton)v.findViewById(R.id.overflow_show);
        if (this.mOverflowShowButton != null) {
            this.mOverflowShowButton.setOnClickListener(this.mOverflowShowListener);
        }
        this.mOverflowHideButton = (ImageButton)v.findViewById(R.id.overflow_hide);
        if (this.mOverflowHideButton != null) {
            this.mOverflowHideButton.setOnClickListener(this.mOverflowHideListener);
        }
        this.mSettingsButton = (ImageButton)v.findViewById(R.id.settings);
        if (this.mSettingsButton != null) {
            this.mSettingsButton.setOnClickListener(this.mSettingsButtonListener);
        }
        this.mVideoQualityButton = (ImageButton)v.findViewById(R.id.video_quality);
        if (this.mVideoQualityButton != null) {
            this.mVideoQualityButton.setOnClickListener(this.mVideoQualityListener);
        }
        this.mAdRemainingView = (TextView)v.findViewById(R.id.ad_remaining);
        this.initializeSettingsLists();
        this.mSettingsListView = (ListView)MediaControlView.inflateLayout(this.getContext(), R.layout.settings_list);
        this.mSettingsAdapter = new SettingsAdapter(this.mSettingsMainTextsList, this.mSettingsSubTextsList, this.mSettingsIconIdsList);
        this.mSubSettingsAdapter = new SubSettingsAdapter(null, 0);
        this.mSettingsListView.setAdapter((ListAdapter)this.mSettingsAdapter);
        this.mSettingsListView.setChoiceMode(1);
        this.mSettingsListView.setOnItemClickListener(this.mSettingsItemClickListener);
        this.mEmbeddedSettingsItemWidth = this.mResources.getDimensionPixelSize(R.dimen.mcv2_embedded_settings_width);
        this.mFullSettingsItemWidth = this.mResources.getDimensionPixelSize(R.dimen.mcv2_full_settings_width);
        this.mSettingsItemHeight = this.mResources.getDimensionPixelSize(R.dimen.mcv2_settings_height);
        this.mSettingsWindowMargin = -1 * this.mResources.getDimensionPixelSize(R.dimen.mcv2_settings_offset);
        this.mSettingsWindow = new PopupWindow((View)this.mSettingsListView, this.mEmbeddedSettingsItemWidth, -2, true);
        this.mSettingsWindow.setOnDismissListener(this.mSettingsDismissListener);
        int titleBarTranslateY = -1 * this.mResources.getDimensionPixelSize(R.dimen.mcv2_title_bar_height);
        int bottomBarHeight = this.mResources.getDimensionPixelSize(R.dimen.mcv2_bottom_bar_height);
        int progressThumbHeight = this.mResources.getDimensionPixelSize(R.dimen.mcv2_custom_progress_thumb_size);
        int progressBarHeight = this.mResources.getDimensionPixelSize(R.dimen.mcv2_custom_progress_max_size);
        int bottomBarTranslateY = bottomBarHeight + progressThumbHeight / 2 - progressBarHeight / 2;
        ValueAnimator fadeOutAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        fadeOutAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        fadeOutAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ScaleDrawable thumb;
                float alpha = ((Float)animation.getAnimatedValue()).floatValue();
                SeekBar seekBar = (SeekBar)MediaControlView.this.mProgress;
                if (MediaControlView.this.mSizeType != 2 && (thumb = (ScaleDrawable)seekBar.getThumb()) != null) {
                    thumb.setLevel((int)(10000.0f * alpha));
                }
                MediaControlView.this.mTransportControls.setAlpha(alpha);
                if (alpha == 0.0f) {
                    MediaControlView.this.mTransportControls.setVisibility(8);
                } else if (alpha == 1.0f) {
                    MediaControlView.this.setEnabled(false);
                }
                if (MediaControlView.this.mSizeType == 2) {
                    MediaControlView.this.mFullScreenButton.setAlpha(alpha);
                    MediaControlView.this.mProgressBar.setAlpha(alpha);
                    if (alpha == 0.0f) {
                        if (MediaControlView.this.mOnFullScreenListener != null) {
                            MediaControlView.this.mFullScreenButton.setVisibility(8);
                        }
                        MediaControlView.this.mProgressBar.setVisibility(8);
                    }
                }
            }
        });
        ValueAnimator fadeInAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        fadeInAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        fadeInAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ScaleDrawable thumb;
                float alpha = ((Float)animation.getAnimatedValue()).floatValue();
                SeekBar seekBar = (SeekBar)MediaControlView.this.mProgress;
                if (MediaControlView.this.mSizeType != 2 && (thumb = (ScaleDrawable)seekBar.getThumb()) != null) {
                    thumb.setLevel((int)(10000.0f * alpha));
                }
                MediaControlView.this.mTransportControls.setAlpha(alpha);
                if (alpha == 0.0f) {
                    MediaControlView.this.mTransportControls.setVisibility(0);
                } else if (alpha == 1.0f) {
                    MediaControlView.this.setEnabled(true);
                }
                if (MediaControlView.this.mSizeType == 2) {
                    MediaControlView.this.mFullScreenButton.setAlpha(alpha);
                    MediaControlView.this.mProgressBar.setAlpha(alpha);
                    if (alpha == 0.0f) {
                        if (MediaControlView.this.mOnFullScreenListener != null) {
                            MediaControlView.this.mFullScreenButton.setVisibility(0);
                        }
                        MediaControlView.this.mProgressBar.setVisibility(0);
                    }
                }
            }
        });
        this.mHideMainBarsAnimator = new AnimatorSet();
        this.mHideMainBarsAnimator.play((Animator)ObjectAnimator.ofFloat((Object)this.mTitleBar, (String)"translationY", (float[])new float[]{0.0f, titleBarTranslateY})).with((Animator)ObjectAnimator.ofFloat((Object)this.mBottomBar, (String)"translationY", (float[])new float[]{0.0f, bottomBarTranslateY})).with((Animator)ObjectAnimator.ofFloat((Object)this.mProgressBar, (String)"translationY", (float[])new float[]{0.0f, bottomBarTranslateY})).with((Animator)fadeOutAnimator);
        this.mHideMainBarsAnimator.setDuration(250L);
        ((Animator)this.mHideMainBarsAnimator.getChildAnimations().get(0)).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MediaControlView.this.setEnabled(false);
                MediaControlView.this.mUxState = 3;
            }

            public void onAnimationEnd(Animator animation) {
                MediaControlView.this.setEnabled(true);
                MediaControlView.this.mUxState = 1;
            }
        });
        this.mHideProgressBarAnimator = new AnimatorSet();
        this.mHideProgressBarAnimator.play((Animator)ObjectAnimator.ofFloat((Object)this.mBottomBar, (String)"translationY", (float[])new float[]{bottomBarTranslateY, bottomBarTranslateY + progressBarHeight})).with((Animator)ObjectAnimator.ofFloat((Object)this.mProgressBar, (String)"translationY", (float[])new float[]{bottomBarTranslateY, bottomBarTranslateY + progressBarHeight}));
        this.mHideProgressBarAnimator.setDuration(250L);
        ((Animator)this.mHideProgressBarAnimator.getChildAnimations().get(0)).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MediaControlView.this.setEnabled(false);
                MediaControlView.this.mUxState = 3;
            }

            public void onAnimationEnd(Animator animation) {
                MediaControlView.this.setEnabled(true);
                MediaControlView.this.mUxState = 2;
            }
        });
        this.mHideAllBarsAnimator = new AnimatorSet();
        this.mHideAllBarsAnimator.play((Animator)ObjectAnimator.ofFloat((Object)this.mTitleBar, (String)"translationY", (float[])new float[]{0.0f, titleBarTranslateY})).with((Animator)ObjectAnimator.ofFloat((Object)this.mBottomBar, (String)"translationY", (float[])new float[]{0.0f, bottomBarTranslateY + progressBarHeight})).with((Animator)ObjectAnimator.ofFloat((Object)this.mProgressBar, (String)"translationY", (float[])new float[]{0.0f, bottomBarTranslateY + progressBarHeight})).with((Animator)fadeOutAnimator);
        this.mHideAllBarsAnimator.setDuration(250L);
        ((Animator)this.mHideAllBarsAnimator.getChildAnimations().get(0)).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MediaControlView.this.setEnabled(false);
                MediaControlView.this.mUxState = 3;
            }

            public void onAnimationEnd(Animator animation) {
                MediaControlView.this.setEnabled(true);
                MediaControlView.this.mUxState = 2;
            }
        });
        this.mShowMainBarsAnimator = new AnimatorSet();
        this.mShowMainBarsAnimator.play((Animator)ObjectAnimator.ofFloat((Object)this.mTitleBar, (String)"translationY", (float[])new float[]{titleBarTranslateY, 0.0f})).with((Animator)ObjectAnimator.ofFloat((Object)this.mBottomBar, (String)"translationY", (float[])new float[]{bottomBarTranslateY, 0.0f})).with((Animator)ObjectAnimator.ofFloat((Object)this.mProgressBar, (String)"translationY", (float[])new float[]{bottomBarTranslateY, 0.0f})).with((Animator)fadeInAnimator);
        this.mShowMainBarsAnimator.setDuration(250L);
        ((Animator)this.mShowMainBarsAnimator.getChildAnimations().get(0)).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MediaControlView.this.setEnabled(false);
                MediaControlView.this.mUxState = 3;
            }

            public void onAnimationEnd(Animator animation) {
                MediaControlView.this.setEnabled(true);
                MediaControlView.this.mUxState = 0;
            }
        });
        this.mShowAllBarsAnimator = new AnimatorSet();
        this.mShowAllBarsAnimator.play((Animator)ObjectAnimator.ofFloat((Object)this.mTitleBar, (String)"translationY", (float[])new float[]{titleBarTranslateY, 0.0f})).with((Animator)ObjectAnimator.ofFloat((Object)this.mBottomBar, (String)"translationY", (float[])new float[]{bottomBarTranslateY + progressBarHeight, 0.0f})).with((Animator)ObjectAnimator.ofFloat((Object)this.mProgressBar, (String)"translationY", (float[])new float[]{bottomBarTranslateY + progressBarHeight, 0.0f})).with((Animator)fadeInAnimator);
        this.mShowAllBarsAnimator.setDuration(250L);
        ((Animator)this.mShowAllBarsAnimator.getChildAnimations().get(0)).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MediaControlView.this.setEnabled(false);
                MediaControlView.this.mUxState = 3;
            }

            public void onAnimationEnd(Animator animation) {
                MediaControlView.this.setEnabled(true);
                MediaControlView.this.mUxState = 0;
            }
        });
        this.mOverflowShowAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mOverflowShowAnimator.setDuration(250L);
        this.mOverflowShowAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                MediaControlView.this.animateOverflow(animation);
            }
        });
        this.mOverflowShowAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MediaControlView.this.mExtraControls.setVisibility(0);
                MediaControlView.this.mOverflowShowButton.setVisibility(8);
                MediaControlView.this.mOverflowHideButton.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                MediaControlView.this.mBasicControls.setVisibility(8);
                if (MediaControlView.this.mSizeType == 1 && MediaControlView.this.mMediaType == 0) {
                    MediaControlView.this.mFfwdButton.setVisibility(8);
                }
            }
        });
        this.mOverflowHideAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.mOverflowHideAnimator.setDuration(250L);
        this.mOverflowHideAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                MediaControlView.this.animateOverflow(animation);
            }
        });
        this.mOverflowHideAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MediaControlView.this.mBasicControls.setVisibility(0);
                MediaControlView.this.mOverflowShowButton.setVisibility(0);
                MediaControlView.this.mOverflowHideButton.setVisibility(8);
                if (MediaControlView.this.mSizeType == 1 && MediaControlView.this.mMediaType == 0) {
                    MediaControlView.this.mFfwdButton.setVisibility(0);
                }
            }

            public void onAnimationEnd(Animator animation) {
                MediaControlView.this.mExtraControls.setVisibility(8);
            }
        });
    }

    private void disableUnsupportedButtons() {
        try {
            if (this.mPlayPauseButton != null && !this.mController.canPause()) {
                this.mPlayPauseButton.setEnabled(false);
            }
            if (this.mRewButton != null && !this.mController.canSeekBackward()) {
                this.mRewButton.setEnabled(false);
            }
            if (this.mFfwdButton != null && !this.mController.canSeekForward()) {
                this.mFfwdButton.setEnabled(false);
            }
            if (this.mProgress != null && !this.mController.canSeekBackward() && !this.mController.canSeekForward()) {
                this.mProgress.setEnabled(false);
            }
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
    }

    String stringForTime(long timeMs) {
        long totalSeconds = timeMs / 1000L;
        long seconds = totalSeconds % 60L;
        long minutes = totalSeconds / 60L % 60L;
        long hours = totalSeconds / 3600L;
        this.mFormatBuilder.setLength(0);
        if (hours > 0L) {
            return this.mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return this.mFormatter.format("%02d:%02d", minutes, seconds).toString();
    }

    long setProgress() {
        int positionOnProgressBar = 0;
        long currentPosition = this.mController.getCurrentPosition();
        if (currentPosition > this.mDuration) {
            currentPosition = this.mDuration;
        }
        if (this.mDuration > 0L) {
            positionOnProgressBar = (int)(1000L * currentPosition / this.mDuration);
        }
        if (this.mProgress != null && currentPosition != this.mDuration) {
            this.mProgress.setProgress(positionOnProgressBar);
            if (this.mController.getBufferPercentage() < 0L) {
                this.mProgress.setSecondaryProgress(1000);
            } else {
                this.mProgress.setSecondaryProgress((int)this.mController.getBufferPercentage() * 10);
            }
        }
        if (this.mEndTime != null) {
            this.mEndTime.setText((CharSequence)this.stringForTime(this.mDuration));
        }
        if (this.mCurrentTime != null) {
            this.mCurrentTime.setText((CharSequence)this.stringForTime(currentPosition));
        }
        if (this.mIsAdvertisement) {
            if (this.mAdSkipView != null) {
                if (currentPosition <= 5000L) {
                    if (this.mAdSkipView.getVisibility() == 8) {
                        this.mAdSkipView.setVisibility(0);
                    }
                    String skipTimeText = this.mResources.getString(R.string.MediaControlView_ad_skip_wait_time, new Object[]{(5000L - currentPosition) / 1000L + 1L});
                    this.mAdSkipView.setText((CharSequence)skipTimeText);
                } else if (this.mAdSkipView.getVisibility() == 0) {
                    this.mAdSkipView.setVisibility(8);
                    this.mNextButton.setEnabled(true);
                    this.mNextButton.clearColorFilter();
                }
            }
            if (this.mAdRemainingView != null) {
                long remainingTime = this.mDuration - currentPosition < 0L ? 0L : this.mDuration - currentPosition;
                String remainingTimeText = this.mResources.getString(R.string.MediaControlView_ad_remaining_time, new Object[]{this.stringForTime(remainingTime)});
                this.mAdRemainingView.setText((CharSequence)remainingTimeText);
            }
        }
        return currentPosition;
    }

    void togglePausePlayState() {
        if (this.mController.isPlaying()) {
            this.mController.pause();
            this.mPlayPauseButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_play_circle_filled));
            this.mPlayPauseButton.setContentDescription((CharSequence)this.mResources.getString(R.string.mcv2_play_button_desc));
        } else {
            if (this.mIsStopped) {
                this.mController.seekTo(0L);
            }
            this.mController.play();
            this.mPlayPauseButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_pause_circle_filled));
            this.mPlayPauseButton.setContentDescription((CharSequence)this.mResources.getString(R.string.mcv2_pause_button_desc));
        }
    }

    private void toggleMediaControlViewVisibility() {
        if (this.shouldNotHideBars() || this.mShowControllerIntervalMs == 0L || this.mUxState == 3) {
            return;
        }
        this.removeCallbacks(this.mHideMainBars);
        this.removeCallbacks(this.mHideProgressBar);
        switch (this.mUxState) {
            case 2: {
                this.post(this.mShowAllBars);
                break;
            }
            case 1: {
                this.post(this.mShowMainBars);
                break;
            }
            case 0: {
                this.post(this.mHideAllBars);
            }
        }
    }

    void updateMetadata() {
        if (!this.mController.hasMetadata()) {
            return;
        }
        long duration = this.mController.getDurationMs();
        if (duration != 0L) {
            this.mDuration = duration;
            this.mTimeView.setVisibility(0);
            this.setProgress();
        }
        if (this.mMediaType != 1) {
            CharSequence title = this.mController.getTitle();
            if (title != null) {
                this.mTitleView.setText((CharSequence)title.toString());
            }
        } else {
            CharSequence artist;
            CharSequence title = this.mController.getTitle();
            if (title == null) {
                title = this.mResources.getString(R.string.mcv2_music_title_unknown_text);
            }
            if ((artist = this.mController.getArtistText()) == null) {
                artist = this.mResources.getString(R.string.mcv2_music_artist_unknown_text);
            }
            this.mTitleView.setText((CharSequence)(title.toString() + " - " + artist.toString()));
            this.mVideoQualityButton.setVisibility(8);
            if (this.mFfwdButton != null) {
                this.mFfwdButton.setVisibility(8);
            }
            if (this.mRewButton != null) {
                this.mRewButton.setVisibility(8);
            }
            Point screenSize = new Point();
            this.mWindowManager.getDefaultDisplay().getSize(screenSize);
            this.updateLayout(2, this.getMeasuredWidth(), this.getMeasuredHeight(), screenSize.x, screenSize.y);
        }
    }

    void updateLayoutForAd() {
        if (this.mIsAdvertisement) {
            this.mRewButton.setVisibility(8);
            this.mFfwdButton.setVisibility(8);
            this.mPrevButton.setVisibility(8);
            this.mTimeView.setVisibility(8);
            this.mAdSkipView.setVisibility(0);
            this.mAdRemainingView.setVisibility(0);
            this.mAdExternalLink.setVisibility(0);
            this.mProgress.setEnabled(false);
            this.mNextButton.setEnabled(false);
            this.mNextButton.setColorFilter(R.color.gray);
        } else {
            this.mRewButton.setVisibility(0);
            this.mFfwdButton.setVisibility(0);
            this.mPrevButton.setVisibility(0);
            this.mTimeView.setVisibility(0);
            this.mAdSkipView.setVisibility(8);
            this.mAdRemainingView.setVisibility(8);
            this.mAdExternalLink.setVisibility(8);
            this.mProgress.setEnabled(true);
            this.mNextButton.setEnabled(true);
            this.mNextButton.clearColorFilter();
            this.disableUnsupportedButtons();
        }
    }

    private void updateLayout(int maxIconNum, int currWidth, int currHeight, int screenWidth, int screenHeight) {
        boolean isFullSize;
        if (this.mMaxTimeViewWidth == 0) {
            this.mMaxTimeViewWidth = this.mTimeView.getWidth();
        }
        int bottomBarRightWidthMax = this.mIconSize * maxIconNum;
        int fullWidth = this.mTransportControls.getWidth() + this.mMaxTimeViewWidth + bottomBarRightWidthMax;
        int screenMaxLength = Math.max(screenWidth, screenHeight);
        int embeddedWidth = this.mMaxTimeViewWidth + bottomBarRightWidthMax;
        boolean bl = this.mMediaType == 0 ? currWidth == screenMaxLength : (isFullSize = currWidth == screenWidth);
        if (isFullSize) {
            if (this.mSizeType != 1) {
                this.updateLayoutForSizeChange(1);
                if (this.mMediaType == 1) {
                    this.mTitleView.setVisibility(8);
                } else {
                    this.mUxState = 2;
                    this.toggleMediaControlViewVisibility();
                }
            }
        } else if (embeddedWidth <= currWidth) {
            if (this.mSizeType != 0) {
                this.updateLayoutForSizeChange(0);
                if (this.mMediaType == 1) {
                    this.mTitleView.setVisibility(0);
                }
            }
        } else if (this.mSizeType != 2) {
            this.updateLayoutForSizeChange(2);
            if (this.mMediaType == 1) {
                this.mTitleView.setVisibility(8);
            }
        }
    }

    private void updateLayoutForSizeChange(int sizeType) {
        this.mSizeType = sizeType;
        RelativeLayout.LayoutParams timeViewParams = (RelativeLayout.LayoutParams)this.mTimeView.getLayoutParams();
        SeekBar seeker = (SeekBar)this.mProgress;
        switch (this.mSizeType) {
            case 0: {
                this.mTitleBar.setVisibility(0);
                this.mBackButton.setVisibility(8);
                this.mTitleView.setPadding(this.mResources.getDimensionPixelSize(R.dimen.mcv2_embedded_icon_padding), this.mTitleView.getPaddingTop(), this.mTitleView.getPaddingRight(), this.mTitleView.getPaddingBottom());
                if (this.mOnFullScreenListener != null) {
                    this.mMinimalSizeFullScreenView.setVisibility(8);
                    this.mFullScreenButton = (ImageButton)this.mBasicControls.findViewById(R.id.fullscreen);
                    this.mFullScreenButton.setOnClickListener(this.mFullScreenListener);
                }
                this.mCenterView.removeAllViews();
                this.mBottomBarLeftView.removeView(this.mTransportControls);
                this.mBottomBarLeftView.setVisibility(8);
                this.mTransportControls = this.inflateTransportControls(R.layout.embedded_transport_controls);
                this.mCenterView.addView(this.mTransportControls);
                seeker.setThumb(this.mResources.getDrawable(R.drawable.custom_progress_thumb));
                seeker.setThumbOffset(0);
                seeker.invalidate();
                this.mProgressBuffer.setVisibility(0);
                this.mBottomBar.setVisibility(0);
                if (timeViewParams.getRules()[0] == 0) break;
                timeViewParams.removeRule(0);
                timeViewParams.addRule(1, R.id.bottom_bar_left);
                break;
            }
            case 1: {
                this.mTitleBar.setVisibility(0);
                this.mBackButton.setVisibility(0);
                this.mTitleView.setPadding(0, this.mTitleView.getPaddingTop(), this.mTitleView.getPaddingRight(), this.mTitleView.getPaddingBottom());
                if (this.mOnFullScreenListener != null) {
                    this.mMinimalSizeFullScreenView.setVisibility(8);
                    this.mFullScreenButton = (ImageButton)this.mBasicControls.findViewById(R.id.fullscreen);
                    this.mFullScreenButton.setOnClickListener(this.mFullScreenListener);
                }
                this.mCenterView.removeAllViews();
                this.mBottomBarLeftView.removeView(this.mTransportControls);
                this.mTransportControls = this.inflateTransportControls(R.layout.full_transport_controls);
                this.mBottomBarLeftView.addView(this.mTransportControls, 0);
                this.mBottomBarLeftView.setVisibility(0);
                seeker.setThumb(this.mResources.getDrawable(R.drawable.custom_progress_thumb));
                seeker.setThumbOffset(0);
                seeker.invalidate();
                this.mProgressBuffer.setVisibility(0);
                this.mBottomBar.setVisibility(0);
                if (timeViewParams.getRules()[1] == 0) break;
                timeViewParams.removeRule(1);
                timeViewParams.addRule(0, R.id.basic_controls);
                break;
            }
            case 2: {
                this.mTitleBar.setVisibility(8);
                this.mBackButton.setVisibility(8);
                if (this.mOnFullScreenListener != null) {
                    this.mMinimalSizeFullScreenView.setVisibility(0);
                    this.mFullScreenButton = (ImageButton)this.mMinimalSizeFullScreenView.findViewById(R.id.minimal_fullscreen);
                    this.mFullScreenButton.setOnClickListener(this.mFullScreenListener);
                }
                this.mCenterView.removeAllViews();
                this.mBottomBarLeftView.removeView(this.mTransportControls);
                this.mTransportControls = this.inflateTransportControls(R.layout.minimal_transport_controls);
                this.mCenterView.addView(this.mTransportControls);
                seeker.setThumb(null);
                this.mProgressBuffer.setVisibility(8);
                this.mBottomBar.setVisibility(8);
            }
        }
        this.mTimeView.setLayoutParams((ViewGroup.LayoutParams)timeViewParams);
        this.updateForStoppedState(this.mIsStopped);
        if (this.mIsFullScreen) {
            this.mFullScreenButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_fullscreen_exit));
        } else {
            this.mFullScreenButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_fullscreen));
        }
    }

    private View inflateTransportControls(int layoutId) {
        View v = MediaControlView.inflateLayout(this.getContext(), layoutId);
        this.mPlayPauseButton = (ImageButton)v.findViewById(R.id.pause);
        if (this.mPlayPauseButton != null) {
            this.mPlayPauseButton.requestFocus();
            this.mPlayPauseButton.setOnClickListener(this.mPlayPauseListener);
        }
        this.mFfwdButton = (ImageButton)v.findViewById(R.id.ffwd);
        if (this.mFfwdButton != null) {
            if (this.mMediaType == 1) {
                this.mFfwdButton.setVisibility(8);
            } else {
                this.mFfwdButton.setOnClickListener(this.mFfwdListener);
            }
        }
        this.mRewButton = (ImageButton)v.findViewById(R.id.rew);
        if (this.mRewButton != null) {
            if (this.mMediaType == 1) {
                this.mRewButton.setVisibility(8);
            } else {
                this.mRewButton.setOnClickListener(this.mRewListener);
            }
        }
        this.mNextButton = (ImageButton)v.findViewById(R.id.next);
        if (this.mNextButton != null) {
            if (this.mController.canSkipToNext()) {
                this.mNextButton.setOnClickListener(this.mNextListener);
            } else {
                this.mNextButton.setVisibility(8);
            }
        }
        this.mPrevButton = (ImageButton)v.findViewById(R.id.prev);
        if (this.mPrevButton != null) {
            if (this.mController.canSkipToPrevious()) {
                this.mPrevButton.setOnClickListener(this.mPrevListener);
            } else {
                this.mPrevButton.setVisibility(8);
            }
        }
        return v;
    }

    private void initializeSettingsLists() {
        this.mSettingsMainTextsList = new ArrayList<String>();
        this.mSettingsMainTextsList.add(this.mResources.getString(R.string.MediaControlView_audio_track_text));
        this.mSettingsMainTextsList.add(this.mResources.getString(R.string.MediaControlView_playback_speed_text));
        this.mSettingsSubTextsList = new ArrayList<String>();
        this.mSettingsSubTextsList.add(this.mResources.getString(R.string.MediaControlView_audio_track_none_text));
        String normalSpeed = this.mResources.getString(R.string.MediaControlView_playback_speed_normal);
        this.mSettingsSubTextsList.add(normalSpeed);
        this.mSettingsSubTextsList.add(RESOURCE_EMPTY);
        this.mSettingsIconIdsList = new ArrayList<Integer>();
        this.mSettingsIconIdsList.add(R.drawable.ic_audiotrack);
        this.mSettingsIconIdsList.add(R.drawable.ic_play_circle_filled);
        this.mAudioTrackList = new ArrayList<String>();
        this.mAudioTrackList.add(this.mResources.getString(R.string.MediaControlView_audio_track_none_text));
        this.mVideoQualityList = new ArrayList<String>();
        this.mVideoQualityList.add(this.mResources.getString(R.string.MediaControlView_video_quality_auto_text));
        this.mPlaybackSpeedTextList = new ArrayList<String>(Arrays.asList(this.mResources.getStringArray(R.array.MediaControlView_playback_speeds)));
        this.mPlaybackSpeedTextList.add(3, normalSpeed);
        this.mSelectedSpeedIndex = 3;
        this.mPlaybackSpeedMultBy100List = new ArrayList<Integer>();
        int[] speeds = this.mResources.getIntArray(R.array.speed_multiplied_by_100);
        for (int i = 0; i < speeds.length; ++i) {
            this.mPlaybackSpeedMultBy100List.add(speeds[i]);
        }
        this.mCustomPlaybackSpeedIndex = -1;
    }

    @VisibleForTesting
    boolean isCurrentMediaItemFromNetwork() {
        MediaItem currentMediaItem = this.mController.getCurrentMediaItem();
        if (!(currentMediaItem instanceof UriMediaItem)) {
            return false;
        }
        Uri uri = ((UriMediaItem)currentMediaItem).getUri();
        return UriUtil.isFromNetwork(uri);
    }

    void displaySettingsWindow(BaseAdapter adapter) {
        this.mSettingsListView.setAdapter((ListAdapter)adapter);
        int itemWidth = this.mSizeType == 0 ? this.mEmbeddedSettingsItemWidth : this.mFullSettingsItemWidth;
        this.mSettingsWindow.setWidth(itemWidth);
        int maxHeight = this.getMeasuredHeight() + this.mSettingsWindowMargin * 2;
        int totalHeight = adapter.getCount() * this.mSettingsItemHeight;
        int height = totalHeight < maxHeight ? totalHeight : maxHeight;
        this.mSettingsWindow.setHeight(height);
        this.mNeedToHideBars = false;
        this.mSettingsWindow.dismiss();
        this.mSettingsWindow.showAsDropDown((View)this, this.mSettingsWindowMargin, this.mSettingsWindowMargin - height, 85);
        this.mNeedToHideBars = true;
    }

    void dismissSettingsWindow() {
        this.mNeedToHideBars = true;
        this.mSettingsWindow.dismiss();
    }

    void animateOverflow(ValueAnimator animation) {
        RelativeLayout.LayoutParams extraControlsParams = (RelativeLayout.LayoutParams)this.mExtraControls.getLayoutParams();
        int iconWidth = this.mResources.getDimensionPixelSize(R.dimen.mcv2_icon_size);
        int extraControlMargin = -2 * iconWidth + (int)((float)(3 * iconWidth) * ((Float)animation.getAnimatedValue()).floatValue());
        extraControlsParams.setMargins(0, 0, extraControlMargin, 0);
        this.mExtraControls.setLayoutParams((ViewGroup.LayoutParams)extraControlsParams);
        this.mTimeView.setAlpha(1.0f - ((Float)animation.getAnimatedValue()).floatValue());
        this.mBasicControls.setAlpha(1.0f - ((Float)animation.getAnimatedValue()).floatValue());
        if (this.mSizeType == 1 && this.mMediaType == 0) {
            int transportControlMargin = -1 * (int)((float)iconWidth * ((Float)animation.getAnimatedValue()).floatValue());
            LinearLayout.LayoutParams transportControlsParams = (LinearLayout.LayoutParams)this.mTransportControls.getLayoutParams();
            transportControlsParams.setMargins(transportControlMargin, 0, 0, 0);
            this.mTransportControls.setLayoutParams((ViewGroup.LayoutParams)transportControlsParams);
            this.mFfwdButton.setAlpha(1.0f - ((Float)animation.getAnimatedValue()).floatValue());
        }
    }

    void resetHideCallbacks() {
        this.removeCallbacks(this.mHideMainBars);
        this.removeCallbacks(this.mHideProgressBar);
        this.postDelayed(this.mHideMainBars, this.mShowControllerIntervalMs);
    }

    void updateAllowedCommands(SessionCommandGroup commands) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("updateAllowedCommands(): commands: " + commands));
        }
        if (this.mController.getAllowedCommands() == commands) {
            return;
        }
        this.mController.setAllowedCommands(commands);
        if (commands.hasCommand(10001)) {
            this.mPlayPauseButton.setVisibility(0);
            this.mPlayPauseButton.setEnabled(true);
        } else {
            this.mPlayPauseButton.setVisibility(8);
        }
        if (commands.hasCommand(40001) && this.mMediaType != 1) {
            if (this.mRewButton != null) {
                this.mRewButton.setVisibility(0);
                this.mRewButton.setEnabled(true);
            }
        } else if (this.mRewButton != null) {
            this.mRewButton.setVisibility(8);
        }
        if (commands.hasCommand(40000) && this.mMediaType != 1) {
            if (this.mFfwdButton != null) {
                this.mFfwdButton.setVisibility(0);
                this.mFfwdButton.setEnabled(true);
            }
        } else if (this.mFfwdButton != null) {
            this.mFfwdButton.setVisibility(8);
        }
        if (commands.hasCommand(10008)) {
            if (this.mPrevButton != null) {
                this.mPrevButton.setVisibility(0);
                this.mPrevButton.setEnabled(true);
            }
        } else if (this.mPrevButton != null) {
            this.mPrevButton.setVisibility(8);
        }
        if (commands.hasCommand(10009)) {
            if (this.mNextButton != null) {
                this.mNextButton.setVisibility(0);
                this.mNextButton.setEnabled(true);
            }
        } else if (this.mNextButton != null) {
            this.mNextButton.setVisibility(8);
        }
        if (commands.hasCommand(10003)) {
            this.mSeekAvailable = true;
            this.mProgress.setEnabled(true);
        }
        if (commands.hasCommand(new SessionCommand(COMMAND_SHOW_SUBTITLE, null)) && commands.hasCommand(new SessionCommand(COMMAND_HIDE_SUBTITLE, null))) {
            this.mSubtitleButton.setVisibility(0);
        } else {
            this.mSubtitleButton.setVisibility(8);
        }
    }

    private int retrieveOrientation() {
        DisplayMetrics dm = Resources.getSystem().getDisplayMetrics();
        int height = dm.heightPixels;
        int width = dm.widthPixels;
        return height > width ? 1 : 0;
    }

    boolean shouldNotHideBars() {
        return this.mMediaType == 1 && this.mSizeType == 1 || this.mAccessibilityManager.isTouchExplorationEnabled() || this.mController.getPlaybackState() == 3 || this.mController.getPlaybackState() == 0;
    }

    void seekTo(long newPosition, boolean shouldSeekNow) {
        int positionOnProgressBar = this.mDuration <= 0L ? 0 : (int)(1000L * newPosition / this.mDuration);
        this.mProgress.setProgress(positionOnProgressBar);
        this.mCurrentTime.setText((CharSequence)this.stringForTime(newPosition));
        if (this.mCurrentSeekPosition == -1L) {
            this.mCurrentSeekPosition = newPosition;
            if (shouldSeekNow) {
                this.mController.seekTo(this.mCurrentSeekPosition);
            }
        } else {
            this.mNextSeekPosition = newPosition;
        }
    }

    private void showAllBars() {
        if (this.mUxState != 0) {
            this.removeCallbacks(this.mHideMainBars);
            this.removeCallbacks(this.mHideProgressBar);
            this.post(this.mShowMainBars);
        } else {
            this.resetHideCallbacks();
        }
    }

    private void hideSettingsAndOverflow() {
        this.mSettingsWindow.dismiss();
        if (this.mOverflowIsShowing) {
            this.mOverflowHideAnimator.start();
        }
    }

    long getLatestSeekPosition() {
        if (this.mNextSeekPosition != -1L) {
            return this.mNextSeekPosition;
        }
        if (this.mCurrentSeekPosition != -1L) {
            return this.mCurrentSeekPosition;
        }
        return this.mController.getCurrentPosition();
    }

    void removeCustomSpeedFromList() {
        this.mPlaybackSpeedMultBy100List.remove(this.mCustomPlaybackSpeedIndex);
        this.mPlaybackSpeedTextList.remove(this.mCustomPlaybackSpeedIndex);
        this.mCustomPlaybackSpeedIndex = -1;
    }

    void updateSelectedSpeed(int selectedSpeedIndex, String selectedSpeedText) {
        this.mSelectedSpeedIndex = selectedSpeedIndex;
        this.mSettingsSubTextsList.set(1, selectedSpeedText);
        this.mSubSettingsAdapter.setTexts(this.mPlaybackSpeedTextList);
        this.mSubSettingsAdapter.setCheckPosition(this.mSelectedSpeedIndex);
    }

    void updateForStoppedState(boolean isStopped) {
        if (isStopped) {
            this.mIsStopped = true;
            if (this.mPlayPauseButton != null) {
                this.mPlayPauseButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_replay_circle_filled));
                this.mPlayPauseButton.setContentDescription((CharSequence)this.mResources.getString(R.string.mcv2_replay_button_desc));
            }
            if (this.mFfwdButton != null) {
                this.mFfwdButton.setAlpha(0.5f);
                this.mFfwdButton.setEnabled(false);
            }
        } else {
            this.mIsStopped = false;
            if (this.mPlayPauseButton != null) {
                if (this.mController.isPlaying()) {
                    this.mPlayPauseButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_pause_circle_filled));
                    this.mPlayPauseButton.setContentDescription((CharSequence)this.mResources.getString(R.string.mcv2_pause_button_desc));
                } else {
                    this.mPlayPauseButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_play_circle_filled));
                    this.mPlayPauseButton.setContentDescription((CharSequence)this.mResources.getString(R.string.mcv2_play_button_desc));
                }
            }
            if (this.mFfwdButton != null) {
                this.mFfwdButton.setAlpha(1.0f);
                this.mFfwdButton.setEnabled(true);
            }
        }
    }

    class Controller {
        private MediaController mController;
        int mPlaybackState = 0;
        int mPrevState = 0;
        MediaMetadata mMediaMetadata;
        private Executor mCallbackExecutor;
        SessionCommandGroup mAllowedCommands;

        Controller() {
            this.mCallbackExecutor = ContextCompat.getMainExecutor((Context)MediaControlView.this.getContext());
        }

        void setSessionToken(SessionToken token) {
            if (this.mController != null) {
                this.mController.close();
            }
            this.mController = new MediaController(MediaControlView.this.getContext(), token, this.mCallbackExecutor, (MediaController.ControllerCallback)new MediaControllerCallback());
            this.mPlaybackState = this.mController.getPlayerState();
            MediaItem currentItem = this.mController.getCurrentMediaItem();
            this.mMediaMetadata = currentItem != null ? currentItem.getMetadata() : null;
        }

        boolean hasMetadata() {
            return this.mMediaMetadata != null;
        }

        boolean isPlaying() {
            return this.mPlaybackState == 2;
        }

        long getCurrentPosition() {
            if (this.mController != null) {
                long currentPosition = this.mController.getCurrentPosition();
                return currentPosition < 0L ? 0L : currentPosition;
            }
            return 0L;
        }

        long getBufferPercentage() {
            if (this.mController != null && MediaControlView.this.mDuration != 0L) {
                long bufferedPos = this.mController.getBufferedPosition();
                return bufferedPos < 0L ? -1L : bufferedPos * 100L / MediaControlView.this.mDuration;
            }
            return 0L;
        }

        int getPlaybackState() {
            if (this.mController != null) {
                return this.mController.getPlayerState();
            }
            return 0;
        }

        boolean canPause() {
            return this.mAllowedCommands != null && this.mAllowedCommands.hasCommand(10001);
        }

        boolean canSeekBackward() {
            return this.mAllowedCommands != null && this.mAllowedCommands.hasCommand(40001);
        }

        boolean canSeekForward() {
            return this.mAllowedCommands != null && this.mAllowedCommands.hasCommand(40000);
        }

        boolean canSkipToNext() {
            return this.mAllowedCommands != null && this.mAllowedCommands.hasCommand(10009);
        }

        boolean canSkipToPrevious() {
            return this.mAllowedCommands != null && this.mAllowedCommands.hasCommand(10008);
        }

        void pause() {
            if (this.mController != null) {
                this.mController.pause();
            }
        }

        void play() {
            if (this.mController != null) {
                this.mController.play();
            }
        }

        void seekTo(long posMs) {
            if (this.mController != null) {
                this.mController.seekTo(posMs);
            }
        }

        void skipToNextItem() {
            if (this.mController != null) {
                this.mController.skipToNextPlaylistItem();
            }
        }

        void skipToPreviousItem() {
            if (this.mController != null) {
                this.mController.skipToPreviousPlaylistItem();
            }
        }

        void setSpeed(float speed) {
            if (this.mController != null) {
                this.mController.setPlaybackSpeed(speed);
            }
        }

        void selectAudioTrack(int trackIndex) {
            if (this.mController != null) {
                Bundle extra = new Bundle();
                extra.putInt(MediaControlView.KEY_SELECTED_AUDIO_INDEX, trackIndex);
                this.mController.sendCustomCommand(new SessionCommand(MediaControlView.COMMAND_SELECT_AUDIO_TRACK, null), extra);
            }
        }

        void showSubtitle(int trackIndex) {
            if (this.mController != null) {
                Bundle extra = new Bundle();
                extra.putInt(MediaControlView.KEY_SELECTED_SUBTITLE_INDEX, trackIndex);
                this.mController.sendCustomCommand(new SessionCommand(MediaControlView.COMMAND_SHOW_SUBTITLE, null), extra);
            }
        }

        void hideSubtitle() {
            if (this.mController != null) {
                this.mController.sendCustomCommand(new SessionCommand(MediaControlView.COMMAND_HIDE_SUBTITLE, null), null);
            }
        }

        long getDurationMs() {
            if (this.mMediaMetadata != null && this.mMediaMetadata.containsKey("android.media.metadata.DURATION")) {
                return this.mMediaMetadata.getLong("android.media.metadata.DURATION");
            }
            if (this.mController != null) {
                return this.mController.getDuration();
            }
            return 0L;
        }

        CharSequence getTitle() {
            if (this.mMediaMetadata != null && this.mMediaMetadata.containsKey("android.media.metadata.TITLE")) {
                return this.mMediaMetadata.getText("android.media.metadata.TITLE");
            }
            return null;
        }

        CharSequence getArtistText() {
            if (this.mMediaMetadata != null && this.mMediaMetadata.containsKey("android.media.metadata.ARTIST")) {
                return this.mMediaMetadata.getText("android.media.metadata.ARTIST");
            }
            return null;
        }

        MediaItem getCurrentMediaItem() {
            if (this.mController != null) {
                return this.mController.getCurrentMediaItem();
            }
            return null;
        }

        void setAllowedCommands(SessionCommandGroup commands) {
            this.mAllowedCommands = commands;
        }

        SessionCommandGroup getAllowedCommands() {
            return this.mAllowedCommands;
        }

        class MediaControllerCallback
        extends MediaController.ControllerCallback {
            MediaControllerCallback() {
            }

            public void onPlayerStateChanged(@NonNull MediaController controller, int state) {
                if (DEBUG) {
                    Log.d((String)MediaControlView.TAG, (String)("onPlayerStateChanged(state: " + state + ")"));
                }
                Controller.this.mPlaybackState = state;
                if (Controller.this.mPlaybackState != Controller.this.mPrevState) {
                    switch (Controller.this.mPlaybackState) {
                        case 2: {
                            MediaControlView.this.removeCallbacks(MediaControlView.this.mUpdateProgress);
                            MediaControlView.this.post(MediaControlView.this.mUpdateProgress);
                            MediaControlView.this.resetHideCallbacks();
                            MediaControlView.this.updateForStoppedState(false);
                            break;
                        }
                        case 1: {
                            MediaControlView.this.mPlayPauseButton.setImageDrawable(MediaControlView.this.mResources.getDrawable(R.drawable.ic_play_circle_filled));
                            MediaControlView.this.mPlayPauseButton.setContentDescription((CharSequence)MediaControlView.this.mResources.getString(R.string.mcv2_play_button_desc));
                            MediaControlView.this.removeCallbacks(MediaControlView.this.mUpdateProgress);
                            break;
                        }
                        case 3: {
                            MediaControlView.this.setEnabled(false);
                            MediaControlView.this.mPlayPauseButton.setImageDrawable(MediaControlView.this.mResources.getDrawable(R.drawable.ic_play_circle_filled));
                            MediaControlView.this.mPlayPauseButton.setContentDescription((CharSequence)MediaControlView.this.mResources.getString(R.string.mcv2_play_button_desc));
                            MediaControlView.this.removeCallbacks(MediaControlView.this.mUpdateProgress);
                            if (MediaControlView.this.getWindowToken() == null) break;
                            new AlertDialog.Builder(MediaControlView.this.getContext()).setMessage(R.string.mcv2_playback_error_text).setPositiveButton(R.string.mcv2_error_dialog_button, new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialogInterface, int i) {
                                    dialogInterface.dismiss();
                                }
                            }).setCancelable(true).show();
                        }
                    }
                    Controller.this.mPrevState = Controller.this.mPlaybackState;
                }
            }

            public void onSeekCompleted(MediaController controller, long position) {
                if (DEBUG) {
                    Log.d((String)MediaControlView.TAG, (String)("onSeekCompleted(): " + position));
                }
                int positionOnProgressBar = MediaControlView.this.mDuration <= 0L ? 0 : (int)(1000L * position / MediaControlView.this.mDuration);
                MediaControlView.this.mProgress.setProgress(positionOnProgressBar);
                MediaControlView.this.mCurrentTime.setText((CharSequence)MediaControlView.this.stringForTime(position));
                if (MediaControlView.this.mNextSeekPosition != -1L) {
                    MediaControlView.this.mCurrentSeekPosition = MediaControlView.this.mNextSeekPosition;
                    MediaControlView.this.mController.seekTo(MediaControlView.this.mNextSeekPosition);
                    MediaControlView.this.mNextSeekPosition = -1L;
                } else {
                    MediaControlView.this.mCurrentSeekPosition = -1L;
                    MediaControlView.this.removeCallbacks(MediaControlView.this.mUpdateProgress);
                    MediaControlView.this.removeCallbacks(MediaControlView.this.mHideMainBars);
                    MediaControlView.this.post(MediaControlView.this.mUpdateProgress);
                    MediaControlView.this.postDelayed(MediaControlView.this.mHideMainBars, MediaControlView.this.mShowControllerIntervalMs);
                }
            }

            public void onCurrentMediaItemChanged(@NonNull MediaController controller, @Nullable MediaItem mediaItem) {
                if (DEBUG) {
                    Log.d((String)MediaControlView.TAG, (String)("onCurrentMediaItemChanged(): " + mediaItem));
                }
                if (mediaItem != null) {
                    Controller.this.mMediaMetadata = mediaItem.getMetadata();
                    MediaControlView.this.updateMetadata();
                }
            }

            public void onPlaybackCompleted(MediaController controller) {
                if (DEBUG) {
                    Log.d((String)MediaControlView.TAG, (String)"onPlaybackCompleted()");
                }
                MediaControlView.this.updateForStoppedState(true);
                MediaControlView.this.mProgress.setProgress(1000);
                MediaControlView.this.mCurrentTime.setText((CharSequence)MediaControlView.this.stringForTime(MediaControlView.this.mDuration));
            }

            public void onConnected(@NonNull MediaController controller, @NonNull SessionCommandGroup allowedCommands) {
                if (DEBUG) {
                    Log.d((String)MediaControlView.TAG, (String)("onConnected(): " + allowedCommands));
                }
                MediaControlView.this.updateAllowedCommands(allowedCommands);
                MediaItem mediaItem = controller.getCurrentMediaItem();
                if (mediaItem != null) {
                    Controller.this.mMediaMetadata = mediaItem.getMetadata();
                    MediaControlView.this.updateMetadata();
                }
            }

            public void onAllowedCommandsChanged(@NonNull MediaController controller, @NonNull SessionCommandGroup commands) {
                MediaControlView.this.updateAllowedCommands(commands);
            }

            public void onPlaylistChanged(@NonNull MediaController controller, @NonNull List<MediaItem> list, @Nullable MediaMetadata metadata) {
                if (DEBUG) {
                    Log.d((String)MediaControlView.TAG, (String)("onPlaylistChanged(): list: " + list));
                }
            }

            public void onPlaybackSpeedChanged(@NonNull MediaController controller, float speed) {
                int customSpeedMultBy100 = Math.round(speed * 100.0f);
                if (MediaControlView.this.mCustomPlaybackSpeedIndex != -1) {
                    MediaControlView.this.removeCustomSpeedFromList();
                }
                if (MediaControlView.this.mPlaybackSpeedMultBy100List.contains(customSpeedMultBy100)) {
                    for (int i = 0; i < MediaControlView.this.mPlaybackSpeedMultBy100List.size(); ++i) {
                        if (customSpeedMultBy100 != MediaControlView.this.mPlaybackSpeedMultBy100List.get(i)) continue;
                        MediaControlView.this.updateSelectedSpeed(i, MediaControlView.this.mPlaybackSpeedTextList.get(i));
                        break;
                    }
                } else {
                    String customSpeedText = MediaControlView.this.mResources.getString(R.string.MediaControlView_custom_playback_speed_text, new Object[]{Float.valueOf((float)customSpeedMultBy100 / 100.0f)});
                    for (int i = 0; i < MediaControlView.this.mPlaybackSpeedMultBy100List.size(); ++i) {
                        if (customSpeedMultBy100 < MediaControlView.this.mPlaybackSpeedMultBy100List.get(i)) {
                            MediaControlView.this.mPlaybackSpeedMultBy100List.add(i, customSpeedMultBy100);
                            MediaControlView.this.mPlaybackSpeedTextList.add(i, customSpeedText);
                            MediaControlView.this.updateSelectedSpeed(i, customSpeedText);
                            break;
                        }
                        if (i != MediaControlView.this.mPlaybackSpeedMultBy100List.size() - 1 || customSpeedMultBy100 <= MediaControlView.this.mPlaybackSpeedMultBy100List.get(i)) continue;
                        MediaControlView.this.mPlaybackSpeedMultBy100List.add(customSpeedMultBy100);
                        MediaControlView.this.mPlaybackSpeedTextList.add(customSpeedText);
                        MediaControlView.this.updateSelectedSpeed(i + 1, customSpeedText);
                    }
                    MediaControlView.this.mCustomPlaybackSpeedIndex = MediaControlView.this.mSelectedSpeedIndex;
                }
            }

            public MediaController.ControllerResult onCustomCommand(@NonNull MediaController controller, @NonNull SessionCommand command, @Nullable Bundle args) {
                if (DEBUG) {
                    Log.d((String)MediaControlView.TAG, (String)("onCustomCommand(): command: " + command));
                }
                switch (command.getCustomCommand()) {
                    case "UpdateTrackStatus": {
                        MediaControlView.this.mVideoTrackCount = args != null ? args.getInt(MediaControlView.KEY_VIDEO_TRACK_COUNT) : 0;
                        MediaControlView.this.mAudioTrackCount = args != null ? args.getInt(MediaControlView.KEY_AUDIO_TRACK_COUNT) : 0;
                        MediaControlView.this.mAudioTrackList = new ArrayList<String>();
                        if (MediaControlView.this.mAudioTrackCount > 0) {
                            for (int i = 0; i < MediaControlView.this.mAudioTrackCount; ++i) {
                                String track = MediaControlView.this.mResources.getString(R.string.MediaControlView_audio_track_number_text, new Object[]{i + 1});
                                MediaControlView.this.mAudioTrackList.add(track);
                            }
                            MediaControlView.this.mSettingsSubTextsList.set(0, MediaControlView.this.mAudioTrackList.get(0));
                        } else {
                            MediaControlView.this.mAudioTrackList.add(MediaControlView.this.mResources.getString(R.string.MediaControlView_audio_track_none_text));
                        }
                        if (MediaControlView.this.mVideoTrackCount == 0 && MediaControlView.this.mAudioTrackCount > 0) {
                            MediaControlView.this.mMediaType = 1;
                        }
                        MediaControlView.this.mSubtitleTrackCount = args != null ? args.getInt(MediaControlView.KEY_SUBTITLE_TRACK_COUNT) : 0;
                        ArrayList subtitleTracksLanguageList = args != null ? args.getStringArrayList(MediaControlView.KEY_SUBTITLE_TRACK_LANGUAGE_LIST) : null;
                        MediaControlView.this.mSubtitleDescriptionsList = new ArrayList<String>();
                        if (MediaControlView.this.mSubtitleTrackCount > 0) {
                            MediaControlView.this.mSubtitleButton.setAlpha(1.0f);
                            MediaControlView.this.mSubtitleButton.setEnabled(true);
                            MediaControlView.this.mSubtitleDescriptionsList.add(MediaControlView.this.mResources.getString(R.string.MediaControlView_subtitle_off_text));
                            for (int i = 0; i < MediaControlView.this.mSubtitleTrackCount; ++i) {
                                String lang = (String)subtitleTracksLanguageList.get(i);
                                String track = lang.equals(MediaControlView.RESOURCE_EMPTY) ? MediaControlView.this.mResources.getString(R.string.MediaControlView_subtitle_track_number_text, new Object[]{i + 1}) : MediaControlView.this.mResources.getString(R.string.MediaControlView_subtitle_track_number_and_lang_text, new Object[]{i + 1, lang});
                                MediaControlView.this.mSubtitleDescriptionsList.add(track);
                            }
                            break;
                        }
                        if (MediaControlView.this.mMediaType == 1) {
                            MediaControlView.this.mSubtitleButton.setVisibility(8);
                            break;
                        }
                        MediaControlView.this.mSubtitleButton.setAlpha(0.5f);
                        MediaControlView.this.mSubtitleButton.setEnabled(false);
                        break;
                    }
                    case "UpdateMediaTypeStatus": {
                        boolean isAd;
                        boolean bl = isAd = args != null && args.getBoolean(MediaControlView.KEY_STATE_IS_ADVERTISEMENT);
                        if (isAd == MediaControlView.this.mIsAdvertisement) break;
                        MediaControlView.this.mIsAdvertisement = isAd;
                        MediaControlView.this.updateLayoutForAd();
                        break;
                    }
                    case "UpdateSubtitleSelected": {
                        int selectedTrackIndex;
                        int n = selectedTrackIndex = args != null ? args.getInt(MediaControlView.KEY_SELECTED_SUBTITLE_INDEX, -1) : -1;
                        if (selectedTrackIndex < 0 || selectedTrackIndex >= MediaControlView.this.mSubtitleTrackCount) {
                            Log.w((String)MediaControlView.TAG, (String)("Selected subtitle track index (" + selectedTrackIndex + ") is out of range."));
                            break;
                        }
                        MediaControlView.this.mSelectedSubtitleTrackIndex = selectedTrackIndex + 1;
                        if (MediaControlView.this.mSettingsMode != 2) break;
                        MediaControlView.this.mSubSettingsAdapter.setCheckPosition(MediaControlView.this.mSelectedSubtitleTrackIndex);
                        break;
                    }
                    case "UpdateSubtitleDeselected": {
                        MediaControlView.this.mSelectedSubtitleTrackIndex = 0;
                        if (MediaControlView.this.mSettingsMode != 2) break;
                        MediaControlView.this.mSubSettingsAdapter.setCheckPosition(MediaControlView.this.mSelectedSubtitleTrackIndex);
                        break;
                    }
                    default: {
                        return new MediaController.ControllerResult(-6, null);
                    }
                }
                return new MediaController.ControllerResult(0, null);
            }
        }
    }

    private class SubSettingsAdapter
    extends BaseAdapter {
        private List<String> mTexts;
        private int mCheckPosition;

        SubSettingsAdapter(List<String> texts, int checkPosition) {
            this.mTexts = texts;
            this.mCheckPosition = checkPosition;
        }

        public String getMainText(int position) {
            if (this.mTexts != null && position < this.mTexts.size()) {
                return this.mTexts.get(position);
            }
            return MediaControlView.RESOURCE_EMPTY;
        }

        public int getCount() {
            return this.mTexts == null ? 0 : this.mTexts.size();
        }

        public long getItemId(int position) {
            return 0L;
        }

        public Object getItem(int position) {
            return null;
        }

        public View getView(int position, View convertView, ViewGroup container) {
            View row = MediaControlView.this.mSizeType == 1 ? MediaControlView.inflateLayout(MediaControlView.this.getContext(), R.layout.full_sub_settings_list_item) : MediaControlView.inflateLayout(MediaControlView.this.getContext(), R.layout.embedded_sub_settings_list_item);
            TextView textView = (TextView)row.findViewById(R.id.text);
            ImageView checkView = (ImageView)row.findViewById(R.id.check);
            textView.setText((CharSequence)this.mTexts.get(position));
            if (position != this.mCheckPosition) {
                checkView.setVisibility(4);
            }
            return row;
        }

        public void setTexts(List<String> texts) {
            this.mTexts = texts;
        }

        public void setCheckPosition(int checkPosition) {
            this.mCheckPosition = checkPosition;
        }
    }

    private class SettingsAdapter
    extends BaseAdapter {
        private List<Integer> mIconIds;
        private List<String> mMainTexts;
        private List<String> mSubTexts;

        SettingsAdapter(@Nullable List<String> mainTexts, @Nullable List<String> subTexts, List<Integer> iconIds) {
            this.mMainTexts = mainTexts;
            this.mSubTexts = subTexts;
            this.mIconIds = iconIds;
        }

        public void updateSubTexts(List<String> subTexts) {
            this.mSubTexts = subTexts;
            this.notifyDataSetChanged();
        }

        public String getMainText(int position) {
            if (this.mMainTexts != null && position < this.mMainTexts.size()) {
                return this.mMainTexts.get(position);
            }
            return MediaControlView.RESOURCE_EMPTY;
        }

        public int getCount() {
            return this.mMainTexts == null ? 0 : this.mMainTexts.size();
        }

        public long getItemId(int position) {
            return 0L;
        }

        public Object getItem(int position) {
            return null;
        }

        public View getView(int position, View convertView, ViewGroup container) {
            View row = MediaControlView.this.mSizeType == 1 ? MediaControlView.inflateLayout(MediaControlView.this.getContext(), R.layout.full_settings_list_item) : MediaControlView.inflateLayout(MediaControlView.this.getContext(), R.layout.embedded_settings_list_item);
            TextView mainTextView = (TextView)row.findViewById(R.id.main_text);
            TextView subTextView = (TextView)row.findViewById(R.id.sub_text);
            ImageView iconView = (ImageView)row.findViewById(R.id.icon);
            mainTextView.setText((CharSequence)this.mMainTexts.get(position));
            if (this.mSubTexts == null || MediaControlView.RESOURCE_EMPTY.equals(this.mSubTexts.get(position))) {
                subTextView.setVisibility(8);
            } else {
                subTextView.setText((CharSequence)this.mSubTexts.get(position));
            }
            if (this.mIconIds == null || this.mIconIds.get(position) == -1) {
                iconView.setVisibility(8);
            } else {
                iconView.setImageDrawable(MediaControlView.this.mResources.getDrawable(this.mIconIds.get(position).intValue()));
            }
            return row;
        }

        public void setSubTexts(List<String> subTexts) {
            this.mSubTexts = subTexts;
        }
    }

    public static interface OnFullScreenListener {
        public void onFullScreen(@NonNull View var1, boolean var2);
    }
}

