/*
 * Decompiled with CFR 0.152.
 */
package androidx.media2.widget;

import android.content.Context;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.concurrent.futures.ResolvableFuture;
import androidx.core.util.Pair;
import androidx.media.AudioAttributesCompat;
import androidx.media2.MediaItem;
import androidx.media2.MediaMetadata;
import androidx.media2.RemoteSessionPlayer;
import androidx.media2.SessionPlayer;
import androidx.media2.UriMediaItem;
import androidx.mediarouter.media.MediaItemStatus;
import androidx.mediarouter.media.MediaRouteSelector;
import androidx.mediarouter.media.MediaRouter;
import androidx.mediarouter.media.MediaSessionStatus;
import androidx.mediarouter.media.RemotePlaybackClient;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=19)
public class RoutePlayer
extends RemoteSessionPlayer {
    private static final String TAG = "RoutePlayer";
    static final boolean DEBUG = Log.isLoggable((String)"RoutePlayer", (int)3);
    private static final int ITEM_NONE = -1;
    String mItemId;
    int mCurrentPlayerState;
    long mDuration;
    long mLastStatusChangedTime;
    long mPosition;
    boolean mCanResume;
    MediaRouter.RouteInfo mSelectedRoute;
    final List<ResolvableFuture<SessionPlayer.PlayerResult>> mPendingVolumeResult = new ArrayList<ResolvableFuture<SessionPlayer.PlayerResult>>();
    private MediaItem mItem;
    private MediaRouter mMediaRouter;
    private RemotePlaybackClient mClient;
    private MediaRouter.Callback mRouterCallback = new MediaRouter.Callback(){

        public void onRouteVolumeChanged(MediaRouter router, MediaRouter.RouteInfo route) {
            if (TextUtils.equals((CharSequence)route.getId(), (CharSequence)RoutePlayer.this.mSelectedRoute.getId())) {
                final int volume = route.getVolume();
                for (int i = 0; i < RoutePlayer.this.mPendingVolumeResult.size(); ++i) {
                    RoutePlayer.this.mPendingVolumeResult.get(i).set((Object)new SessionPlayer.PlayerResult(0, RoutePlayer.this.getCurrentMediaItem()));
                }
                RoutePlayer.this.mPendingVolumeResult.clear();
                List callbacks = RoutePlayer.this.getCallbacks();
                for (Pair pair : callbacks) {
                    if (!(pair.first instanceof RemoteSessionPlayer.Callback)) continue;
                    final SessionPlayer.PlayerCallback callback = (SessionPlayer.PlayerCallback)pair.first;
                    ((Executor)pair.second).execute(new Runnable(){

                        @Override
                        public void run() {
                            ((RemoteSessionPlayer.Callback)callback).onVolumeChanged((RemoteSessionPlayer)RoutePlayer.this, volume);
                        }
                    });
                }
            }
        }
    };
    private RemotePlaybackClient.StatusCallback mStatusCallback = new RemotePlaybackClient.StatusCallback(){

        public void onItemStatusChanged(Bundle data, String sessionId, MediaSessionStatus sessionStatus, String itemId, MediaItemStatus itemStatus) {
            if (DEBUG && !RoutePlayer.this.isSessionActive(sessionStatus)) {
                Log.v((String)RoutePlayer.TAG, (String)"onItemStatusChanged() is called, but session is not active.");
            }
            RoutePlayer.this.mLastStatusChangedTime = SystemClock.elapsedRealtime();
            RoutePlayer.this.mPosition = itemStatus.getContentPosition();
            RoutePlayer.this.mCurrentPlayerState = RoutePlayer.this.convertPlaybackStateToPlayerState(itemStatus.getPlaybackState());
            List callbacks = RoutePlayer.this.getCallbacks();
            for (Pair pair : callbacks) {
                final SessionPlayer.PlayerCallback callback = (SessionPlayer.PlayerCallback)pair.first;
                ((Executor)pair.second).execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onPlayerStateChanged((SessionPlayer)RoutePlayer.this, RoutePlayer.this.mCurrentPlayerState);
                    }
                });
            }
        }
    };

    public RoutePlayer(Context context, MediaRouteSelector selector, MediaRouter.RouteInfo route) {
        this.mMediaRouter = MediaRouter.getInstance((Context)context);
        this.mMediaRouter.addCallback(selector, this.mRouterCallback);
        this.mSelectedRoute = route;
        this.mClient = new RemotePlaybackClient(context, route);
        this.mClient.setStatusCallback(this.mStatusCallback);
        if (this.mClient.isSessionManagementSupported()) {
            this.mClient.startSession(null, new RemotePlaybackClient.SessionActionCallback(){

                public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus) {
                    if (DEBUG && !RoutePlayer.this.isSessionActive(sessionStatus)) {
                        Log.v((String)RoutePlayer.TAG, (String)"RoutePlayer has been initialized, but session is notactive.");
                    }
                }
            });
        }
    }

    public ListenableFuture<SessionPlayer.PlayerResult> play() {
        if (this.mItem == null) {
            return this.createResult(-3);
        }
        if (!this.mCanResume) {
            return this.playInternal();
        }
        if (this.mClient.isSessionManagementSupported()) {
            final ResolvableFuture result = ResolvableFuture.create();
            this.mClient.resume(null, new RemotePlaybackClient.SessionActionCallback(){

                public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus) {
                    if (DEBUG && !RoutePlayer.this.isSessionActive(sessionStatus)) {
                        Log.v((String)RoutePlayer.TAG, (String)"play() is called, but session is not active.");
                    }
                    result.set((Object)new SessionPlayer.PlayerResult(0, RoutePlayer.this.getCurrentMediaItem()));
                }
            });
        }
        return this.createResult(-2);
    }

    public ListenableFuture<SessionPlayer.PlayerResult> prepare() {
        return this.createResult();
    }

    public ListenableFuture<SessionPlayer.PlayerResult> pause() {
        if (this.mClient.isSessionManagementSupported()) {
            final ResolvableFuture result = ResolvableFuture.create();
            this.mClient.pause(null, new RemotePlaybackClient.SessionActionCallback(){

                public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus) {
                    if (DEBUG && !RoutePlayer.this.isSessionActive(sessionStatus)) {
                        Log.v((String)RoutePlayer.TAG, (String)"pause() is called, but session is not active.");
                    }
                    RoutePlayer.this.mCanResume = true;
                    result.set((Object)new SessionPlayer.PlayerResult(0, RoutePlayer.this.getCurrentMediaItem()));
                }
            });
        }
        return this.createResult(-2);
    }

    public ListenableFuture<SessionPlayer.PlayerResult> seekTo(long pos) {
        if (this.mClient.isSessionManagementSupported()) {
            final ResolvableFuture result = ResolvableFuture.create();
            this.mClient.seek(this.mItemId, pos, null, new RemotePlaybackClient.ItemActionCallback(){

                public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus, String itemId, final MediaItemStatus itemStatus) {
                    if (DEBUG && !RoutePlayer.this.isSessionActive(sessionStatus)) {
                        Log.v((String)RoutePlayer.TAG, (String)"seekTo(long) is called, but session is not active.");
                    }
                    if (itemStatus != null) {
                        List callbacks = RoutePlayer.this.getCallbacks();
                        for (Pair pair : callbacks) {
                            final SessionPlayer.PlayerCallback callback = (SessionPlayer.PlayerCallback)pair.first;
                            ((Executor)pair.second).execute(new Runnable(){

                                @Override
                                public void run() {
                                    callback.onSeekCompleted((SessionPlayer)RoutePlayer.this, itemStatus.getContentPosition());
                                }
                            });
                        }
                    } else {
                        result.set((Object)new SessionPlayer.PlayerResult(-1, RoutePlayer.this.getCurrentMediaItem()));
                    }
                }
            });
        }
        return this.createResult(-2);
    }

    public long getCurrentPosition() {
        long expectedPosition = this.mPosition;
        if (this.mCurrentPlayerState == 2) {
            expectedPosition = this.mPosition + (SystemClock.elapsedRealtime() - this.mLastStatusChangedTime);
        }
        return expectedPosition;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public long getBufferedPosition() {
        return 0L;
    }

    public int getPlayerState() {
        return this.mCurrentPlayerState;
    }

    public int getBufferingState() {
        return 0;
    }

    public ListenableFuture<SessionPlayer.PlayerResult> setAudioAttributes(AudioAttributesCompat attributes) {
        return this.createResult(-2);
    }

    public AudioAttributesCompat getAudioAttributes() {
        return null;
    }

    public ListenableFuture<SessionPlayer.PlayerResult> setMediaItem(MediaItem item) {
        this.mItem = item;
        return this.createResult();
    }

    public MediaItem getCurrentMediaItem() {
        return this.mItem;
    }

    public int getCurrentMediaItemIndex() {
        return -1;
    }

    public int getPreviousMediaItemIndex() {
        return -1;
    }

    public int getNextMediaItemIndex() {
        return -1;
    }

    public ListenableFuture<SessionPlayer.PlayerResult> setPlaybackSpeed(float speed) {
        return this.createResult(-2);
    }

    public float getPlaybackSpeed() {
        return 1.0f;
    }

    public int getVolume() {
        return this.mSelectedRoute.getVolume();
    }

    public Future<SessionPlayer.PlayerResult> adjustVolume(int direction) {
        this.mSelectedRoute.requestUpdateVolume(direction);
        ResolvableFuture result = ResolvableFuture.create();
        this.mPendingVolumeResult.add((ResolvableFuture<SessionPlayer.PlayerResult>)result);
        return result;
    }

    public Future<SessionPlayer.PlayerResult> setVolume(int volume) {
        this.mSelectedRoute.requestSetVolume(volume);
        ResolvableFuture result = ResolvableFuture.create();
        this.mPendingVolumeResult.add((ResolvableFuture<SessionPlayer.PlayerResult>)result);
        return result;
    }

    public int getMaxVolume() {
        return this.mSelectedRoute.getVolumeMax();
    }

    public int getVolumeControlType() {
        return this.mSelectedRoute.getVolumeHandling();
    }

    public ListenableFuture<SessionPlayer.PlayerResult> setPlaylist(List<MediaItem> list, MediaMetadata metadata) {
        return this.createResult(-2);
    }

    public ListenableFuture<SessionPlayer.PlayerResult> addPlaylistItem(int index, MediaItem item) {
        return this.createResult(-2);
    }

    public ListenableFuture<SessionPlayer.PlayerResult> removePlaylistItem(int index) {
        return this.createResult(-2);
    }

    public ListenableFuture<SessionPlayer.PlayerResult> replacePlaylistItem(int index, MediaItem item) {
        return this.createResult(-2);
    }

    public ListenableFuture<SessionPlayer.PlayerResult> skipToPreviousPlaylistItem() {
        return this.createResult(-2);
    }

    public ListenableFuture<SessionPlayer.PlayerResult> skipToNextPlaylistItem() {
        return this.createResult(-2);
    }

    public ListenableFuture<SessionPlayer.PlayerResult> skipToPlaylistItem(int index) {
        return this.createResult(-2);
    }

    public ListenableFuture<SessionPlayer.PlayerResult> updatePlaylistMetadata(MediaMetadata metadata) {
        return this.createResult(-2);
    }

    public ListenableFuture<SessionPlayer.PlayerResult> setRepeatMode(int repeatMode) {
        return this.createResult(-2);
    }

    public ListenableFuture<SessionPlayer.PlayerResult> setShuffleMode(int shuffleMode) {
        return this.createResult(-2);
    }

    public List<MediaItem> getPlaylist() {
        ArrayList<MediaItem> list = new ArrayList<MediaItem>();
        list.add(this.mItem);
        return list;
    }

    public MediaMetadata getPlaylistMetadata() {
        return null;
    }

    public int getRepeatMode() {
        return 0;
    }

    public int getShuffleMode() {
        return 0;
    }

    public void close() {
        if (this.mClient != null) {
            try {
                this.mClient.release();
            }
            catch (IllegalArgumentException e) {
                Log.d((String)TAG, (String)"Receiver not registered");
            }
            this.mClient = null;
        }
        this.mMediaRouter.removeCallback(this.mRouterCallback);
    }

    void setCurrentPosition(long position) {
        this.mPosition = position;
    }

    boolean isSessionActive(MediaSessionStatus status) {
        return status != null && status.getSessionState() != 1 && status.getSessionState() != 2;
    }

    int convertPlaybackStateToPlayerState(int playbackState) {
        int playerState = 0;
        switch (playbackState) {
            case 0: 
            case 4: 
            case 5: {
                playerState = 0;
                break;
            }
            case 1: {
                playerState = 2;
                break;
            }
            case 2: 
            case 3: {
                playerState = 1;
                break;
            }
            case 6: 
            case 7: {
                playerState = 3;
            }
        }
        return playerState;
    }

    private ListenableFuture<SessionPlayer.PlayerResult> playInternal() {
        if (!(this.mItem instanceof UriMediaItem)) {
            Log.w((String)TAG, (String)("Data source type is not Uri." + this.mItem));
            return this.createResult(-3);
        }
        final ResolvableFuture result = ResolvableFuture.create();
        this.mClient.play(((UriMediaItem)this.mItem).getUri(), "video/mp4", null, this.mPosition, null, new RemotePlaybackClient.ItemActionCallback(){

            public void onResult(Bundle data, String sessionId, MediaSessionStatus sessionStatus, String itemId, MediaItemStatus itemStatus) {
                if (DEBUG && !RoutePlayer.this.isSessionActive(sessionStatus)) {
                    Log.v((String)RoutePlayer.TAG, (String)"play() is called, but session is not active.");
                }
                RoutePlayer.this.mItemId = itemId;
                if (itemStatus != null) {
                    RoutePlayer.this.mDuration = itemStatus.getContentDuration();
                }
                result.set((Object)new SessionPlayer.PlayerResult(0, RoutePlayer.this.getCurrentMediaItem()));
            }
        });
        return result;
    }

    private ListenableFuture<SessionPlayer.PlayerResult> createResult() {
        return this.createResult(0);
    }

    private ListenableFuture<SessionPlayer.PlayerResult> createResult(int code) {
        ResolvableFuture result = ResolvableFuture.create();
        result.set((Object)new SessionPlayer.PlayerResult(code, this.getCurrentMediaItem()));
        return result;
    }
}

