/*
 * Decompiled with CFR 0.152.
 */
package androidx.media2.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.media.AudioAttributesCompat;
import androidx.media2.MediaItem;
import androidx.media2.SessionToken;
import androidx.media2.widget.BaseLayout;
import androidx.media2.widget.MediaControlView;
import androidx.media2.widget.VideoViewImpl;
import androidx.media2.widget.VideoViewImplBase;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@RequiresApi(value=19)
public class VideoView
extends BaseLayout {
    public static final int VIEW_TYPE_SURFACEVIEW = 0;
    public static final int VIEW_TYPE_TEXTUREVIEW = 1;
    private static final String TAG = "VideoView";
    private static final boolean DEBUG = Log.isLoggable((String)"VideoView", (int)3);
    private VideoViewImpl mImpl;

    public VideoView(@NonNull Context context) {
        this(context, null);
    }

    public VideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VideoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (DEBUG) {
            Log.d((String)TAG, (String)"Create VideoViewImplBase");
        }
        this.mImpl = new VideoViewImplBase();
        this.mImpl.initialize(this, context, attrs, defStyleAttr);
    }

    public void setMediaControlView(@NonNull MediaControlView mediaControlView, long intervalMs) {
        this.mImpl.setMediaControlView(mediaControlView, intervalMs);
    }

    @Nullable
    public MediaControlView getMediaControlView() {
        return this.mImpl.getMediaControlView();
    }

    @NonNull
    public SessionToken getSessionToken() {
        return this.mImpl.getSessionToken();
    }

    public void setAudioAttributes(@NonNull AudioAttributesCompat attributes) {
        this.mImpl.setAudioAttributes(attributes);
    }

    public void setMediaItem(@NonNull MediaItem mediaItem) {
        this.mImpl.setMediaItem(mediaItem);
    }

    public void setViewType(int viewType) {
        this.mImpl.setViewType(viewType);
    }

    public int getViewType() {
        return this.mImpl.getViewType();
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setOnViewTypeChangedListener(OnViewTypeChangedListener l) {
        this.mImpl.setOnViewTypeChangedListener(l);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mImpl.onAttachedToWindowImpl();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mImpl.onDetachedFromWindowImpl();
    }

    public void onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        this.mImpl.onVisibilityAggregatedImpl(isVisible);
    }

    public CharSequence getAccessibilityClassName() {
        return VideoView.class.getName();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.mImpl.onTouchEventImpl(ev);
        return super.onTouchEvent(ev);
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        this.mImpl.onTrackballEventImpl(ev);
        return super.onTrackballEvent(ev);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mImpl.onMeasureImpl(widthMeasureSpec, heightMeasureSpec);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface OnViewTypeChangedListener {
        public void onViewTypeChanged(View var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ViewType {
    }
}

