/*
 * Decompiled with CFR 0.152.
 */
package androidx.media2.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import androidx.media.AudioAttributesCompat;
import androidx.media2.FileMediaItem;
import androidx.media2.MediaItem;
import androidx.media2.MediaMetadata;
import androidx.media2.MediaPlayer;
import androidx.media2.MediaSession;
import androidx.media2.RemoteSessionPlayer;
import androidx.media2.SessionCommand;
import androidx.media2.SessionCommandGroup;
import androidx.media2.SessionPlayer;
import androidx.media2.SessionToken;
import androidx.media2.SubtitleData;
import androidx.media2.UriMediaItem;
import androidx.media2.VideoSize;
import androidx.media2.subtitle.Cea708CaptionRenderer;
import androidx.media2.subtitle.ClosedCaptionRenderer;
import androidx.media2.subtitle.SubtitleController;
import androidx.media2.subtitle.SubtitleTrack;
import androidx.media2.widget.MediaControlView;
import androidx.media2.widget.R;
import androidx.media2.widget.RoutePlayer;
import androidx.media2.widget.SubtitleAnchorView;
import androidx.media2.widget.UriUtil;
import androidx.media2.widget.VideoSurfaceView;
import androidx.media2.widget.VideoTextureView;
import androidx.media2.widget.VideoView;
import androidx.media2.widget.VideoViewImpl;
import androidx.media2.widget.VideoViewInterface;
import androidx.media2.widget.VideoViewPlayer;
import androidx.mediarouter.media.MediaRouteSelector;
import androidx.mediarouter.media.MediaRouter;
import androidx.palette.graphics.Palette;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

@RequiresApi(value=19)
class VideoViewImplBase
implements VideoViewImpl,
VideoViewInterface.SurfaceListener {
    private static final String TAG = "VideoViewImplBase";
    static final boolean DEBUG = Log.isLoggable((String)"VideoViewImplBase", (int)3);
    private static final int STATE_ERROR = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PREPARING = 1;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_PAUSED = 4;
    private static final int STATE_PLAYBACK_COMPLETED = 5;
    private static final int INVALID_TRACK_INDEX = -1;
    private static final int SIZE_TYPE_EMBEDDED = 0;
    private static final int SIZE_TYPE_FULL = 1;
    private static final String SUBTITLE_TRACK_LANG_UNDEFINED = "und";
    private AudioAttributesCompat mAudioAttributes;
    private VideoView.OnViewTypeChangedListener mViewTypeChangedListener;
    VideoViewInterface mCurrentView;
    VideoViewInterface mTargetView;
    VideoTextureView mTextureView;
    VideoSurfaceView mSurfaceView;
    VideoViewPlayer mMediaPlayer;
    MediaItem mMediaItem;
    MediaControlView mMediaControlView;
    MediaSession mMediaSession;
    private String mTitle;
    Executor mCallbackExecutor;
    View mCurrentMusicView;
    View mMusicFullLandscapeView;
    View mMusicFullPortraitView;
    View mMusicEmbeddedView;
    private Drawable mMusicAlbumDrawable;
    private String mMusicArtistText;
    final Object mLock = new Object();
    @GuardedBy(value="mLock")
    boolean mCurrentItemIsMusic;
    private int mPrevWidth;
    int mDominantColor;
    private int mSizeType;
    int mTargetState = 0;
    int mCurrentState = 0;
    long mSeekWhenPrepared;
    private ArrayList<Integer> mVideoTrackIndices;
    ArrayList<Integer> mAudioTrackIndices;
    SparseArray<SubtitleTrack> mSubtitleTracks;
    private SubtitleController mSubtitleController;
    int mSelectedAudioTrackIndex;
    int mSelectedSubtitleTrackIndex;
    private SubtitleAnchorView mSubtitleAnchorView;
    VideoView mInstance;
    private MediaRouter mMediaRouter;
    MediaRouteSelector mRouteSelector;
    MediaRouter.RouteInfo mRoute;
    RoutePlayer mRoutePlayer;
    private final MediaRouter.Callback mRouterCallback = new MediaRouter.Callback(){

        public void onRouteSelected(MediaRouter router, MediaRouter.RouteInfo route) {
            if (route.supportsControlCategory("android.media.intent.category.REMOTE_PLAYBACK")) {
                int localPlaybackState = VideoViewImplBase.this.mCurrentState;
                long localPlaybackPosition = VideoViewImplBase.this.mMediaSession == null ? 0L : VideoViewImplBase.this.mMediaSession.getPlayer().getCurrentPosition();
                VideoViewImplBase.this.resetPlayer();
                VideoViewImplBase.this.mRoute = route;
                VideoViewImplBase.this.mRoutePlayer = new RoutePlayer(VideoViewImplBase.this.mInstance.getContext(), VideoViewImplBase.this.mRouteSelector, route);
                VideoViewImplBase.this.mRoutePlayer.setMediaItem(VideoViewImplBase.this.mMediaItem);
                VideoViewImplBase.this.mRoutePlayer.setCurrentPosition(localPlaybackPosition);
                VideoViewImplBase.this.ensureSessionWithPlayer((SessionPlayer)VideoViewImplBase.this.mRoutePlayer);
                if (localPlaybackState == 3) {
                    VideoViewImplBase.this.mMediaSession.getPlayer().play();
                }
            }
        }

        public void onRouteUnselected(MediaRouter router, MediaRouter.RouteInfo route, int reason) {
            long currentPosition = 0L;
            int currentState = 0;
            if (VideoViewImplBase.this.mRoute != null && VideoViewImplBase.this.mRoutePlayer != null) {
                currentPosition = VideoViewImplBase.this.mRoutePlayer.getCurrentPosition();
                currentState = VideoViewImplBase.this.mRoutePlayer.getPlayerState();
                VideoViewImplBase.this.mRoutePlayer.close();
                VideoViewImplBase.this.mRoutePlayer = null;
            }
            if (VideoViewImplBase.this.mRoute == route) {
                VideoViewImplBase.this.mRoute = null;
            }
            if (reason != 3) {
                VideoViewImplBase.this.openVideo();
                VideoViewImplBase.this.mMediaSession.getPlayer().seekTo(currentPosition);
                if (currentState == 2) {
                    VideoViewImplBase.this.mMediaSession.getPlayer().play();
                }
            }
        }
    };
    @SuppressLint(value={"SyntheticAccessor"})
    MediaPlayer.PlayerCallback mMediaPlayerCallback = new MediaPlayer.PlayerCallback(){

        public void onVideoSizeChanged(MediaPlayer mp, MediaItem dsd, VideoSize size) {
            if (DEBUG) {
                Log.d((String)VideoViewImplBase.TAG, (String)("onVideoSizeChanged(): size: " + size.getWidth() + "/" + size.getHeight()));
            }
            if (mp != VideoViewImplBase.this.mMediaPlayer) {
                if (DEBUG) {
                    Log.w((String)VideoViewImplBase.TAG, (String)"onVideoSizeChanged() is ignored. mp is already gone.");
                }
                return;
            }
            VideoViewImplBase.this.mTextureView.forceLayout();
            VideoViewImplBase.this.mSurfaceView.forceLayout();
            VideoViewImplBase.this.mInstance.requestLayout();
        }

        public void onInfo(MediaPlayer mp, MediaItem dsd, int what, int extra) {
            Bundle data;
            if (DEBUG) {
                Log.d((String)VideoViewImplBase.TAG, (String)"onInfo()");
            }
            if (mp != VideoViewImplBase.this.mMediaPlayer) {
                if (DEBUG) {
                    Log.w((String)VideoViewImplBase.TAG, (String)"onInfo() is ignored. mp is already gone.");
                }
                return;
            }
            if (what == 802 && (data = VideoViewImplBase.this.extractTrackInfoData()) != null) {
                VideoViewImplBase.this.mMediaSession.broadcastCustomCommand(new SessionCommand("UpdateTrackStatus", null), data);
            }
        }

        public void onError(MediaPlayer mp, MediaItem dsd, int frameworkErr, int implErr) {
            if (DEBUG) {
                Log.d((String)VideoViewImplBase.TAG, (String)("Error: " + frameworkErr + "," + implErr));
            }
            if (mp != VideoViewImplBase.this.mMediaPlayer) {
                if (DEBUG) {
                    Log.w((String)VideoViewImplBase.TAG, (String)"onError() is ignored. mp is already gone.");
                }
                return;
            }
            if (VideoViewImplBase.this.mCurrentState != -1) {
                VideoViewImplBase.this.mCurrentState = -1;
                VideoViewImplBase.this.mTargetState = -1;
            }
        }

        public void onSubtitleData(MediaPlayer mp, MediaItem dsd, SubtitleData data) {
            if (DEBUG) {
                Log.d((String)VideoViewImplBase.TAG, (String)("onSubtitleData(): getTrackIndex: " + data.getTrackIndex() + ", getCurrentPosition: " + mp.getCurrentPosition() + ", getStartTimeUs(): " + data.getStartTimeUs() + ", diff: " + (data.getStartTimeUs() / 1000L - mp.getCurrentPosition()) + "ms, getDurationUs(): " + data.getDurationUs()));
            }
            if (mp != VideoViewImplBase.this.mMediaPlayer) {
                if (DEBUG) {
                    Log.w((String)VideoViewImplBase.TAG, (String)"onSubtitleData() is ignored. mp is already gone.");
                }
                return;
            }
            int index = data.getTrackIndex();
            if (index != VideoViewImplBase.this.mSelectedSubtitleTrackIndex) {
                return;
            }
            SubtitleTrack track = (SubtitleTrack)VideoViewImplBase.this.mSubtitleTracks.get(index);
            if (track != null) {
                track.onData(data);
            }
        }

        public void onPlayerStateChanged(@NonNull SessionPlayer player, int state) {
            switch (state) {
                case 0: {
                    VideoViewImplBase.this.mCurrentState = 0;
                    break;
                }
                case 2: {
                    VideoViewImplBase.this.mCurrentState = 3;
                    break;
                }
                case 1: {
                    if (VideoViewImplBase.this.mCurrentState == 1) {
                        this.onPrepared(player);
                    }
                    VideoViewImplBase.this.mCurrentState = 4;
                    break;
                }
                case 3: {
                    VideoViewImplBase.this.mCurrentState = -1;
                }
            }
        }

        private void onPrepared(SessionPlayer player) {
            long seekToPosition;
            if (DEBUG) {
                Log.d((String)VideoViewImplBase.TAG, (String)("OnPreparedListener(): , mCurrentState=" + VideoViewImplBase.this.mCurrentState + ", mTargetState=" + VideoViewImplBase.this.mTargetState));
            }
            VideoViewImplBase.this.mCurrentState = 2;
            if (VideoViewImplBase.this.mMediaSession != null) {
                Bundle data = VideoViewImplBase.this.extractTrackInfoData();
                if (data != null) {
                    VideoViewImplBase.this.mMediaSession.broadcastCustomCommand(new SessionCommand("UpdateTrackStatus", null), data);
                }
                MetadataExtractTask task = new MetadataExtractTask();
                task.execute(new Void[0]);
            }
            if (VideoViewImplBase.this.mMediaControlView != null) {
                Uri uri;
                VideoViewImplBase.this.mMediaControlView.setEnabled(true);
                Uri uri2 = uri = VideoViewImplBase.this.mMediaItem instanceof UriMediaItem ? ((UriMediaItem)VideoViewImplBase.this.mMediaItem).getUri() : null;
                if (uri != null && UriUtil.isFromNetwork(uri)) {
                    VideoViewImplBase.this.mMediaControlView.setRouteSelector(VideoViewImplBase.this.mRouteSelector);
                } else {
                    VideoViewImplBase.this.mMediaControlView.setRouteSelector(null);
                }
            }
            if ((seekToPosition = VideoViewImplBase.this.mSeekWhenPrepared) != 0L) {
                VideoViewImplBase.this.mMediaSession.getPlayer().seekTo(seekToPosition);
            }
            if (player instanceof VideoViewPlayer && VideoViewImplBase.this.needToStart()) {
                VideoViewImplBase.this.mMediaSession.getPlayer().play();
            }
        }

        private void onCompletion(MediaPlayer mp, MediaItem dsd) {
            VideoViewImplBase.this.mCurrentState = 5;
            VideoViewImplBase.this.mTargetState = 5;
        }
    };

    VideoViewImplBase() {
    }

    @Override
    public void initialize(VideoView instance, Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        int viewType;
        boolean enableControlView;
        this.mInstance = instance;
        this.mSelectedSubtitleTrackIndex = -1;
        this.mAudioAttributes = new AudioAttributesCompat.Builder().setUsage(1).setContentType(3).build();
        this.mCallbackExecutor = ContextCompat.getMainExecutor((Context)context);
        this.mInstance.setFocusable(true);
        this.mInstance.setFocusableInTouchMode(true);
        this.mInstance.requestFocus();
        this.mTextureView = new VideoTextureView(context);
        this.mSurfaceView = new VideoSurfaceView(context);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.mTextureView.setLayoutParams(params);
        this.mSurfaceView.setLayoutParams(params);
        this.mTextureView.setSurfaceListener(this);
        this.mSurfaceView.setSurfaceListener(this);
        this.mInstance.addView((View)this.mTextureView);
        this.mInstance.addView((View)this.mSurfaceView);
        this.mSubtitleAnchorView = new SubtitleAnchorView(context);
        this.mSubtitleAnchorView.setLayoutParams(params);
        this.mSubtitleAnchorView.setBackgroundColor(0);
        this.mInstance.addView((View)this.mSubtitleAnchorView);
        LayoutInflater inflater = (LayoutInflater)this.mInstance.getContext().getSystemService("layout_inflater");
        this.mMusicFullLandscapeView = inflater.inflate(R.layout.full_landscape_music, null);
        this.mMusicFullPortraitView = inflater.inflate(R.layout.full_portrait_music, null);
        this.mMusicEmbeddedView = inflater.inflate(R.layout.embedded_music, null);
        boolean bl = enableControlView = attrs == null || attrs.getAttributeBooleanValue("http://schemas.android.com/apk/res-auto", "enableControlView", true);
        if (enableControlView) {
            this.mMediaControlView = new MediaControlView(context);
        }
        int n = viewType = attrs == null ? 0 : attrs.getAttributeIntValue("http://schemas.android.com/apk/res-auto", "viewType", 0);
        if (viewType == 0) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"viewType attribute is surfaceView.");
            }
            this.mTextureView.setVisibility(8);
            this.mSurfaceView.setVisibility(0);
            this.mCurrentView = this.mSurfaceView;
        } else if (viewType == 1) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"viewType attribute is textureView.");
            }
            this.mTextureView.setVisibility(0);
            this.mSurfaceView.setVisibility(8);
            this.mCurrentView = this.mTextureView;
        }
        this.mTargetView = this.mCurrentView;
        MediaRouteSelector.Builder builder = new MediaRouteSelector.Builder();
        builder.addControlCategory("android.media.intent.category.REMOTE_PLAYBACK");
        builder.addControlCategory("android.media.intent.category.LIVE_AUDIO");
        builder.addControlCategory("android.media.intent.category.LIVE_VIDEO");
        this.mRouteSelector = builder.build();
    }

    @Override
    public void setMediaControlView(@NonNull MediaControlView mediaControlView, long intervalMs) {
        this.mMediaControlView = mediaControlView;
        this.mMediaControlView.setShowControllerInterval(intervalMs);
        if (this.mInstance.isAttachedToWindow()) {
            this.attachMediaControlView();
        }
    }

    @Override
    public MediaControlView getMediaControlView() {
        return this.mMediaControlView;
    }

    @Override
    @NonNull
    public SessionToken getSessionToken() {
        if (this.mMediaSession == null) {
            throw new IllegalStateException("MediaSession instance is not available.");
        }
        return this.mMediaSession.getToken();
    }

    @Override
    public void setAudioAttributes(@NonNull AudioAttributesCompat attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributes");
        }
        this.mAudioAttributes = attributes;
    }

    @Override
    public void setMediaItem(@NonNull MediaItem mediaItem) {
        this.mSeekWhenPrepared = 0L;
        this.mMediaItem = mediaItem;
        this.openVideo();
    }

    @Override
    public void setViewType(int viewType) {
        VideoViewInterface targetView;
        if (viewType == this.mTargetView.getViewType()) {
            Log.d((String)TAG, (String)("setViewType with the same type (" + viewType + ") is ignored."));
            return;
        }
        if (viewType == 1) {
            Log.d((String)TAG, (String)"switching to TextureView");
            targetView = this.mTextureView;
        } else if (viewType == 0) {
            Log.d((String)TAG, (String)"switching to SurfaceView");
            targetView = this.mSurfaceView;
        } else {
            throw new IllegalArgumentException("Unknown view type: " + viewType);
        }
        this.mTargetView = targetView;
        ((View)targetView).setVisibility(0);
        targetView.takeOver();
        this.mInstance.requestLayout();
    }

    @Override
    public int getViewType() {
        return this.mCurrentView.getViewType();
    }

    @Override
    public void setOnViewTypeChangedListener(VideoView.OnViewTypeChangedListener l) {
        this.mViewTypeChangedListener = l;
    }

    @Override
    public void onAttachedToWindowImpl() {
        if (this.mMediaPlayer == null) {
            this.mMediaPlayer = new VideoViewPlayer(this.mInstance.getContext());
            this.mSurfaceView.setMediaPlayer(this.mMediaPlayer);
            this.mTextureView.setMediaPlayer(this.mMediaPlayer);
            this.mCurrentView.assignSurfaceToMediaPlayer(this.mMediaPlayer);
            if (this.mMediaSession != null) {
                this.mMediaSession.updatePlayer((SessionPlayer)this.mMediaPlayer);
            }
        } else if (!this.mCurrentView.assignSurfaceToMediaPlayer(this.mMediaPlayer)) {
            Log.w((String)TAG, (String)"failed to assign surface");
        }
        this.ensureSessionWithPlayer((SessionPlayer)this.mMediaPlayer);
        this.attachMediaControlView();
        this.mMediaRouter = MediaRouter.getInstance((Context)this.mInstance.getContext());
        this.mMediaRouter.setMediaSessionCompat(this.mMediaSession.getSessionCompat());
        this.mMediaRouter.addCallback(this.mRouteSelector, this.mRouterCallback, 1);
    }

    @Override
    public void onDetachedFromWindowImpl() {
        try {
            this.mMediaPlayer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mMediaSession.close();
        this.mMediaPlayer = null;
        this.mMediaSession = null;
    }

    @Override
    public void onVisibilityAggregatedImpl(boolean isVisible) {
        if (this.isMediaPrepared()) {
            if (!isVisible && this.mCurrentState == 3) {
                this.mMediaSession.getPlayer().pause();
            } else if (isVisible && this.mTargetState == 3) {
                this.mMediaSession.getPlayer().play();
            }
        }
    }

    @Override
    public void onTouchEventImpl(MotionEvent ev) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onTouchEvent(). mCurrentState=" + this.mCurrentState + ", mTargetState=" + this.mTargetState));
        }
    }

    @Override
    public void onTrackballEventImpl(MotionEvent ev) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onTrackBallEvent(). mCurrentState=" + this.mCurrentState + ", mTargetState=" + this.mTargetState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMeasureImpl(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.mLock;
        synchronized (object) {
            int currWidth;
            if (this.mCurrentItemIsMusic && this.mPrevWidth != (currWidth = this.mInstance.getMeasuredWidth())) {
                Point screenSize = new Point();
                WindowManager winManager = (WindowManager)this.mInstance.getContext().getApplicationContext().getSystemService("window");
                winManager.getDefaultDisplay().getSize(screenSize);
                int screenWidth = screenSize.x;
                if (currWidth == screenWidth) {
                    int orientation = this.retrieveOrientation();
                    if (orientation == 0) {
                        this.updateCurrentMusicView(this.mMusicFullLandscapeView);
                    } else {
                        this.updateCurrentMusicView(this.mMusicFullPortraitView);
                    }
                    if (this.mSizeType != 1) {
                        this.mSizeType = 1;
                    }
                } else if (this.mSizeType != 0) {
                    this.mSizeType = 0;
                    this.updateCurrentMusicView(this.mMusicEmbeddedView);
                }
                this.mPrevWidth = currWidth;
            }
        }
    }

    @Override
    public void onSurfaceCreated(View view, int width, int height) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onSurfaceCreated(). mCurrentState=" + this.mCurrentState + ", mTargetState=" + this.mTargetState + ", width/height: " + width + "/" + height + ", " + view.toString()));
        }
        if (view == this.mTargetView) {
            ((VideoViewInterface)view).takeOver();
        }
        if (this.needToStart()) {
            this.mMediaSession.getPlayer().play();
        }
    }

    @Override
    public void onSurfaceDestroyed(View view) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onSurfaceDestroyed(). mCurrentState=" + this.mCurrentState + ", mTargetState=" + this.mTargetState + ", " + view.toString()));
        }
    }

    @Override
    public void onSurfaceChanged(View view, int width, int height) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onSurfaceChanged(). width/height: " + width + "/" + height + ", " + view.toString()));
        }
    }

    @Override
    public void onSurfaceTakeOverDone(VideoViewInterface view) {
        if (view != this.mTargetView) {
            if (DEBUG) {
                Log.d((String)TAG, (String)("onSurfaceTakeOverDone(). view is not targetView. ignore.: " + view));
            }
            return;
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)("onSurfaceTakeOverDone(). Now current view is: " + view));
        }
        if (this.mCurrentState != 3) {
            this.mMediaSession.getPlayer().seekTo(this.mMediaSession.getPlayer().getCurrentPosition());
        }
        if (view != this.mCurrentView) {
            ((View)this.mCurrentView).setVisibility(8);
            this.mCurrentView = view;
            if (this.mViewTypeChangedListener != null) {
                this.mViewTypeChangedListener.onViewTypeChanged((View)this.mInstance, view.getViewType());
            }
        }
        if (this.needToStart()) {
            this.mMediaSession.getPlayer().play();
        }
    }

    private void attachMediaControlView() {
        this.mMediaControlView.setSessionToken(this.mMediaSession.getToken());
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.mInstance.addView((View)this.mMediaControlView, params);
    }

    void ensureSessionWithPlayer(SessionPlayer player) {
        if (this.mMediaSession != null) {
            SessionPlayer oldPlayer = this.mMediaSession.getPlayer();
            if (oldPlayer == player) {
                return;
            }
            oldPlayer.unregisterPlayerCallback((SessionPlayer.PlayerCallback)this.mMediaPlayerCallback);
            this.mMediaSession.updatePlayer(player);
        } else {
            Context context = this.mInstance.getContext();
            this.mMediaSession = new MediaSession.Builder(context, player).setId("VideoView_" + this.mInstance.toString()).setSessionCallback(this.mCallbackExecutor, (MediaSession.SessionCallback)new MediaSessionCallback()).build();
        }
        player.registerPlayerCallback(this.mCallbackExecutor, (SessionPlayer.PlayerCallback)this.mMediaPlayerCallback);
    }

    private boolean isMediaPrepared() {
        return this.mMediaSession != null && this.mMediaSession.getPlayer().getPlayerState() != 3 && this.mMediaSession.getPlayer().getPlayerState() != 0;
    }

    boolean needToStart() {
        return (this.mMediaPlayer != null || this.mRoutePlayer != null) && this.isWaitingPlayback();
    }

    private boolean isWaitingPlayback() {
        return this.mCurrentState != 3 && this.mTargetState == 3;
    }

    void openVideo() {
        if (DEBUG) {
            Log.d((String)TAG, (String)"openVideo()");
        }
        if (this.mMediaItem != null) {
            this.resetPlayer();
            if (this.isRemotePlayback()) {
                this.mRoutePlayer.setMediaItem(this.mMediaItem);
                return;
            }
        }
        try {
            if (this.mMediaPlayer == null) {
                this.mMediaPlayer = new VideoViewPlayer(this.mInstance.getContext());
            }
            this.mSurfaceView.setMediaPlayer(this.mMediaPlayer);
            this.mTextureView.setMediaPlayer(this.mMediaPlayer);
            if (!this.mCurrentView.assignSurfaceToMediaPlayer(this.mMediaPlayer)) {
                Log.w((String)TAG, (String)"failed to assign surface");
            }
            this.mMediaPlayer.setAudioAttributes(this.mAudioAttributes);
            this.ensureSessionWithPlayer((SessionPlayer)this.mMediaPlayer);
            this.mMediaPlayer.setMediaItem(this.mMediaItem);
            Context context = this.mInstance.getContext();
            this.mSubtitleController = new SubtitleController(context);
            this.mSubtitleController.registerRenderer((SubtitleController.Renderer)new ClosedCaptionRenderer(context));
            this.mSubtitleController.registerRenderer((SubtitleController.Renderer)new Cea708CaptionRenderer(context));
            this.mSubtitleController.setAnchor((SubtitleController.Anchor)this.mSubtitleAnchorView);
            this.mCurrentState = 1;
            this.mMediaSession.getPlayer().prepare();
        }
        catch (IllegalArgumentException ex) {
            Log.w((String)TAG, (String)("Unable to open content: " + this.mMediaItem), (Throwable)ex);
            this.mCurrentState = -1;
            this.mTargetState = -1;
        }
    }

    void resetPlayer() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mTextureView.setMediaPlayer(null);
            this.mSurfaceView.setMediaPlayer(null);
            this.mCurrentState = 0;
            this.mTargetState = 0;
            this.mSelectedSubtitleTrackIndex = -1;
            this.mSelectedAudioTrackIndex = -1;
        }
    }

    boolean isRemotePlayback() {
        return this.mRoutePlayer != null && this.mMediaSession != null && this.mMediaSession.getPlayer() instanceof RemoteSessionPlayer;
    }

    void selectSubtitleTrack(int trackIndex) {
        if (!this.isMediaPrepared()) {
            return;
        }
        SubtitleTrack track = (SubtitleTrack)this.mSubtitleTracks.get(trackIndex);
        if (track != null) {
            this.mMediaPlayer.selectTrack(trackIndex);
            this.mSubtitleController.selectTrack(track);
            this.mSelectedSubtitleTrackIndex = trackIndex;
            this.mSubtitleAnchorView.setVisibility(0);
            Bundle data = new Bundle();
            data.putInt("SelectedSubtitleIndex", this.mSubtitleTracks.indexOfKey(trackIndex));
            this.mMediaSession.broadcastCustomCommand(new SessionCommand("UpdateSubtitleSelected", null), data);
        }
    }

    void deselectSubtitleTrack() {
        if (!this.isMediaPrepared() || this.mSelectedSubtitleTrackIndex == -1) {
            return;
        }
        this.mMediaPlayer.deselectTrack(this.mSelectedSubtitleTrackIndex);
        this.mSelectedSubtitleTrackIndex = -1;
        this.mSubtitleAnchorView.setVisibility(8);
        this.mMediaSession.broadcastCustomCommand(new SessionCommand("UpdateSubtitleDeselected", null), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle extractTrackInfoData() {
        List trackInfos = this.mMediaPlayer.getTrackInfo();
        this.mVideoTrackIndices = new ArrayList();
        this.mAudioTrackIndices = new ArrayList();
        this.mSubtitleTracks = new SparseArray();
        ArrayList<String> subtitleTracksLanguageList = new ArrayList<String>();
        this.mSubtitleController.reset();
        for (int i = 0; i < trackInfos.size(); ++i) {
            SubtitleTrack track;
            int trackType = ((MediaPlayer.TrackInfo)trackInfos.get(i)).getTrackType();
            if (trackType == 1) {
                this.mVideoTrackIndices.add(i);
                continue;
            }
            if (trackType == 2) {
                this.mAudioTrackIndices.add(i);
                continue;
            }
            if (trackType != 4 || (track = this.mSubtitleController.addTrack(((MediaPlayer.TrackInfo)trackInfos.get(i)).getFormat())) == null) continue;
            this.mSubtitleTracks.put(i, (Object)track);
            String language = ((MediaPlayer.TrackInfo)trackInfos.get(i)).getLanguage().equals(SUBTITLE_TRACK_LANG_UNDEFINED) ? "" : ((MediaPlayer.TrackInfo)trackInfos.get(i)).getLanguage();
            subtitleTracksLanguageList.add(language);
        }
        if (this.mAudioTrackIndices.size() > 0) {
            this.mSelectedAudioTrackIndex = 0;
        }
        Object i = this.mLock;
        synchronized (i) {
            this.mCurrentItemIsMusic = this.mVideoTrackIndices.size() == 0 && this.mAudioTrackIndices.size() > 0;
        }
        Bundle data = new Bundle();
        data.putInt("VideoTrackCount", this.mVideoTrackIndices.size());
        data.putInt("AudioTrackCount", this.mAudioTrackIndices.size());
        data.putInt("SubtitleTrackCount", this.mSubtitleTracks.size());
        data.putStringArrayList("SubtitleTrackLanguageList", subtitleTracksLanguageList);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaMetadata extractMetadata() {
        MediaMetadataRetriever retriever = null;
        String path = "";
        try {
            if (this.mMediaItem == null) {
                return null;
            }
            if (this.mMediaItem instanceof UriMediaItem) {
                Uri uri = ((UriMediaItem)this.mMediaItem).getUri();
                if (UriUtil.isFromNetwork(uri)) {
                    path = uri.getPath();
                } else if ("file".equals(uri.getScheme())) {
                    path = uri.getLastPathSegment();
                }
                retriever = new MediaMetadataRetriever();
                retriever.setDataSource(this.mInstance.getContext(), uri);
            } else if (this.mMediaItem instanceof FileMediaItem) {
                retriever = new MediaMetadataRetriever();
                retriever.setDataSource(((FileMediaItem)this.mMediaItem).getFileDescriptor(), ((FileMediaItem)this.mMediaItem).getFileDescriptorOffset(), ((FileMediaItem)this.mMediaItem).getFileDescriptorLength());
            }
        }
        catch (IllegalArgumentException e) {
            Log.v((String)TAG, (String)"Cannot retrieve metadata for this media file.");
            retriever = null;
        }
        MediaMetadata metadata = this.mMediaItem.getMetadata();
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mCurrentItemIsMusic) {
                this.mTitle = this.extractString(metadata, "android.media.metadata.TITLE", retriever, 7, path);
            } else {
                Resources resources = this.mInstance.getResources();
                this.mTitle = this.extractString(metadata, "android.media.metadata.TITLE", retriever, 7, resources.getString(R.string.mcv2_music_title_unknown_text));
                this.mMusicArtistText = this.extractString(metadata, "android.media.metadata.ARTIST", retriever, 2, resources.getString(R.string.mcv2_music_artist_unknown_text));
                this.mMusicAlbumDrawable = this.extractAlbumArt(metadata, retriever, resources.getDrawable(R.drawable.ic_default_album_image));
            }
            if (retriever != null) {
                retriever.release();
            }
            MediaMetadata.Builder builder = new MediaMetadata.Builder();
            if (this.mCurrentItemIsMusic) {
                builder.putString("android.media.metadata.ARTIST", this.mMusicArtistText);
            }
            builder.putString("android.media.metadata.TITLE", this.mTitle);
            builder.putLong("android.media.metadata.DURATION", this.mMediaSession.getPlayer().getDuration());
            builder.putString("android.media.metadata.MEDIA_ID", this.mMediaItem.getMediaId());
            builder.putLong("androidx.media2.metadata.PLAYABLE", 1L);
            return builder.build();
        }
    }

    private String extractString(MediaMetadata metadata, String stringKey, MediaMetadataRetriever retriever, int intKey, String defaultValue) {
        String value = null;
        if (metadata != null && (value = metadata.getString(stringKey)) != null && !value.isEmpty()) {
            return value;
        }
        if (retriever != null) {
            value = retriever.extractMetadata(intKey);
        }
        return value == null ? defaultValue : value;
    }

    private Drawable extractAlbumArt(MediaMetadata metadata, MediaMetadataRetriever retriever, Drawable defaultDrawable) {
        byte[] album;
        Bitmap bitmap = null;
        if (metadata != null && metadata.containsKey("android.media.metadata.ALBUM_ART")) {
            bitmap = metadata.getBitmap("android.media.metadata.ALBUM_ART");
        } else if (retriever != null && (album = retriever.getEmbeddedPicture()) != null) {
            bitmap = BitmapFactory.decodeByteArray((byte[])album, (int)0, (int)album.length);
        }
        if (bitmap != null) {
            Palette.Builder builder = Palette.from(bitmap);
            builder.generate(new Palette.PaletteAsyncListener(){

                public void onGenerated(Palette palette) {
                    VideoViewImplBase.this.mDominantColor = palette.getDominantColor(0);
                    if (VideoViewImplBase.this.mCurrentMusicView != null) {
                        VideoViewImplBase.this.mCurrentMusicView.setBackgroundColor(VideoViewImplBase.this.mDominantColor);
                    }
                }
            });
            return new BitmapDrawable(bitmap);
        }
        return defaultDrawable;
    }

    private int retrieveOrientation() {
        DisplayMetrics dm = Resources.getSystem().getDisplayMetrics();
        int height = dm.heightPixels;
        int width = dm.widthPixels;
        return height > width ? 1 : 0;
    }

    void updateCurrentMusicView(View newMusicView) {
        TextView artistView;
        TextView titleView;
        newMusicView.setBackgroundColor(this.mDominantColor);
        ImageView albumView = (ImageView)newMusicView.findViewById(R.id.album);
        if (albumView != null) {
            albumView.setImageDrawable(this.mMusicAlbumDrawable);
        }
        if ((titleView = (TextView)newMusicView.findViewById(R.id.title)) != null) {
            titleView.setText((CharSequence)this.mTitle);
        }
        if ((artistView = (TextView)newMusicView.findViewById(R.id.artist)) != null) {
            artistView.setText((CharSequence)this.mMusicArtistText);
        }
        this.mInstance.removeView(this.mCurrentMusicView);
        this.mInstance.addView(newMusicView, 0);
        this.mCurrentMusicView = newMusicView;
    }

    private class MetadataExtractTask
    extends AsyncTask<Void, Void, MediaMetadata> {
        MetadataExtractTask() {
        }

        protected MediaMetadata doInBackground(Void ... params) {
            return VideoViewImplBase.this.extractMetadata();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"SyntheticAccessor"})
        protected void onPostExecute(MediaMetadata metadata) {
            if (metadata != null) {
                VideoViewImplBase.this.mMediaItem.setMetadata(metadata);
            }
            Object object = VideoViewImplBase.this.mLock;
            synchronized (object) {
                if (VideoViewImplBase.this.mCurrentItemIsMusic) {
                    VideoViewImplBase.this.mInstance.removeView((View)VideoViewImplBase.this.mSurfaceView);
                    VideoViewImplBase.this.mInstance.removeView((View)VideoViewImplBase.this.mTextureView);
                    VideoViewImplBase.this.updateCurrentMusicView(VideoViewImplBase.this.mMusicEmbeddedView);
                }
            }
        }
    }

    class MediaSessionCallback
    extends MediaSession.SessionCallback {
        MediaSessionCallback() {
        }

        public SessionCommandGroup onConnect(@NonNull MediaSession session, @NonNull MediaSession.ControllerInfo controller) {
            if (session != VideoViewImplBase.this.mMediaSession && DEBUG) {
                Log.w((String)VideoViewImplBase.TAG, (String)"onConnect() is ignored. session is already gone.");
            }
            SessionCommandGroup.Builder commandsBuilder = new SessionCommandGroup.Builder().addCommand(10001).addCommand(10000).addCommand(10002).addCommand(10004).addCommand(40000).addCommand(40001).addCommand(10003).addCommand(30000).addCommand(30001).addCommand(40006).addCommand(40009).addCommand(10005).addCommand(10012).addCommand(new SessionCommand("SelectTrack", null)).addCommand(new SessionCommand("showSubtitle", null)).addCommand(new SessionCommand("hideSubtitle", null));
            return commandsBuilder.build();
        }

        public MediaSession.SessionResult onCustomCommand(@NonNull MediaSession session, @NonNull MediaSession.ControllerInfo controller, @NonNull SessionCommand customCommand, @Nullable Bundle args) {
            if (session != VideoViewImplBase.this.mMediaSession && DEBUG) {
                Log.w((String)VideoViewImplBase.TAG, (String)"onCustomCommand() is ignored. session is already gone.");
            }
            if (VideoViewImplBase.this.isRemotePlayback()) {
                return new MediaSession.SessionResult(0, null);
            }
            switch (customCommand.getCustomCommand()) {
                case "showSubtitle": {
                    int subtitleTrackIndex;
                    int subtitleIndex;
                    int n = subtitleIndex = args != null ? args.getInt("SelectedSubtitleIndex", -1) : -1;
                    if (subtitleIndex == -1 || (subtitleTrackIndex = VideoViewImplBase.this.mSubtitleTracks.keyAt(subtitleIndex)) == VideoViewImplBase.this.mSelectedSubtitleTrackIndex) break;
                    VideoViewImplBase.this.selectSubtitleTrack(subtitleTrackIndex);
                    break;
                }
                case "hideSubtitle": {
                    VideoViewImplBase.this.deselectSubtitleTrack();
                    break;
                }
                case "SelectTrack": {
                    int audioTrackIndex;
                    int audioIndex;
                    int n = audioIndex = args != null ? args.getInt("SelectedAudioIndex", -1) : -1;
                    if (audioIndex == -1 || (audioTrackIndex = VideoViewImplBase.this.mAudioTrackIndices.get(audioIndex).intValue()) == VideoViewImplBase.this.mSelectedAudioTrackIndex) break;
                    VideoViewImplBase.this.mSelectedAudioTrackIndex = audioTrackIndex;
                    VideoViewImplBase.this.mMediaPlayer.selectTrack(VideoViewImplBase.this.mSelectedAudioTrackIndex);
                }
            }
            return new MediaSession.SessionResult(0, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int onCommandRequest(@NonNull MediaSession session, @NonNull MediaSession.ControllerInfo controller, @NonNull SessionCommand command) {
            if (session != VideoViewImplBase.this.mMediaSession && DEBUG) {
                Log.w((String)VideoViewImplBase.TAG, (String)"onCommandRequest() is ignored. session is already gone.");
            }
            switch (command.getCommandCode()) {
                case 10000: {
                    VideoViewImplBase.this.mTargetState = 3;
                    Object object = VideoViewImplBase.this.mLock;
                    synchronized (object) {
                        if (!VideoViewImplBase.this.mCurrentView.hasAvailableSurface() && !VideoViewImplBase.this.mCurrentItemIsMusic) {
                            Log.d((String)VideoViewImplBase.TAG, (String)"surface is not available");
                            return -2;
                        }
                        break;
                    }
                }
                case 10001: {
                    VideoViewImplBase.this.mTargetState = 4;
                    break;
                }
                case 10003: {
                    VideoViewImplBase.this.mSeekWhenPrepared = 0L;
                }
            }
            return 0;
        }
    }
}

