/*
 * Decompiled with CFR 0.152.
 */
package androidx.media.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Bundle;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.media.SessionToken2;
import androidx.media.widget.BaseLayout;
import androidx.media.widget.R;
import androidx.mediarouter.app.MediaRouteButton;
import androidx.mediarouter.media.MediaRouteSelector;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;

@RequiresApi(value=21)
public class MediaControlView2
extends BaseLayout {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_PLAY_PAUSE = 1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_FFWD = 2;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_REW = 3;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_NEXT = 4;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_PREV = 5;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_SUBTITLE = 6;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_FULL_SCREEN = 7;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_OVERFLOW = 8;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_MUTE = 9;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_ASPECT_RATIO = 10;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_SETTINGS = 11;
    private static final String TAG = "MediaControlView2";
    static final String KEY_VIDEO_TRACK_COUNT = "VideoTrackCount";
    static final String KEY_AUDIO_TRACK_COUNT = "AudioTrackCount";
    static final String KEY_SUBTITLE_TRACK_COUNT = "SubtitleTrackCount";
    static final String KEY_PLAYBACK_SPEED = "PlaybackSpeed";
    static final String KEY_SELECTED_AUDIO_INDEX = "SelectedAudioIndex";
    static final String KEY_SELECTED_SUBTITLE_INDEX = "SelectedSubtitleIndex";
    static final String EVENT_UPDATE_TRACK_STATUS = "UpdateTrackStatus";
    static final String KEY_STATE_IS_ADVERTISEMENT = "MediaTypeAdvertisement";
    static final String EVENT_UPDATE_MEDIA_TYPE_STATUS = "UpdateMediaTypeStatus";
    static final String COMMAND_SHOW_SUBTITLE = "showSubtitle";
    static final String COMMAND_HIDE_SUBTITLE = "hideSubtitle";
    static final String COMMAND_SELECT_AUDIO_TRACK = "SelectTrack";
    static final String COMMAND_SET_PLAYBACK_SPEED = "SetPlaybackSpeed";
    static final String COMMAND_MUTE = "Mute";
    static final String COMMAND_UNMUTE = "Unmute";
    private static final int SETTINGS_MODE_AUDIO_TRACK = 0;
    private static final int SETTINGS_MODE_PLAYBACK_SPEED = 1;
    private static final int SETTINGS_MODE_HELP = 2;
    private static final int SETTINGS_MODE_SUBTITLE_TRACK = 3;
    private static final int SETTINGS_MODE_VIDEO_QUALITY = 4;
    private static final int SETTINGS_MODE_MAIN = 5;
    private static final int PLAYBACK_SPEED_1x_INDEX = 3;
    private static final int MEDIA_TYPE_DEFAULT = 0;
    private static final int MEDIA_TYPE_MUSIC = 1;
    private static final int MEDIA_TYPE_ADVERTISEMENT = 2;
    private static final int SIZE_TYPE_EMBEDDED = 0;
    private static final int SIZE_TYPE_FULL = 1;
    private static final int SIZE_TYPE_MINIMAL = 2;
    private static final int MAX_PROGRESS = 1000;
    private static final int DEFAULT_PROGRESS_UPDATE_TIME_MS = 1000;
    private static final int REWIND_TIME_MS = 10000;
    private static final int FORWARD_TIME_MS = 30000;
    private static final int AD_SKIP_WAIT_TIME_MS = 5000;
    private static final int RESOURCE_NON_EXISTENT = -1;
    private static final String RESOURCE_EMPTY = "";
    private Resources mResources;
    private MediaControllerCompat mController;
    private MediaControllerCompat.TransportControls mControls;
    private PlaybackStateCompat mPlaybackState;
    private MediaMetadataCompat mMetadata;
    private OnFullScreenListener mOnFullScreenListener;
    private int mDuration;
    private int mPrevState;
    private int mPrevWidth;
    private int mPrevHeight;
    private int mOriginalLeftBarWidth;
    private int mVideoTrackCount;
    private int mAudioTrackCount;
    private int mSubtitleTrackCount;
    private int mSettingsMode;
    private int mSelectedSubtitleTrackIndex;
    private int mSelectedAudioTrackIndex;
    private int mSelectedVideoQualityIndex;
    private int mSelectedSpeedIndex;
    private int mEmbeddedSettingsItemWidth;
    private int mFullSettingsItemWidth;
    private int mSettingsItemHeight;
    private int mSettingsWindowMargin;
    private int mMediaType;
    private int mSizeType;
    private int mOrientation;
    private long mPlaybackActions;
    private boolean mDragging;
    private boolean mIsFullScreen;
    private boolean mOverflowExpanded;
    private boolean mIsStopped;
    private boolean mSubtitleIsEnabled;
    private boolean mSeekAvailable;
    private boolean mIsAdvertisement;
    private boolean mIsMute;
    private boolean mNeedUXUpdate;
    private ViewGroup mRoot;
    private View mTitleBar;
    private TextView mTitleView;
    private View mAdExternalLink;
    private ImageButton mBackButton;
    private MediaRouteButton mRouteButton;
    private MediaRouteSelector mRouteSelector;
    private ViewGroup mCenterView;
    private View mTransportControls;
    private ImageButton mPlayPauseButton;
    private ImageButton mFfwdButton;
    private ImageButton mRewButton;
    private ImageButton mNextButton;
    private ImageButton mPrevButton;
    private LinearLayout mMinimalExtraView;
    private ProgressBar mProgress;
    private View mProgressBuffer;
    private ViewGroup mBottomBar;
    private ViewGroup mBottomBarLeftView;
    private ViewGroup mTimeView;
    private TextView mEndTime;
    private TextView mCurrentTime;
    private TextView mAdSkipView;
    private StringBuilder mFormatBuilder;
    private Formatter mFormatter;
    private ViewGroup mBottomBarRightView;
    private ViewGroup mBasicControls;
    private ViewGroup mExtraControls;
    private ViewGroup mCustomButtons;
    private ImageButton mSubtitleButton;
    private ImageButton mFullScreenButton;
    private ImageButton mOverflowButtonRight;
    private ImageButton mOverflowButtonLeft;
    private ImageButton mMuteButton;
    private ImageButton mVideoQualityButton;
    private ImageButton mSettingsButton;
    private TextView mAdRemainingView;
    private ListView mSettingsListView;
    private PopupWindow mSettingsWindow;
    private SettingsAdapter mSettingsAdapter;
    private SubSettingsAdapter mSubSettingsAdapter;
    private List<String> mSettingsMainTextsList;
    private List<String> mSettingsSubTextsList;
    private List<Integer> mSettingsIconIdsList;
    private List<String> mSubtitleDescriptionsList;
    private List<String> mAudioTrackList;
    private List<String> mVideoQualityList;
    private List<String> mPlaybackSpeedTextList;
    private List<Float> mPlaybackSpeedList;
    private final Runnable mUpdateProgress = new Runnable(){

        @Override
        public void run() {
            boolean isShowing;
            int pos = MediaControlView2.this.setProgress();
            boolean bl = isShowing = MediaControlView2.this.getVisibility() == 0;
            if (!MediaControlView2.this.mDragging && isShowing && MediaControlView2.this.isPlaying()) {
                MediaControlView2.this.postDelayed(MediaControlView2.this.mUpdateProgress, 1000 - pos % 1000);
            }
        }
    };
    private final SeekBar.OnSeekBarChangeListener mSeekListener = new SeekBar.OnSeekBarChangeListener(){

        public void onStartTrackingTouch(SeekBar bar) {
            if (!MediaControlView2.this.mSeekAvailable) {
                return;
            }
            MediaControlView2.this.mDragging = true;
            MediaControlView2.this.removeCallbacks(MediaControlView2.this.mUpdateProgress);
            if (MediaControlView2.this.mIsStopped) {
                MediaControlView2.this.mPlayPauseButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_play_circle_filled, null));
                MediaControlView2.this.mPlayPauseButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_play_button_desc));
                MediaControlView2.this.mIsStopped = false;
            }
        }

        public void onProgressChanged(SeekBar bar, int progress, boolean fromUser) {
            if (!MediaControlView2.this.mSeekAvailable) {
                return;
            }
            if (!fromUser) {
                return;
            }
            if (MediaControlView2.this.mDuration > 0) {
                int position = (int)((long)MediaControlView2.this.mDuration * (long)progress / 1000L);
                MediaControlView2.this.mControls.seekTo((long)position);
                if (MediaControlView2.this.mCurrentTime != null) {
                    MediaControlView2.this.mCurrentTime.setText((CharSequence)MediaControlView2.this.stringForTime(position));
                }
            }
        }

        public void onStopTrackingTouch(SeekBar bar) {
            if (!MediaControlView2.this.mSeekAvailable) {
                return;
            }
            MediaControlView2.this.mDragging = false;
            MediaControlView2.this.setProgress();
            MediaControlView2.this.post(MediaControlView2.this.mUpdateProgress);
        }
    };
    private final View.OnClickListener mPlayPauseListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.togglePausePlayState();
        }
    };
    private final View.OnClickListener mRewListener = new View.OnClickListener(){

        public void onClick(View v) {
            int pos = MediaControlView2.this.getCurrentPosition() - 10000;
            MediaControlView2.this.mControls.seekTo((long)pos);
            MediaControlView2.this.setProgress();
        }
    };
    private final View.OnClickListener mFfwdListener = new View.OnClickListener(){

        public void onClick(View v) {
            int pos = MediaControlView2.this.getCurrentPosition() + 30000;
            MediaControlView2.this.mControls.seekTo((long)pos);
            MediaControlView2.this.setProgress();
        }
    };
    private final View.OnClickListener mNextListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.mControls.skipToNext();
        }
    };
    private final View.OnClickListener mPrevListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.mControls.skipToPrevious();
        }
    };
    private final View.OnClickListener mBackListener = new View.OnClickListener(){

        public void onClick(View v) {
            View parent = (View)MediaControlView2.this.getParent();
            if (parent != null) {
                parent.onKeyDown(4, new KeyEvent(0, 4));
            }
        }
    };
    private final View.OnClickListener mSubtitleListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.mSettingsMode = 3;
            MediaControlView2.this.mSubSettingsAdapter.setTexts(MediaControlView2.this.mSubtitleDescriptionsList);
            MediaControlView2.this.mSubSettingsAdapter.setCheckPosition(MediaControlView2.this.mSelectedSubtitleTrackIndex);
            MediaControlView2.this.displaySettingsWindow(MediaControlView2.this.mSubSettingsAdapter);
        }
    };
    private final View.OnClickListener mVideoQualityListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.mSettingsMode = 4;
            MediaControlView2.this.mSubSettingsAdapter.setTexts(MediaControlView2.this.mVideoQualityList);
            MediaControlView2.this.mSubSettingsAdapter.setCheckPosition(MediaControlView2.this.mSelectedVideoQualityIndex);
            MediaControlView2.this.displaySettingsWindow(MediaControlView2.this.mSubSettingsAdapter);
        }
    };
    private final View.OnClickListener mFullScreenListener = new View.OnClickListener(){

        public void onClick(View v) {
            boolean isEnteringFullScreen;
            if (MediaControlView2.this.mOnFullScreenListener == null) {
                return;
            }
            boolean bl = isEnteringFullScreen = !MediaControlView2.this.mIsFullScreen;
            if (isEnteringFullScreen) {
                MediaControlView2.this.mFullScreenButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_fullscreen_exit, null));
            } else {
                MediaControlView2.this.mFullScreenButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_fullscreen, null));
            }
            MediaControlView2.this.mIsFullScreen = isEnteringFullScreen;
            MediaControlView2.this.mOnFullScreenListener.onFullScreen((View)MediaControlView2.this, MediaControlView2.this.mIsFullScreen);
        }
    };
    private final View.OnClickListener mOverflowRightListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.mBasicControls.setVisibility(8);
            MediaControlView2.this.mExtraControls.setVisibility(0);
        }
    };
    private final View.OnClickListener mOverflowLeftListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.mBasicControls.setVisibility(0);
            MediaControlView2.this.mExtraControls.setVisibility(8);
        }
    };
    private final View.OnClickListener mMuteButtonListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (!MediaControlView2.this.mIsMute) {
                MediaControlView2.this.mMuteButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_mute, null));
                MediaControlView2.this.mMuteButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_muted_button_desc));
                MediaControlView2.this.mIsMute = true;
                MediaControlView2.this.mController.sendCommand(MediaControlView2.COMMAND_MUTE, null, null);
            } else {
                MediaControlView2.this.mMuteButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_unmute, null));
                MediaControlView2.this.mMuteButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_unmuted_button_desc));
                MediaControlView2.this.mIsMute = false;
                MediaControlView2.this.mController.sendCommand(MediaControlView2.COMMAND_UNMUTE, null, null);
            }
        }
    };
    private final View.OnClickListener mSettingsButtonListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.mSettingsMode = 5;
            MediaControlView2.this.mSettingsAdapter.setSubTexts(MediaControlView2.this.mSettingsSubTextsList);
            MediaControlView2.this.displaySettingsWindow(MediaControlView2.this.mSettingsAdapter);
        }
    };
    private final AdapterView.OnItemClickListener mSettingsItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            switch (MediaControlView2.this.mSettingsMode) {
                case 5: {
                    if (position == 0) {
                        MediaControlView2.this.mSubSettingsAdapter.setTexts(MediaControlView2.this.mAudioTrackList);
                        MediaControlView2.this.mSubSettingsAdapter.setCheckPosition(MediaControlView2.this.mSelectedAudioTrackIndex);
                        MediaControlView2.this.mSettingsMode = 0;
                    } else if (position == 1) {
                        MediaControlView2.this.mSubSettingsAdapter.setTexts(MediaControlView2.this.mPlaybackSpeedTextList);
                        MediaControlView2.this.mSubSettingsAdapter.setCheckPosition(MediaControlView2.this.mSelectedSpeedIndex);
                        MediaControlView2.this.mSettingsMode = 1;
                    } else if (position == 2) {
                        MediaControlView2.this.mSettingsWindow.dismiss();
                        return;
                    }
                    MediaControlView2.this.displaySettingsWindow(MediaControlView2.this.mSubSettingsAdapter);
                    break;
                }
                case 0: {
                    if (position != MediaControlView2.this.mSelectedAudioTrackIndex) {
                        MediaControlView2.this.mSelectedAudioTrackIndex = position;
                        if (MediaControlView2.this.mAudioTrackCount > 0) {
                            Bundle extra = new Bundle();
                            extra.putInt(MediaControlView2.KEY_SELECTED_AUDIO_INDEX, position);
                            MediaControlView2.this.mController.sendCommand(MediaControlView2.COMMAND_SELECT_AUDIO_TRACK, extra, null);
                        }
                        MediaControlView2.this.mSettingsSubTextsList.set(0, MediaControlView2.this.mSubSettingsAdapter.getMainText(position));
                    }
                    MediaControlView2.this.mSettingsWindow.dismiss();
                    break;
                }
                case 1: {
                    if (position != MediaControlView2.this.mSelectedSpeedIndex) {
                        MediaControlView2.this.mSelectedSpeedIndex = position;
                        Bundle extra = new Bundle();
                        extra.putFloat(MediaControlView2.KEY_PLAYBACK_SPEED, ((Float)MediaControlView2.this.mPlaybackSpeedList.get(position)).floatValue());
                        MediaControlView2.this.mController.sendCommand(MediaControlView2.COMMAND_SET_PLAYBACK_SPEED, extra, null);
                        MediaControlView2.this.mSettingsSubTextsList.set(1, MediaControlView2.this.mSubSettingsAdapter.getMainText(position));
                    }
                    MediaControlView2.this.mSettingsWindow.dismiss();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (position != MediaControlView2.this.mSelectedSubtitleTrackIndex) {
                        MediaControlView2.this.mSelectedSubtitleTrackIndex = position;
                        if (position > 0) {
                            Bundle extra = new Bundle();
                            extra.putInt(MediaControlView2.KEY_SELECTED_SUBTITLE_INDEX, position - 1);
                            MediaControlView2.this.mController.sendCommand(MediaControlView2.COMMAND_SHOW_SUBTITLE, extra, null);
                            MediaControlView2.this.mSubtitleButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_subtitle_on, null));
                            MediaControlView2.this.mSubtitleButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_cc_is_on));
                            MediaControlView2.this.mSubtitleIsEnabled = true;
                        } else {
                            MediaControlView2.this.mController.sendCommand(MediaControlView2.COMMAND_HIDE_SUBTITLE, null, null);
                            MediaControlView2.this.mSubtitleButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_subtitle_off, null));
                            MediaControlView2.this.mSubtitleButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_cc_is_off));
                            MediaControlView2.this.mSubtitleIsEnabled = false;
                        }
                    }
                    MediaControlView2.this.mSettingsWindow.dismiss();
                    break;
                }
                case 4: {
                    MediaControlView2.this.mSelectedVideoQualityIndex = position;
                    MediaControlView2.this.mSettingsWindow.dismiss();
                }
            }
        }
    };

    public MediaControlView2(@NonNull Context context) {
        this(context, null);
    }

    public MediaControlView2(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MediaControlView2(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mResources = context.getResources();
        this.mRoot = this.makeControllerView();
        this.addView((View)this.mRoot);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setMediaSessionToken(SessionToken2 token) {
    }

    public void setOnFullScreenListener(OnFullScreenListener l) {
        this.mOnFullScreenListener = l;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setController(MediaControllerCompat controller) {
        this.mController = controller;
        if (controller != null) {
            this.mControls = this.mController.getTransportControls();
            this.mPlaybackState = this.mController.getPlaybackState();
            this.mMetadata = this.mController.getMetadata();
            this.updateDuration();
            this.updateTitle();
            this.mController.registerCallback((MediaControllerCompat.Callback)new MediaControllerCallback());
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setButtonVisibility(int button, int visibility) {
        switch (button) {
            case 1: {
                if (this.mPlayPauseButton == null || !this.canPause()) break;
                this.mPlayPauseButton.setVisibility(visibility);
                break;
            }
            case 2: {
                if (this.mFfwdButton == null || !this.canSeekForward()) break;
                this.mFfwdButton.setVisibility(visibility);
                break;
            }
            case 3: {
                if (this.mRewButton == null || !this.canSeekBackward()) break;
                this.mRewButton.setVisibility(visibility);
                break;
            }
            case 4: {
                if (this.mNextButton == null) break;
                this.mNextButton.setVisibility(visibility);
                break;
            }
            case 5: {
                if (this.mPrevButton == null) break;
                this.mPrevButton.setVisibility(visibility);
                break;
            }
            case 6: {
                if (this.mSubtitleButton == null || this.mSubtitleTrackCount <= 0) break;
                this.mSubtitleButton.setVisibility(visibility);
                break;
            }
            case 7: {
                if (this.mFullScreenButton == null) break;
                this.mFullScreenButton.setVisibility(visibility);
                break;
            }
            case 8: {
                if (this.mOverflowButtonRight == null) break;
                this.mOverflowButtonRight.setVisibility(visibility);
                break;
            }
            case 9: {
                if (this.mMuteButton == null) break;
                this.mMuteButton.setVisibility(visibility);
                break;
            }
            case 11: {
                if (this.mSettingsButton == null) break;
                this.mSettingsButton.setVisibility(visibility);
                break;
            }
        }
    }

    public void requestPlayButtonFocus() {
        if (this.mPlayPauseButton != null) {
            this.mPlayPauseButton.requestFocus();
        }
    }

    public CharSequence getAccessibilityClassName() {
        return MediaControlView2.class.getName();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        return false;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        return false;
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mPrevWidth != this.getMeasuredWidth() || this.mPrevHeight != this.getMeasuredHeight() || this.mNeedUXUpdate) {
            this.mSettingsWindow.dismiss();
            if (this.mTransportControls.getWidth() == 0 || this.mTimeView.getWidth() == 0) {
                return;
            }
            int currWidth = this.getMeasuredWidth();
            int currHeight = this.getMeasuredHeight();
            WindowManager manager = (WindowManager)this.getContext().getApplicationContext().getSystemService("window");
            Point screenSize = new Point();
            manager.getDefaultDisplay().getSize(screenSize);
            int screenWidth = screenSize.x;
            int screenHeight = screenSize.y;
            int iconSize = this.mResources.getDimensionPixelSize(R.dimen.mcv2_icon_size);
            if (this.mMediaType == 0) {
                int maxIconCount = 4;
                this.updateLayout(maxIconCount, iconSize, currWidth, currHeight, screenWidth, screenHeight);
            } else if (this.mMediaType == 1) {
                if (this.mNeedUXUpdate) {
                    this.mBasicControls.removeView((View)this.mMuteButton);
                    this.mExtraControls.addView((View)this.mMuteButton, 0);
                    this.mVideoQualityButton.setVisibility(8);
                    if (this.mFfwdButton != null) {
                        this.mFfwdButton.setVisibility(8);
                    }
                    if (this.mRewButton != null) {
                        this.mRewButton.setVisibility(8);
                    }
                }
                this.mNeedUXUpdate = false;
                int maxIconCount = 3;
                this.updateLayout(maxIconCount, iconSize, currWidth, currHeight, screenWidth, screenHeight);
            }
            this.mPrevWidth = currWidth;
            this.mPrevHeight = currHeight;
        }
        this.updateTitleBarLayout();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.mPlayPauseButton != null) {
            this.mPlayPauseButton.setEnabled(enabled);
        }
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setEnabled(enabled);
        }
        if (this.mRewButton != null) {
            this.mRewButton.setEnabled(enabled);
        }
        if (this.mNextButton != null) {
            this.mNextButton.setEnabled(enabled);
        }
        if (this.mPrevButton != null) {
            this.mPrevButton.setEnabled(enabled);
        }
        if (this.mProgress != null) {
            this.mProgress.setEnabled(enabled);
        }
        this.disableUnsupportedButtons();
    }

    public void onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        if (isVisible) {
            this.disableUnsupportedButtons();
            this.removeCallbacks(this.mUpdateProgress);
            this.post(this.mUpdateProgress);
        } else {
            this.removeCallbacks(this.mUpdateProgress);
        }
    }

    void setRouteSelector(MediaRouteSelector selector) {
        this.mRouteSelector = selector;
        if (this.mRouteSelector != null && !this.mRouteSelector.isEmpty()) {
            this.mRouteButton.setRouteSelector(selector);
            this.mRouteButton.setVisibility(0);
        } else {
            this.mRouteButton.setRouteSelector(MediaRouteSelector.EMPTY);
            this.mRouteButton.setVisibility(8);
        }
    }

    private boolean isPlaying() {
        if (this.mPlaybackState != null) {
            return this.mPlaybackState.getState() == 3;
        }
        return false;
    }

    private int getCurrentPosition() {
        this.mPlaybackState = this.mController.getPlaybackState();
        if (this.mPlaybackState != null) {
            return (int)this.mPlaybackState.getPosition();
        }
        return 0;
    }

    private int getBufferPercentage() {
        if (this.mDuration == 0) {
            return 0;
        }
        this.mPlaybackState = this.mController.getPlaybackState();
        if (this.mPlaybackState != null) {
            long bufferedPos = this.mPlaybackState.getBufferedPosition();
            return bufferedPos == -1L ? -1 : (int)(bufferedPos * 100L / (long)this.mDuration);
        }
        return 0;
    }

    private boolean canPause() {
        if (this.mPlaybackState != null) {
            return (this.mPlaybackState.getActions() & 2L) != 0L;
        }
        return true;
    }

    private boolean canSeekBackward() {
        if (this.mPlaybackState != null) {
            return (this.mPlaybackState.getActions() & 8L) != 0L;
        }
        return true;
    }

    private boolean canSeekForward() {
        if (this.mPlaybackState != null) {
            return (this.mPlaybackState.getActions() & 0x40L) != 0L;
        }
        return true;
    }

    private ViewGroup makeControllerView() {
        ViewGroup root = (ViewGroup)this.inflateLayout(this.getContext(), R.layout.media_controller);
        this.initControllerView(root);
        return root;
    }

    private View inflateLayout(Context context, int resId) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        return inflater.inflate(resId, null);
    }

    private void initControllerView(ViewGroup v) {
        this.mTitleBar = v.findViewById(R.id.title_bar);
        this.mTitleView = (TextView)v.findViewById(R.id.title_text);
        this.mAdExternalLink = v.findViewById(R.id.ad_external_link);
        this.mBackButton = (ImageButton)v.findViewById(R.id.back);
        if (this.mBackButton != null) {
            this.mBackButton.setOnClickListener(this.mBackListener);
            this.mBackButton.setVisibility(8);
        }
        this.mRouteButton = (MediaRouteButton)v.findViewById(R.id.cast);
        this.mCenterView = (ViewGroup)v.findViewById(R.id.center_view);
        this.mTransportControls = this.inflateTransportControls(R.layout.embedded_transport_controls);
        this.mCenterView.addView(this.mTransportControls);
        this.mMinimalExtraView = (LinearLayout)v.findViewById(R.id.minimal_extra_view);
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mMinimalExtraView.getLayoutParams();
        int iconSize = this.mResources.getDimensionPixelSize(R.dimen.mcv2_icon_size);
        int marginSize = this.mResources.getDimensionPixelSize(R.dimen.mcv2_icon_margin);
        params.setMargins(0, (iconSize + marginSize * 2) * -1, 0, 0);
        this.mMinimalExtraView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mMinimalExtraView.setVisibility(8);
        this.mProgress = (ProgressBar)v.findViewById(R.id.progress);
        if (this.mProgress != null) {
            if (this.mProgress instanceof SeekBar) {
                SeekBar seeker = (SeekBar)this.mProgress;
                seeker.setOnSeekBarChangeListener(this.mSeekListener);
                seeker.setProgressDrawable(this.mResources.getDrawable(R.drawable.custom_progress));
                seeker.setThumb(this.mResources.getDrawable(R.drawable.custom_progress_thumb));
            }
            this.mProgress.setMax(1000);
        }
        this.mProgressBuffer = v.findViewById(R.id.progress_buffer);
        this.mBottomBar = (ViewGroup)v.findViewById(R.id.bottom_bar);
        this.mBottomBarLeftView = (ViewGroup)v.findViewById(R.id.bottom_bar_left);
        this.mTimeView = (ViewGroup)v.findViewById(R.id.time);
        this.mEndTime = (TextView)v.findViewById(R.id.time_end);
        this.mCurrentTime = (TextView)v.findViewById(R.id.time_current);
        this.mAdSkipView = (TextView)v.findViewById(R.id.ad_skip_time);
        this.mFormatBuilder = new StringBuilder();
        this.mFormatter = new Formatter(this.mFormatBuilder, Locale.getDefault());
        this.mBottomBarRightView = (ViewGroup)v.findViewById(R.id.bottom_bar_right);
        this.mBasicControls = (ViewGroup)v.findViewById(R.id.basic_controls);
        this.mExtraControls = (ViewGroup)v.findViewById(R.id.extra_controls);
        this.mCustomButtons = (ViewGroup)v.findViewById(R.id.custom_buttons);
        this.mSubtitleButton = (ImageButton)v.findViewById(R.id.subtitle);
        if (this.mSubtitleButton != null) {
            this.mSubtitleButton.setOnClickListener(this.mSubtitleListener);
        }
        this.mFullScreenButton = (ImageButton)v.findViewById(R.id.fullscreen);
        if (this.mFullScreenButton != null) {
            this.mFullScreenButton.setOnClickListener(this.mFullScreenListener);
        }
        this.mOverflowButtonRight = (ImageButton)v.findViewById(R.id.overflow_right);
        if (this.mOverflowButtonRight != null) {
            this.mOverflowButtonRight.setOnClickListener(this.mOverflowRightListener);
        }
        this.mOverflowButtonLeft = (ImageButton)v.findViewById(R.id.overflow_left);
        if (this.mOverflowButtonLeft != null) {
            this.mOverflowButtonLeft.setOnClickListener(this.mOverflowLeftListener);
        }
        this.mMuteButton = (ImageButton)v.findViewById(R.id.mute);
        if (this.mMuteButton != null) {
            this.mMuteButton.setOnClickListener(this.mMuteButtonListener);
        }
        this.mSettingsButton = (ImageButton)v.findViewById(R.id.settings);
        if (this.mSettingsButton != null) {
            this.mSettingsButton.setOnClickListener(this.mSettingsButtonListener);
        }
        this.mVideoQualityButton = (ImageButton)v.findViewById(R.id.video_quality);
        if (this.mVideoQualityButton != null) {
            this.mVideoQualityButton.setOnClickListener(this.mVideoQualityListener);
        }
        this.mAdRemainingView = (TextView)v.findViewById(R.id.ad_remaining);
        this.initializeSettingsLists();
        this.mSettingsListView = (ListView)this.inflateLayout(this.getContext(), R.layout.settings_list);
        this.mSettingsAdapter = new SettingsAdapter(this.mSettingsMainTextsList, this.mSettingsSubTextsList, this.mSettingsIconIdsList);
        this.mSubSettingsAdapter = new SubSettingsAdapter(null, 0);
        this.mSettingsListView.setAdapter((ListAdapter)this.mSettingsAdapter);
        this.mSettingsListView.setChoiceMode(1);
        this.mSettingsListView.setOnItemClickListener(this.mSettingsItemClickListener);
        this.mEmbeddedSettingsItemWidth = this.mResources.getDimensionPixelSize(R.dimen.mcv2_embedded_settings_width);
        this.mFullSettingsItemWidth = this.mResources.getDimensionPixelSize(R.dimen.mcv2_full_settings_width);
        this.mSettingsItemHeight = this.mResources.getDimensionPixelSize(R.dimen.mcv2_settings_height);
        this.mSettingsWindowMargin = -1 * this.mResources.getDimensionPixelSize(R.dimen.mcv2_settings_offset);
        this.mSettingsWindow = new PopupWindow((View)this.mSettingsListView, this.mEmbeddedSettingsItemWidth, -2, true);
    }

    private void disableUnsupportedButtons() {
        try {
            if (this.mPlayPauseButton != null && !this.canPause()) {
                this.mPlayPauseButton.setEnabled(false);
            }
            if (this.mRewButton != null && !this.canSeekBackward()) {
                this.mRewButton.setEnabled(false);
            }
            if (this.mFfwdButton != null && !this.canSeekForward()) {
                this.mFfwdButton.setEnabled(false);
            }
            if (this.mProgress != null && !this.canSeekBackward() && !this.canSeekForward()) {
                this.mProgress.setEnabled(false);
            }
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
    }

    private String stringForTime(int timeMs) {
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        this.mFormatBuilder.setLength(0);
        if (hours > 0) {
            return this.mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return this.mFormatter.format("%02d:%02d", minutes, seconds).toString();
    }

    private int setProgress() {
        if (this.mController == null || this.mDragging) {
            return 0;
        }
        int positionOnProgressBar = 0;
        int currentPosition = this.getCurrentPosition();
        if (this.mDuration > 0) {
            positionOnProgressBar = (int)(1000L * (long)currentPosition / (long)this.mDuration);
        }
        if (this.mProgress != null && currentPosition != this.mDuration) {
            this.mProgress.setProgress(positionOnProgressBar);
            if (this.getBufferPercentage() < 0) {
                this.mProgress.setSecondaryProgress(1000);
            } else {
                this.mProgress.setSecondaryProgress(this.getBufferPercentage() * 10);
            }
        }
        if (this.mEndTime != null) {
            this.mEndTime.setText((CharSequence)this.stringForTime(this.mDuration));
        }
        if (this.mCurrentTime != null) {
            this.mCurrentTime.setText((CharSequence)this.stringForTime(currentPosition));
        }
        if (this.mIsAdvertisement) {
            if (this.mAdSkipView != null) {
                if (currentPosition <= 5000) {
                    if (this.mAdSkipView.getVisibility() == 8) {
                        this.mAdSkipView.setVisibility(0);
                    }
                    String skipTimeText = this.mResources.getString(R.string.MediaControlView2_ad_skip_wait_time, new Object[]{(5000 - currentPosition) / 1000 + 1});
                    this.mAdSkipView.setText((CharSequence)skipTimeText);
                } else if (this.mAdSkipView.getVisibility() == 0) {
                    this.mAdSkipView.setVisibility(8);
                    this.mNextButton.setEnabled(true);
                    this.mNextButton.clearColorFilter();
                }
            }
            if (this.mAdRemainingView != null) {
                int remainingTime = this.mDuration - currentPosition < 0 ? 0 : this.mDuration - currentPosition;
                String remainingTimeText = this.mResources.getString(R.string.MediaControlView2_ad_remaining_time, new Object[]{this.stringForTime(remainingTime)});
                this.mAdRemainingView.setText((CharSequence)remainingTimeText);
            }
        }
        return currentPosition;
    }

    private void togglePausePlayState() {
        if (this.isPlaying()) {
            this.mControls.pause();
            this.mPlayPauseButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_play_circle_filled, null));
            this.mPlayPauseButton.setContentDescription((CharSequence)this.mResources.getString(R.string.mcv2_play_button_desc));
        } else {
            this.mControls.play();
            this.mPlayPauseButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_pause_circle_filled, null));
            this.mPlayPauseButton.setContentDescription((CharSequence)this.mResources.getString(R.string.mcv2_pause_button_desc));
        }
    }

    private void updateDuration() {
        if (this.mMetadata != null && this.mMetadata.containsKey("android.media.metadata.DURATION")) {
            this.mDuration = (int)this.mMetadata.getLong("android.media.metadata.DURATION");
            this.setProgress();
        }
    }

    private void updateTitle() {
        if (this.mMetadata != null && this.mMetadata.containsKey("android.media.metadata.TITLE")) {
            this.mTitleView.setText((CharSequence)this.mMetadata.getString("android.media.metadata.TITLE"));
        }
    }

    private void updateTitleBarLayout() {
        if (this.mTitleBar != null) {
            int titleBarWidth = this.mTitleBar.getWidth();
            View leftBar = this.mTitleBar.findViewById(R.id.title_bar_left);
            View rightBar = this.mTitleBar.findViewById(R.id.title_bar_right);
            int leftBarWidth = leftBar.getWidth();
            int rightBarWidth = rightBar.getWidth();
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)leftBar.getLayoutParams();
            if (leftBarWidth + rightBarWidth > titleBarWidth) {
                params.width = titleBarWidth - rightBarWidth;
                this.mOriginalLeftBarWidth = leftBarWidth;
            } else if (leftBarWidth + rightBarWidth < titleBarWidth && this.mOriginalLeftBarWidth != 0) {
                params.width = this.mOriginalLeftBarWidth;
                this.mOriginalLeftBarWidth = 0;
            }
            leftBar.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void updateAudioMetadata() {
        if (this.mMediaType != 1) {
            return;
        }
        if (this.mMetadata != null) {
            String titleText = RESOURCE_EMPTY;
            String artistText = RESOURCE_EMPTY;
            titleText = this.mMetadata.containsKey("android.media.metadata.TITLE") ? this.mMetadata.getString("android.media.metadata.TITLE") : this.mResources.getString(R.string.mcv2_music_title_unknown_text);
            artistText = this.mMetadata.containsKey("android.media.metadata.ARTIST") ? this.mMetadata.getString("android.media.metadata.ARTIST") : this.mResources.getString(R.string.mcv2_music_artist_unknown_text);
            this.mTitleView.setText((CharSequence)(titleText + " - " + artistText));
            this.mNeedUXUpdate = true;
        }
    }

    private void updateLayout() {
        if (this.mIsAdvertisement) {
            this.mRewButton.setVisibility(8);
            this.mFfwdButton.setVisibility(8);
            this.mPrevButton.setVisibility(8);
            this.mTimeView.setVisibility(8);
            this.mAdSkipView.setVisibility(0);
            this.mAdRemainingView.setVisibility(0);
            this.mAdExternalLink.setVisibility(0);
            this.mProgress.setEnabled(false);
            this.mNextButton.setEnabled(false);
            this.mNextButton.setColorFilter(R.color.gray);
        } else {
            this.mRewButton.setVisibility(0);
            this.mFfwdButton.setVisibility(0);
            this.mPrevButton.setVisibility(0);
            this.mTimeView.setVisibility(0);
            this.mAdSkipView.setVisibility(8);
            this.mAdRemainingView.setVisibility(8);
            this.mAdExternalLink.setVisibility(8);
            this.mProgress.setEnabled(true);
            this.mNextButton.setEnabled(true);
            this.mNextButton.clearColorFilter();
            this.disableUnsupportedButtons();
        }
    }

    private void updateLayout(int maxIconCount, int iconSize, int currWidth, int currHeight, int screenWidth, int screenHeight) {
        boolean isFullSize;
        int bottomBarRightWidthMax = iconSize * maxIconCount;
        int fullWidth = this.mTransportControls.getWidth() + this.mTimeView.getWidth() + bottomBarRightWidthMax;
        int embeddedWidth = this.mTimeView.getWidth() + bottomBarRightWidthMax;
        int screenMaxLength = Math.max(screenWidth, screenHeight);
        boolean bl = this.mMediaType == 0 ? currWidth == screenMaxLength : (isFullSize = currWidth == screenWidth && currHeight == screenHeight);
        if (isFullSize) {
            if (this.mSizeType != 1) {
                this.updateLayoutForSizeChange(1);
                if (this.mMediaType == 1) {
                    this.mTitleView.setVisibility(8);
                }
            }
        } else if (embeddedWidth <= currWidth) {
            if (this.mSizeType != 0) {
                this.updateLayoutForSizeChange(0);
                if (this.mMediaType == 1) {
                    this.mTitleView.setVisibility(0);
                }
            }
        } else if (this.mSizeType != 2) {
            this.updateLayoutForSizeChange(2);
            if (this.mMediaType == 1) {
                this.mTitleView.setVisibility(8);
            }
        }
    }

    private void updateLayoutForSizeChange(int sizeType) {
        this.mSizeType = sizeType;
        RelativeLayout.LayoutParams timeViewParams = (RelativeLayout.LayoutParams)this.mTimeView.getLayoutParams();
        SeekBar seeker = (SeekBar)this.mProgress;
        switch (this.mSizeType) {
            case 0: {
                this.mTitleBar.setVisibility(0);
                this.mBackButton.setVisibility(8);
                this.mTitleView.setPadding(this.mResources.getDimensionPixelSize(R.dimen.mcv2_embedded_icon_padding), this.mTitleView.getPaddingTop(), this.mTitleView.getPaddingRight(), this.mTitleView.getPaddingBottom());
                this.mMinimalExtraView.setVisibility(8);
                this.mFullScreenButton = (ImageButton)this.mBottomBarRightView.findViewById(R.id.fullscreen);
                this.mFullScreenButton.setOnClickListener(this.mFullScreenListener);
                this.mCenterView.removeAllViews();
                this.mBottomBarLeftView.removeView(this.mTransportControls);
                this.mBottomBarLeftView.setVisibility(8);
                this.mTransportControls = this.inflateTransportControls(R.layout.embedded_transport_controls);
                this.mCenterView.addView(this.mTransportControls);
                seeker.setThumb(this.mResources.getDrawable(R.drawable.custom_progress_thumb));
                this.mProgressBuffer.setVisibility(0);
                this.mBottomBar.setVisibility(0);
                if (timeViewParams.getRules()[0] == 0) break;
                timeViewParams.removeRule(0);
                timeViewParams.addRule(1, R.id.bottom_bar_left);
                break;
            }
            case 1: {
                this.mTitleBar.setVisibility(0);
                this.mBackButton.setVisibility(0);
                this.mTitleView.setPadding(0, this.mTitleView.getPaddingTop(), this.mTitleView.getPaddingRight(), this.mTitleView.getPaddingBottom());
                this.mMinimalExtraView.setVisibility(8);
                this.mFullScreenButton = (ImageButton)this.mBottomBarRightView.findViewById(R.id.fullscreen);
                this.mFullScreenButton.setOnClickListener(this.mFullScreenListener);
                this.mCenterView.removeAllViews();
                this.mBottomBarLeftView.removeView(this.mTransportControls);
                this.mTransportControls = this.inflateTransportControls(R.layout.full_transport_controls);
                this.mBottomBarLeftView.addView(this.mTransportControls, 0);
                this.mBottomBarLeftView.setVisibility(0);
                seeker.setThumb(this.mResources.getDrawable(R.drawable.custom_progress_thumb));
                this.mProgressBuffer.setVisibility(0);
                this.mBottomBar.setVisibility(0);
                if (timeViewParams.getRules()[1] == 0) break;
                timeViewParams.removeRule(1);
                timeViewParams.addRule(0, R.id.bottom_bar_right);
                break;
            }
            case 2: {
                this.mTitleBar.setVisibility(8);
                this.mBackButton.setVisibility(8);
                this.mMinimalExtraView.setVisibility(0);
                this.mFullScreenButton = (ImageButton)this.mMinimalExtraView.findViewById(R.id.minimal_fullscreen);
                this.mFullScreenButton.setOnClickListener(this.mFullScreenListener);
                this.mCenterView.removeAllViews();
                this.mBottomBarLeftView.removeView(this.mTransportControls);
                this.mTransportControls = this.inflateTransportControls(R.layout.minimal_transport_controls);
                this.mCenterView.addView(this.mTransportControls);
                seeker.setThumb(null);
                this.mProgressBuffer.setVisibility(8);
                this.mBottomBar.setVisibility(8);
            }
        }
        this.mTimeView.setLayoutParams((ViewGroup.LayoutParams)timeViewParams);
        if (this.isPlaying()) {
            this.mPlayPauseButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_pause_circle_filled, null));
            this.mPlayPauseButton.setContentDescription((CharSequence)this.mResources.getString(R.string.mcv2_pause_button_desc));
        } else {
            this.mPlayPauseButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_play_circle_filled, null));
            this.mPlayPauseButton.setContentDescription((CharSequence)this.mResources.getString(R.string.mcv2_play_button_desc));
        }
        if (this.mIsFullScreen) {
            this.mFullScreenButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_fullscreen_exit, null));
        } else {
            this.mFullScreenButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_fullscreen, null));
        }
    }

    private View inflateTransportControls(int layoutId) {
        View v = this.inflateLayout(this.getContext(), layoutId);
        this.mPlayPauseButton = (ImageButton)v.findViewById(R.id.pause);
        if (this.mPlayPauseButton != null) {
            this.mPlayPauseButton.requestFocus();
            this.mPlayPauseButton.setOnClickListener(this.mPlayPauseListener);
        }
        this.mFfwdButton = (ImageButton)v.findViewById(R.id.ffwd);
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setOnClickListener(this.mFfwdListener);
            if (this.mMediaType == 1) {
                this.mFfwdButton.setVisibility(8);
            }
        }
        this.mRewButton = (ImageButton)v.findViewById(R.id.rew);
        if (this.mRewButton != null) {
            this.mRewButton.setOnClickListener(this.mRewListener);
            if (this.mMediaType == 1) {
                this.mRewButton.setVisibility(8);
            }
        }
        this.mNextButton = (ImageButton)v.findViewById(R.id.next);
        if (this.mNextButton != null) {
            this.mNextButton.setOnClickListener(this.mNextListener);
            this.mNextButton.setVisibility(8);
        }
        this.mPrevButton = (ImageButton)v.findViewById(R.id.prev);
        if (this.mPrevButton != null) {
            this.mPrevButton.setOnClickListener(this.mPrevListener);
            this.mPrevButton.setVisibility(8);
        }
        return v;
    }

    private void initializeSettingsLists() {
        this.mSettingsMainTextsList = new ArrayList<String>();
        this.mSettingsMainTextsList.add(this.mResources.getString(R.string.MediaControlView2_audio_track_text));
        this.mSettingsMainTextsList.add(this.mResources.getString(R.string.MediaControlView2_playback_speed_text));
        this.mSettingsMainTextsList.add(this.mResources.getString(R.string.MediaControlView2_help_text));
        this.mSettingsSubTextsList = new ArrayList<String>();
        this.mSettingsSubTextsList.add(this.mResources.getString(R.string.MediaControlView2_audio_track_none_text));
        this.mSettingsSubTextsList.add(this.mResources.getStringArray(R.array.MediaControlView2_playback_speeds)[3]);
        this.mSettingsSubTextsList.add(RESOURCE_EMPTY);
        this.mSettingsIconIdsList = new ArrayList<Integer>();
        this.mSettingsIconIdsList.add(R.drawable.ic_audiotrack);
        this.mSettingsIconIdsList.add(R.drawable.ic_play_circle_filled);
        this.mSettingsIconIdsList.add(R.drawable.ic_help);
        this.mAudioTrackList = new ArrayList<String>();
        this.mAudioTrackList.add(this.mResources.getString(R.string.MediaControlView2_audio_track_none_text));
        this.mVideoQualityList = new ArrayList<String>();
        this.mVideoQualityList.add(this.mResources.getString(R.string.MediaControlView2_video_quality_auto_text));
        this.mPlaybackSpeedTextList = new ArrayList<String>(Arrays.asList(this.mResources.getStringArray(R.array.MediaControlView2_playback_speeds)));
        this.mSelectedSpeedIndex = 3;
        this.mPlaybackSpeedList = new ArrayList<Float>();
        int[] speeds = this.mResources.getIntArray(R.array.speed_multiplied_by_100);
        for (int i = 0; i < speeds.length; ++i) {
            float speed = (float)speeds[i] / 100.0f;
            this.mPlaybackSpeedList.add(Float.valueOf(speed));
        }
    }

    private void displaySettingsWindow(BaseAdapter adapter) {
        this.mSettingsListView.setAdapter((ListAdapter)adapter);
        int itemWidth = this.mSizeType == 0 ? this.mEmbeddedSettingsItemWidth : this.mFullSettingsItemWidth;
        this.mSettingsWindow.setWidth(itemWidth);
        int totalHeight = adapter.getCount() * this.mSettingsItemHeight;
        this.mSettingsWindow.dismiss();
        this.mSettingsWindow.showAsDropDown((View)this, this.mSettingsWindowMargin, this.mSettingsWindowMargin - totalHeight, 85);
    }

    private class SubSettingsAdapter
    extends BaseAdapter {
        private List<String> mTexts;
        private int mCheckPosition;

        SubSettingsAdapter(List<String> texts, int checkPosition) {
            this.mTexts = texts;
            this.mCheckPosition = checkPosition;
        }

        public String getMainText(int position) {
            if (this.mTexts != null && position < this.mTexts.size()) {
                return this.mTexts.get(position);
            }
            return MediaControlView2.RESOURCE_EMPTY;
        }

        public int getCount() {
            return this.mTexts == null ? 0 : this.mTexts.size();
        }

        public long getItemId(int position) {
            return 0L;
        }

        public Object getItem(int position) {
            return null;
        }

        public View getView(int position, View convertView, ViewGroup container) {
            View row = MediaControlView2.this.mSizeType == 1 ? MediaControlView2.this.inflateLayout(MediaControlView2.this.getContext(), R.layout.full_sub_settings_list_item) : MediaControlView2.this.inflateLayout(MediaControlView2.this.getContext(), R.layout.embedded_sub_settings_list_item);
            TextView textView = (TextView)row.findViewById(R.id.text);
            ImageView checkView = (ImageView)row.findViewById(R.id.check);
            textView.setText((CharSequence)this.mTexts.get(position));
            if (position != this.mCheckPosition) {
                checkView.setVisibility(4);
            }
            return row;
        }

        public void setTexts(List<String> texts) {
            this.mTexts = texts;
        }

        public void setCheckPosition(int checkPosition) {
            this.mCheckPosition = checkPosition;
        }
    }

    private class SettingsAdapter
    extends BaseAdapter {
        private List<Integer> mIconIds;
        private List<String> mMainTexts;
        private List<String> mSubTexts;

        SettingsAdapter(@Nullable List<String> mainTexts, @Nullable List<String> subTexts, List<Integer> iconIds) {
            this.mMainTexts = mainTexts;
            this.mSubTexts = subTexts;
            this.mIconIds = iconIds;
        }

        public void updateSubTexts(List<String> subTexts) {
            this.mSubTexts = subTexts;
            this.notifyDataSetChanged();
        }

        public String getMainText(int position) {
            if (this.mMainTexts != null && position < this.mMainTexts.size()) {
                return this.mMainTexts.get(position);
            }
            return MediaControlView2.RESOURCE_EMPTY;
        }

        public int getCount() {
            return this.mMainTexts == null ? 0 : this.mMainTexts.size();
        }

        public long getItemId(int position) {
            return 0L;
        }

        public Object getItem(int position) {
            return null;
        }

        public View getView(int position, View convertView, ViewGroup container) {
            View row = MediaControlView2.this.mSizeType == 1 ? MediaControlView2.this.inflateLayout(MediaControlView2.this.getContext(), R.layout.full_settings_list_item) : MediaControlView2.this.inflateLayout(MediaControlView2.this.getContext(), R.layout.embedded_settings_list_item);
            TextView mainTextView = (TextView)row.findViewById(R.id.main_text);
            TextView subTextView = (TextView)row.findViewById(R.id.sub_text);
            ImageView iconView = (ImageView)row.findViewById(R.id.icon);
            mainTextView.setText((CharSequence)this.mMainTexts.get(position));
            if (this.mSubTexts == null || MediaControlView2.RESOURCE_EMPTY.equals(this.mSubTexts.get(position))) {
                subTextView.setVisibility(8);
            } else {
                subTextView.setText((CharSequence)this.mSubTexts.get(position));
            }
            if (this.mIconIds == null || this.mIconIds.get(position) == -1) {
                iconView.setVisibility(8);
            } else {
                iconView.setImageDrawable(MediaControlView2.this.mResources.getDrawable(this.mIconIds.get(position).intValue(), null));
            }
            return row;
        }

        public void setSubTexts(List<String> subTexts) {
            this.mSubTexts = subTexts;
        }
    }

    private class MediaControllerCallback
    extends MediaControllerCompat.Callback {
        private MediaControllerCallback() {
        }

        public void onPlaybackStateChanged(PlaybackStateCompat state) {
            MediaControlView2.this.mPlaybackState = state;
            if (MediaControlView2.this.mPlaybackState.getState() != MediaControlView2.this.mPrevState) {
                switch (MediaControlView2.this.mPlaybackState.getState()) {
                    case 3: {
                        MediaControlView2.this.mPlayPauseButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_pause_circle_filled, null));
                        MediaControlView2.this.mPlayPauseButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_pause_button_desc));
                        MediaControlView2.this.removeCallbacks(MediaControlView2.this.mUpdateProgress);
                        MediaControlView2.this.post(MediaControlView2.this.mUpdateProgress);
                        break;
                    }
                    case 2: {
                        MediaControlView2.this.mPlayPauseButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_play_circle_filled, null));
                        MediaControlView2.this.mPlayPauseButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_play_button_desc));
                        break;
                    }
                    case 1: {
                        MediaControlView2.this.mPlayPauseButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_replay_circle_filled, null));
                        MediaControlView2.this.mPlayPauseButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_replay_button_desc));
                        MediaControlView2.this.mIsStopped = true;
                        break;
                    }
                }
                MediaControlView2.this.mPrevState = MediaControlView2.this.mPlaybackState.getState();
            }
            if (MediaControlView2.this.mPlaybackActions != MediaControlView2.this.mPlaybackState.getActions()) {
                long newActions = MediaControlView2.this.mPlaybackState.getActions();
                if ((newActions & 2L) != 0L) {
                    MediaControlView2.this.mPlayPauseButton.setVisibility(0);
                }
                if ((newActions & 8L) != 0L && MediaControlView2.this.mMediaType != 1 && MediaControlView2.this.mRewButton != null) {
                    MediaControlView2.this.mRewButton.setVisibility(0);
                }
                if ((newActions & 0x40L) != 0L && MediaControlView2.this.mMediaType != 1 && MediaControlView2.this.mFfwdButton != null) {
                    MediaControlView2.this.mFfwdButton.setVisibility(0);
                }
                if ((newActions & 0x100L) != 0L) {
                    MediaControlView2.this.mSeekAvailable = true;
                } else {
                    MediaControlView2.this.mSeekAvailable = false;
                }
                MediaControlView2.this.mPlaybackActions = newActions;
            }
            List customActions = MediaControlView2.this.mPlaybackState.getCustomActions();
            MediaControlView2.this.mCustomButtons.removeAllViews();
            if (customActions.size() > 0) {
                for (final PlaybackStateCompat.CustomAction action : customActions) {
                    ImageButton button = new ImageButton(MediaControlView2.this.getContext(), null, 0);
                    button.setImageResource(action.getIcon());
                    final String actionString = action.getAction().toString();
                    button.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            MediaControlView2.this.mControls.sendCustomAction(actionString, action.getExtras());
                            MediaControlView2.this.setVisibility(0);
                        }
                    });
                    MediaControlView2.this.mCustomButtons.addView((View)button);
                }
            }
        }

        public void onMetadataChanged(MediaMetadataCompat metadata) {
            MediaControlView2.this.mMetadata = metadata;
            MediaControlView2.this.updateDuration();
            MediaControlView2.this.updateTitle();
            MediaControlView2.this.updateAudioMetadata();
        }

        public void onSessionEvent(String event, Bundle extras) {
            switch (event) {
                case "UpdateTrackStatus": {
                    String track;
                    int i;
                    MediaControlView2.this.mVideoTrackCount = extras.getInt(MediaControlView2.KEY_VIDEO_TRACK_COUNT);
                    MediaControlView2.this.mAudioTrackCount = extras.getInt(MediaControlView2.KEY_AUDIO_TRACK_COUNT);
                    MediaControlView2.this.mAudioTrackList = new ArrayList();
                    if (MediaControlView2.this.mAudioTrackCount > 0) {
                        for (i = 0; i < MediaControlView2.this.mAudioTrackCount; ++i) {
                            track = MediaControlView2.this.mResources.getString(R.string.MediaControlView2_audio_track_number_text, new Object[]{i + 1});
                            MediaControlView2.this.mAudioTrackList.add(track);
                        }
                        MediaControlView2.this.mSettingsSubTextsList.set(0, MediaControlView2.this.mAudioTrackList.get(0));
                    } else {
                        MediaControlView2.this.mAudioTrackList.add(MediaControlView2.this.mResources.getString(R.string.MediaControlView2_audio_track_none_text));
                    }
                    if (MediaControlView2.this.mVideoTrackCount == 0 && MediaControlView2.this.mAudioTrackCount > 0) {
                        MediaControlView2.this.mMediaType = 1;
                    }
                    MediaControlView2.this.mSubtitleTrackCount = extras.getInt(MediaControlView2.KEY_SUBTITLE_TRACK_COUNT);
                    MediaControlView2.this.mSubtitleDescriptionsList = new ArrayList();
                    if (MediaControlView2.this.mSubtitleTrackCount > 0) {
                        MediaControlView2.this.mSubtitleButton.setVisibility(0);
                        MediaControlView2.this.mSubtitleButton.setEnabled(true);
                        MediaControlView2.this.mSubtitleDescriptionsList.add(MediaControlView2.this.mResources.getString(R.string.MediaControlView2_subtitle_off_text));
                        for (i = 0; i < MediaControlView2.this.mSubtitleTrackCount; ++i) {
                            track = MediaControlView2.this.mResources.getString(R.string.MediaControlView2_subtitle_track_number_text, new Object[]{i + 1});
                            MediaControlView2.this.mSubtitleDescriptionsList.add(track);
                        }
                        break;
                    }
                    MediaControlView2.this.mSubtitleButton.setVisibility(8);
                    MediaControlView2.this.mSubtitleButton.setEnabled(false);
                    break;
                }
                case "UpdateMediaTypeStatus": {
                    boolean newStatus = extras.getBoolean(MediaControlView2.KEY_STATE_IS_ADVERTISEMENT);
                    if (newStatus == MediaControlView2.this.mIsAdvertisement) break;
                    MediaControlView2.this.mIsAdvertisement = newStatus;
                    MediaControlView2.this.updateLayout();
                }
            }
        }
    }

    public static interface OnFullScreenListener {
        public void onFullScreen(View var1, boolean var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Button {
    }
}

