/*
 * Decompiled with CFR 0.152.
 */
package androidx.media.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Looper;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media.subtitle.SubtitleController;
import androidx.media.subtitle.SubtitleTrack;
import androidx.media.widget.BaseLayout;

@RequiresApi(value=21)
class SubtitleView
extends BaseLayout
implements SubtitleController.Anchor {
    private static final String TAG = "SubtitleView";
    private SubtitleTrack.RenderingWidget mSubtitleWidget;
    private SubtitleTrack.RenderingWidget.OnChangedListener mSubtitlesChangedListener;

    SubtitleView(Context context) {
        this(context, null);
    }

    SubtitleView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    SubtitleView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    SubtitleView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void setSubtitleWidget(SubtitleTrack.RenderingWidget subtitleWidget) {
        if (this.mSubtitleWidget == subtitleWidget) {
            return;
        }
        boolean attachedToWindow = this.isAttachedToWindow();
        if (this.mSubtitleWidget != null) {
            if (attachedToWindow) {
                this.mSubtitleWidget.onDetachedFromWindow();
            }
            this.mSubtitleWidget.setOnChangedListener(null);
        }
        this.mSubtitleWidget = subtitleWidget;
        if (subtitleWidget != null) {
            if (this.mSubtitlesChangedListener == null) {
                this.mSubtitlesChangedListener = new SubtitleTrack.RenderingWidget.OnChangedListener(){

                    public void onChanged(SubtitleTrack.RenderingWidget renderingWidget) {
                        SubtitleView.this.invalidate();
                    }
                };
            }
            this.setWillNotDraw(false);
            subtitleWidget.setOnChangedListener(this.mSubtitlesChangedListener);
            if (attachedToWindow) {
                subtitleWidget.onAttachedToWindow();
                this.requestLayout();
            }
        } else {
            this.setWillNotDraw(true);
        }
        this.invalidate();
    }

    public Looper getSubtitleLooper() {
        return Looper.getMainLooper();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mSubtitleWidget != null) {
            this.mSubtitleWidget.onAttachedToWindow();
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mSubtitleWidget != null) {
            this.mSubtitleWidget.onDetachedFromWindow();
        }
    }

    @Override
    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mSubtitleWidget != null) {
            int width = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
            int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            this.mSubtitleWidget.setSize(width, height);
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mSubtitleWidget != null) {
            int saveCount = canvas.save();
            canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            this.mSubtitleWidget.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
    }

    public CharSequence getAccessibilityClassName() {
        return SubtitleView.class.getName();
    }
}

