/*
 * Decompiled with CFR 0.152.
 */
package androidx.media.widget;

import android.content.Context;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.media.AudioAttributesCompat;
import androidx.media.DataSourceDesc;
import androidx.media.MediaItem2;
import androidx.media.MediaMetadata2;
import androidx.media.SessionToken2;
import androidx.media.widget.BaseLayout;
import androidx.media.widget.MediaControlView2;
import androidx.media.widget.VideoView2Impl;
import androidx.media.widget.VideoView2ImplApi28WithMp1;
import androidx.media.widget.VideoView2ImplBase;
import androidx.media.widget.VideoView2ImplBaseWithMp1;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public class VideoView2
extends BaseLayout {
    public static final int VIEW_TYPE_SURFACEVIEW = 0;
    public static final int VIEW_TYPE_TEXTUREVIEW = 1;
    private static final String TAG = "VideoView2";
    private static final boolean DEBUG = Log.isLoggable((String)"VideoView2", (int)3);
    private static final boolean USE_MP2 = Log.isLoggable((String)"VV2MP2", (int)3);
    private VideoView2Impl mImpl;

    public VideoView2(@NonNull Context context) {
        this(context, null);
    }

    public VideoView2(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VideoView2(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (Build.VERSION.SDK_INT >= 28) {
            if (USE_MP2) {
                Log.d((String)TAG, (String)"Create VideoView2ImplBase");
                this.mImpl = new VideoView2ImplBase();
            } else {
                Log.d((String)TAG, (String)"Create VideoView2ImplApi28WithMp1");
                this.mImpl = new VideoView2ImplApi28WithMp1();
            }
        } else {
            Log.d((String)TAG, (String)"Create VideoView2ImplBaseWithMp1");
            this.mImpl = new VideoView2ImplBaseWithMp1();
        }
        this.mImpl.initialize(this, context, attrs, defStyleAttr);
    }

    public void setMediaControlView2(MediaControlView2 mediaControlView, long intervalMs) {
        this.mImpl.setMediaControlView2(mediaControlView, intervalMs);
    }

    public MediaControlView2 getMediaControlView2() {
        return this.mImpl.getMediaControlView2();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setMediaMetadata(MediaMetadata2 metadata) {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MediaMetadata2 getMediaMetadata() {
        return this.mImpl.getMediaMetadata();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MediaControllerCompat getMediaController() {
        return this.mImpl.getMediaController();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SessionToken2 getMediaSessionToken() {
        return null;
    }

    public void setSubtitleEnabled(boolean enable) {
        this.mImpl.setSubtitleEnabled(enable);
    }

    public boolean isSubtitleEnabled() {
        return this.mImpl.isSubtitleEnabled();
    }

    public void setSpeed(float speed) {
        this.mImpl.setSpeed(speed);
    }

    public float getSpeed() {
        return this.mImpl.getSpeed();
    }

    public void setAudioFocusRequest(int focusGain) {
        this.mImpl.setAudioFocusRequest(focusGain);
    }

    public void setAudioAttributes(@NonNull AudioAttributes attributes) {
        this.mImpl.setAudioAttributes(AudioAttributesCompat.wrap((Object)attributes));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setAudioAttributes(@NonNull AudioAttributesCompat attributes) {
        this.mImpl.setAudioAttributes(attributes);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setVideoPath(String path) {
        this.mImpl.setVideoUri(Uri.parse((String)path));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setVideoUri(Uri uri) {
        this.mImpl.setVideoUri(uri, null);
    }

    public void setVideoUri(Uri uri, @Nullable Map<String, String> headers) {
        this.mImpl.setVideoUri(uri, headers);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setMediaItem(@NonNull MediaItem2 mediaItem) {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setDataSource(@NonNull DataSourceDesc dataSource) {
    }

    public void setViewType(int viewType) {
        this.mImpl.setViewType(viewType);
    }

    public int getViewType() {
        return this.mImpl.getViewType();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setCustomActions(List<PlaybackStateCompat.CustomAction> actionList, Executor executor, OnCustomActionListener listener) {
        this.mImpl.setCustomActions(actionList, executor, listener);
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setOnViewTypeChangedListener(OnViewTypeChangedListener l) {
        this.mImpl.setOnViewTypeChangedListener(l);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mImpl.onAttachedToWindowImpl();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mImpl.onDetachedFromWindowImpl();
    }

    public CharSequence getAccessibilityClassName() {
        return VideoView2.class.getName();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.mImpl.onTouchEventImpl(ev);
        return super.onTouchEvent(ev);
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        this.mImpl.onTrackballEventImpl(ev);
        return super.onTrackballEvent(ev);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mImpl.onMeasureImpl(widthMeasureSpec, heightMeasureSpec);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface OnCustomActionListener {
        public void onCustomAction(String var1, Bundle var2);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface OnViewTypeChangedListener {
        public void onViewTypeChanged(View var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ViewType {
    }
}

