/*
 * Decompiled with CFR 0.152.
 */
package androidx.media.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.AudioAttributes;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.media.MediaMetadataRetriever;
import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.media.AudioAttributesCompat;
import androidx.media.DataSourceDesc;
import androidx.media.MediaItem2;
import androidx.media.MediaMetadata2;
import androidx.media.SessionToken2;
import androidx.media.widget.MediaControlView2;
import androidx.media.widget.R;
import androidx.media.widget.RoutePlayer;
import androidx.media.widget.VideoSurfaceViewWithMp1;
import androidx.media.widget.VideoTextureViewWithMp1;
import androidx.media.widget.VideoView2;
import androidx.media.widget.VideoView2Impl;
import androidx.media.widget.VideoViewInterfaceWithMp1;
import androidx.mediarouter.media.MediaItemStatus;
import androidx.mediarouter.media.MediaRouteSelector;
import androidx.mediarouter.media.MediaRouter;
import androidx.palette.graphics.Palette;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
class VideoView2ImplBaseWithMp1
implements VideoView2Impl,
VideoViewInterfaceWithMp1.SurfaceListener {
    private static final String TAG = "VideoView2ImplBase_1";
    private static final boolean DEBUG = Log.isLoggable((String)"VideoView2ImplBase_1", (int)3);
    private static final long DEFAULT_SHOW_CONTROLLER_INTERVAL_MS = 2000L;
    private static final int STATE_ERROR = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PREPARING = 1;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_PAUSED = 4;
    private static final int STATE_PLAYBACK_COMPLETED = 5;
    private static final int INVALID_TRACK_INDEX = -1;
    private static final float INVALID_SPEED = 0.0f;
    private static final int SIZE_TYPE_EMBEDDED = 0;
    private static final int SIZE_TYPE_FULL = 1;
    private static final int SIZE_TYPE_MINIMAL = 2;
    private AccessibilityManager mAccessibilityManager;
    private AudioManager mAudioManager;
    private AudioAttributes mAudioAttributes;
    private int mAudioFocusType = 1;
    private boolean mAudioFocused = false;
    private Pair<Executor, VideoView2.OnCustomActionListener> mCustomActionListenerRecord;
    private VideoView2.OnViewTypeChangedListener mViewTypeChangedListener;
    private VideoViewInterfaceWithMp1 mCurrentView;
    private VideoTextureViewWithMp1 mTextureView;
    private VideoSurfaceViewWithMp1 mSurfaceView;
    protected MediaPlayer mMediaPlayer;
    private DataSourceDesc mDsd;
    private Uri mUri;
    private Map<String, String> mHeaders;
    private MediaControlView2 mMediaControlView;
    protected MediaSessionCompat mMediaSession;
    private MediaControllerCompat mMediaController;
    private MediaMetadata2 mMediaMetadata;
    private MediaMetadataRetriever mRetriever;
    private boolean mNeedUpdateMediaType;
    private Bundle mMediaTypeData;
    private String mTitle;
    private WindowManager mManager;
    private Resources mResources;
    private View mMusicView;
    private Drawable mMusicAlbumDrawable;
    private String mMusicTitleText;
    private String mMusicArtistText;
    private int mPrevWidth;
    private int mPrevHeight;
    private int mDominantColor;
    private int mSizeType;
    private PlaybackStateCompat.Builder mStateBuilder;
    private List<PlaybackStateCompat.CustomAction> mCustomActionList;
    private int mTargetState = 0;
    private int mCurrentState = 0;
    private int mCurrentBufferPercentage;
    private long mSeekWhenPrepared;
    private int mVideoWidth;
    private int mVideoHeight;
    protected ArrayList<Integer> mVideoTrackIndices;
    protected ArrayList<Integer> mAudioTrackIndices;
    protected int mSelectedVideoTrackIndex;
    protected int mSelectedAudioTrackIndex;
    private float mSpeed;
    private float mFallbackSpeed;
    private float mVolumeLevelFloat;
    private int mVolumeLevel;
    protected VideoView2 mInstance;
    private long mShowControllerIntervalMs;
    private MediaRouter mMediaRouter;
    private MediaRouteSelector mRouteSelector;
    private MediaRouter.RouteInfo mRoute;
    private RoutePlayer mRoutePlayer;
    private final MediaRouter.Callback mRouterCallback = new MediaRouter.Callback(){

        public void onRouteSelected(MediaRouter router, MediaRouter.RouteInfo route) {
            if (route.supportsControlCategory("android.media.intent.category.REMOTE_PLAYBACK")) {
                VideoView2ImplBaseWithMp1.this.resetPlayer();
                VideoView2ImplBaseWithMp1.this.mRoute = route;
                VideoView2ImplBaseWithMp1.this.mRoutePlayer = new RoutePlayer(VideoView2ImplBaseWithMp1.this.mInstance.getContext(), route);
                VideoView2ImplBaseWithMp1.this.mRoutePlayer.setPlayerEventCallback(new RoutePlayer.PlayerEventCallback(){

                    @Override
                    public void onPlayerStateChanged(MediaItemStatus itemStatus) {
                        PlaybackStateCompat.Builder psBuilder = new PlaybackStateCompat.Builder();
                        psBuilder.setActions(334L);
                        long position = itemStatus.getContentPosition();
                        switch (itemStatus.getPlaybackState()) {
                            case 0: {
                                psBuilder.setState(0, position, 0.0f);
                                VideoView2ImplBaseWithMp1.this.mCurrentState = 0;
                                break;
                            }
                            case 1: {
                                psBuilder.setState(3, position, 1.0f);
                                VideoView2ImplBaseWithMp1.this.mCurrentState = 3;
                                break;
                            }
                            case 2: {
                                psBuilder.setState(2, position, 0.0f);
                                VideoView2ImplBaseWithMp1.this.mCurrentState = 4;
                                break;
                            }
                            case 3: {
                                psBuilder.setState(6, position, 0.0f);
                                VideoView2ImplBaseWithMp1.this.mCurrentState = 4;
                                break;
                            }
                            case 4: {
                                psBuilder.setState(1, position, 0.0f);
                                VideoView2ImplBaseWithMp1.this.mCurrentState = 5;
                            }
                        }
                        PlaybackStateCompat pbState = psBuilder.build();
                        VideoView2ImplBaseWithMp1.this.mMediaSession.setPlaybackState(pbState);
                        MediaMetadataCompat.Builder mmBuilder = new MediaMetadataCompat.Builder();
                        mmBuilder.putLong("android.media.metadata.DURATION", itemStatus.getContentDuration());
                        VideoView2ImplBaseWithMp1.this.mMediaSession.setMetadata(mmBuilder.build());
                    }
                });
                VideoView2ImplBaseWithMp1.this.mRoutePlayer.openVideo(VideoView2ImplBaseWithMp1.this.mUri);
            }
        }

        public void onRouteUnselected(MediaRouter router, MediaRouter.RouteInfo route, int reason) {
            if (VideoView2ImplBaseWithMp1.this.mRoute != null && VideoView2ImplBaseWithMp1.this.mRoutePlayer != null) {
                VideoView2ImplBaseWithMp1.this.mRoutePlayer.release();
                VideoView2ImplBaseWithMp1.this.mRoutePlayer = null;
            }
            if (VideoView2ImplBaseWithMp1.this.mRoute == route) {
                VideoView2ImplBaseWithMp1.this.mRoute = null;
            }
            if (reason != 3) {
                VideoView2ImplBaseWithMp1.this.openVideo(VideoView2ImplBaseWithMp1.this.mUri, VideoView2ImplBaseWithMp1.this.mHeaders);
            }
        }
    };
    private AudioManager.OnAudioFocusChangeListener mAudioFocusListener = new AudioManager.OnAudioFocusChangeListener(){

        public void onAudioFocusChange(int focusChange) {
            switch (focusChange) {
                case 1: {
                    VideoView2ImplBaseWithMp1.this.mAudioFocused = true;
                    if (!VideoView2ImplBaseWithMp1.this.needToStart()) break;
                    VideoView2ImplBaseWithMp1.this.mMediaController.getTransportControls().play();
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    VideoView2ImplBaseWithMp1.this.mAudioFocused = false;
                    if (VideoView2ImplBaseWithMp1.this.isInPlaybackState() && VideoView2ImplBaseWithMp1.this.mMediaPlayer.isPlaying()) {
                        VideoView2ImplBaseWithMp1.this.mMediaController.getTransportControls().pause();
                        break;
                    }
                    VideoView2ImplBaseWithMp1.this.mTargetState = 4;
                }
            }
        }
    };
    private final Runnable mFadeOut = new Runnable(){

        @Override
        public void run() {
            if (VideoView2ImplBaseWithMp1.this.mCurrentState == 3) {
                VideoView2ImplBaseWithMp1.this.mMediaControlView.setVisibility(8);
            }
        }
    };
    private MediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            if (DEBUG) {
                Log.d((String)VideoView2ImplBaseWithMp1.TAG, (String)("onVideoSizeChanged(): size: " + width + "/" + height));
            }
            VideoView2ImplBaseWithMp1.this.mVideoWidth = mp.getVideoWidth();
            VideoView2ImplBaseWithMp1.this.mVideoHeight = mp.getVideoHeight();
            if (DEBUG) {
                Log.d((String)VideoView2ImplBaseWithMp1.TAG, (String)("onVideoSizeChanged(): mVideoSize:" + VideoView2ImplBaseWithMp1.this.mVideoWidth + "/" + VideoView2ImplBaseWithMp1.this.mVideoHeight));
            }
            if (VideoView2ImplBaseWithMp1.this.mVideoWidth != 0 && VideoView2ImplBaseWithMp1.this.mVideoHeight != 0) {
                VideoView2ImplBaseWithMp1.this.mInstance.requestLayout();
            }
        }
    };
    private MediaPlayer.OnPreparedListener mPreparedListener = new MediaPlayer.OnPreparedListener(){

        public void onPrepared(MediaPlayer mp) {
            if (DEBUG) {
                Log.d((String)VideoView2ImplBaseWithMp1.TAG, (String)("OnPreparedListener(). mCurrentState=" + VideoView2ImplBaseWithMp1.this.mCurrentState + ", mTargetState=" + VideoView2ImplBaseWithMp1.this.mTargetState));
            }
            VideoView2ImplBaseWithMp1.this.mCurrentState = 2;
            VideoView2ImplBaseWithMp1.this.updatePlaybackState();
            if (VideoView2ImplBaseWithMp1.this.mMediaSession != null) {
                VideoView2ImplBaseWithMp1.this.extractTracks();
                VideoView2ImplBaseWithMp1.this.extractMetadata();
                VideoView2ImplBaseWithMp1.this.extractAudioMetadata();
            }
            if (VideoView2ImplBaseWithMp1.this.mMediaControlView != null) {
                VideoView2ImplBaseWithMp1.this.mMediaControlView.setEnabled(true);
            }
            int videoWidth = mp.getVideoWidth();
            int videoHeight = mp.getVideoHeight();
            long seekToPosition = VideoView2ImplBaseWithMp1.this.mSeekWhenPrepared;
            if (seekToPosition != 0L) {
                VideoView2ImplBaseWithMp1.this.mMediaController.getTransportControls().seekTo(seekToPosition);
            }
            if (videoWidth != 0 && videoHeight != 0) {
                if (videoWidth != VideoView2ImplBaseWithMp1.this.mVideoWidth || videoHeight != VideoView2ImplBaseWithMp1.this.mVideoHeight) {
                    VideoView2ImplBaseWithMp1.this.mVideoWidth = videoWidth;
                    VideoView2ImplBaseWithMp1.this.mVideoHeight = videoHeight;
                    VideoView2ImplBaseWithMp1.this.mInstance.requestLayout();
                }
                if (VideoView2ImplBaseWithMp1.this.needToStart()) {
                    VideoView2ImplBaseWithMp1.this.mMediaController.getTransportControls().play();
                }
            } else if (VideoView2ImplBaseWithMp1.this.needToStart()) {
                VideoView2ImplBaseWithMp1.this.mMediaController.getTransportControls().play();
            }
            MediaMetadataCompat.Builder builder = new MediaMetadataCompat.Builder();
            builder.putString("android.media.metadata.TITLE", VideoView2ImplBaseWithMp1.this.mTitle);
            builder.putLong("android.media.metadata.DURATION", (long)VideoView2ImplBaseWithMp1.this.mMediaPlayer.getDuration());
            if (VideoView2ImplBaseWithMp1.this.mMediaSession != null) {
                VideoView2ImplBaseWithMp1.this.mMediaSession.setMetadata(builder.build());
                if (VideoView2ImplBaseWithMp1.this.mNeedUpdateMediaType) {
                    VideoView2ImplBaseWithMp1.this.mMediaSession.sendSessionEvent("UpdateMediaTypeStatus", VideoView2ImplBaseWithMp1.this.mMediaTypeData);
                    VideoView2ImplBaseWithMp1.this.mNeedUpdateMediaType = false;
                }
            }
        }
    };
    private MediaPlayer.OnSeekCompleteListener mSeekCompleteListener = new MediaPlayer.OnSeekCompleteListener(){

        public void onSeekComplete(MediaPlayer mp) {
            VideoView2ImplBaseWithMp1.this.updatePlaybackState();
        }
    };
    private MediaPlayer.OnCompletionListener mCompletionListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            VideoView2ImplBaseWithMp1.this.mCurrentState = 5;
            VideoView2ImplBaseWithMp1.this.mTargetState = 5;
            VideoView2ImplBaseWithMp1.this.updatePlaybackState();
            if (VideoView2ImplBaseWithMp1.this.mAudioFocusType != 0) {
                VideoView2ImplBaseWithMp1.this.mAudioManager.abandonAudioFocus(null);
            }
        }
    };
    private MediaPlayer.OnInfoListener mInfoListener = new MediaPlayer.OnInfoListener(){

        public boolean onInfo(MediaPlayer mp, int what, int extra) {
            if (what == 802) {
                VideoView2ImplBaseWithMp1.this.extractTracks();
            }
            return true;
        }
    };
    private MediaPlayer.OnErrorListener mErrorListener = new MediaPlayer.OnErrorListener(){

        public boolean onError(MediaPlayer mp, int frameworkErr, int implErr) {
            if (DEBUG) {
                Log.d((String)VideoView2ImplBaseWithMp1.TAG, (String)("Error: " + frameworkErr + "," + implErr));
            }
            VideoView2ImplBaseWithMp1.this.mCurrentState = -1;
            VideoView2ImplBaseWithMp1.this.mTargetState = -1;
            VideoView2ImplBaseWithMp1.this.updatePlaybackState();
            if (VideoView2ImplBaseWithMp1.this.mMediaControlView != null) {
                VideoView2ImplBaseWithMp1.this.mMediaControlView.setVisibility(8);
            }
            return true;
        }
    };
    private MediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener = new MediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(MediaPlayer mp, int percent) {
            VideoView2ImplBaseWithMp1.this.mCurrentBufferPercentage = percent;
            VideoView2ImplBaseWithMp1.this.updatePlaybackState();
        }
    };

    VideoView2ImplBaseWithMp1() {
    }

    @Override
    public void initialize(VideoView2 instance, Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        int viewType;
        boolean enableControlView;
        this.mInstance = instance;
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.mFallbackSpeed = this.mSpeed = 1.0f;
        this.mShowControllerIntervalMs = 2000L;
        this.mAccessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mAudioAttributes = new AudioAttributes.Builder().setUsage(1).setContentType(3).build();
        this.mInstance.setFocusable(true);
        this.mInstance.setFocusableInTouchMode(true);
        this.mInstance.requestFocus();
        this.mTextureView = new VideoTextureViewWithMp1(context);
        this.mSurfaceView = new VideoSurfaceViewWithMp1(context);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.mTextureView.setLayoutParams(params);
        this.mSurfaceView.setLayoutParams(params);
        this.mTextureView.setSurfaceListener(this);
        this.mSurfaceView.setSurfaceListener(this);
        this.mInstance.addView((View)this.mTextureView);
        this.mInstance.addView((View)this.mSurfaceView);
        boolean bl = enableControlView = attrs == null || attrs.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "enableControlView", true);
        if (enableControlView) {
            this.mMediaControlView = new MediaControlView2(context);
        }
        int n = viewType = attrs == null ? 0 : attrs.getAttributeIntValue("http://schemas.android.com/apk/res/android", "viewType", 0);
        if (viewType == 0) {
            Log.d((String)TAG, (String)"viewType attribute is surfaceView.");
            this.mTextureView.setVisibility(8);
            this.mSurfaceView.setVisibility(0);
            this.mCurrentView = this.mSurfaceView;
        } else if (viewType == 1) {
            Log.d((String)TAG, (String)"viewType attribute is textureView.");
            this.mTextureView.setVisibility(0);
            this.mSurfaceView.setVisibility(8);
            this.mCurrentView = this.mTextureView;
        }
        MediaRouteSelector.Builder builder = new MediaRouteSelector.Builder();
        builder.addControlCategory("android.media.intent.category.REMOTE_PLAYBACK");
        builder.addControlCategory("android.media.intent.category.LIVE_AUDIO");
        builder.addControlCategory("android.media.intent.category.LIVE_VIDEO");
        this.mRouteSelector = builder.build();
    }

    @Override
    public void setMediaControlView2(MediaControlView2 mediaControlView, long intervalMs) {
        this.mMediaControlView = mediaControlView;
        this.mShowControllerIntervalMs = intervalMs;
        this.mMediaControlView.setRouteSelector(this.mRouteSelector);
        if (this.mInstance.isAttachedToWindow()) {
            this.attachMediaControlView();
        }
    }

    @Override
    public MediaControlView2 getMediaControlView2() {
        return this.mMediaControlView;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setMediaMetadata(MediaMetadata2 metadata) {
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MediaMetadata2 getMediaMetadata() {
        return this.mMediaMetadata;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MediaControllerCompat getMediaController() {
        if (this.mMediaSession == null) {
            throw new IllegalStateException("MediaSession instance is not available.");
        }
        return this.mMediaController;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SessionToken2 getMediaSessionToken() {
        return null;
    }

    @Override
    public void setSubtitleEnabled(boolean enable) {
    }

    @Override
    public boolean isSubtitleEnabled() {
        return false;
    }

    @Override
    public void setSpeed(float speed) {
        if (speed <= 0.0f) {
            Log.e((String)TAG, (String)("Unsupported speed (" + speed + ") is ignored."));
            return;
        }
        this.mSpeed = speed;
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            this.applySpeed();
        }
        this.updatePlaybackState();
    }

    @Override
    public float getSpeed() {
        return this.mSpeed;
    }

    @Override
    public void setAudioFocusRequest(int focusGain) {
        if (focusGain != 0 && focusGain != 1 && focusGain != 2 && focusGain != 3 && focusGain != 4) {
            throw new IllegalArgumentException("Illegal audio focus type " + focusGain);
        }
        this.mAudioFocusType = focusGain;
    }

    @Override
    public void setAudioAttributes(@NonNull AudioAttributesCompat attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Illegal null AudioAttributesCompat");
        }
        this.mAudioAttributes = (AudioAttributes)attributes.unwrap();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setVideoPath(String path) {
        this.setVideoUri(Uri.parse((String)path));
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setVideoUri(Uri uri) {
        this.setVideoUri(uri, null);
    }

    @Override
    public void setVideoUri(Uri uri, @Nullable Map<String, String> headers) {
        this.mSeekWhenPrepared = 0L;
        this.openVideo(uri, headers);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setMediaItem(@NonNull MediaItem2 mediaItem) {
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setDataSource(@NonNull DataSourceDesc dataSource) {
    }

    @Override
    public void setViewType(int viewType) {
        VideoViewInterfaceWithMp1 targetView;
        if (viewType == this.mCurrentView.getViewType()) {
            return;
        }
        if (viewType == 1) {
            Log.d((String)TAG, (String)"switching to TextureView");
            targetView = this.mTextureView;
        } else if (viewType == 0) {
            Log.d((String)TAG, (String)"switching to SurfaceView");
            targetView = this.mSurfaceView;
        } else {
            throw new IllegalArgumentException("Unknown view type: " + viewType);
        }
        ((View)targetView).setVisibility(0);
        targetView.takeOver(this.mCurrentView);
        this.mInstance.requestLayout();
    }

    @Override
    public int getViewType() {
        return this.mCurrentView.getViewType();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setCustomActions(List<PlaybackStateCompat.CustomAction> actionList, Executor executor, VideoView2.OnCustomActionListener listener) {
        this.mCustomActionList = actionList;
        this.mCustomActionListenerRecord = new Pair((Object)executor, (Object)listener);
        this.mStateBuilder = null;
        this.updatePlaybackState();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setOnViewTypeChangedListener(VideoView2.OnViewTypeChangedListener l) {
        this.mViewTypeChangedListener = l;
    }

    @Override
    public void onAttachedToWindowImpl() {
        this.mMediaSession = new MediaSessionCompat(this.mInstance.getContext(), "VideoView2MediaSession");
        this.mMediaSession.setCallback((MediaSessionCompat.Callback)new MediaSessionCallback());
        this.mMediaSession.setActive(true);
        this.mMediaController = this.mMediaSession.getController();
        this.attachMediaControlView();
        if (this.mCurrentState == 2) {
            this.extractTracks();
            this.extractMetadata();
            this.extractAudioMetadata();
            if (this.mNeedUpdateMediaType) {
                this.mMediaSession.sendSessionEvent("UpdateMediaTypeStatus", this.mMediaTypeData);
                this.mNeedUpdateMediaType = false;
            }
        }
        this.mMediaRouter = MediaRouter.getInstance((Context)this.mInstance.getContext());
        this.mMediaRouter.setMediaSessionCompat(this.mMediaSession);
        this.mMediaRouter.addCallback(this.mRouteSelector, this.mRouterCallback, 1);
    }

    @Override
    public void onDetachedFromWindowImpl() {
        this.mMediaSession.release();
        this.mMediaSession = null;
        this.mMediaController = null;
    }

    @Override
    public void onTouchEventImpl(MotionEvent ev) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onTouchEvent(). mCurrentState=" + this.mCurrentState + ", mTargetState=" + this.mTargetState));
        }
        if (!(ev.getAction() != 1 || this.mMediaControlView == null || this.isMusicMediaType() && this.mSizeType == 1)) {
            this.toggleMediaControlViewVisibility();
        }
    }

    @Override
    public void onTrackballEventImpl(MotionEvent ev) {
        if (!(ev.getAction() != 1 || this.mMediaControlView == null || this.isMusicMediaType() && this.mSizeType == 1)) {
            this.toggleMediaControlViewVisibility();
        }
    }

    @Override
    public void onMeasureImpl(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.isMusicMediaType()) {
            int currWidth = this.mInstance.getMeasuredWidth();
            int currHeight = this.mInstance.getMeasuredHeight();
            if (this.mPrevWidth != currWidth || this.mPrevHeight != currHeight) {
                Point screenSize = new Point();
                this.mManager.getDefaultDisplay().getSize(screenSize);
                int screenWidth = screenSize.x;
                int screenHeight = screenSize.y;
                if (currWidth == screenWidth && currHeight == screenHeight) {
                    int orientation = this.retrieveOrientation();
                    if (orientation == 0) {
                        this.inflateMusicView(R.layout.full_landscape_music);
                    } else {
                        this.inflateMusicView(R.layout.full_portrait_music);
                    }
                    if (this.mSizeType != 1) {
                        this.mSizeType = 1;
                        this.mMediaControlView.removeCallbacks(this.mFadeOut);
                        this.mMediaControlView.setVisibility(0);
                    }
                } else if (this.mSizeType != 0) {
                    this.mSizeType = 0;
                    this.inflateMusicView(R.layout.embedded_music);
                    this.mMediaControlView.postDelayed(this.mFadeOut, this.mShowControllerIntervalMs);
                }
                this.mPrevWidth = currWidth;
                this.mPrevHeight = currHeight;
            }
        }
    }

    @Override
    public void onSurfaceCreated(View view, int width, int height) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onSurfaceCreated(). mCurrentState=" + this.mCurrentState + ", mTargetState=" + this.mTargetState + ", width/height: " + width + "/" + height + ", " + view.toString()));
        }
        if (this.needToStart()) {
            this.mMediaController.getTransportControls().play();
        }
    }

    @Override
    public void onSurfaceDestroyed(View view) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onSurfaceDestroyed(). mCurrentState=" + this.mCurrentState + ", mTargetState=" + this.mTargetState + ", " + view.toString()));
        }
    }

    @Override
    public void onSurfaceChanged(View view, int width, int height) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onSurfaceChanged(). width/height: " + width + "/" + height + ", " + view.toString()));
        }
    }

    @Override
    public void onSurfaceTakeOverDone(VideoViewInterfaceWithMp1 view) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("onSurfaceTakeOverDone(). Now current view is: " + view));
        }
        this.mCurrentView = view;
        if (this.mViewTypeChangedListener != null) {
            this.mViewTypeChangedListener.onViewTypeChanged((View)this.mInstance, view.getViewType());
        }
        if (this.needToStart()) {
            this.mMediaController.getTransportControls().play();
        }
    }

    private void attachMediaControlView() {
        this.mMediaControlView.setController(this.mMediaSession.getController());
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.mInstance.addView((View)this.mMediaControlView, params);
    }

    protected boolean isInPlaybackState() {
        return (this.mMediaPlayer != null || this.mRoutePlayer != null) && this.mCurrentState != -1 && this.mCurrentState != 0 && this.mCurrentState != 1;
    }

    private boolean needToStart() {
        return (this.mMediaPlayer != null || this.mRoutePlayer != null) && this.isAudioGranted() && this.isWaitingPlayback();
    }

    private boolean isMusicMediaType() {
        return this.mVideoTrackIndices != null && this.mVideoTrackIndices.size() == 0;
    }

    private boolean isWaitingPlayback() {
        return this.mCurrentState != 3 && this.mTargetState == 3;
    }

    private boolean isAudioGranted() {
        return this.mAudioFocused || this.mAudioFocusType == 0;
    }

    private void requestAudioFocus(int focusType) {
        int result;
        if (Build.VERSION.SDK_INT >= 26) {
            AudioFocusRequest focusRequest = new AudioFocusRequest.Builder(focusType).setAudioAttributes(this.mAudioAttributes).setOnAudioFocusChangeListener(this.mAudioFocusListener).build();
            result = this.mAudioManager.requestAudioFocus(focusRequest);
        } else {
            result = this.mAudioManager.requestAudioFocus(this.mAudioFocusListener, 3, focusType);
        }
        if (result == 0) {
            this.mAudioFocused = false;
        } else if (result == 1) {
            this.mAudioFocused = true;
        } else if (result == 2) {
            this.mAudioFocused = false;
        }
    }

    private void openVideo(Uri uri, Map<String, String> headers) {
        this.resetPlayer();
        this.mUri = uri;
        if (this.isRemotePlayback()) {
            this.mRoutePlayer.openVideo(uri);
            return;
        }
        try {
            Log.d((String)TAG, (String)"openVideo(): creating new MediaPlayer instance.");
            this.mMediaPlayer = new MediaPlayer();
            Context context = this.mInstance.getContext();
            this.setupMediaPlayer(context, uri, headers);
            this.mCurrentState = 1;
            this.mMediaPlayer.prepareAsync();
            this.mTitle = uri.getPath();
            String scheme = uri.getScheme();
            if (scheme != null && scheme.equals("file")) {
                this.mTitle = uri.getLastPathSegment();
                this.mRetriever = new MediaMetadataRetriever();
                this.mRetriever.setDataSource(context, uri);
            }
            if (DEBUG) {
                Log.d((String)TAG, (String)("openVideo(). mCurrentState=" + this.mCurrentState + ", mTargetState=" + this.mTargetState));
            }
        }
        catch (IOException | IllegalArgumentException ex) {
            Log.w((String)TAG, (String)("Unable to open content: " + uri), (Throwable)ex);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mErrorListener.onError(this.mMediaPlayer, 1, -1004);
        }
    }

    protected void setupMediaPlayer(Context context, Uri uri, Map<String, String> headers) throws IOException {
        this.mSurfaceView.setMediaPlayer(this.mMediaPlayer);
        this.mTextureView.setMediaPlayer(this.mMediaPlayer);
        this.mCurrentView.assignSurfaceToMediaPlayer(this.mMediaPlayer);
        this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
        this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
        this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
        this.mMediaPlayer.setOnSeekCompleteListener(this.mSeekCompleteListener);
        this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
        this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
        this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
        this.mCurrentBufferPercentage = -1;
        this.mMediaPlayer.setDataSource(context, uri, headers);
        this.mMediaPlayer.setAudioAttributes(this.mAudioAttributes);
    }

    private void resetPlayer() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mTextureView.setMediaPlayer(null);
            this.mSurfaceView.setMediaPlayer(null);
            this.mCurrentState = 0;
            this.mTargetState = 0;
            if (this.mAudioFocusType != 0) {
                this.mAudioManager.abandonAudioFocus(null);
            }
        }
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
    }

    private void updatePlaybackState() {
        if (this.mStateBuilder == null) {
            long playbackActions = 334L;
            this.mStateBuilder = new PlaybackStateCompat.Builder();
            this.mStateBuilder.setActions(playbackActions);
            if (this.mCustomActionList != null) {
                for (PlaybackStateCompat.CustomAction action : this.mCustomActionList) {
                    this.mStateBuilder.addCustomAction(action);
                }
            }
        }
        this.mStateBuilder.setState(this.getCorrespondingPlaybackState(), (long)this.mMediaPlayer.getCurrentPosition(), this.mSpeed);
        if (this.mCurrentState != -1 && this.mCurrentState != 0 && this.mCurrentState != 1) {
            if (this.mCurrentBufferPercentage == -1) {
                this.mStateBuilder.setBufferedPosition(-1L);
            } else {
                this.mStateBuilder.setBufferedPosition((long)((double)this.mCurrentBufferPercentage / 100.0 * (double)this.mMediaPlayer.getDuration()));
            }
        }
        if (this.mMediaSession != null) {
            PlaybackStateCompat state = this.mStateBuilder.build();
            this.mMediaSession.setPlaybackState(state);
        }
    }

    private int getCorrespondingPlaybackState() {
        switch (this.mCurrentState) {
            case -1: {
                return 7;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    private void showController() {
        if (this.mMediaControlView == null || !this.isInPlaybackState() || this.isMusicMediaType() && this.mSizeType == 1) {
            return;
        }
        this.mMediaControlView.removeCallbacks(this.mFadeOut);
        this.mMediaControlView.setVisibility(0);
        if (this.mShowControllerIntervalMs != 0L && !this.mAccessibilityManager.isTouchExplorationEnabled()) {
            this.mMediaControlView.postDelayed(this.mFadeOut, this.mShowControllerIntervalMs);
        }
    }

    private void toggleMediaControlViewVisibility() {
        if (this.mMediaControlView.getVisibility() == 0) {
            this.mMediaControlView.removeCallbacks(this.mFadeOut);
            this.mMediaControlView.setVisibility(8);
        } else {
            this.showController();
        }
    }

    private void applySpeed() {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        PlaybackParams params = this.mMediaPlayer.getPlaybackParams().allowDefaults();
        if (this.mSpeed != params.getSpeed()) {
            try {
                params.setSpeed(this.mSpeed);
                this.mMediaPlayer.setPlaybackParams(params);
                this.mFallbackSpeed = this.mSpeed;
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)("PlaybackParams has unsupported value: " + e));
                float fallbackSpeed = this.mMediaPlayer.getPlaybackParams().allowDefaults().getSpeed();
                if (fallbackSpeed > 0.0f) {
                    this.mFallbackSpeed = fallbackSpeed;
                }
                this.mSpeed = this.mFallbackSpeed;
            }
        }
    }

    private boolean isRemotePlayback() {
        if (this.mMediaController == null) {
            return false;
        }
        MediaControllerCompat.PlaybackInfo playbackInfo = this.mMediaController.getPlaybackInfo();
        return playbackInfo != null && playbackInfo.getPlaybackType() == 2;
    }

    protected void extractTracks() {
        MediaPlayer.TrackInfo[] trackInfos = this.mMediaPlayer.getTrackInfo();
        this.mVideoTrackIndices = new ArrayList();
        this.mAudioTrackIndices = new ArrayList();
        for (int i = 0; i < trackInfos.length; ++i) {
            int trackType = trackInfos[i].getTrackType();
            if (trackType == 1) {
                this.mVideoTrackIndices.add(i);
                continue;
            }
            if (trackType != 2) continue;
            this.mAudioTrackIndices.add(i);
        }
        if (this.mVideoTrackIndices.size() > 0) {
            this.mSelectedVideoTrackIndex = 0;
        }
        if (this.mAudioTrackIndices.size() > 0) {
            this.mSelectedAudioTrackIndex = 0;
        }
        Bundle data = new Bundle();
        data.putInt("VideoTrackCount", this.mVideoTrackIndices.size());
        data.putInt("AudioTrackCount", this.mAudioTrackIndices.size());
        this.mMediaSession.sendSessionEvent("UpdateTrackStatus", data);
    }

    protected void doShowSubtitleCommand(Bundle args) {
    }

    protected void doHideSubtitleCommand() {
    }

    private void extractMetadata() {
        if (this.mRetriever == null) {
            return;
        }
        MediaMetadataCompat.Builder builder = new MediaMetadataCompat.Builder();
        String title = this.mRetriever.extractMetadata(7);
        if (title != null) {
            this.mTitle = title;
        }
        builder.putString("android.media.metadata.TITLE", this.mTitle);
        builder.putLong("android.media.metadata.DURATION", (long)this.mMediaPlayer.getDuration());
        if (this.mMediaSession != null) {
            this.mMediaSession.setMetadata(builder.build());
        }
    }

    private void extractAudioMetadata() {
        if (this.mRetriever == null || !this.isMusicMediaType()) {
            return;
        }
        this.mResources = this.mInstance.getResources();
        this.mManager = (WindowManager)this.mInstance.getContext().getApplicationContext().getSystemService("window");
        byte[] album = this.mRetriever.getEmbeddedPicture();
        if (album != null) {
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])album, (int)0, (int)album.length);
            this.mMusicAlbumDrawable = new BitmapDrawable(bitmap);
            Palette.Builder builder = Palette.from((Bitmap)bitmap);
            builder.generate(new Palette.PaletteAsyncListener(){

                public void onGenerated(Palette palette) {
                    VideoView2ImplBaseWithMp1.this.mDominantColor = palette.getDominantColor(0);
                    if (VideoView2ImplBaseWithMp1.this.mMusicView != null) {
                        VideoView2ImplBaseWithMp1.this.mMusicView.setBackgroundColor(VideoView2ImplBaseWithMp1.this.mDominantColor);
                    }
                }
            });
        } else {
            this.mMusicAlbumDrawable = this.mResources.getDrawable(R.drawable.ic_default_album_image);
        }
        String title = this.mRetriever.extractMetadata(7);
        this.mMusicTitleText = title != null ? title : this.mResources.getString(R.string.mcv2_music_title_unknown_text);
        String artist = this.mRetriever.extractMetadata(2);
        this.mMusicArtistText = artist != null ? artist : this.mResources.getString(R.string.mcv2_music_artist_unknown_text);
        MediaMetadataCompat.Builder builder = new MediaMetadataCompat.Builder();
        builder.putString("android.media.metadata.TITLE", this.mMusicTitleText);
        builder.putString("android.media.metadata.ARTIST", this.mMusicArtistText);
        this.mMediaSession.setMetadata(builder.build());
        this.mInstance.removeView((View)this.mSurfaceView);
        this.mInstance.removeView((View)this.mTextureView);
        this.inflateMusicView(R.layout.embedded_music);
    }

    private int retrieveOrientation() {
        DisplayMetrics dm = Resources.getSystem().getDisplayMetrics();
        int height = dm.heightPixels;
        int width = dm.widthPixels;
        return height > width ? 1 : 0;
    }

    private void inflateMusicView(int layoutId) {
        TextView artistView;
        TextView titleView;
        this.mInstance.removeView(this.mMusicView);
        LayoutInflater inflater = (LayoutInflater)this.mInstance.getContext().getSystemService("layout_inflater");
        View v = inflater.inflate(layoutId, null);
        v.setBackgroundColor(this.mDominantColor);
        ImageView albumView = (ImageView)v.findViewById(R.id.album);
        if (albumView != null) {
            albumView.setImageDrawable(this.mMusicAlbumDrawable);
        }
        if ((titleView = (TextView)v.findViewById(R.id.title)) != null) {
            titleView.setText((CharSequence)this.mMusicTitleText);
        }
        if ((artistView = (TextView)v.findViewById(R.id.artist)) != null) {
            artistView.setText((CharSequence)this.mMusicArtistText);
        }
        this.mMusicView = v;
        this.mInstance.addView(this.mMusicView, 0);
    }

    private class MediaSessionCallback
    extends MediaSessionCompat.Callback {
        private MediaSessionCallback() {
        }

        public void onCommand(String command, Bundle args, ResultReceiver receiver) {
            if (VideoView2ImplBaseWithMp1.this.isRemotePlayback()) {
                VideoView2ImplBaseWithMp1.this.mRoutePlayer.onCommand(command, args, receiver);
            } else {
                switch (command) {
                    case "showSubtitle": {
                        VideoView2ImplBaseWithMp1.this.doShowSubtitleCommand(args);
                        break;
                    }
                    case "hideSubtitle": {
                        VideoView2ImplBaseWithMp1.this.doHideSubtitleCommand();
                        break;
                    }
                    case "SelectTrack": {
                        int audioTrackIndex;
                        int audioIndex = args.getInt("SelectedAudioIndex", -1);
                        if (audioIndex == -1 || (audioTrackIndex = VideoView2ImplBaseWithMp1.this.mAudioTrackIndices.get(audioIndex).intValue()) == VideoView2ImplBaseWithMp1.this.mSelectedAudioTrackIndex) break;
                        VideoView2ImplBaseWithMp1.this.mSelectedAudioTrackIndex = audioTrackIndex;
                        VideoView2ImplBaseWithMp1.this.mMediaPlayer.selectTrack(VideoView2ImplBaseWithMp1.this.mSelectedAudioTrackIndex);
                        break;
                    }
                    case "SetPlaybackSpeed": {
                        float speed = args.getFloat("PlaybackSpeed", 0.0f);
                        if (speed == 0.0f || speed == VideoView2ImplBaseWithMp1.this.mSpeed) break;
                        VideoView2ImplBaseWithMp1.this.setSpeed(speed);
                        VideoView2ImplBaseWithMp1.this.mSpeed = speed;
                        break;
                    }
                    case "Mute": {
                        VideoView2ImplBaseWithMp1.this.mVolumeLevel = VideoView2ImplBaseWithMp1.this.mAudioManager.getStreamVolume(3);
                        VideoView2ImplBaseWithMp1.this.mAudioManager.setStreamVolume(3, 0, 0);
                        break;
                    }
                    case "Unmute": {
                        VideoView2ImplBaseWithMp1.this.mAudioManager.setStreamVolume(3, VideoView2ImplBaseWithMp1.this.mVolumeLevel, 0);
                    }
                }
            }
            VideoView2ImplBaseWithMp1.this.showController();
        }

        public void onCustomAction(final String action, final Bundle extras) {
            ((Executor)((VideoView2ImplBaseWithMp1)VideoView2ImplBaseWithMp1.this).mCustomActionListenerRecord.first).execute(new Runnable(){

                @Override
                public void run() {
                    ((VideoView2.OnCustomActionListener)((VideoView2ImplBaseWithMp1)VideoView2ImplBaseWithMp1.this).mCustomActionListenerRecord.second).onCustomAction(action, extras);
                }
            });
            VideoView2ImplBaseWithMp1.this.showController();
        }

        public void onPlay() {
            if (!VideoView2ImplBaseWithMp1.this.isAudioGranted()) {
                VideoView2ImplBaseWithMp1.this.requestAudioFocus(VideoView2ImplBaseWithMp1.this.mAudioFocusType);
            }
            if (VideoView2ImplBaseWithMp1.this.isInPlaybackState() && VideoView2ImplBaseWithMp1.this.mCurrentView.hasAvailableSurface() || VideoView2ImplBaseWithMp1.this.isMusicMediaType()) {
                if (VideoView2ImplBaseWithMp1.this.isRemotePlayback()) {
                    VideoView2ImplBaseWithMp1.this.mRoutePlayer.onPlay();
                } else {
                    VideoView2ImplBaseWithMp1.this.applySpeed();
                    VideoView2ImplBaseWithMp1.this.mMediaPlayer.start();
                    VideoView2ImplBaseWithMp1.this.mCurrentState = 3;
                    VideoView2ImplBaseWithMp1.this.updatePlaybackState();
                }
                VideoView2ImplBaseWithMp1.this.mCurrentState = 3;
            }
            VideoView2ImplBaseWithMp1.this.mTargetState = 3;
            if (DEBUG) {
                Log.d((String)VideoView2ImplBaseWithMp1.TAG, (String)("onPlay(). mCurrentState=" + VideoView2ImplBaseWithMp1.this.mCurrentState + ", mTargetState=" + VideoView2ImplBaseWithMp1.this.mTargetState));
            }
            VideoView2ImplBaseWithMp1.this.showController();
        }

        public void onPause() {
            if (VideoView2ImplBaseWithMp1.this.isInPlaybackState()) {
                if (VideoView2ImplBaseWithMp1.this.isRemotePlayback()) {
                    VideoView2ImplBaseWithMp1.this.mRoutePlayer.onPlay();
                    VideoView2ImplBaseWithMp1.this.mCurrentState = 4;
                } else if (VideoView2ImplBaseWithMp1.this.mMediaPlayer.isPlaying()) {
                    VideoView2ImplBaseWithMp1.this.mMediaPlayer.pause();
                    VideoView2ImplBaseWithMp1.this.mCurrentState = 4;
                    VideoView2ImplBaseWithMp1.this.updatePlaybackState();
                }
            }
            VideoView2ImplBaseWithMp1.this.mTargetState = 4;
            if (DEBUG) {
                Log.d((String)VideoView2ImplBaseWithMp1.TAG, (String)("onPause(). mCurrentState=" + VideoView2ImplBaseWithMp1.this.mCurrentState + ", mTargetState=" + VideoView2ImplBaseWithMp1.this.mTargetState));
            }
            VideoView2ImplBaseWithMp1.this.showController();
        }

        public void onSeekTo(long pos) {
            if (VideoView2ImplBaseWithMp1.this.isInPlaybackState()) {
                if (VideoView2ImplBaseWithMp1.this.isRemotePlayback()) {
                    VideoView2ImplBaseWithMp1.this.mRoutePlayer.onPlay();
                } else {
                    if (Build.VERSION.SDK_INT < 26) {
                        VideoView2ImplBaseWithMp1.this.mMediaPlayer.seekTo((int)pos);
                    } else {
                        VideoView2ImplBaseWithMp1.this.mMediaPlayer.seekTo(pos, 0);
                    }
                    VideoView2ImplBaseWithMp1.this.mSeekWhenPrepared = 0L;
                }
            } else {
                VideoView2ImplBaseWithMp1.this.mSeekWhenPrepared = pos;
            }
            VideoView2ImplBaseWithMp1.this.showController();
        }

        public void onStop() {
            if (VideoView2ImplBaseWithMp1.this.isRemotePlayback()) {
                VideoView2ImplBaseWithMp1.this.mRoutePlayer.onPlay();
            } else {
                VideoView2ImplBaseWithMp1.this.resetPlayer();
            }
            VideoView2ImplBaseWithMp1.this.showController();
        }
    }
}

