/*
 * Decompiled with CFR 0.152.
 */
package androidx.media.widget;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import androidx.annotation.NonNull;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

class MainHandlerExecutor
implements Executor {
    private final Handler mHandler;

    static Executor getExecutor(Context context) {
        if (Build.VERSION.SDK_INT >= 28) {
            return context.getMainExecutor();
        }
        return new MainHandlerExecutor(new Handler(context.getMainLooper()));
    }

    MainHandlerExecutor(@NonNull Handler handler) {
        this.mHandler = handler;
    }

    @Override
    public void execute(Runnable command) {
        if (!this.mHandler.post(command)) {
            throw new RejectedExecutionException(this.mHandler + " is shutting down");
        }
    }
}

