/*
 * Decompiled with CFR 0.152.
 */
package androidx.media.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.LinearInterpolator;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.media.widget.BaseLayout;
import androidx.media.widget.MainHandlerExecutor;
import androidx.media.widget.R;
import androidx.media2.MediaController2;
import androidx.media2.MediaItem2;
import androidx.media2.MediaMetadata2;
import androidx.media2.SessionCommand2;
import androidx.media2.SessionCommandGroup2;
import androidx.media2.SessionToken2;
import androidx.mediarouter.app.MediaRouteButton;
import androidx.mediarouter.media.MediaRouteSelector;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;

@TargetApi(value=28)
@RequiresApi(value=21)
public class MediaControlView2
extends BaseLayout {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_PLAY_PAUSE = 1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_FFWD = 2;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_REW = 3;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_NEXT = 4;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_PREV = 5;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_SUBTITLE = 6;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_FULL_SCREEN = 7;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_OVERFLOW = 8;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_MUTE = 9;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_ASPECT_RATIO = 10;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int BUTTON_SETTINGS = 11;
    private static final String TAG = "MediaControlView2";
    static final boolean DEBUG = Log.isLoggable((String)"MediaControlView2", (int)3);
    static final String KEY_VIDEO_TRACK_COUNT = "VideoTrackCount";
    static final String KEY_AUDIO_TRACK_COUNT = "AudioTrackCount";
    static final String KEY_SUBTITLE_TRACK_COUNT = "SubtitleTrackCount";
    static final String KEY_PLAYBACK_SPEED = "PlaybackSpeed";
    static final String KEY_SELECTED_AUDIO_INDEX = "SelectedAudioIndex";
    static final String KEY_SELECTED_SUBTITLE_INDEX = "SelectedSubtitleIndex";
    static final String EVENT_UPDATE_TRACK_STATUS = "UpdateTrackStatus";
    static final String KEY_STATE_IS_ADVERTISEMENT = "MediaTypeAdvertisement";
    static final String EVENT_UPDATE_MEDIA_TYPE_STATUS = "UpdateMediaTypeStatus";
    static final String COMMAND_SHOW_SUBTITLE = "showSubtitle";
    static final String COMMAND_HIDE_SUBTITLE = "hideSubtitle";
    static final String COMMAND_SELECT_AUDIO_TRACK = "SelectTrack";
    static final String COMMAND_SET_PLAYBACK_SPEED = "SetPlaybackSpeed";
    static final String COMMAND_MUTE = "Mute";
    static final String COMMAND_UNMUTE = "Unmute";
    private static final int SETTINGS_MODE_AUDIO_TRACK = 0;
    private static final int SETTINGS_MODE_PLAYBACK_SPEED = 1;
    private static final int SETTINGS_MODE_HELP = 2;
    private static final int SETTINGS_MODE_SUBTITLE_TRACK = 3;
    private static final int SETTINGS_MODE_VIDEO_QUALITY = 4;
    private static final int SETTINGS_MODE_MAIN = 5;
    private static final int PLAYBACK_SPEED_1x_INDEX = 3;
    private static final int MEDIA_TYPE_DEFAULT = 0;
    private static final int MEDIA_TYPE_MUSIC = 1;
    private static final int MEDIA_TYPE_ADVERTISEMENT = 2;
    private static final int SIZE_TYPE_EMBEDDED = 0;
    private static final int SIZE_TYPE_FULL = 1;
    private static final int SIZE_TYPE_MINIMAL = 2;
    private static final int UX_STATE_FULL = 0;
    private static final int UX_STATE_PROGRESS_BAR_ONLY = 1;
    private static final int UX_STATE_EMPTY = 2;
    private static final int UX_STATE_ANIMATING = 3;
    private static final long DEFAULT_SHOW_CONTROLLER_INTERVAL_MS = 2000L;
    private static final long DEFAULT_PROGRESS_UPDATE_TIME_MS = 1000L;
    private static final long REWIND_TIME_MS = 10000L;
    private static final long FORWARD_TIME_MS = 30000L;
    private static final long AD_SKIP_WAIT_TIME_MS = 5000L;
    private static final long HIDE_TIME_MS = 250L;
    private static final long SHOW_TIME_MS = 250L;
    private static final int MAX_PROGRESS = 1000;
    private static final int RESOURCE_NON_EXISTENT = -1;
    private static final String RESOURCE_EMPTY = "";
    Resources mResources;
    ControllerInterface mController;
    OnFullScreenListener mOnFullScreenListener;
    private AccessibilityManager mAccessibilityManager;
    SessionCommandGroup2 mAllowedCommands;
    int mPrevState;
    private int mPrevWidth;
    private int mOriginalLeftBarWidth;
    int mVideoTrackCount;
    int mAudioTrackCount;
    int mSubtitleTrackCount;
    int mSettingsMode;
    int mSelectedSubtitleTrackIndex;
    int mSelectedAudioTrackIndex;
    int mSelectedVideoQualityIndex;
    int mSelectedSpeedIndex;
    private int mEmbeddedSettingsItemWidth;
    private int mFullSettingsItemWidth;
    private int mSettingsItemHeight;
    private int mSettingsWindowMargin;
    int mMediaType;
    int mSizeType;
    int mUxState;
    long mDuration;
    long mPlaybackActions;
    long mShowControllerIntervalMs;
    boolean mDragging;
    boolean mIsFullScreen;
    boolean mOverflowIsShowing;
    boolean mIsStopped;
    boolean mSeekAvailable;
    boolean mIsAdvertisement;
    boolean mIsMute;
    private boolean mNeedUxUpdate;
    boolean mNeedToHideBars;
    private ViewGroup mRoot;
    private View mTitleBar;
    private TextView mTitleView;
    private View mAdExternalLink;
    private ImageButton mBackButton;
    private MediaRouteButton mRouteButton;
    private MediaRouteSelector mRouteSelector;
    private ViewGroup mCenterView;
    View mTransportControls;
    ImageButton mPlayPauseButton;
    ImageButton mFfwdButton;
    ImageButton mRewButton;
    private ImageButton mNextButton;
    private ImageButton mPrevButton;
    private LinearLayout mMinimalSizeFullScreenView;
    View mProgressBar;
    ProgressBar mProgress;
    private View mProgressBuffer;
    private ViewGroup mBottomBar;
    private ViewGroup mBottomBarLeftView;
    private ViewGroup mTimeView;
    private TextView mEndTime;
    TextView mCurrentTime;
    private TextView mAdSkipView;
    private StringBuilder mFormatBuilder;
    private Formatter mFormatter;
    private ViewGroup mBottomBarRightView;
    ViewGroup mBasicControls;
    ViewGroup mExtraControls;
    ViewGroup mCustomButtons;
    ImageButton mSubtitleButton;
    ImageButton mFullScreenButton;
    ImageButton mOverflowShowButton;
    ImageButton mOverflowHideButton;
    ImageButton mMuteButton;
    private ImageButton mVideoQualityButton;
    private ImageButton mSettingsButton;
    private TextView mAdRemainingView;
    private ListView mSettingsListView;
    private PopupWindow mSettingsWindow;
    SettingsAdapter mSettingsAdapter;
    SubSettingsAdapter mSubSettingsAdapter;
    private List<String> mSettingsMainTextsList;
    List<String> mSettingsSubTextsList;
    private List<Integer> mSettingsIconIdsList;
    List<String> mSubtitleDescriptionsList;
    List<String> mAudioTrackList;
    List<String> mVideoQualityList;
    List<String> mPlaybackSpeedTextList;
    List<Float> mPlaybackSpeedList;
    AnimatorSet mHideMainBarsAnimator;
    AnimatorSet mHideProgressBarAnimator;
    AnimatorSet mHideAllBarsAnimator;
    AnimatorSet mShowMainBarsAnimator;
    AnimatorSet mShowAllBarsAnimator;
    ValueAnimator mOverflowShowAnimator;
    ValueAnimator mOverflowHideAnimator;
    final Runnable mUpdateProgress = new Runnable(){

        @Override
        public void run() {
            boolean isShowing;
            boolean bl = isShowing = MediaControlView2.this.getVisibility() == 0;
            if (!MediaControlView2.this.mDragging && isShowing && MediaControlView2.this.isPlaying()) {
                long pos = MediaControlView2.this.setProgress();
                MediaControlView2.this.postDelayed(MediaControlView2.this.mUpdateProgress, 1000L - pos % 1000L);
            }
        }
    };
    private final Runnable mShowAllBars = new Runnable(){

        @Override
        public void run() {
            MediaControlView2.this.mShowAllBarsAnimator.start();
            if (MediaControlView2.this.isPlaying()) {
                MediaControlView2.this.postDelayed(MediaControlView2.this.mHideMainBars, MediaControlView2.this.mShowControllerIntervalMs);
            }
        }
    };
    private final Runnable mShowMainBars = new Runnable(){

        @Override
        public void run() {
            MediaControlView2.this.mShowMainBarsAnimator.start();
            MediaControlView2.this.postDelayed(MediaControlView2.this.mHideMainBars, MediaControlView2.this.mShowControllerIntervalMs);
        }
    };
    private final Runnable mHideAllBars = new Runnable(){

        @Override
        public void run() {
            MediaControlView2.this.mHideAllBarsAnimator.start();
        }
    };
    Runnable mHideMainBars = new Runnable(){

        @Override
        public void run() {
            if (!MediaControlView2.this.isPlaying()) {
                return;
            }
            MediaControlView2.this.mHideMainBarsAnimator.start();
            MediaControlView2.this.postDelayed(MediaControlView2.this.mHideProgressBar, MediaControlView2.this.mShowControllerIntervalMs);
        }
    };
    final Runnable mHideProgressBar = new Runnable(){

        @Override
        public void run() {
            if (!MediaControlView2.this.isPlaying()) {
                return;
            }
            MediaControlView2.this.mHideProgressBarAnimator.start();
        }
    };
    private final SeekBar.OnSeekBarChangeListener mSeekListener = new SeekBar.OnSeekBarChangeListener(){

        public void onStartTrackingTouch(SeekBar bar) {
            if (!MediaControlView2.this.mSeekAvailable) {
                return;
            }
            MediaControlView2.this.mDragging = true;
            MediaControlView2.this.removeCallbacks(MediaControlView2.this.mUpdateProgress);
            MediaControlView2.this.removeCallbacks(MediaControlView2.this.mHideMainBars);
            MediaControlView2.this.removeCallbacks(MediaControlView2.this.mHideProgressBar);
            if (MediaControlView2.this.mIsStopped) {
                MediaControlView2.this.mPlayPauseButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_play_circle_filled, null));
                MediaControlView2.this.mPlayPauseButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_play_button_desc));
                MediaControlView2.this.mIsStopped = false;
            }
        }

        public void onProgressChanged(SeekBar bar, int progress, boolean fromUser) {
            if (!MediaControlView2.this.mSeekAvailable) {
                return;
            }
            if (!fromUser) {
                return;
            }
            if (MediaControlView2.this.mDuration > 0L) {
                int position = (int)(MediaControlView2.this.mDuration * (long)progress / 1000L);
                MediaControlView2.this.mController.seekTo(position);
                if (MediaControlView2.this.mCurrentTime != null) {
                    MediaControlView2.this.mCurrentTime.setText((CharSequence)MediaControlView2.this.stringForTime(position));
                }
            }
        }

        public void onStopTrackingTouch(SeekBar bar) {
            if (!MediaControlView2.this.mSeekAvailable) {
                return;
            }
            MediaControlView2.this.mDragging = false;
            MediaControlView2.this.setProgress();
            MediaControlView2.this.post(MediaControlView2.this.mUpdateProgress);
            MediaControlView2.this.postDelayed(MediaControlView2.this.mHideMainBars, MediaControlView2.this.mShowControllerIntervalMs);
        }
    };
    private final View.OnClickListener mPlayPauseListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.resetHideCallbacks();
            MediaControlView2.this.togglePausePlayState();
        }
    };
    private final View.OnClickListener mRewListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.resetHideCallbacks();
            long pos = MediaControlView2.this.getCurrentPosition() - 10000L;
            MediaControlView2.this.mController.seekTo(pos);
            MediaControlView2.this.setProgress();
        }
    };
    private final View.OnClickListener mFfwdListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.resetHideCallbacks();
            long pos = MediaControlView2.this.getCurrentPosition() + 30000L;
            MediaControlView2.this.mController.seekTo(pos);
            MediaControlView2.this.setProgress();
        }
    };
    private final View.OnClickListener mNextListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.resetHideCallbacks();
            MediaControlView2.this.mController.skipToNextItem();
        }
    };
    private final View.OnClickListener mPrevListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.resetHideCallbacks();
            MediaControlView2.this.mController.skipToPreviousItem();
        }
    };
    private final View.OnClickListener mBackListener = new View.OnClickListener(){

        public void onClick(View v) {
            View parent = (View)MediaControlView2.this.getParent();
            if (parent != null) {
                parent.onKeyDown(4, new KeyEvent(0, 4));
            }
        }
    };
    private final View.OnClickListener mSubtitleListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.removeCallbacks(MediaControlView2.this.mHideMainBars);
            MediaControlView2.this.removeCallbacks(MediaControlView2.this.mHideProgressBar);
            MediaControlView2.this.mSettingsMode = 3;
            MediaControlView2.this.mSubSettingsAdapter.setTexts(MediaControlView2.this.mSubtitleDescriptionsList);
            MediaControlView2.this.mSubSettingsAdapter.setCheckPosition(MediaControlView2.this.mSelectedSubtitleTrackIndex);
            MediaControlView2.this.displaySettingsWindow(MediaControlView2.this.mSubSettingsAdapter);
        }
    };
    private final View.OnClickListener mVideoQualityListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.removeCallbacks(MediaControlView2.this.mHideMainBars);
            MediaControlView2.this.removeCallbacks(MediaControlView2.this.mHideProgressBar);
            MediaControlView2.this.mSettingsMode = 4;
            MediaControlView2.this.mSubSettingsAdapter.setTexts(MediaControlView2.this.mVideoQualityList);
            MediaControlView2.this.mSubSettingsAdapter.setCheckPosition(MediaControlView2.this.mSelectedVideoQualityIndex);
            MediaControlView2.this.displaySettingsWindow(MediaControlView2.this.mSubSettingsAdapter);
        }
    };
    private final View.OnClickListener mFullScreenListener = new View.OnClickListener(){

        public void onClick(View v) {
            boolean isEnteringFullScreen;
            MediaControlView2.this.resetHideCallbacks();
            if (MediaControlView2.this.mOnFullScreenListener == null) {
                return;
            }
            boolean bl = isEnteringFullScreen = !MediaControlView2.this.mIsFullScreen;
            if (isEnteringFullScreen) {
                MediaControlView2.this.mFullScreenButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_fullscreen_exit, null));
            } else {
                MediaControlView2.this.mFullScreenButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_fullscreen, null));
            }
            MediaControlView2.this.mIsFullScreen = isEnteringFullScreen;
            MediaControlView2.this.mOnFullScreenListener.onFullScreen((View)MediaControlView2.this, MediaControlView2.this.mIsFullScreen);
        }
    };
    private final View.OnClickListener mOverflowShowListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.resetHideCallbacks();
            MediaControlView2.this.mOverflowIsShowing = true;
            MediaControlView2.this.mOverflowShowAnimator.start();
        }
    };
    private final View.OnClickListener mOverflowHideListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.resetHideCallbacks();
            MediaControlView2.this.mOverflowIsShowing = false;
            MediaControlView2.this.mOverflowHideAnimator.start();
        }
    };
    private final View.OnClickListener mMuteButtonListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.resetHideCallbacks();
            if (!MediaControlView2.this.mIsMute) {
                MediaControlView2.this.mMuteButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_mute, null));
                MediaControlView2.this.mMuteButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_muted_button_desc));
                MediaControlView2.this.mIsMute = true;
                MediaControlView2.this.mController.volumeMute();
            } else {
                MediaControlView2.this.mMuteButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_unmute, null));
                MediaControlView2.this.mMuteButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_unmuted_button_desc));
                MediaControlView2.this.mIsMute = false;
                MediaControlView2.this.mController.volumeUnmute();
            }
        }
    };
    private final View.OnClickListener mSettingsButtonListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaControlView2.this.removeCallbacks(MediaControlView2.this.mHideMainBars);
            MediaControlView2.this.removeCallbacks(MediaControlView2.this.mHideProgressBar);
            MediaControlView2.this.mSettingsMode = 5;
            MediaControlView2.this.mSettingsAdapter.setSubTexts(MediaControlView2.this.mSettingsSubTextsList);
            MediaControlView2.this.displaySettingsWindow(MediaControlView2.this.mSettingsAdapter);
        }
    };
    private final AdapterView.OnItemClickListener mSettingsItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            switch (MediaControlView2.this.mSettingsMode) {
                case 5: {
                    if (position == 0) {
                        MediaControlView2.this.mSubSettingsAdapter.setTexts(MediaControlView2.this.mAudioTrackList);
                        MediaControlView2.this.mSubSettingsAdapter.setCheckPosition(MediaControlView2.this.mSelectedAudioTrackIndex);
                        MediaControlView2.this.mSettingsMode = 0;
                    } else if (position == 1) {
                        MediaControlView2.this.mSubSettingsAdapter.setTexts(MediaControlView2.this.mPlaybackSpeedTextList);
                        MediaControlView2.this.mSubSettingsAdapter.setCheckPosition(MediaControlView2.this.mSelectedSpeedIndex);
                        MediaControlView2.this.mSettingsMode = 1;
                    } else if (position == 2) {
                        MediaControlView2.this.dismissSettingsWindow();
                        return;
                    }
                    MediaControlView2.this.displaySettingsWindow(MediaControlView2.this.mSubSettingsAdapter);
                    break;
                }
                case 0: {
                    if (position != MediaControlView2.this.mSelectedAudioTrackIndex) {
                        MediaControlView2.this.mSelectedAudioTrackIndex = position;
                        if (MediaControlView2.this.mAudioTrackCount > 0) {
                            MediaControlView2.this.mController.selectAudioTrack(position);
                        }
                        MediaControlView2.this.mSettingsSubTextsList.set(0, MediaControlView2.this.mSubSettingsAdapter.getMainText(position));
                    }
                    MediaControlView2.this.dismissSettingsWindow();
                    break;
                }
                case 1: {
                    if (position != MediaControlView2.this.mSelectedSpeedIndex) {
                        MediaControlView2.this.mSelectedSpeedIndex = position;
                        float speed = MediaControlView2.this.mPlaybackSpeedList.get(position).floatValue();
                        MediaControlView2.this.mController.setSpeed(speed);
                        MediaControlView2.this.mSettingsSubTextsList.set(1, MediaControlView2.this.mSubSettingsAdapter.getMainText(position));
                    }
                    MediaControlView2.this.dismissSettingsWindow();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (position != MediaControlView2.this.mSelectedSubtitleTrackIndex) {
                        MediaControlView2.this.mSelectedSubtitleTrackIndex = position;
                        if (position > 0) {
                            MediaControlView2.this.mController.showSubtitle(position - 1);
                            MediaControlView2.this.mSubtitleButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_subtitle_on, null));
                            MediaControlView2.this.mSubtitleButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_cc_is_on));
                        } else {
                            MediaControlView2.this.mController.hideSubtitle();
                            MediaControlView2.this.mSubtitleButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_subtitle_off, null));
                            MediaControlView2.this.mSubtitleButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_cc_is_off));
                        }
                    }
                    MediaControlView2.this.dismissSettingsWindow();
                    break;
                }
                case 4: {
                    MediaControlView2.this.mSelectedVideoQualityIndex = position;
                    MediaControlView2.this.dismissSettingsWindow();
                }
            }
        }
    };
    private PopupWindow.OnDismissListener mSettingsDismissListener = new PopupWindow.OnDismissListener(){

        public void onDismiss() {
            if (MediaControlView2.this.mNeedToHideBars) {
                MediaControlView2.this.postDelayed(MediaControlView2.this.mHideMainBars, MediaControlView2.this.mShowControllerIntervalMs);
            }
        }
    };

    public MediaControlView2(@NonNull Context context) {
        this(context, null);
    }

    public MediaControlView2(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MediaControlView2(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mResources = context.getResources();
        this.mRoot = this.makeControllerView();
        this.addView((View)this.mRoot);
        this.mShowControllerIntervalMs = 2000L;
        this.mAccessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
    }

    public void setMediaSessionToken2(SessionToken2 token) {
        if (this.mController != null) {
            this.mController.close();
        }
        this.mController = new Controller2(token);
        if (this.mController.hasMetadata()) {
            this.updateDuration();
            this.updateTitle();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setController(MediaControllerCompat controllerCompat) {
        this.mController = new ControllerCompat(controllerCompat);
        if (this.mController.hasMetadata()) {
            this.updateDuration();
            this.updateTitle();
        }
    }

    public void setOnFullScreenListener(OnFullScreenListener l) {
        this.mOnFullScreenListener = l;
        this.mFullScreenButton.setVisibility(0);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setButtonVisibility(int button, int visibility) {
        switch (button) {
            case 1: {
                if (this.mPlayPauseButton == null || !this.canPause()) break;
                this.mPlayPauseButton.setVisibility(visibility);
                break;
            }
            case 2: {
                if (this.mFfwdButton == null || !this.canSeekForward()) break;
                this.mFfwdButton.setVisibility(visibility);
                break;
            }
            case 3: {
                if (this.mRewButton == null || !this.canSeekBackward()) break;
                this.mRewButton.setVisibility(visibility);
                break;
            }
            case 4: {
                if (this.mNextButton == null) break;
                this.mNextButton.setVisibility(visibility);
                break;
            }
            case 5: {
                if (this.mPrevButton == null) break;
                this.mPrevButton.setVisibility(visibility);
                break;
            }
            case 6: {
                if (this.mSubtitleButton == null || this.mSubtitleTrackCount <= 0) break;
                this.mSubtitleButton.setVisibility(visibility);
                break;
            }
            case 7: {
                if (this.mFullScreenButton == null || this.mOnFullScreenListener == null) break;
                this.mFullScreenButton.setVisibility(visibility);
                break;
            }
            case 8: {
                if (this.mOverflowShowButton == null) break;
                this.mOverflowShowButton.setVisibility(visibility);
                break;
            }
            case 9: {
                if (this.mMuteButton == null) break;
                this.mMuteButton.setVisibility(visibility);
                break;
            }
            case 11: {
                if (this.mSettingsButton == null) break;
                this.mSettingsButton.setVisibility(visibility);
                break;
            }
        }
    }

    public void requestPlayButtonFocus() {
        if (this.mPlayPauseButton != null) {
            this.mPlayPauseButton.requestFocus();
        }
    }

    public CharSequence getAccessibilityClassName() {
        return MediaControlView2.class.getName();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 1 && (this.mMediaType != 1 || this.mSizeType != 1)) {
            this.toggleMediaControlViewVisibility();
        }
        return true;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (ev.getAction() == 1 && (this.mMediaType != 1 || this.mSizeType != 1)) {
            this.toggleMediaControlViewVisibility();
        }
        return true;
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mPrevWidth != this.getMeasuredWidth() || this.mNeedUxUpdate) {
            this.mSettingsWindow.dismiss();
            if (this.mOverflowIsShowing) {
                this.mOverflowHideAnimator.start();
            }
            if (this.mTransportControls.getWidth() == 0 || this.mTimeView.getWidth() == 0) {
                return;
            }
            int currWidth = this.getMeasuredWidth();
            int currHeight = this.getMeasuredHeight();
            WindowManager manager = (WindowManager)this.getContext().getApplicationContext().getSystemService("window");
            Point screenSize = new Point();
            manager.getDefaultDisplay().getSize(screenSize);
            int screenWidth = screenSize.x;
            int screenHeight = screenSize.y;
            int iconSize = this.mResources.getDimensionPixelSize(R.dimen.mcv2_icon_size);
            if (this.mMediaType == 0) {
                int maxIconCount = 4;
                this.updateLayout(maxIconCount, iconSize, currWidth, currHeight, screenWidth, screenHeight);
            } else if (this.mMediaType == 1) {
                if (this.mNeedUxUpdate) {
                    this.mBasicControls.removeView((View)this.mMuteButton);
                    this.mExtraControls.addView((View)this.mMuteButton, 0);
                    this.mVideoQualityButton.setVisibility(8);
                    if (this.mFfwdButton != null) {
                        this.mFfwdButton.setVisibility(8);
                    }
                    if (this.mRewButton != null) {
                        this.mRewButton.setVisibility(8);
                    }
                }
                this.mNeedUxUpdate = false;
                int maxIconCount = 3;
                this.updateLayout(maxIconCount, iconSize, currWidth, currHeight, screenWidth, screenHeight);
            }
            this.mPrevWidth = currWidth;
            if (this.mUxState != 0) {
                this.removeCallbacks(this.mHideMainBars);
                this.removeCallbacks(this.mHideProgressBar);
                this.post(this.mShowMainBars);
            }
        }
        this.updateTitleBarLayout();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.mPlayPauseButton != null) {
            this.mPlayPauseButton.setEnabled(enabled);
        }
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setEnabled(enabled);
        }
        if (this.mRewButton != null) {
            this.mRewButton.setEnabled(enabled);
        }
        if (this.mNextButton != null) {
            this.mNextButton.setEnabled(enabled);
        }
        if (this.mPrevButton != null) {
            this.mPrevButton.setEnabled(enabled);
        }
        if (this.mProgress != null) {
            this.mProgress.setEnabled(enabled);
        }
        if (this.mSubtitleButton != null) {
            this.mSubtitleButton.setEnabled(enabled);
        }
        if (this.mFullScreenButton != null) {
            this.mFullScreenButton.setEnabled(enabled);
        }
        if (this.mOverflowShowButton != null) {
            this.mOverflowShowButton.setEnabled(enabled);
        }
        if (this.mOverflowHideButton != null) {
            this.mOverflowHideButton.setEnabled(enabled);
        }
        if (this.mMuteButton != null) {
            this.mMuteButton.setEnabled(enabled);
        }
        if (this.mVideoQualityButton != null) {
            this.mVideoQualityButton.setEnabled(enabled);
        }
        if (this.mSettingsButton != null) {
            this.mSettingsButton.setEnabled(enabled);
        }
        if (this.mBackButton != null) {
            this.mBackButton.setEnabled(enabled);
        }
        if (this.mRouteButton != null) {
            this.mRouteButton.setEnabled(enabled);
        }
        this.disableUnsupportedButtons();
    }

    public void onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        if (isVisible) {
            this.disableUnsupportedButtons();
            this.removeCallbacks(this.mUpdateProgress);
            this.post(this.mUpdateProgress);
        } else {
            this.removeCallbacks(this.mUpdateProgress);
        }
    }

    void setRouteSelector(MediaRouteSelector selector) {
        this.mRouteSelector = selector;
        if (this.mRouteSelector != null && !this.mRouteSelector.isEmpty()) {
            this.mRouteButton.setRouteSelector(selector);
            this.mRouteButton.setVisibility(0);
        } else {
            this.mRouteButton.setRouteSelector(MediaRouteSelector.EMPTY);
            this.mRouteButton.setVisibility(8);
        }
    }

    void setShowControllerInterval(long interval) {
        this.mShowControllerIntervalMs = interval;
    }

    boolean isPlaying() {
        return this.mController.isPlaying();
    }

    long getCurrentPosition() {
        return this.mController.getCurrentPosition();
    }

    private int getBufferPercentage() {
        if (this.mDuration == 0L) {
            return 0;
        }
        long bufferedPos = this.mController.getBufferedPosition();
        return bufferedPos < 0L ? -1 : (int)(bufferedPos * 100L / this.mDuration);
    }

    private boolean canPause() {
        return this.mController != null && this.mController.canPause();
    }

    private boolean canSeekBackward() {
        return this.mController != null && this.mController.canSeekBackward();
    }

    private boolean canSeekForward() {
        return this.mController != null && this.mController.canSeekForward();
    }

    private ViewGroup makeControllerView() {
        ViewGroup root = (ViewGroup)MediaControlView2.inflateLayout(this.getContext(), R.layout.media_controller);
        this.initControllerView(root);
        return root;
    }

    static View inflateLayout(Context context, int resId) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        return inflater.inflate(resId, null);
    }

    private void initControllerView(ViewGroup v) {
        this.mTitleBar = v.findViewById(R.id.title_bar);
        this.mTitleView = (TextView)v.findViewById(R.id.title_text);
        this.mAdExternalLink = v.findViewById(R.id.ad_external_link);
        this.mBackButton = (ImageButton)v.findViewById(R.id.back);
        if (this.mBackButton != null) {
            this.mBackButton.setOnClickListener(this.mBackListener);
            this.mBackButton.setVisibility(8);
        }
        this.mRouteButton = (MediaRouteButton)v.findViewById(R.id.cast);
        this.mCenterView = (ViewGroup)v.findViewById(R.id.center_view);
        this.mTransportControls = this.inflateTransportControls(R.layout.embedded_transport_controls);
        this.mCenterView.addView(this.mTransportControls);
        this.mMinimalSizeFullScreenView = (LinearLayout)v.findViewById(R.id.minimal_fullscreen_view);
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mMinimalSizeFullScreenView.getLayoutParams();
        int iconSize = this.mResources.getDimensionPixelSize(R.dimen.mcv2_icon_size);
        params.setMargins(0, iconSize * -1, 0, 0);
        this.mMinimalSizeFullScreenView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mMinimalSizeFullScreenView.setVisibility(8);
        this.mProgressBar = v.findViewById(R.id.progress_bar);
        this.mProgress = (ProgressBar)v.findViewById(R.id.progress);
        if (this.mProgress != null) {
            if (this.mProgress instanceof SeekBar) {
                SeekBar seeker = (SeekBar)this.mProgress;
                seeker.setOnSeekBarChangeListener(this.mSeekListener);
                seeker.setProgressDrawable(this.mResources.getDrawable(R.drawable.custom_progress));
                seeker.setThumb(this.mResources.getDrawable(R.drawable.custom_progress_thumb));
            }
            this.mProgress.setMax(1000);
        }
        this.mProgressBuffer = v.findViewById(R.id.progress_buffer);
        this.mBottomBar = (ViewGroup)v.findViewById(R.id.bottom_bar);
        this.mBottomBarLeftView = (ViewGroup)v.findViewById(R.id.bottom_bar_left);
        this.mTimeView = (ViewGroup)v.findViewById(R.id.time);
        this.mEndTime = (TextView)v.findViewById(R.id.time_end);
        this.mCurrentTime = (TextView)v.findViewById(R.id.time_current);
        this.mAdSkipView = (TextView)v.findViewById(R.id.ad_skip_time);
        this.mFormatBuilder = new StringBuilder();
        this.mFormatter = new Formatter(this.mFormatBuilder, Locale.getDefault());
        this.mBasicControls = (ViewGroup)v.findViewById(R.id.basic_controls);
        this.mExtraControls = (ViewGroup)v.findViewById(R.id.extra_controls);
        this.mCustomButtons = (ViewGroup)v.findViewById(R.id.custom_buttons);
        this.mSubtitleButton = (ImageButton)v.findViewById(R.id.subtitle);
        if (this.mSubtitleButton != null) {
            this.mSubtitleButton.setOnClickListener(this.mSubtitleListener);
        }
        this.mFullScreenButton = (ImageButton)v.findViewById(R.id.fullscreen);
        if (this.mFullScreenButton != null) {
            this.mFullScreenButton.setOnClickListener(this.mFullScreenListener);
        }
        this.mOverflowShowButton = (ImageButton)v.findViewById(R.id.overflow_show);
        if (this.mOverflowShowButton != null) {
            this.mOverflowShowButton.setOnClickListener(this.mOverflowShowListener);
        }
        this.mOverflowHideButton = (ImageButton)v.findViewById(R.id.overflow_hide);
        if (this.mOverflowHideButton != null) {
            this.mOverflowHideButton.setOnClickListener(this.mOverflowHideListener);
        }
        this.mMuteButton = (ImageButton)v.findViewById(R.id.mute);
        if (this.mMuteButton != null) {
            this.mMuteButton.setOnClickListener(this.mMuteButtonListener);
        }
        this.mSettingsButton = (ImageButton)v.findViewById(R.id.settings);
        if (this.mSettingsButton != null) {
            this.mSettingsButton.setOnClickListener(this.mSettingsButtonListener);
        }
        this.mVideoQualityButton = (ImageButton)v.findViewById(R.id.video_quality);
        if (this.mVideoQualityButton != null) {
            this.mVideoQualityButton.setOnClickListener(this.mVideoQualityListener);
        }
        this.mAdRemainingView = (TextView)v.findViewById(R.id.ad_remaining);
        this.initializeSettingsLists();
        this.mSettingsListView = (ListView)MediaControlView2.inflateLayout(this.getContext(), R.layout.settings_list);
        this.mSettingsAdapter = new SettingsAdapter(this.mSettingsMainTextsList, this.mSettingsSubTextsList, this.mSettingsIconIdsList);
        this.mSubSettingsAdapter = new SubSettingsAdapter(null, 0);
        this.mSettingsListView.setAdapter((ListAdapter)this.mSettingsAdapter);
        this.mSettingsListView.setChoiceMode(1);
        this.mSettingsListView.setOnItemClickListener(this.mSettingsItemClickListener);
        this.mEmbeddedSettingsItemWidth = this.mResources.getDimensionPixelSize(R.dimen.mcv2_embedded_settings_width);
        this.mFullSettingsItemWidth = this.mResources.getDimensionPixelSize(R.dimen.mcv2_full_settings_width);
        this.mSettingsItemHeight = this.mResources.getDimensionPixelSize(R.dimen.mcv2_settings_height);
        this.mSettingsWindowMargin = -1 * this.mResources.getDimensionPixelSize(R.dimen.mcv2_settings_offset);
        this.mSettingsWindow = new PopupWindow((View)this.mSettingsListView, this.mEmbeddedSettingsItemWidth, -2, true);
        this.mSettingsWindow.setOnDismissListener(this.mSettingsDismissListener);
        int titleBarTranslateY = -1 * this.mResources.getDimensionPixelSize(R.dimen.mcv2_title_bar_height);
        int bottomBarHeight = this.mResources.getDimensionPixelSize(R.dimen.mcv2_bottom_bar_height);
        int progressThumbHeight = this.mResources.getDimensionPixelSize(R.dimen.mcv2_custom_progress_thumb_size);
        int progressBarHeight = this.mResources.getDimensionPixelSize(R.dimen.mcv2_custom_progress_max_size);
        int bottomBarTranslateY = bottomBarHeight + progressThumbHeight / 2 - progressBarHeight / 2;
        ValueAnimator fadeOutAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        fadeOutAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        fadeOutAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float alpha = ((Float)animation.getAnimatedValue()).floatValue();
                SeekBar seekBar = (SeekBar)MediaControlView2.this.mProgress;
                if (MediaControlView2.this.mSizeType != 2) {
                    GradientDrawable thumb = (GradientDrawable)MediaControlView2.this.mResources.getDrawable(R.drawable.custom_progress_thumb);
                    int newSize = (int)((float)MediaControlView2.this.mResources.getDimensionPixelSize(R.dimen.mcv2_custom_progress_thumb_size) * alpha);
                    thumb.setSize(newSize, newSize);
                    seekBar.setThumb((Drawable)thumb);
                }
                MediaControlView2.this.mTransportControls.setAlpha(alpha);
                if (alpha == 0.0f) {
                    MediaControlView2.this.mTransportControls.setVisibility(8);
                } else if (alpha == 1.0f) {
                    MediaControlView2.this.setEnabled(false);
                }
                if (MediaControlView2.this.mSizeType == 2) {
                    MediaControlView2.this.mFullScreenButton.setAlpha(alpha);
                    MediaControlView2.this.mProgressBar.setAlpha(alpha);
                    if (alpha == 0.0f) {
                        MediaControlView2.this.mFullScreenButton.setVisibility(8);
                        MediaControlView2.this.mProgressBar.setVisibility(8);
                    }
                }
            }
        });
        ValueAnimator fadeInAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        fadeInAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        fadeInAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float alpha = ((Float)animation.getAnimatedValue()).floatValue();
                SeekBar seekBar = (SeekBar)MediaControlView2.this.mProgress;
                if (MediaControlView2.this.mSizeType != 2) {
                    GradientDrawable thumb = (GradientDrawable)MediaControlView2.this.mResources.getDrawable(R.drawable.custom_progress_thumb);
                    int newSize = (int)((float)MediaControlView2.this.mResources.getDimensionPixelSize(R.dimen.mcv2_custom_progress_thumb_size) * alpha);
                    thumb.setSize(newSize, newSize);
                    seekBar.setThumb((Drawable)thumb);
                }
                MediaControlView2.this.mTransportControls.setAlpha(alpha);
                if (alpha == 0.0f) {
                    MediaControlView2.this.mTransportControls.setVisibility(0);
                } else if (alpha == 1.0f) {
                    MediaControlView2.this.setEnabled(true);
                }
                if (MediaControlView2.this.mSizeType == 2) {
                    MediaControlView2.this.mFullScreenButton.setAlpha(alpha);
                    MediaControlView2.this.mProgressBar.setAlpha(alpha);
                    if (alpha == 0.0f) {
                        MediaControlView2.this.mFullScreenButton.setVisibility(0);
                        MediaControlView2.this.mProgressBar.setVisibility(0);
                    }
                }
            }
        });
        this.mHideMainBarsAnimator = new AnimatorSet();
        this.mHideMainBarsAnimator.play((Animator)ObjectAnimator.ofFloat((Object)this.mTitleBar, (String)"translationY", (float[])new float[]{0.0f, titleBarTranslateY})).with((Animator)ObjectAnimator.ofFloat((Object)this.mBottomBar, (String)"translationY", (float[])new float[]{0.0f, bottomBarTranslateY})).with((Animator)ObjectAnimator.ofFloat((Object)this.mProgressBar, (String)"translationY", (float[])new float[]{0.0f, bottomBarTranslateY})).with((Animator)fadeOutAnimator);
        this.mHideMainBarsAnimator.setDuration(250L);
        ((Animator)this.mHideMainBarsAnimator.getChildAnimations().get(0)).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MediaControlView2.this.setEnabled(false);
                MediaControlView2.this.mUxState = 3;
            }

            public void onAnimationEnd(Animator animation) {
                MediaControlView2.this.setEnabled(true);
                MediaControlView2.this.mUxState = 1;
            }
        });
        this.mHideProgressBarAnimator = new AnimatorSet();
        this.mHideProgressBarAnimator.play((Animator)ObjectAnimator.ofFloat((Object)this.mBottomBar, (String)"translationY", (float[])new float[]{bottomBarTranslateY, bottomBarTranslateY + progressBarHeight})).with((Animator)ObjectAnimator.ofFloat((Object)this.mProgressBar, (String)"translationY", (float[])new float[]{bottomBarTranslateY, bottomBarTranslateY + progressBarHeight}));
        this.mHideProgressBarAnimator.setDuration(250L);
        ((Animator)this.mHideProgressBarAnimator.getChildAnimations().get(0)).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MediaControlView2.this.setEnabled(false);
                MediaControlView2.this.mUxState = 3;
            }

            public void onAnimationEnd(Animator animation) {
                MediaControlView2.this.setEnabled(true);
                MediaControlView2.this.mUxState = 2;
            }
        });
        this.mHideAllBarsAnimator = new AnimatorSet();
        this.mHideAllBarsAnimator.play((Animator)ObjectAnimator.ofFloat((Object)this.mTitleBar, (String)"translationY", (float[])new float[]{0.0f, titleBarTranslateY})).with((Animator)ObjectAnimator.ofFloat((Object)this.mBottomBar, (String)"translationY", (float[])new float[]{0.0f, bottomBarTranslateY + progressBarHeight})).with((Animator)ObjectAnimator.ofFloat((Object)this.mProgressBar, (String)"translationY", (float[])new float[]{0.0f, bottomBarTranslateY + progressBarHeight})).with((Animator)fadeOutAnimator);
        this.mHideAllBarsAnimator.setDuration(250L);
        ((Animator)this.mHideAllBarsAnimator.getChildAnimations().get(0)).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MediaControlView2.this.setEnabled(false);
                MediaControlView2.this.mUxState = 3;
            }

            public void onAnimationEnd(Animator animation) {
                MediaControlView2.this.setEnabled(true);
                MediaControlView2.this.mUxState = 2;
            }
        });
        this.mShowMainBarsAnimator = new AnimatorSet();
        this.mShowMainBarsAnimator.play((Animator)ObjectAnimator.ofFloat((Object)this.mTitleBar, (String)"translationY", (float[])new float[]{titleBarTranslateY, 0.0f})).with((Animator)ObjectAnimator.ofFloat((Object)this.mBottomBar, (String)"translationY", (float[])new float[]{bottomBarTranslateY, 0.0f})).with((Animator)ObjectAnimator.ofFloat((Object)this.mProgressBar, (String)"translationY", (float[])new float[]{bottomBarTranslateY, 0.0f})).with((Animator)fadeInAnimator);
        this.mShowMainBarsAnimator.setDuration(250L);
        ((Animator)this.mShowMainBarsAnimator.getChildAnimations().get(0)).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MediaControlView2.this.setEnabled(false);
                MediaControlView2.this.mUxState = 3;
            }

            public void onAnimationEnd(Animator animation) {
                MediaControlView2.this.setEnabled(true);
                MediaControlView2.this.mUxState = 0;
            }
        });
        this.mShowAllBarsAnimator = new AnimatorSet();
        this.mShowAllBarsAnimator.play((Animator)ObjectAnimator.ofFloat((Object)this.mTitleBar, (String)"translationY", (float[])new float[]{titleBarTranslateY, 0.0f})).with((Animator)ObjectAnimator.ofFloat((Object)this.mBottomBar, (String)"translationY", (float[])new float[]{bottomBarTranslateY + progressBarHeight, 0.0f})).with((Animator)ObjectAnimator.ofFloat((Object)this.mProgressBar, (String)"translationY", (float[])new float[]{bottomBarTranslateY + progressBarHeight, 0.0f})).with((Animator)fadeInAnimator);
        this.mShowAllBarsAnimator.setDuration(250L);
        ((Animator)this.mShowAllBarsAnimator.getChildAnimations().get(0)).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MediaControlView2.this.setEnabled(false);
                MediaControlView2.this.mUxState = 3;
            }

            public void onAnimationEnd(Animator animation) {
                MediaControlView2.this.setEnabled(true);
                MediaControlView2.this.mUxState = 0;
            }
        });
        this.mOverflowShowAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mOverflowShowAnimator.setDuration(250L);
        this.mOverflowShowAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                MediaControlView2.this.animateOverflow(animation);
            }
        });
        this.mOverflowShowAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MediaControlView2.this.mExtraControls.setVisibility(0);
                MediaControlView2.this.mOverflowShowButton.setVisibility(8);
                MediaControlView2.this.mOverflowHideButton.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                MediaControlView2.this.mBasicControls.setVisibility(8);
                if (MediaControlView2.this.mSizeType == 1) {
                    MediaControlView2.this.mFfwdButton.setVisibility(8);
                }
            }
        });
        this.mOverflowHideAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.mOverflowHideAnimator.setDuration(250L);
        this.mOverflowHideAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                MediaControlView2.this.animateOverflow(animation);
            }
        });
        this.mOverflowHideAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                MediaControlView2.this.mBasicControls.setVisibility(0);
                MediaControlView2.this.mOverflowShowButton.setVisibility(0);
                MediaControlView2.this.mOverflowHideButton.setVisibility(8);
                if (MediaControlView2.this.mSizeType == 1) {
                    MediaControlView2.this.mFfwdButton.setVisibility(0);
                }
            }

            public void onAnimationEnd(Animator animation) {
                MediaControlView2.this.mExtraControls.setVisibility(8);
            }
        });
    }

    private void disableUnsupportedButtons() {
        try {
            if (this.mPlayPauseButton != null && !this.canPause()) {
                this.mPlayPauseButton.setEnabled(false);
            }
            if (this.mRewButton != null && !this.canSeekBackward()) {
                this.mRewButton.setEnabled(false);
            }
            if (this.mFfwdButton != null && !this.canSeekForward()) {
                this.mFfwdButton.setEnabled(false);
            }
            if (this.mProgress != null && !this.canSeekBackward() && !this.canSeekForward()) {
                this.mProgress.setEnabled(false);
            }
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
    }

    String stringForTime(long timeMs) {
        long totalSeconds = timeMs / 1000L;
        long seconds = totalSeconds % 60L;
        long minutes = totalSeconds / 60L % 60L;
        long hours = totalSeconds / 3600L;
        this.mFormatBuilder.setLength(0);
        if (hours > 0L) {
            return this.mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return this.mFormatter.format("%02d:%02d", minutes, seconds).toString();
    }

    long setProgress() {
        if (this.mController == null || this.mDragging) {
            return 0L;
        }
        int positionOnProgressBar = 0;
        long currentPosition = this.getCurrentPosition();
        if (this.mDuration > 0L) {
            positionOnProgressBar = (int)(1000L * currentPosition / this.mDuration);
        }
        if (this.mProgress != null && currentPosition != this.mDuration) {
            this.mProgress.setProgress(positionOnProgressBar);
            if (this.getBufferPercentage() < 0) {
                this.mProgress.setSecondaryProgress(1000);
            } else {
                this.mProgress.setSecondaryProgress(this.getBufferPercentage() * 10);
            }
        }
        if (this.mEndTime != null) {
            this.mEndTime.setText((CharSequence)this.stringForTime(this.mDuration));
        }
        if (this.mCurrentTime != null) {
            this.mCurrentTime.setText((CharSequence)this.stringForTime(currentPosition));
        }
        if (this.mIsAdvertisement) {
            if (this.mAdSkipView != null) {
                if (currentPosition <= 5000L) {
                    if (this.mAdSkipView.getVisibility() == 8) {
                        this.mAdSkipView.setVisibility(0);
                    }
                    String skipTimeText = this.mResources.getString(R.string.MediaControlView2_ad_skip_wait_time, new Object[]{(5000L - currentPosition) / 1000L + 1L});
                    this.mAdSkipView.setText((CharSequence)skipTimeText);
                } else if (this.mAdSkipView.getVisibility() == 0) {
                    this.mAdSkipView.setVisibility(8);
                    this.mNextButton.setEnabled(true);
                    this.mNextButton.clearColorFilter();
                }
            }
            if (this.mAdRemainingView != null) {
                long remainingTime = this.mDuration - currentPosition < 0L ? 0L : this.mDuration - currentPosition;
                String remainingTimeText = this.mResources.getString(R.string.MediaControlView2_ad_remaining_time, new Object[]{this.stringForTime(remainingTime)});
                this.mAdRemainingView.setText((CharSequence)remainingTimeText);
            }
        }
        return currentPosition;
    }

    void togglePausePlayState() {
        if (this.isPlaying()) {
            this.mController.pause();
            this.mPlayPauseButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_play_circle_filled, null));
            this.mPlayPauseButton.setContentDescription((CharSequence)this.mResources.getString(R.string.mcv2_play_button_desc));
        } else {
            this.mController.play();
            this.mPlayPauseButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_pause_circle_filled, null));
            this.mPlayPauseButton.setContentDescription((CharSequence)this.mResources.getString(R.string.mcv2_pause_button_desc));
        }
    }

    private void toggleMediaControlViewVisibility() {
        if (this.mMediaType == 1 && this.mSizeType == 1 || this.mShowControllerIntervalMs == 0L || this.mAccessibilityManager.isTouchExplorationEnabled() || this.mUxState == 3) {
            return;
        }
        this.removeCallbacks(this.mHideMainBars);
        this.removeCallbacks(this.mHideProgressBar);
        switch (this.mUxState) {
            case 2: {
                this.post(this.mShowAllBars);
                break;
            }
            case 1: {
                this.post(this.mShowMainBars);
                break;
            }
            case 0: {
                this.post(this.mHideAllBars);
            }
        }
    }

    void updateDuration() {
        if (this.mController != null && this.mController.hasMetadata()) {
            this.mDuration = this.mController.getDurationMs();
            this.setProgress();
        }
    }

    void updateTitle() {
        if (this.mController != null && this.mController.hasMetadata()) {
            this.mTitleView.setText((CharSequence)this.mController.getTitle());
        }
    }

    private void updateTitleBarLayout() {
        if (this.mTitleBar != null) {
            int titleBarWidth = this.mTitleBar.getWidth();
            View leftBar = this.mTitleBar.findViewById(R.id.title_bar_left);
            View rightBar = this.mTitleBar.findViewById(R.id.title_bar_right);
            int leftBarWidth = leftBar.getWidth();
            int rightBarWidth = rightBar.getWidth();
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)leftBar.getLayoutParams();
            if (leftBarWidth + rightBarWidth > titleBarWidth) {
                params.width = titleBarWidth - rightBarWidth;
                this.mOriginalLeftBarWidth = leftBarWidth;
            } else if (leftBarWidth + rightBarWidth < titleBarWidth && this.mOriginalLeftBarWidth != 0) {
                params.width = this.mOriginalLeftBarWidth;
                this.mOriginalLeftBarWidth = 0;
            }
            leftBar.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    void updateAudioMetadata() {
        if (this.mMediaType != 1) {
            return;
        }
        if (this.mController.hasMetadata()) {
            String titleText = this.mController.getTitle();
            String artistText = this.mController.getArtistText();
            if (titleText == null) {
                titleText = this.mResources.getString(R.string.mcv2_music_title_unknown_text);
            }
            if (artistText == null) {
                artistText = this.mResources.getString(R.string.mcv2_music_artist_unknown_text);
            }
            this.mTitleView.setText((CharSequence)(titleText + " - " + artistText));
            this.mNeedUxUpdate = true;
        }
    }

    void updateLayout() {
        if (this.mIsAdvertisement) {
            this.mRewButton.setVisibility(8);
            this.mFfwdButton.setVisibility(8);
            this.mPrevButton.setVisibility(8);
            this.mTimeView.setVisibility(8);
            this.mAdSkipView.setVisibility(0);
            this.mAdRemainingView.setVisibility(0);
            this.mAdExternalLink.setVisibility(0);
            this.mProgress.setEnabled(false);
            this.mNextButton.setEnabled(false);
            this.mNextButton.setColorFilter(R.color.gray);
        } else {
            this.mRewButton.setVisibility(0);
            this.mFfwdButton.setVisibility(0);
            this.mPrevButton.setVisibility(0);
            this.mTimeView.setVisibility(0);
            this.mAdSkipView.setVisibility(8);
            this.mAdRemainingView.setVisibility(8);
            this.mAdExternalLink.setVisibility(8);
            this.mProgress.setEnabled(true);
            this.mNextButton.setEnabled(true);
            this.mNextButton.clearColorFilter();
            this.disableUnsupportedButtons();
        }
    }

    private void updateLayout(int maxIconCount, int iconSize, int currWidth, int currHeight, int screenWidth, int screenHeight) {
        boolean isFullSize;
        int bottomBarRightWidthMax = iconSize * maxIconCount;
        int fullWidth = this.mTransportControls.getWidth() + this.mTimeView.getWidth() + bottomBarRightWidthMax;
        int embeddedWidth = this.mTimeView.getWidth() + bottomBarRightWidthMax;
        int screenMaxLength = Math.max(screenWidth, screenHeight);
        boolean bl = this.mMediaType == 0 ? currWidth == screenMaxLength : (isFullSize = currWidth == screenWidth && currHeight == screenHeight);
        if (isFullSize) {
            if (this.mSizeType != 1) {
                this.updateLayoutForSizeChange(1);
                if (this.mMediaType == 1) {
                    this.mTitleView.setVisibility(8);
                } else {
                    this.mUxState = 2;
                    this.toggleMediaControlViewVisibility();
                }
            }
        } else if (embeddedWidth <= currWidth) {
            if (this.mSizeType != 0) {
                this.updateLayoutForSizeChange(0);
                if (this.mMediaType == 1) {
                    this.mTitleView.setVisibility(0);
                }
            }
        } else if (this.mSizeType != 2) {
            this.updateLayoutForSizeChange(2);
            if (this.mMediaType == 1) {
                this.mTitleView.setVisibility(8);
            }
        }
    }

    private void updateLayoutForSizeChange(int sizeType) {
        this.mSizeType = sizeType;
        RelativeLayout.LayoutParams timeViewParams = (RelativeLayout.LayoutParams)this.mTimeView.getLayoutParams();
        SeekBar seeker = (SeekBar)this.mProgress;
        switch (this.mSizeType) {
            case 0: {
                this.mTitleBar.setVisibility(0);
                this.mBackButton.setVisibility(8);
                this.mTitleView.setPadding(this.mResources.getDimensionPixelSize(R.dimen.mcv2_embedded_icon_padding), this.mTitleView.getPaddingTop(), this.mTitleView.getPaddingRight(), this.mTitleView.getPaddingBottom());
                if (this.mOnFullScreenListener != null) {
                    this.mMinimalSizeFullScreenView.setVisibility(8);
                    this.mFullScreenButton = (ImageButton)this.mBasicControls.findViewById(R.id.fullscreen);
                    this.mFullScreenButton.setOnClickListener(this.mFullScreenListener);
                }
                this.mCenterView.removeAllViews();
                this.mBottomBarLeftView.removeView(this.mTransportControls);
                this.mBottomBarLeftView.setVisibility(8);
                this.mTransportControls = this.inflateTransportControls(R.layout.embedded_transport_controls);
                this.mCenterView.addView(this.mTransportControls);
                GradientDrawable thumb = (GradientDrawable)this.mResources.getDrawable(R.drawable.custom_progress_thumb);
                if (this.mUxState == 0) {
                    int originalSize = this.mResources.getDimensionPixelSize(R.dimen.mcv2_custom_progress_thumb_size);
                    thumb.setSize(originalSize, originalSize);
                }
                seeker.setThumb((Drawable)thumb);
                this.mProgressBuffer.setVisibility(0);
                this.mBottomBar.setVisibility(0);
                if (timeViewParams.getRules()[0] == 0) break;
                timeViewParams.removeRule(0);
                timeViewParams.addRule(1, R.id.bottom_bar_left);
                break;
            }
            case 1: {
                this.mTitleBar.setVisibility(0);
                this.mBackButton.setVisibility(0);
                this.mTitleView.setPadding(0, this.mTitleView.getPaddingTop(), this.mTitleView.getPaddingRight(), this.mTitleView.getPaddingBottom());
                if (this.mOnFullScreenListener != null) {
                    this.mMinimalSizeFullScreenView.setVisibility(8);
                    this.mFullScreenButton = (ImageButton)this.mBasicControls.findViewById(R.id.fullscreen);
                    this.mFullScreenButton.setOnClickListener(this.mFullScreenListener);
                }
                this.mCenterView.removeAllViews();
                this.mBottomBarLeftView.removeView(this.mTransportControls);
                this.mTransportControls = this.inflateTransportControls(R.layout.full_transport_controls);
                this.mBottomBarLeftView.addView(this.mTransportControls, 0);
                this.mBottomBarLeftView.setVisibility(0);
                seeker.setThumb(this.mResources.getDrawable(R.drawable.custom_progress_thumb));
                this.mProgressBuffer.setVisibility(0);
                this.mBottomBar.setVisibility(0);
                if (timeViewParams.getRules()[1] == 0) break;
                timeViewParams.removeRule(1);
                timeViewParams.addRule(0, R.id.basic_controls);
                break;
            }
            case 2: {
                this.mTitleBar.setVisibility(8);
                this.mBackButton.setVisibility(8);
                if (this.mOnFullScreenListener != null) {
                    this.mMinimalSizeFullScreenView.setVisibility(0);
                    this.mFullScreenButton = (ImageButton)this.mMinimalSizeFullScreenView.findViewById(R.id.minimal_fullscreen);
                    this.mFullScreenButton.setOnClickListener(this.mFullScreenListener);
                }
                this.mCenterView.removeAllViews();
                this.mBottomBarLeftView.removeView(this.mTransportControls);
                this.mTransportControls = this.inflateTransportControls(R.layout.minimal_transport_controls);
                this.mCenterView.addView(this.mTransportControls);
                seeker.setThumb(null);
                this.mProgressBuffer.setVisibility(8);
                this.mBottomBar.setVisibility(8);
            }
        }
        this.mTimeView.setLayoutParams((ViewGroup.LayoutParams)timeViewParams);
        if (this.isPlaying()) {
            this.mPlayPauseButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_pause_circle_filled, null));
            this.mPlayPauseButton.setContentDescription((CharSequence)this.mResources.getString(R.string.mcv2_pause_button_desc));
        } else {
            this.mPlayPauseButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_play_circle_filled, null));
            this.mPlayPauseButton.setContentDescription((CharSequence)this.mResources.getString(R.string.mcv2_play_button_desc));
        }
        if (this.mIsFullScreen) {
            this.mFullScreenButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_fullscreen_exit, null));
        } else {
            this.mFullScreenButton.setImageDrawable(this.mResources.getDrawable(R.drawable.ic_fullscreen, null));
        }
    }

    private View inflateTransportControls(int layoutId) {
        View v = MediaControlView2.inflateLayout(this.getContext(), layoutId);
        this.mPlayPauseButton = (ImageButton)v.findViewById(R.id.pause);
        if (this.mPlayPauseButton != null) {
            this.mPlayPauseButton.requestFocus();
            this.mPlayPauseButton.setOnClickListener(this.mPlayPauseListener);
        }
        this.mFfwdButton = (ImageButton)v.findViewById(R.id.ffwd);
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setOnClickListener(this.mFfwdListener);
            if (this.mMediaType == 1) {
                this.mFfwdButton.setVisibility(8);
            }
        }
        this.mRewButton = (ImageButton)v.findViewById(R.id.rew);
        if (this.mRewButton != null) {
            this.mRewButton.setOnClickListener(this.mRewListener);
            if (this.mMediaType == 1) {
                this.mRewButton.setVisibility(8);
            }
        }
        this.mNextButton = (ImageButton)v.findViewById(R.id.next);
        if (this.mNextButton != null) {
            this.mNextButton.setOnClickListener(this.mNextListener);
            this.mNextButton.setVisibility(8);
        }
        this.mPrevButton = (ImageButton)v.findViewById(R.id.prev);
        if (this.mPrevButton != null) {
            this.mPrevButton.setOnClickListener(this.mPrevListener);
            this.mPrevButton.setVisibility(8);
        }
        return v;
    }

    private void initializeSettingsLists() {
        this.mSettingsMainTextsList = new ArrayList<String>();
        this.mSettingsMainTextsList.add(this.mResources.getString(R.string.MediaControlView2_audio_track_text));
        this.mSettingsMainTextsList.add(this.mResources.getString(R.string.MediaControlView2_playback_speed_text));
        this.mSettingsMainTextsList.add(this.mResources.getString(R.string.MediaControlView2_help_text));
        this.mSettingsSubTextsList = new ArrayList<String>();
        this.mSettingsSubTextsList.add(this.mResources.getString(R.string.MediaControlView2_audio_track_none_text));
        this.mSettingsSubTextsList.add(this.mResources.getStringArray(R.array.MediaControlView2_playback_speeds)[3]);
        this.mSettingsSubTextsList.add(RESOURCE_EMPTY);
        this.mSettingsIconIdsList = new ArrayList<Integer>();
        this.mSettingsIconIdsList.add(R.drawable.ic_audiotrack);
        this.mSettingsIconIdsList.add(R.drawable.ic_play_circle_filled);
        this.mSettingsIconIdsList.add(R.drawable.ic_help);
        this.mAudioTrackList = new ArrayList<String>();
        this.mAudioTrackList.add(this.mResources.getString(R.string.MediaControlView2_audio_track_none_text));
        this.mVideoQualityList = new ArrayList<String>();
        this.mVideoQualityList.add(this.mResources.getString(R.string.MediaControlView2_video_quality_auto_text));
        this.mPlaybackSpeedTextList = new ArrayList<String>(Arrays.asList(this.mResources.getStringArray(R.array.MediaControlView2_playback_speeds)));
        this.mSelectedSpeedIndex = 3;
        this.mPlaybackSpeedList = new ArrayList<Float>();
        int[] speeds = this.mResources.getIntArray(R.array.speed_multiplied_by_100);
        for (int i = 0; i < speeds.length; ++i) {
            float speed = (float)speeds[i] / 100.0f;
            this.mPlaybackSpeedList.add(Float.valueOf(speed));
        }
    }

    void displaySettingsWindow(BaseAdapter adapter) {
        this.mSettingsListView.setAdapter((ListAdapter)adapter);
        int itemWidth = this.mSizeType == 0 ? this.mEmbeddedSettingsItemWidth : this.mFullSettingsItemWidth;
        this.mSettingsWindow.setWidth(itemWidth);
        int maxHeight = this.getMeasuredHeight() + this.mSettingsWindowMargin * 2;
        int totalHeight = adapter.getCount() * this.mSettingsItemHeight;
        int height = totalHeight < maxHeight ? totalHeight : maxHeight;
        this.mSettingsWindow.setHeight(height);
        this.mNeedToHideBars = false;
        this.mSettingsWindow.dismiss();
        this.mSettingsWindow.showAsDropDown((View)this, this.mSettingsWindowMargin, this.mSettingsWindowMargin - height, 85);
        this.mNeedToHideBars = true;
    }

    void dismissSettingsWindow() {
        this.mNeedToHideBars = true;
        this.mSettingsWindow.dismiss();
    }

    void animateOverflow(ValueAnimator animation) {
        RelativeLayout.LayoutParams extraControlsParams = (RelativeLayout.LayoutParams)this.mExtraControls.getLayoutParams();
        int iconWidth = this.mResources.getDimensionPixelSize(R.dimen.mcv2_icon_size);
        int extraControlMargin = -2 * iconWidth + (int)((float)(3 * iconWidth) * ((Float)animation.getAnimatedValue()).floatValue());
        extraControlsParams.setMargins(0, 0, extraControlMargin, 0);
        this.mExtraControls.setLayoutParams((ViewGroup.LayoutParams)extraControlsParams);
        this.mTimeView.setAlpha(1.0f - ((Float)animation.getAnimatedValue()).floatValue());
        this.mBasicControls.setAlpha(1.0f - ((Float)animation.getAnimatedValue()).floatValue());
        if (this.mSizeType == 1) {
            int transportControlMargin = -1 * (int)((float)iconWidth * ((Float)animation.getAnimatedValue()).floatValue());
            LinearLayout.LayoutParams transportControlsParams = (LinearLayout.LayoutParams)this.mTransportControls.getLayoutParams();
            transportControlsParams.setMargins(transportControlMargin, 0, 0, 0);
            this.mTransportControls.setLayoutParams((ViewGroup.LayoutParams)transportControlsParams);
            this.mFfwdButton.setAlpha(1.0f - ((Float)animation.getAnimatedValue()).floatValue());
        }
    }

    void resetHideCallbacks() {
        this.removeCallbacks(this.mHideMainBars);
        this.removeCallbacks(this.mHideProgressBar);
        this.postDelayed(this.mHideMainBars, this.mShowControllerIntervalMs);
    }

    void updateAllowedCommands(SessionCommandGroup2 commands) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("updateAllowedCommands(): commands: " + commands));
        }
        if (this.mAllowedCommands == commands) {
            return;
        }
        this.mAllowedCommands = commands;
        if (commands.hasCommand(2)) {
            this.mPlayPauseButton.setVisibility(0);
            this.mPlayPauseButton.setEnabled(true);
        } else {
            this.mPlayPauseButton.setVisibility(8);
        }
        if (commands.hasCommand(8) && this.mMediaType != 1) {
            if (this.mRewButton != null) {
                this.mRewButton.setVisibility(0);
                this.mRewButton.setEnabled(true);
            }
        } else if (this.mRewButton != null) {
            this.mRewButton.setVisibility(8);
        }
        if (commands.hasCommand(7) && this.mMediaType != 1) {
            if (this.mFfwdButton != null) {
                this.mFfwdButton.setVisibility(0);
                this.mFfwdButton.setEnabled(true);
            }
        } else if (this.mFfwdButton != null) {
            this.mFfwdButton.setVisibility(8);
        }
        if (commands.hasCommand(9)) {
            this.mSeekAvailable = true;
            this.mProgress.setEnabled(true);
        }
        if (commands.hasCommand(new SessionCommand2(COMMAND_SHOW_SUBTITLE, null)) && commands.hasCommand(new SessionCommand2(COMMAND_HIDE_SUBTITLE, null))) {
            this.mSubtitleButton.setVisibility(0);
        } else {
            this.mSubtitleButton.setVisibility(8);
        }
        if (commands.hasCommand(new SessionCommand2(COMMAND_MUTE, null)) && commands.hasCommand(new SessionCommand2(COMMAND_UNMUTE, null))) {
            this.mMuteButton.setVisibility(0);
        } else {
            this.mMuteButton.setVisibility(8);
        }
    }

    class ControllerCompat
    implements ControllerInterface {
        private MediaControllerCompat mControllerCompat;
        MediaControllerCompat.TransportControls mControls;
        MediaMetadataCompat mMediaMetadata;
        PlaybackStateCompat mPlaybackState;

        ControllerCompat(MediaControllerCompat controllerCompat) {
            this.mControllerCompat = controllerCompat;
            if (controllerCompat != null) {
                this.mControls = this.mControllerCompat.getTransportControls();
                this.mPlaybackState = this.mControllerCompat.getPlaybackState();
                this.mMediaMetadata = this.mControllerCompat.getMetadata();
                this.mControllerCompat.registerCallback((MediaControllerCompat.Callback)new MediaControllerCompatCallback());
            }
        }

        @Override
        public boolean hasMetadata() {
            return this.mMediaMetadata != null;
        }

        @Override
        public boolean isPlaying() {
            return this.mPlaybackState != null && this.mPlaybackState.getState() == 3;
        }

        @Override
        public long getCurrentPosition() {
            this.mPlaybackState = this.mControllerCompat.getPlaybackState();
            return this.mPlaybackState != null ? this.mPlaybackState.getPosition() : 0L;
        }

        @Override
        public long getBufferedPosition() {
            this.mPlaybackState = this.mControllerCompat.getPlaybackState();
            if (this.mPlaybackState != null) {
                return this.mPlaybackState.getBufferedPosition();
            }
            return 0L;
        }

        @Override
        public boolean canPause() {
            if (this.mPlaybackState != null) {
                return (this.mPlaybackState.getActions() & 2L) != 0L;
            }
            return true;
        }

        @Override
        public boolean canSeekBackward() {
            if (this.mPlaybackState != null) {
                return (this.mPlaybackState.getActions() & 8L) != 0L;
            }
            return true;
        }

        @Override
        public boolean canSeekForward() {
            if (this.mPlaybackState != null) {
                return (this.mPlaybackState.getActions() & 0x40L) != 0L;
            }
            return true;
        }

        @Override
        public void pause() {
            this.mControls.pause();
        }

        @Override
        public void play() {
            this.mControls.play();
        }

        @Override
        public void seekTo(long posMs) {
            this.mControls.seekTo(posMs);
        }

        @Override
        public void skipToNextItem() {
            this.mControls.skipToNext();
        }

        @Override
        public void skipToPreviousItem() {
            this.mControls.skipToPrevious();
        }

        @Override
        public void volumeMute() {
            this.mControllerCompat.sendCommand(MediaControlView2.COMMAND_MUTE, null, null);
        }

        @Override
        public void volumeUnmute() {
            this.mControllerCompat.sendCommand(MediaControlView2.COMMAND_UNMUTE, null, null);
        }

        @Override
        public void setSpeed(float speed) {
            Bundle extra = new Bundle();
            extra.putFloat(MediaControlView2.KEY_PLAYBACK_SPEED, speed);
            this.mControllerCompat.sendCommand(MediaControlView2.COMMAND_SET_PLAYBACK_SPEED, extra, null);
        }

        @Override
        public void selectAudioTrack(int trackIndex) {
            Bundle extra = new Bundle();
            extra.putInt(MediaControlView2.KEY_SELECTED_AUDIO_INDEX, trackIndex);
            this.mControllerCompat.sendCommand(MediaControlView2.COMMAND_SELECT_AUDIO_TRACK, extra, null);
        }

        @Override
        public void showSubtitle(int trackIndex) {
            Bundle extra = new Bundle();
            extra.putInt(MediaControlView2.KEY_SELECTED_SUBTITLE_INDEX, trackIndex);
            this.mControllerCompat.sendCommand(MediaControlView2.COMMAND_SHOW_SUBTITLE, extra, null);
        }

        @Override
        public void hideSubtitle() {
            this.mControllerCompat.sendCommand(MediaControlView2.COMMAND_HIDE_SUBTITLE, null, null);
        }

        @Override
        public long getDurationMs() {
            return this.mMediaMetadata == null ? 0L : this.mMediaMetadata.getLong("android.media.metadata.DURATION");
        }

        @Override
        public String getTitle() {
            return this.mMediaMetadata == null ? null : this.mMediaMetadata.getString("android.media.metadata.TITLE");
        }

        @Override
        public String getArtistText() {
            return this.mMediaMetadata == null ? null : this.mMediaMetadata.getString("android.media.metadata.ARTIST");
        }

        @Override
        public void close() {
        }

        private class MediaControllerCompatCallback
        extends MediaControllerCompat.Callback {
            MediaControllerCompatCallback() {
            }

            public void onPlaybackStateChanged(PlaybackStateCompat state) {
                ControllerCompat.this.mPlaybackState = state;
                if (ControllerCompat.this.mPlaybackState.getState() != MediaControlView2.this.mPrevState) {
                    switch (ControllerCompat.this.mPlaybackState.getState()) {
                        case 3: {
                            MediaControlView2.this.mPlayPauseButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_pause_circle_filled, null));
                            MediaControlView2.this.mPlayPauseButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_pause_button_desc));
                            MediaControlView2.this.removeCallbacks(MediaControlView2.this.mUpdateProgress);
                            MediaControlView2.this.post(MediaControlView2.this.mUpdateProgress);
                            MediaControlView2.this.resetHideCallbacks();
                            MediaControlView2.this.mIsStopped = false;
                            break;
                        }
                        case 2: {
                            MediaControlView2.this.mPlayPauseButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_play_circle_filled, null));
                            MediaControlView2.this.mPlayPauseButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_play_button_desc));
                            break;
                        }
                        case 1: {
                            MediaControlView2.this.mPlayPauseButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_replay_circle_filled, null));
                            MediaControlView2.this.mPlayPauseButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_replay_button_desc));
                            MediaControlView2.this.mIsStopped = true;
                            break;
                        }
                    }
                    MediaControlView2.this.mPrevState = ControllerCompat.this.mPlaybackState.getState();
                }
                if (MediaControlView2.this.mPlaybackActions != ControllerCompat.this.mPlaybackState.getActions()) {
                    long newActions = ControllerCompat.this.mPlaybackState.getActions();
                    if ((newActions & 2L) != 0L) {
                        MediaControlView2.this.mPlayPauseButton.setVisibility(0);
                    }
                    if ((newActions & 8L) != 0L && MediaControlView2.this.mMediaType != 1 && MediaControlView2.this.mRewButton != null) {
                        MediaControlView2.this.mRewButton.setVisibility(0);
                    }
                    if ((newActions & 0x40L) != 0L && MediaControlView2.this.mMediaType != 1 && MediaControlView2.this.mFfwdButton != null) {
                        MediaControlView2.this.mFfwdButton.setVisibility(0);
                    }
                    MediaControlView2.this.mSeekAvailable = (newActions & 0x100L) != 0L;
                    MediaControlView2.this.mPlaybackActions = newActions;
                }
                List customActions = ControllerCompat.this.mPlaybackState.getCustomActions();
                MediaControlView2.this.mCustomButtons.removeAllViews();
                if (customActions.size() > 0) {
                    for (final PlaybackStateCompat.CustomAction action : customActions) {
                        ImageButton button = new ImageButton(MediaControlView2.this.getContext(), null, 0);
                        button.setImageResource(action.getIcon());
                        final String actionString = action.getAction().toString();
                        button.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                ControllerCompat.this.mControls.sendCustomAction(actionString, action.getExtras());
                                MediaControlView2.this.setVisibility(0);
                            }
                        });
                        MediaControlView2.this.mCustomButtons.addView((View)button);
                    }
                }
            }

            public void onMetadataChanged(MediaMetadataCompat metadata) {
                ControllerCompat.this.mMediaMetadata = metadata;
                MediaControlView2.this.updateDuration();
                MediaControlView2.this.updateTitle();
                MediaControlView2.this.updateAudioMetadata();
            }

            public void onSessionEvent(String event, Bundle extras) {
                switch (event) {
                    case "UpdateTrackStatus": {
                        String track;
                        int i;
                        MediaControlView2.this.mVideoTrackCount = extras.getInt(MediaControlView2.KEY_VIDEO_TRACK_COUNT);
                        MediaControlView2.this.mAudioTrackCount = extras.getInt(MediaControlView2.KEY_AUDIO_TRACK_COUNT);
                        MediaControlView2.this.mAudioTrackList = new ArrayList<String>();
                        if (MediaControlView2.this.mAudioTrackCount > 0) {
                            for (i = 0; i < MediaControlView2.this.mAudioTrackCount; ++i) {
                                track = MediaControlView2.this.mResources.getString(R.string.MediaControlView2_audio_track_number_text, new Object[]{i + 1});
                                MediaControlView2.this.mAudioTrackList.add(track);
                            }
                            MediaControlView2.this.mSettingsSubTextsList.set(0, MediaControlView2.this.mAudioTrackList.get(0));
                        } else {
                            MediaControlView2.this.mAudioTrackList.add(MediaControlView2.this.mResources.getString(R.string.MediaControlView2_audio_track_none_text));
                        }
                        if (MediaControlView2.this.mVideoTrackCount == 0 && MediaControlView2.this.mAudioTrackCount > 0) {
                            MediaControlView2.this.mMediaType = 1;
                        }
                        MediaControlView2.this.mSubtitleTrackCount = extras.getInt(MediaControlView2.KEY_SUBTITLE_TRACK_COUNT);
                        MediaControlView2.this.mSubtitleDescriptionsList = new ArrayList<String>();
                        if (MediaControlView2.this.mSubtitleTrackCount > 0) {
                            MediaControlView2.this.mSubtitleButton.setVisibility(0);
                            MediaControlView2.this.mSubtitleButton.setEnabled(true);
                            MediaControlView2.this.mSubtitleDescriptionsList.add(MediaControlView2.this.mResources.getString(R.string.MediaControlView2_subtitle_off_text));
                            for (i = 0; i < MediaControlView2.this.mSubtitleTrackCount; ++i) {
                                track = MediaControlView2.this.mResources.getString(R.string.MediaControlView2_subtitle_track_number_text, new Object[]{i + 1});
                                MediaControlView2.this.mSubtitleDescriptionsList.add(track);
                            }
                            break;
                        }
                        MediaControlView2.this.mSubtitleButton.setVisibility(8);
                        MediaControlView2.this.mSubtitleButton.setEnabled(false);
                        break;
                    }
                    case "UpdateMediaTypeStatus": {
                        boolean newStatus = extras.getBoolean(MediaControlView2.KEY_STATE_IS_ADVERTISEMENT);
                        if (newStatus == MediaControlView2.this.mIsAdvertisement) break;
                        MediaControlView2.this.mIsAdvertisement = newStatus;
                        MediaControlView2.this.updateLayout();
                    }
                }
            }
        }
    }

    class Controller2
    implements ControllerInterface {
        private MediaController2 mController2;
        int mPlaybackState;
        MediaMetadata2 mMediaMetadata2;
        private Executor mCallbackExecutor;

        Controller2(SessionToken2 token) {
            this.mCallbackExecutor = MainHandlerExecutor.getExecutor(MediaControlView2.this.getContext());
            this.mController2 = new MediaController2(MediaControlView2.this.getContext(), token, this.mCallbackExecutor, (MediaController2.ControllerCallback)new MediaControllerCallback());
            this.mPlaybackState = this.mController2.getPlayerState();
            MediaItem2 currentItem = this.mController2.getCurrentMediaItem();
            this.mMediaMetadata2 = currentItem != null ? currentItem.getMetadata() : null;
        }

        @Override
        public boolean hasMetadata() {
            return this.mMediaMetadata2 != null;
        }

        @Override
        public boolean isPlaying() {
            return this.mPlaybackState == 2;
        }

        @Override
        public long getCurrentPosition() {
            long currentPosition = this.mController2.getCurrentPosition();
            return currentPosition < 0L ? 0L : currentPosition;
        }

        @Override
        public long getBufferedPosition() {
            return this.mController2.getBufferedPosition();
        }

        @Override
        public boolean canPause() {
            return MediaControlView2.this.mAllowedCommands != null && MediaControlView2.this.mAllowedCommands.hasCommand(2);
        }

        @Override
        public boolean canSeekBackward() {
            return MediaControlView2.this.mAllowedCommands != null && MediaControlView2.this.mAllowedCommands.hasCommand(8);
        }

        @Override
        public boolean canSeekForward() {
            return MediaControlView2.this.mAllowedCommands != null && MediaControlView2.this.mAllowedCommands.hasCommand(7);
        }

        @Override
        public void pause() {
            this.mController2.pause();
        }

        @Override
        public void play() {
            this.mController2.play();
        }

        @Override
        public void seekTo(long posMs) {
            this.mController2.seekTo(posMs);
        }

        @Override
        public void skipToNextItem() {
            this.mController2.skipToNextItem();
        }

        @Override
        public void skipToPreviousItem() {
            this.mController2.skipToPreviousItem();
        }

        @Override
        public void volumeMute() {
            this.mController2.adjustVolume(-100, 8);
        }

        @Override
        public void volumeUnmute() {
            this.mController2.adjustVolume(100, 8);
        }

        @Override
        public void setSpeed(float speed) {
            this.mController2.setPlaybackSpeed(speed);
        }

        @Override
        public void selectAudioTrack(int trackIndex) {
            Bundle extra = new Bundle();
            extra.putInt(MediaControlView2.KEY_SELECTED_AUDIO_INDEX, trackIndex);
            this.mController2.sendCustomCommand(new SessionCommand2(MediaControlView2.COMMAND_SELECT_AUDIO_TRACK, null), extra, null);
        }

        @Override
        public void showSubtitle(int trackIndex) {
            Bundle extra = new Bundle();
            extra.putInt(MediaControlView2.KEY_SELECTED_SUBTITLE_INDEX, trackIndex);
            this.mController2.sendCustomCommand(new SessionCommand2(MediaControlView2.COMMAND_SHOW_SUBTITLE, null), extra, null);
        }

        @Override
        public void hideSubtitle() {
            this.mController2.sendCustomCommand(new SessionCommand2(MediaControlView2.COMMAND_HIDE_SUBTITLE, null), null, null);
        }

        @Override
        public long getDurationMs() {
            if (this.mMediaMetadata2 != null && this.mMediaMetadata2.containsKey("android.media.metadata.DURATION")) {
                return this.mMediaMetadata2.getLong("android.media.metadata.DURATION");
            }
            return this.mController2.getDuration();
        }

        @Override
        public String getTitle() {
            if (this.mMediaMetadata2 != null && this.mMediaMetadata2.containsKey("android.media.metadata.TITLE")) {
                return this.mMediaMetadata2.getString("android.media.metadata.TITLE");
            }
            return null;
        }

        @Override
        public String getArtistText() {
            if (this.mMediaMetadata2 != null && this.mMediaMetadata2.containsKey("android.media.metadata.ARTIST")) {
                return this.mMediaMetadata2.getString("android.media.metadata.ARTIST");
            }
            return null;
        }

        @Override
        public void close() {
            this.mController2.close();
        }

        class MediaControllerCallback
        extends MediaController2.ControllerCallback {
            MediaControllerCallback() {
            }

            public void onPlayerStateChanged(@NonNull MediaController2 controller, int state) {
                if (DEBUG) {
                    Log.d((String)MediaControlView2.TAG, (String)("onPlayerStateChanged(state: " + state + ")"));
                }
                Controller2.this.mPlaybackState = state;
                if (Controller2.this.mPlaybackState != MediaControlView2.this.mPrevState) {
                    switch (Controller2.this.mPlaybackState) {
                        case 2: {
                            MediaControlView2.this.mPlayPauseButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_pause_circle_filled, null));
                            MediaControlView2.this.mPlayPauseButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_pause_button_desc));
                            MediaControlView2.this.removeCallbacks(MediaControlView2.this.mUpdateProgress);
                            MediaControlView2.this.post(MediaControlView2.this.mUpdateProgress);
                            MediaControlView2.this.resetHideCallbacks();
                            MediaControlView2.this.mIsStopped = false;
                            break;
                        }
                        case 1: {
                            MediaControlView2.this.mPlayPauseButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_play_circle_filled, null));
                            MediaControlView2.this.mPlayPauseButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_play_button_desc));
                            MediaControlView2.this.removeCallbacks(MediaControlView2.this.mUpdateProgress);
                            break;
                        }
                    }
                    MediaControlView2.this.mPrevState = Controller2.this.mPlaybackState;
                }
            }

            public void onCurrentMediaItemChanged(@NonNull MediaController2 controller, @Nullable MediaItem2 mediaItem) {
                Log.d((String)MediaControlView2.TAG, (String)("onCurrentMediaItemChanged()" + mediaItem));
                if (mediaItem == null) {
                    MediaControlView2.this.mPlayPauseButton.setImageDrawable(MediaControlView2.this.mResources.getDrawable(R.drawable.ic_replay_circle_filled, null));
                    MediaControlView2.this.mPlayPauseButton.setContentDescription((CharSequence)MediaControlView2.this.mResources.getString(R.string.mcv2_replay_button_desc));
                    MediaControlView2.this.mIsStopped = true;
                }
            }

            public void onConnected(@NonNull MediaController2 controller, @NonNull SessionCommandGroup2 allowedCommands) {
                MediaControlView2.this.updateAllowedCommands(allowedCommands);
            }

            public void onAllowedCommandsChanged(@NonNull MediaController2 controller, @NonNull SessionCommandGroup2 commands) {
                MediaControlView2.this.updateAllowedCommands(commands);
            }

            public void onPlaylistChanged(@NonNull MediaController2 controller, @NonNull List<MediaItem2> list, @Nullable MediaMetadata2 metadata) {
                if (DEBUG) {
                    Log.d((String)MediaControlView2.TAG, (String)("onPlaylistChanged(): list: " + list));
                }
                MediaItem2 mediaItem = list.isEmpty() ? null : list.get(0);
                Controller2.this.mMediaMetadata2 = mediaItem != null ? mediaItem.getMetadata() : null;
                MediaControlView2.this.updateDuration();
                MediaControlView2.this.updateTitle();
                MediaControlView2.this.updateAudioMetadata();
            }

            public void onCustomCommand(@NonNull MediaController2 controller, @NonNull SessionCommand2 command, @Nullable Bundle args, @Nullable ResultReceiver receiver) {
                if (DEBUG) {
                    Log.d((String)MediaControlView2.TAG, (String)("onCustomCommand(): command: " + command));
                }
                switch (command.getCustomCommand()) {
                    case "UpdateTrackStatus": {
                        String track;
                        int i;
                        MediaControlView2.this.mVideoTrackCount = args != null ? args.getInt(MediaControlView2.KEY_VIDEO_TRACK_COUNT) : 0;
                        MediaControlView2.this.mAudioTrackCount = args != null ? args.getInt(MediaControlView2.KEY_AUDIO_TRACK_COUNT) : 0;
                        MediaControlView2.this.mAudioTrackList = new ArrayList<String>();
                        if (MediaControlView2.this.mAudioTrackCount > 0) {
                            for (i = 0; i < MediaControlView2.this.mAudioTrackCount; ++i) {
                                track = MediaControlView2.this.mResources.getString(R.string.MediaControlView2_audio_track_number_text, new Object[]{i + 1});
                                MediaControlView2.this.mAudioTrackList.add(track);
                            }
                            MediaControlView2.this.mSettingsSubTextsList.set(0, MediaControlView2.this.mAudioTrackList.get(0));
                        } else {
                            MediaControlView2.this.mAudioTrackList.add(MediaControlView2.this.mResources.getString(R.string.MediaControlView2_audio_track_none_text));
                        }
                        if (MediaControlView2.this.mVideoTrackCount == 0 && MediaControlView2.this.mAudioTrackCount > 0) {
                            MediaControlView2.this.mMediaType = 1;
                        }
                        MediaControlView2.this.mSubtitleTrackCount = args != null ? args.getInt(MediaControlView2.KEY_SUBTITLE_TRACK_COUNT) : 0;
                        MediaControlView2.this.mSubtitleDescriptionsList = new ArrayList<String>();
                        if (MediaControlView2.this.mSubtitleTrackCount > 0) {
                            MediaControlView2.this.mSubtitleButton.setVisibility(0);
                            MediaControlView2.this.mSubtitleButton.setEnabled(true);
                            MediaControlView2.this.mSubtitleDescriptionsList.add(MediaControlView2.this.mResources.getString(R.string.MediaControlView2_subtitle_off_text));
                            for (i = 0; i < MediaControlView2.this.mSubtitleTrackCount; ++i) {
                                track = MediaControlView2.this.mResources.getString(R.string.MediaControlView2_subtitle_track_number_text, new Object[]{i + 1});
                                MediaControlView2.this.mSubtitleDescriptionsList.add(track);
                            }
                            break;
                        }
                        MediaControlView2.this.mSubtitleButton.setVisibility(8);
                        MediaControlView2.this.mSubtitleButton.setEnabled(false);
                        break;
                    }
                    case "UpdateMediaTypeStatus": {
                        boolean isAd;
                        boolean bl = isAd = args != null && args.getBoolean(MediaControlView2.KEY_STATE_IS_ADVERTISEMENT);
                        if (isAd == MediaControlView2.this.mIsAdvertisement) break;
                        MediaControlView2.this.mIsAdvertisement = isAd;
                        MediaControlView2.this.updateLayout();
                    }
                }
            }
        }
    }

    static interface ControllerInterface {
        public boolean hasMetadata();

        public boolean isPlaying();

        public long getCurrentPosition();

        public long getBufferedPosition();

        public boolean canPause();

        public boolean canSeekForward();

        public boolean canSeekBackward();

        public void pause();

        public void play();

        public void seekTo(long var1);

        public void skipToNextItem();

        public void skipToPreviousItem();

        public void volumeMute();

        public void volumeUnmute();

        public void setSpeed(float var1);

        public void selectAudioTrack(int var1);

        public void showSubtitle(int var1);

        public void hideSubtitle();

        public long getDurationMs();

        public String getTitle();

        public String getArtistText();

        public void close();
    }

    private class SubSettingsAdapter
    extends BaseAdapter {
        private List<String> mTexts;
        private int mCheckPosition;

        SubSettingsAdapter(List<String> texts, int checkPosition) {
            this.mTexts = texts;
            this.mCheckPosition = checkPosition;
        }

        public String getMainText(int position) {
            if (this.mTexts != null && position < this.mTexts.size()) {
                return this.mTexts.get(position);
            }
            return MediaControlView2.RESOURCE_EMPTY;
        }

        public int getCount() {
            return this.mTexts == null ? 0 : this.mTexts.size();
        }

        public long getItemId(int position) {
            return 0L;
        }

        public Object getItem(int position) {
            return null;
        }

        public View getView(int position, View convertView, ViewGroup container) {
            View row = MediaControlView2.this.mSizeType == 1 ? MediaControlView2.inflateLayout(MediaControlView2.this.getContext(), R.layout.full_sub_settings_list_item) : MediaControlView2.inflateLayout(MediaControlView2.this.getContext(), R.layout.embedded_sub_settings_list_item);
            TextView textView = (TextView)row.findViewById(R.id.text);
            ImageView checkView = (ImageView)row.findViewById(R.id.check);
            textView.setText((CharSequence)this.mTexts.get(position));
            if (position != this.mCheckPosition) {
                checkView.setVisibility(4);
            }
            return row;
        }

        public void setTexts(List<String> texts) {
            this.mTexts = texts;
        }

        public void setCheckPosition(int checkPosition) {
            this.mCheckPosition = checkPosition;
        }
    }

    private class SettingsAdapter
    extends BaseAdapter {
        private List<Integer> mIconIds;
        private List<String> mMainTexts;
        private List<String> mSubTexts;

        SettingsAdapter(@Nullable List<String> mainTexts, @Nullable List<String> subTexts, List<Integer> iconIds) {
            this.mMainTexts = mainTexts;
            this.mSubTexts = subTexts;
            this.mIconIds = iconIds;
        }

        public void updateSubTexts(List<String> subTexts) {
            this.mSubTexts = subTexts;
            this.notifyDataSetChanged();
        }

        public String getMainText(int position) {
            if (this.mMainTexts != null && position < this.mMainTexts.size()) {
                return this.mMainTexts.get(position);
            }
            return MediaControlView2.RESOURCE_EMPTY;
        }

        public int getCount() {
            return this.mMainTexts == null ? 0 : this.mMainTexts.size();
        }

        public long getItemId(int position) {
            return 0L;
        }

        public Object getItem(int position) {
            return null;
        }

        public View getView(int position, View convertView, ViewGroup container) {
            View row = MediaControlView2.this.mSizeType == 1 ? MediaControlView2.inflateLayout(MediaControlView2.this.getContext(), R.layout.full_settings_list_item) : MediaControlView2.inflateLayout(MediaControlView2.this.getContext(), R.layout.embedded_settings_list_item);
            TextView mainTextView = (TextView)row.findViewById(R.id.main_text);
            TextView subTextView = (TextView)row.findViewById(R.id.sub_text);
            ImageView iconView = (ImageView)row.findViewById(R.id.icon);
            mainTextView.setText((CharSequence)this.mMainTexts.get(position));
            if (this.mSubTexts == null || MediaControlView2.RESOURCE_EMPTY.equals(this.mSubTexts.get(position))) {
                subTextView.setVisibility(8);
            } else {
                subTextView.setText((CharSequence)this.mSubTexts.get(position));
            }
            if (this.mIconIds == null || this.mIconIds.get(position) == -1) {
                iconView.setVisibility(8);
            } else {
                iconView.setImageDrawable(MediaControlView2.this.mResources.getDrawable(this.mIconIds.get(position).intValue(), null));
            }
            return row;
        }

        public void setSubTexts(List<String> subTexts) {
            this.mSubTexts = subTexts;
        }
    }

    public static interface OnFullScreenListener {
        public void onFullScreen(View var1, boolean var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Button {
    }
}

