/*
 * Decompiled with CFR 0.152.
 */
package androidx.media.widget;

import android.content.Context;
import android.media.MediaPlayer;
import android.media.SubtitleData;
import android.net.Uri;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media.widget.SubtitleAnchorView;
import androidx.media.widget.VideoView2;
import androidx.media.widget.VideoView2ImplBaseWithMp1;
import androidx.media2.SubtitleData2;
import androidx.media2.subtitle.Cea708CaptionRenderer;
import androidx.media2.subtitle.ClosedCaptionRenderer;
import androidx.media2.subtitle.SubtitleController;
import androidx.media2.subtitle.SubtitleTrack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

@RequiresApi(value=28)
class VideoView2ImplApi28WithMp1
extends VideoView2ImplBaseWithMp1 {
    private static final String TAG = "VideoView2ImplApi28_1";
    static final boolean DEBUG = Log.isLoggable((String)"VideoView2ImplApi28_1", (int)3);
    private static final int INVALID_TRACK_INDEX = -1;
    ArrayList<Pair<Integer, SubtitleTrack>> mSubtitleTrackIndices;
    private SubtitleController mSubtitleController;
    int mSelectedSubtitleTrackIndex;
    private SubtitleAnchorView mSubtitleAnchorView;
    private boolean mSubtitleEnabled;
    private MediaPlayer.OnSubtitleDataListener mSubtitleListener = new MediaPlayer.OnSubtitleDataListener(){

        public void onSubtitleData(MediaPlayer mp, SubtitleData data) {
            int index;
            if (DEBUG) {
                Log.d((String)VideoView2ImplApi28WithMp1.TAG, (String)("onSubtitleData(): getTrackIndex: " + data.getTrackIndex() + ", getCurrentPosition: " + mp.getCurrentPosition() + ", getStartTimeUs(): " + data.getStartTimeUs() + ", diff: " + (data.getStartTimeUs() / 1000L - (long)mp.getCurrentPosition()) + "ms, getDurationUs(): " + data.getDurationUs()));
            }
            if ((index = data.getTrackIndex()) != VideoView2ImplApi28WithMp1.this.mSelectedSubtitleTrackIndex) {
                Log.d((String)VideoView2ImplApi28WithMp1.TAG, (String)("onSubtitleData(): getTrackIndex: " + data.getTrackIndex() + ", selected track index: " + VideoView2ImplApi28WithMp1.this.mSelectedSubtitleTrackIndex));
                return;
            }
            for (Pair<Integer, SubtitleTrack> p : VideoView2ImplApi28WithMp1.this.mSubtitleTrackIndices) {
                if ((Integer)p.first != index) continue;
                SubtitleTrack track = (SubtitleTrack)p.second;
                track.onData(new SubtitleData2(data));
            }
        }
    };

    VideoView2ImplApi28WithMp1() {
    }

    @Override
    public void initialize(VideoView2 instance, Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super.initialize(instance, context, attrs, defStyleAttr);
        this.mSelectedSubtitleTrackIndex = -1;
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.mSubtitleAnchorView = new SubtitleAnchorView(context);
        this.mSubtitleAnchorView.setLayoutParams(params);
        this.mSubtitleAnchorView.setBackgroundColor(0);
        this.mInstance.addView((View)this.mSubtitleAnchorView);
        this.mSubtitleEnabled = attrs == null || attrs.getAttributeBooleanValue("http://schemas.android.com/apk/res/android", "enableSubtitle", false);
    }

    @Override
    public void setSubtitleEnabled(boolean enable) {
        if (enable != this.mSubtitleEnabled) {
            this.selectOrDeselectSubtitle(enable);
        }
        this.mSubtitleEnabled = enable;
    }

    @Override
    public boolean isSubtitleEnabled() {
        return this.mSubtitleEnabled;
    }

    @Override
    protected void setupMediaPlayer(Context context, Uri uri, Map<String, String> headers) throws IOException {
        super.setupMediaPlayer(context, uri, headers);
        this.mSubtitleController = new SubtitleController(context);
        this.mSubtitleController.registerRenderer((SubtitleController.Renderer)new ClosedCaptionRenderer(context));
        this.mSubtitleController.registerRenderer((SubtitleController.Renderer)new Cea708CaptionRenderer(context));
        this.mSubtitleController.setAnchor((SubtitleController.Anchor)this.mSubtitleAnchorView);
        this.mMediaPlayer.setOnSubtitleDataListener(this.mSubtitleListener);
    }

    private void selectOrDeselectSubtitle(boolean select) {
        if (!this.isInPlaybackState()) {
            return;
        }
        if (select) {
            if (this.mSubtitleTrackIndices.size() > 0) {
                this.mSelectedSubtitleTrackIndex = (Integer)this.mSubtitleTrackIndices.get((int)0).first;
                this.mSubtitleController.selectTrack((SubtitleTrack)this.mSubtitleTrackIndices.get((int)0).second);
                this.mMediaPlayer.selectTrack(this.mSelectedSubtitleTrackIndex);
                this.mSubtitleAnchorView.setVisibility(0);
            }
        } else if (this.mSelectedSubtitleTrackIndex != -1) {
            this.mMediaPlayer.deselectTrack(this.mSelectedSubtitleTrackIndex);
            this.mSelectedSubtitleTrackIndex = -1;
            this.mSubtitleAnchorView.setVisibility(8);
        }
    }

    @Override
    protected void extractTracks() {
        MediaPlayer.TrackInfo[] trackInfos = this.mMediaPlayer.getTrackInfo();
        this.mVideoTrackIndices = new ArrayList();
        this.mAudioTrackIndices = new ArrayList();
        this.mSubtitleTrackIndices = new ArrayList();
        this.mSubtitleController.reset();
        for (int i = 0; i < trackInfos.length; ++i) {
            SubtitleTrack track;
            int trackType = trackInfos[i].getTrackType();
            if (trackType == 1) {
                this.mVideoTrackIndices.add(i);
                continue;
            }
            if (trackType == 2) {
                this.mAudioTrackIndices.add(i);
                continue;
            }
            if (trackType != 4 || (track = this.mSubtitleController.addTrack(trackInfos[i].getFormat())) == null) continue;
            this.mSubtitleTrackIndices.add((Pair<Integer, SubtitleTrack>)new Pair((Object)i, (Object)track));
        }
        if (this.mVideoTrackIndices.size() > 0) {
            this.mSelectedVideoTrackIndex = 0;
        }
        if (this.mAudioTrackIndices.size() > 0) {
            this.mSelectedAudioTrackIndex = 0;
        }
        Bundle data = new Bundle();
        data.putInt("VideoTrackCount", this.mVideoTrackIndices.size());
        data.putInt("AudioTrackCount", this.mAudioTrackIndices.size());
        data.putInt("SubtitleTrackCount", this.mSubtitleTrackIndices.size());
        if (this.mSubtitleTrackIndices.size() > 0) {
            this.selectOrDeselectSubtitle(this.mSubtitleEnabled);
        }
        this.mMediaSession.sendSessionEvent("UpdateTrackStatus", data);
    }

    @Override
    protected void doShowSubtitleCommand(Bundle args) {
        int subtitleTrackIndex;
        int subtitleIndex = args.getInt("SelectedSubtitleIndex", -1);
        if (subtitleIndex != -1 && (subtitleTrackIndex = ((Integer)this.mSubtitleTrackIndices.get((int)subtitleIndex).first).intValue()) != this.mSelectedSubtitleTrackIndex) {
            this.mSelectedSubtitleTrackIndex = subtitleTrackIndex;
            this.mInstance.setSubtitleEnabled(true);
        }
    }

    @Override
    protected void doHideSubtitleCommand() {
        this.mInstance.setSubtitleEnabled(false);
    }
}

